/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.dialog.AbstractDialog;
import com.projity.dialog.ButtonPanel;
import com.projity.field.FieldConverter;
import com.projity.pm.task.Project;
import com.projity.pm.task.ProjectFactory;
import com.projity.server.data.ProjectData;
import com.projity.strings.Messages;
import com.projity.util.Environment;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.apache.commons.collections.Closure;

public final class OpenProjectDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private Object[] form;
    private List projects;
    private Set currentProjectIds;
    private boolean allowMaster = true;
    private boolean allowOpenAs;
    OpenProjectTable table;
    JScrollPane scrollPane;
    JLabel resourcePoolMessage;
    protected JButton openReadOnly;
    private boolean openCopy;

    public static OpenProjectDialog getInstance(Frame frame, List list, String string, boolean bl, boolean bl2, Project project) {
        return new OpenProjectDialog(frame, list, string, bl, bl2, project);
    }

    private OpenProjectDialog(Frame frame, List list, String string, boolean bl, boolean bl2, Project project) {
        super(frame, string, true);
        this.allowMaster = bl;
        this.allowOpenAs = bl2;
        this.projects = list;
        this.currentProjectIds = new HashSet();
        if (project != null) {
            this.currentProjectIds.add(new Long(project.getUniqueId()));
        } else {
            ProjectFactory.getInstance().getPortfolio().forProjects(new Closure(){

                @Override
                public void execute(Object object) {
                    Project project = (Project)object;
                    OpenProjectDialog.this.currentProjectIds.add(new Long(project.getUniqueId()));
                }
            });
        }
    }

    protected void initControls() {
        this.table = new OpenProjectTable(this);
        this.bind(true);
    }

    @Override
    public ButtonPanel createButtonPanel() {
        this.createOkCancelButtons();
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel = new ButtonPanel();
        buttonPanel.addButton(this.ok);
        if (this.allowOpenAs) {
            this.openReadOnly = new JButton(Messages.getString("ButtonText.OpenCopy"));
            this.openReadOnly.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OpenProjectDialog.this.onOpenCopy();
                }
            });
            buttonPanel.add(this.openReadOnly);
        }
        if (this.hasOkAndCancelButtons()) {
            buttonPanel.addButton(this.cancel);
        }
        return buttonPanel;
    }

    protected void onOpenCopy() {
        this.openCopy = true;
        this.onOk();
    }

    @Override
    protected void createOkCancelButtons() {
        if (this.allowOpenAs) {
            this.createOkCancelButtons(Messages.getString("ButtonText.Open"), Messages.getString("ButtonText.Cancel"));
        } else {
            super.createOkCancelButtons();
        }
    }

    @Override
    protected boolean bind(boolean bl) {
        if (!bl) {
            int n = this.table.getSelectedRow();
            if (n < 0 || n >= this.projects.size()) {
                this.form = null;
            } else {
                ProjectData projectData = (ProjectData)this.projects.get(n);
                boolean bl2 = this.openCopy || !this.canBeUsed(projectData);
                this.openCopy = false;
                if (!this.allowMaster && projectData.isMaster()) {
                    return false;
                }
                System.out.println("open " + projectData.getName() + " copy " + bl2);
                this.form = new Object[]{projectData, bl2};
            }
        }
        return true;
    }

    @Override
    public JComponent createContentPanel() {
        this.initControls();
        FormLayout formLayout = new FormLayout("400dlu:grow", "p,3dlu,p,2dlu");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        defaultFormBuilder.add(new JScrollPane(this.table));
        defaultFormBuilder.nextLine(2);
        this.resourcePoolMessage = new JLabel(Messages.getString("Warn.resourcePoolCannotOpen"));
        this.resourcePoolMessage.setVisible(false);
        defaultFormBuilder.add(this.resourcePoolMessage);
        return defaultFormBuilder.getPanel();
    }

    public Object[] getForm() {
        return this.form;
    }

    @Override
    public Object getBean() {
        return this.form;
    }

    private boolean canBeUsed(ProjectData projectData) {
        return projectData.canBeUsed() && (this.allowMaster || !projectData.isMaster()) && !this.currentProjectIds.contains(new Long(projectData.getUniqueId()));
    }

    private class OpenProjectListSelectionModel
    extends DefaultListSelectionModel {
        private OpenProjectListSelectionModel() {
        }

        @Override
        public void setSelectionInterval(int n, int n2) {
            if (n != n2) {
                return;
            }
            ProjectData projectData = (ProjectData)OpenProjectDialog.this.projects.get(n);
            if (!OpenProjectDialog.this.allowMaster && projectData.isMaster()) {
                OpenProjectDialog.this.ok.setEnabled(false);
                if (OpenProjectDialog.this.openReadOnly != null) {
                    OpenProjectDialog.this.openReadOnly.setEnabled(false);
                }
                OpenProjectDialog.this.resourcePoolMessage.setVisible(true);
            } else {
                OpenProjectDialog.this.resourcePoolMessage.setVisible(false);
                OpenProjectDialog.this.ok.setEnabled(OpenProjectDialog.this.canBeUsed(projectData));
                if (OpenProjectDialog.this.allowOpenAs && OpenProjectDialog.this.openReadOnly != null) {
                    OpenProjectDialog.this.openReadOnly.setEnabled(!projectData.isMaster());
                } else if (!OpenProjectDialog.this.canBeUsed(projectData)) {
                    this.clearSelection();
                    return;
                }
            }
            super.setSelectionInterval(n, n2);
        }
    }

    private class OpenProjectableColumnModel
    extends DefaultTableColumnModel {
        protected int columnIndex = 0;

        @Override
        public void addColumn(TableColumn tableColumn) {
            switch (this.columnIndex) {
                case 0: {
                    tableColumn.setHeaderValue(Messages.getString("OpenProjectDialog.Name"));
                    tableColumn.setPreferredWidth(250);
                    break;
                }
                case 1: {
                    tableColumn.setHeaderValue(Messages.getString("OpenProjectDialog.LockedBy"));
                    tableColumn.setPreferredWidth(150);
                    break;
                }
                case 2: {
                    tableColumn.setHeaderValue(Messages.getString("OpenProjectDialog.ModificationDate"));
                    tableColumn.setPreferredWidth(100);
                    break;
                }
                case 3: {
                    tableColumn.setHeaderValue(Messages.getString("OpenProjectDialog.CreationDate"));
                    tableColumn.setPreferredWidth(100);
                    break;
                }
            }
            tableColumn.setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    ProjectData projectData = (ProjectData)OpenProjectDialog.this.projects.get(n);
                    this.setEnabled(jTable == null || jTable.isEnabled());
                    this.setForeground(OpenProjectDialog.this.canBeUsed(projectData) ? Color.BLACK : Color.GRAY);
                    super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    return this;
                }
            });
            super.addColumn(tableColumn);
            ++this.columnIndex;
        }

        @Override
        public void moveColumn(int n, int n2) {
        }
    }

    private class OpenProjectTableModel
    extends AbstractTableModel {
        private OpenProjectTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return OpenProjectDialog.this.projects.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ProjectData projectData = (ProjectData)OpenProjectDialog.this.projects.get(n);
            switch (n2) {
                case 0: {
                    return projectData.getName();
                }
                case 1: {
                    return projectData.getLockerInfo();
                }
                case 2: {
                    return FieldConverter.toString(projectData.getLastModificationDate());
                }
                case 3: {
                    if (projectData.isMaster()) {
                        return null;
                    }
                    return FieldConverter.toString(projectData.getCreationDate());
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }

        public void update() {
            this.fireTableDataChanged();
        }
    }

    private static class HeaderRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        public HeaderRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader;
            this.setEnabled(jTable == null || jTable.isEnabled());
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
                this.setFont(jTableHeader.getFont());
            }
            this.setText(object == null ? "" : object.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }

    private class OpenProjectTable
    extends JTable {
        OpenProjectDialog dialog;

        public OpenProjectTable(OpenProjectDialog openProjectDialog2) {
            super(new OpenProjectTableModel(), new OpenProjectableColumnModel());
            this.dialog = openProjectDialog2;
            this.getTableHeader().setDefaultRenderer(new HeaderRenderer());
            this.registerEditors();
            this.createDefaultColumnsFromModel();
            this.setSelectionModel(new OpenProjectListSelectionModel());
            this.setSelectionMode(0);
            this.addMouseListener();
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        OpenProjectDialog.this.onCancel();
                    } else if (keyEvent.getKeyCode() == 10) {
                        OpenProjectDialog.this.onOk();
                    }
                }
            });
            if (Environment.isMac()) {
                this.setGridColor(Color.LIGHT_GRAY);
            }
        }

        protected void registerEditors() {
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.getTableHeader().setEnabled(bl);
        }

        private void addMouseListener() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isConsumed() && mouseEvent.getClickCount() == 2) {
                        Point point = mouseEvent.getPoint();
                        int n = OpenProjectTable.this.rowAtPoint(point);
                        int n2 = OpenProjectTable.this.columnAtPoint(point);
                        if (OpenProjectDialog.this.allowOpenAs || OpenProjectDialog.this.canBeUsed((ProjectData)OpenProjectDialog.this.projects.get(n))) {
                            OpenProjectTable.this.dialog.onOk();
                        }
                    }
                }
            });
        }
    }
}

