/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.network.layout;

import com.projity.document.ObjectEvent;
import com.projity.graphic.configuration.BarStyles;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.model.event.CompositeCacheEvent;
import com.projity.pm.graphic.network.NetworkParams;
import com.projity.pm.graphic.network.layout.NetworkLayout;
import com.projity.pm.graphic.network.layout.NetworkLayoutEvent;
import com.projity.pm.graphic.network.layout.NetworkLayoutListener;
import com.projity.pm.scheduling.ScheduleEvent;
import java.awt.Rectangle;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public abstract class AbstractNetworkLayout
implements NetworkLayout {
    protected NodeModelCache cache;
    protected BarStyles barStyles;
    protected Rectangle bounds;
    protected NetworkParams network;
    protected EventListenerList listenerList = new EventListenerList();

    public AbstractNetworkLayout(NetworkParams networkParams) {
        this.network = networkParams;
        this.addNetworkLayoutListener(networkParams);
    }

    @Override
    public void setCache(NodeModelCache nodeModelCache) {
        this.cache = nodeModelCache;
        this.bounds = new Rectangle();
    }

    @Override
    public void setBarStyles(BarStyles barStyles) {
        this.barStyles = barStyles;
    }

    @Override
    public abstract void updateBounds();

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    protected void setEmpty() {
        this.bounds.setSize(0, 0);
    }

    protected boolean isEmpty() {
        return this.bounds.isEmpty();
    }

    @Override
    public void scheduleChanged(ScheduleEvent scheduleEvent) {
    }

    @Override
    public void objectChanged(ObjectEvent objectEvent) {
    }

    @Override
    public void graphicNodesCompositeEvent(CompositeCacheEvent compositeCacheEvent) {
    }

    @Override
    public void addNetworkLayoutListener(NetworkLayoutListener networkLayoutListener) {
        this.listenerList.add(NetworkLayoutListener.class, networkLayoutListener);
    }

    @Override
    public void removeNetworkLayoutListener(NetworkLayoutListener networkLayoutListener) {
        this.listenerList.remove(NetworkLayoutListener.class, networkLayoutListener);
    }

    @Override
    public NetworkLayoutListener[] getNetworkLayoutListeners() {
        return (NetworkLayoutListener[])this.listenerList.getListeners(NetworkLayoutListener.class);
    }

    protected void fireLayoutChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        NetworkLayoutEvent networkLayoutEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != NetworkLayoutListener.class) continue;
            if (networkLayoutEvent == null) {
                networkLayoutEvent = new NetworkLayoutEvent(this);
            }
            ((NetworkLayoutListener)objectArray[i + 1]).layoutChanged(networkLayoutEvent);
        }
    }

    @Override
    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }
}

