/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet.time;

import com.projity.field.Field;
import com.projity.graphic.configuration.ActionList;
import com.projity.graphic.configuration.CellStyle;
import com.projity.graphic.configuration.GraphicConfiguration;
import com.projity.graphic.configuration.shape.Colors;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.model.event.CompositeCacheEvent;
import com.projity.pm.graphic.spreadsheet.common.CommonSpreadSheet;
import com.projity.pm.graphic.spreadsheet.common.CommonSpreadSheetModel;
import com.projity.pm.graphic.spreadsheet.selection.SpreadSheetListSelectionModel;
import com.projity.pm.graphic.spreadsheet.selection.SpreadSheetSelectionModel;
import com.projity.pm.graphic.spreadsheet.time.TimeSpreadSheetColumnModel;
import com.projity.pm.graphic.spreadsheet.time.TimeSpreadSheetModel;
import com.projity.pm.graphic.spreadsheet.time.TimeSpreadSheetRowHeaderColumnModel;
import com.projity.pm.graphic.timescale.CoordinatesConverter;
import com.projity.pm.graphic.timescale.ScaledComponent;
import com.projity.pm.task.Project;
import com.projity.timescale.TimeScaleListener;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TimeSpreadSheet
extends CommonSpreadSheet
implements ScaledComponent {
    protected Project project;
    protected ArrayList fieldArray;

    public TimeSpreadSheet(Project project) {
        this.setTableHeader(null);
        this.project = project;
    }

    public void setCache(NodeModelCache nodeModelCache, ArrayList arrayList, CellStyle cellStyle, ActionList actionList) {
        TimeSpreadSheetModel timeSpreadSheetModel = new TimeSpreadSheetModel(nodeModelCache, arrayList, cellStyle, actionList);
        this.setModel(timeSpreadSheetModel, new TimeSpreadSheetColumnModel(this));
    }

    @Override
    public void setFieldArray(ArrayList arrayList) {
        ((TimeSpreadSheetModel)this.getModel()).setFieldArray(arrayList);
        ((TimeSpreadSheetModel)this.getModel()).resetSelectedFieldArray();
    }

    public void setSelectedFieldArray(ArrayList arrayList) {
        ((TimeSpreadSheetModel)this.getModel()).setSelectedFieldArray(arrayList);
    }

    public final ArrayList getSelectedFieldArray() {
        return ((TimeSpreadSheetModel)this.getModel()).getSelectedFieldArray();
    }

    public void selectFieldArray(Field field) {
        ((TimeSpreadSheetModel)this.getModel()).selectFieldArray(field);
    }

    public void setModel(CommonSpreadSheetModel commonSpreadSheetModel, DefaultTableColumnModel defaultTableColumnModel) {
        TableModel tableModel = this.getModel();
        this.setModel(commonSpreadSheetModel);
        this.setColumnModel(defaultTableColumnModel);
        this.selection = new SpreadSheetSelectionModel(this);
        this.selection.setRowSelection(new SpreadSheetListSelectionModel(this.selection, true));
        this.selection.setColumnSelection(new SpreadSheetListSelectionModel(this.selection, false));
        this.setSelectionModel(this.selection.getRowSelection());
        this.getColumnModel().setSelectionModel(this.selection.getColumnSelection());
        this.registerEditors(true);
        this.initRowHeader(commonSpreadSheetModel);
        this.initModel();
        this.initListeners();
        if (tableModel != commonSpreadSheetModel && tableModel instanceof CommonSpreadSheetModel) {
            ((CommonSpreadSheetModel)this.getModel()).getCache().removeNodeModelListener(this);
        }
        commonSpreadSheetModel.getCache().addNodeModelListener(this);
    }

    @Override
    public void cleanUp() {
        ((TimeSpreadSheetModel)this.getModel()).getCache().removeNodeModelListener(this);
        this.getCoord().removeTimeScaleListener((TimeScaleListener)((Object)this.getColumnModel()));
        this.getCoord().removeTimeScaleListener((TimeScaleListener)((Object)this.getColumnModel()));
        super.cleanUp();
    }

    @Override
    protected void initRowHeader(CommonSpreadSheetModel commonSpreadSheetModel) {
        this.rowHeader.setModel(commonSpreadSheetModel, new TimeSpreadSheetRowHeaderColumnModel());
        this.rowHeader.createDefaultColumnsFromModel();
        GraphicConfiguration graphicConfiguration = GraphicConfiguration.getInstance();
        this.rowHeader.setRowHeight(graphicConfiguration.getRowHeight());
    }

    public Project getProject() {
        return this.project;
    }

    @Override
    public CoordinatesConverter getCoord() {
        TimeSpreadSheetModel timeSpreadSheetModel = (TimeSpreadSheetModel)this.getModel();
        return timeSpreadSheetModel.getCoord();
    }

    @Override
    public void setCoord(CoordinatesConverter coordinatesConverter) {
        TimeSpreadSheetModel timeSpreadSheetModel = (TimeSpreadSheetModel)this.getModel();
        timeSpreadSheetModel.setCoord(coordinatesConverter);
        TimeSpreadSheetColumnModel timeSpreadSheetColumnModel = (TimeSpreadSheetColumnModel)this.getColumnModel();
        timeSpreadSheetColumnModel.setCoord(coordinatesConverter);
    }

    @Override
    public void createDefaultColumnsFromModel() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (tableColumnModel != null && tableColumnModel instanceof TimeSpreadSheetColumnModel) {
            ((TimeSpreadSheetColumnModel)tableColumnModel).updateColumns();
        }
    }

    public Class getRowClass(int n) {
        return ((TimeSpreadSheetModel)this.getModel()).getRowClass(n);
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (this.getModel() instanceof TimeSpreadSheetModel) {
            return this.getDefaultRenderer(this.getRowClass(n));
        }
        return super.getCellRenderer(n, n2);
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        if (this.getModel() instanceof TimeSpreadSheetModel) {
            return this.getDefaultEditor(this.getRowClass(n));
        }
        return super.getCellEditor(n, n2);
    }

    @Override
    public void graphicNodesCompositeEvent(CompositeCacheEvent compositeCacheEvent) {
        super.graphicNodesCompositeEvent(compositeCacheEvent);
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.getRowHeight() * this.getRowCount()));
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (!this.getModel().isCellEditable(n, n2 + 1)) {
            component.setBackground(Colors.LIGHT_GRAY);
        }
        return component;
    }
}

