/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionExtension;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompletionContributor {
    private final MultiMap<CompletionType, Pair<ElementPattern<? extends PsiElement>, CompletionProvider<CompletionParameters>>> myMap = new MultiMap();
    private static final LanguageExtension<CompletionContributor> INSTANCE = new CompletionExtension<CompletionContributor>("com.intellij.completion.contributor");

    public final void extend(@Nullable CompletionType type, @NotNull ElementPattern<? extends PsiElement> place, CompletionProvider<CompletionParameters> provider) {
        if (place == null) {
            CompletionContributor.$$$reportNull$$$0(0);
        }
        this.myMap.putValue((Object)type, (Object)new Pair(place, provider));
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        ProcessingContext context;
        if (parameters == null) {
            CompletionContributor.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            CompletionContributor.$$$reportNull$$$0(2);
        }
        for (Pair pair : this.myMap.get((Object)parameters.getCompletionType())) {
            ProgressManager.checkCanceled();
            context = new ProcessingContext();
            if (!((ElementPattern)pair.first).accepts(parameters.getPosition(), context)) continue;
            ((CompletionProvider)pair.second).addCompletionVariants(parameters, context, result2);
            if (!result2.isStopped()) continue;
            return;
        }
        for (Pair pair : this.myMap.get(null)) {
            context = new ProcessingContext();
            if (!((ElementPattern)pair.first).accepts(parameters.getPosition(), context)) continue;
            ((CompletionProvider)pair.second).addCompletionVariants(parameters, context, result2);
            if (!result2.isStopped()) continue;
            return;
        }
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            CompletionContributor.$$$reportNull$$$0(3);
        }
    }

    @Nullable
    public String advertise(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            CompletionContributor.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Nullable
    public String handleEmptyLookup(@NotNull CompletionParameters parameters, Editor editor) {
        if (parameters == null) {
            CompletionContributor.$$$reportNull$$$0(5);
        }
        return null;
    }

    @Nullable
    public AutoCompletionDecision handleAutoCompletionPossibility(@NotNull AutoCompletionContext context) {
        if (context == null) {
            CompletionContributor.$$$reportNull$$$0(6);
        }
        return null;
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        if (position == null) {
            CompletionContributor.$$$reportNull$$$0(7);
        }
        return false;
    }

    public void duringCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            CompletionContributor.$$$reportNull$$$0(8);
        }
    }

    @NotNull
    protected static String getActionShortcut(@NonNls @NotNull String actionId) {
        if (actionId == null) {
            CompletionContributor.$$$reportNull$$$0(9);
        }
        String string = KeymapUtil.getFirstKeyboardShortcutText(ActionManager.getInstance().getAction(actionId));
        if (string == null) {
            CompletionContributor.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static List<CompletionContributor> forParameters(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            CompletionContributor.$$$reportNull$$$0(11);
        }
        List list = (List)ReadAction.compute(() -> {
            if (parameters == null) {
                CompletionContributor.$$$reportNull$$$0(18);
            }
            PsiElement position = parameters.getPosition();
            return CompletionContributor.forLanguageHonorDumbness(PsiUtilCore.getLanguageAtOffset(position.getContainingFile(), parameters.getOffset()), position.getProject());
        });
        if (list == null) {
            CompletionContributor.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public static List<CompletionContributor> forLanguage(@NotNull Language language) {
        if (language == null) {
            CompletionContributor.$$$reportNull$$$0(13);
        }
        List<CompletionContributor> list = INSTANCE.forKey(language);
        if (list == null) {
            CompletionContributor.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public static List<CompletionContributor> forLanguageHonorDumbness(@NotNull Language language, @NotNull Project project) {
        if (language == null) {
            CompletionContributor.$$$reportNull$$$0(15);
        }
        if (project == null) {
            CompletionContributor.$$$reportNull$$$0(16);
        }
        List<CompletionContributor> list = DumbService.getInstance(project).filterByDumbAwareness(CompletionContributor.forLanguage(language));
        if (list == null) {
            CompletionContributor.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionContributor";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionContributor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionShortcut";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "forParameters";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguage";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguageHonorDumbness";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extend";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "beforeCompletion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "advertise";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleEmptyLookup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleAutoCompletionPossibility";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invokeAutoPopup";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "duringCompletion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getActionShortcut";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 17: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "forParameters";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "forLanguage";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "forLanguageHonorDumbness";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$forParameters$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

