/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorSettingsPages;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class JumpToColorsAndFontsAction
extends DumbAwareAction {
    public JumpToColorsAndFontsAction() {
        this.setInjectedContext(true);
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        e.getPresentation().setEnabledAndVisible(project != null && editor != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (project == null || editor == null) {
            return;
        }
        HashMap keyMap = ContainerUtil.newHashMap();
        Processor processor2 = r -> {
            Pair p;
            HighlightInfo info = HighlightInfo.fromRangeHighlighter(r);
            TextAttributesKey key = info != null ? (TextAttributesKey)ObjectUtils.chooseNotNull((Object)info.forcedTextAttributesKey, (Object)info.type.getAttributesKey()) : null;
            Pair pair = p = key == null ? null : ColorSettingsPages.getInstance().getAttributeDescriptor(key);
            if (p != null) {
                keyMap.put(key, p);
            }
            return true;
        };
        JBIterable editors = editor instanceof EditorWindow ? JBIterable.of((Object[])new Editor[]{editor, ((EditorWindow)editor).getDelegate()}) : JBIterable.of((Object)editor);
        block0: for (Editor ed : editors) {
            TextRange selection = EditorUtil.getSelectionInAnyMode(ed);
            MarkupModel forDocument = DocumentMarkupModel.forDocument(ed.getDocument(), project, false);
            if (forDocument != null) {
                ((MarkupModelEx)forDocument).processRangeHighlightersOverlappingWith(selection.getStartOffset(), selection.getEndOffset(), (Processor<? super RangeHighlighterEx>)processor2);
            }
            ((MarkupModelEx)ed.getMarkupModel()).processRangeHighlightersOverlappingWith(selection.getStartOffset(), selection.getEndOffset(), (Processor<? super RangeHighlighterEx>)processor2);
            EditorHighlighter highlighter = ed instanceof EditorEx ? ((EditorEx)ed).getHighlighter() : null;
            SyntaxHighlighter syntaxHighlighter = highlighter instanceof LexerEditorHighlighter ? ((LexerEditorHighlighter)highlighter).getSyntaxHighlighter() : null;
            if (syntaxHighlighter == null) continue;
            HighlighterIterator iterator = highlighter.createIterator(selection.getStartOffset());
            while (!iterator.atEnd()) {
                for (TextAttributesKey key : syntaxHighlighter.getTokenHighlights(iterator.getTokenType())) {
                    Pair p2;
                    Pair pair = p2 = key == null ? null : ColorSettingsPages.getInstance().getAttributeDescriptor(key);
                    if (p2 == null) continue;
                    keyMap.put(key, p2);
                }
                if (iterator.getEnd() >= selection.getEndOffset()) continue block0;
                iterator.advance();
            }
        }
        if (keyMap.isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, "No text attributes found");
        } else if (keyMap.size() == 1) {
            Pair p3 = (Pair)keyMap.values().iterator().next();
            if (!JumpToColorsAndFontsAction.openSettingsAndSelectKey(project, (ColorAndFontDescriptorsProvider)p3.first, (AttributesDescriptor)p3.second)) {
                HintManager.getInstance().showErrorHint(editor, "No appropriate settings page found");
            }
        } else {
            ArrayList attrs = ContainerUtil.newArrayList(keyMap.values());
            Collections.sort(attrs, (o1, o2) -> StringUtil.naturalCompare((String)(((ColorAndFontDescriptorsProvider)o1.first).getDisplayName() + ((AttributesDescriptor)o1.second).getDisplayName()), (String)(((ColorAndFontDescriptorsProvider)o2.first).getDisplayName() + ((AttributesDescriptor)o2.second).getDisplayName())));
            final EditorColorsScheme colorsScheme = editor.getColorsScheme();
            ColoredListCellRenderer<Pair<ColorAndFontDescriptorsProvider, AttributesDescriptor>> renderer = new ColoredListCellRenderer<Pair<ColorAndFontDescriptorsProvider, AttributesDescriptor>>(){

                protected void customizeCellRenderer(@NotNull JList<? extends Pair<ColorAndFontDescriptorsProvider, AttributesDescriptor>> list2, Pair<ColorAndFontDescriptorsProvider, AttributesDescriptor> value, int index, boolean selected, boolean hasFocus) {
                    boolean addBoxed;
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    TextAttributes ta = colorsScheme.getAttributes(((AttributesDescriptor)value.second).getKey());
                    Color fg = (Color)ObjectUtils.chooseNotNull((Object)ta.getForegroundColor(), (Object)colorsScheme.getDefaultForeground());
                    Color bg = (Color)ObjectUtils.chooseNotNull((Object)ta.getBackgroundColor(), (Object)colorsScheme.getDefaultBackground());
                    SimpleTextAttributes sa = SimpleTextAttributes.fromTextAttributes((TextAttributes)ta);
                    SimpleTextAttributes saOpaque = sa.derive(0x100 | sa.getStyle(), fg, bg, null);
                    SimpleTextAttributes saSelected = SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(sa.getStyle(), null, null, null);
                    SimpleTextAttributes saCur = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    List split = StringUtil.split((String)(((ColorAndFontDescriptorsProvider)value.first).getDisplayName() + "//" + ((AttributesDescriptor)value.second).getDisplayName()), (String)"//");
                    int len = split.size();
                    for (int i = 0; i < len; ++i) {
                        boolean last;
                        boolean bl = last = i == len - 1;
                        SimpleTextAttributes simpleTextAttributes = !last ? SimpleTextAttributes.REGULAR_ATTRIBUTES : (saCur = selected ? saSelected : saOpaque);
                        if (last) {
                            this.append(" ", saCur);
                        }
                        this.append((String)split.get(i), saCur);
                        if (last) {
                            this.append(" ", saCur);
                            continue;
                        }
                        this.append(" > ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                    Color stripeColor = ta.getErrorStripeColor();
                    boolean addStripe = stripeColor != null && stripeColor != saCur.getBgColor();
                    boolean bl = addBoxed = ta.getEffectType() == EffectType.BOXED && ta.getEffectColor() != null;
                    if (addBoxed) {
                        this.append("\u25a2" + (addStripe ? "" : " "), saCur.derive(-1, ta.getEffectColor(), null, null));
                    }
                    if (addStripe) {
                        this.append(" ", saCur.derive(256, null, stripeColor, null));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/application/options/colors/JumpToColorsAndFontsAction$1", "customizeCellRenderer"));
                }
            };
            JBPopupFactory.getInstance().createPopupChooserBuilder((List)attrs).setRenderer((ListCellRenderer)renderer).setTitle(StringUtil.notNullize((String)e.getPresentation().getText())).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(p -> {
                if (!JumpToColorsAndFontsAction.openSettingsAndSelectKey(project, (ColorAndFontDescriptorsProvider)p.first, (AttributesDescriptor)p.second)) {
                    HintManager.getInstance().showErrorHint(editor, "No appropriate settings page found");
                }
            }).createPopup().showInBestPositionFor(editor);
        }
    }

    private static boolean openSettingsAndSelectKey(@NotNull Project project, @NotNull ColorAndFontDescriptorsProvider page, @NotNull AttributesDescriptor descriptor2) {
        if (project == null) {
            JumpToColorsAndFontsAction.$$$reportNull$$$0(0);
        }
        if (page == null) {
            JumpToColorsAndFontsAction.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            JumpToColorsAndFontsAction.$$$reportNull$$$0(2);
        }
        return ColorAndFontOptions.selectOrEditColor(id -> {
            if (project == null) {
                JumpToColorsAndFontsAction.$$$reportNull$$$0(3);
            }
            return CommonDataKeys.PROJECT.is(id) ? project : null;
        }, descriptor2.getDisplayName(), page.getDisplayName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "page";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/colors/JumpToColorsAndFontsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "openSettingsAndSelectKey";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$openSettingsAndSelectKey$3";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

