/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.BuildConsoleView;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.ExecutionNode;
import com.intellij.build.ExecutionNodeProgressAnimator;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.FileMessageEvent;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.build.events.FinishEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.ProgressBuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.StartEvent;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SideBorder;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildTreeConsoleView
implements ConsoleView,
DataProvider,
BuildConsoleView {
    private static final Logger LOG = Logger.getInstance(BuildTreeConsoleView.class);
    @NonNls
    private static final String TREE = "tree";
    private final JPanel myPanel = new JPanel();
    private final SimpleTreeBuilder myBuilder;
    private final Map<Object, ExecutionNode> nodesMap = ContainerUtil.newConcurrentMap();
    private final ExecutionNodeProgressAnimator myProgressAnimator;
    private final Project myProject;
    private final SimpleTreeStructure myTreeStructure;
    private final DetailsHandler myDetailsHandler;
    private final TableColumn myTimeColumn;
    private final String myWorkingDir;
    private volatile int myTimeColumnWidth;
    private final AtomicBoolean myDisposed = new AtomicBoolean();
    private final TransferToEDTQueue<Runnable> myLaterInvocator = TransferToEDTQueue.createRunnableMerger((String)"BuildTreeConsoleView later invocator");

    public BuildTreeConsoleView(Project project, BuildDescriptor buildDescriptor) {
        this.myProject = project;
        this.myWorkingDir = FileUtil.toSystemIndependentName((String)buildDescriptor.getWorkingDir());
        ColumnInfo[] COLUMNS = new ColumnInfo[]{new TreeColumnInfo("name"), new ColumnInfo("time elapsed"){

            @Nullable
            public Object valueOf(Object o) {
                Object userObject;
                if (o instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)o).getUserObject()) instanceof ExecutionNode) {
                    String duration = ((ExecutionNode)((Object)userObject)).getDuration();
                    BuildTreeConsoleView.this.updateTimeColumnWidth("___" + duration, false);
                    return duration;
                }
                return null;
            }
        }};
        ExecutionNode rootNode = new ExecutionNode(this.myProject, null);
        rootNode.setAutoExpandNode(true);
        ListTreeTableModelOnColumns model = new ListTreeTableModelOnColumns((TreeNode)new DefaultMutableTreeNode((Object)rootNode), COLUMNS);
        final DefaultTableCellRenderer timeColumnCellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setHorizontalAlignment(4);
                Color fg = isSelected ? UIUtil.getTreeSelectionForeground() : SimpleTextAttributes.GRAY_ATTRIBUTES.getFgColor();
                this.setForeground(fg);
                return this;
            }
        };
        final TreeTable treeTable = new TreeTable((TreeTableModel)model){

            public TableCellRenderer getCellRenderer(int row, int column) {
                if (column == 1) {
                    return timeColumnCellRenderer;
                }
                return super.getCellRenderer(row, column);
            }
        };
        EditSourceOnDoubleClickHandler.install((TreeTable)treeTable);
        EditSourceOnEnterKeyHandler.install((JComponent)treeTable, null);
        TreeTableTree tree = treeTable.getTree();
        final TreeCellRenderer treeCellRenderer = tree.getCellRenderer();
        tree.setCellRenderer(new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component rendererComponent = treeCellRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                if (rendererComponent instanceof SimpleColoredComponent) {
                    Color fg;
                    Color bg = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
                    Color color = fg = selected ? UIUtil.getTreeSelectionForeground() : UIUtil.getTreeForeground();
                    if (selected) {
                        SimpleColoredComponent.ColoredIterator it = ((SimpleColoredComponent)rendererComponent).iterator();
                        while (it.hasNext()) {
                            it.next();
                            int offset = it.getOffset();
                            int endOffset = it.getEndOffset();
                            SimpleTextAttributes currentAttributes = it.getTextAttributes();
                            SimpleTextAttributes newAttributes = new SimpleTextAttributes(bg, fg, currentAttributes.getWaveColor(), currentAttributes.getStyle());
                            it.split(endOffset - offset, newAttributes);
                        }
                    }
                    SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)treeTable, (SimpleColoredComponent)((SimpleColoredComponent)rendererComponent), (boolean)true, (boolean)selected);
                }
                return rendererComponent;
            }
        });
        new TreeTableSpeedSearch(treeTable).setComparator(new SpeedSearchComparator(false));
        treeTable.setTableHeader(null);
        this.myTimeColumn = treeTable.getColumnModel().getColumn(1);
        this.myTimeColumn.setResizable(false);
        this.updateTimeColumnWidth("Running for " + StringUtil.formatDuration((long)11111L), true);
        TreeUtil.installActions((JTree)tree);
        this.myTreeStructure = new SimpleTreeStructure.Impl((SimpleNode)rootNode);
        this.myBuilder = new SimpleTreeBuilder((JTree)tree, (DefaultTreeModel)model, (AbstractTreeStructure)this.myTreeStructure, null);
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        this.myBuilder.initRootNode();
        this.myBuilder.updateFromRoot();
        JPanel myContentPanel = new JPanel();
        myContentPanel.setLayout(new CardLayout());
        myContentPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)treeTable, (int)1), TREE);
        this.myPanel.setLayout(new BorderLayout());
        ThreeComponentsSplitter myThreeComponentsSplitter = new ThreeComponentsSplitter(){

            public void doLayout() {
                super.doLayout();
                JComponent detailsComponent = BuildTreeConsoleView.this.myDetailsHandler.getComponent();
                if (detailsComponent != null && detailsComponent.isVisible()) {
                    int firstSize = this.getFirstSize();
                    int lastSize = this.getLastSize();
                    if (firstSize == 0 && lastSize == 0) {
                        int width = Math.round((float)this.getWidth() / 2.0f);
                        this.setFirstSize(width);
                    }
                }
            }
        };
        Disposer.register((Disposable)this, (Disposable)myThreeComponentsSplitter);
        myThreeComponentsSplitter.setFirstComponent((JComponent)myContentPanel);
        this.myDetailsHandler = new DetailsHandler(this.myProject, tree, myThreeComponentsSplitter);
        myThreeComponentsSplitter.setLastComponent(this.myDetailsHandler.getComponent());
        this.myPanel.add((Component)myThreeComponentsSplitter, "Center");
        this.myProgressAnimator = new ExecutionNodeProgressAnimator(this);
    }

    private ExecutionNode getRootElement() {
        return (ExecutionNode)((Object)this.myTreeStructure.getRootElement());
    }

    public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        if (text2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(0);
        }
        if (contentType == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(1);
        }
    }

    public void clear() {
        this.getRootElement().removeChildren();
        this.nodesMap.clear();
        this.myDetailsHandler.clear();
        this.myBuilder.queueUpdate();
    }

    public void scrollTo(int offset) {
    }

    public void attachToProcess(ProcessHandler processHandler2) {
    }

    public void setOutputPaused(boolean value) {
    }

    public boolean isOutputPaused() {
        return false;
    }

    public boolean hasDeferredOutput() {
        return false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(2);
        }
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(3);
        }
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(4);
        }
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        if (hyperlinkText == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(5);
        }
    }

    public int getContentSize() {
        return 0;
    }

    public boolean canPause() {
        return false;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        if (AnAction.EMPTY_ARRAY == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(6);
        }
        return AnAction.EMPTY_ARRAY;
    }

    public void allowHeavyFilters() {
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myBuilder.getTree();
    }

    public void dispose() {
        this.myDisposed.set(true);
    }

    public boolean isDisposed() {
        return this.myDisposed.get();
    }

    public void onEvent(BuildEvent event) {
        ExecutionNode parentNode = event.getParentId() == null ? null : this.nodesMap.get(event.getParentId());
        ExecutionNode currentNode = this.nodesMap.get(event.getId());
        if (event instanceof StartEvent || event instanceof MessageEvent) {
            MessageEvent messageEvent;
            ExecutionNode rootElement = this.getRootElement();
            if (currentNode == null) {
                if (event instanceof StartBuildEvent) {
                    currentNode = rootElement;
                } else {
                    if (event instanceof MessageEvent) {
                        messageEvent = (MessageEvent)event;
                        parentNode = this.createMessageParentNodes(messageEvent, parentNode);
                    }
                    currentNode = new ExecutionNode(this.myProject, parentNode);
                }
            } else {
                LOG.warn("start event id collision found");
                return;
            }
            currentNode.setAutoExpandNode(currentNode == rootElement || parentNode == rootElement);
            this.nodesMap.put(event.getId(), currentNode);
            if (parentNode != null) {
                parentNode.add(currentNode);
            }
            if (event instanceof StartBuildEvent) {
                String buildTitle = ((StartBuildEvent)event).getBuildTitle();
                currentNode.setTitle(buildTitle);
                currentNode.setAutoExpandNode(true);
                this.myProgressAnimator.startMovie();
            } else if (event instanceof MessageEvent) {
                messageEvent = (MessageEvent)event;
                currentNode.setStartTime(messageEvent.getEventTime());
                currentNode.setEndTime(messageEvent.getEventTime());
                currentNode.setNavigatable(messageEvent.getNavigatable(this.myProject));
                MessageEventResult messageEventResult = messageEvent.getResult();
                currentNode.setResult((EventResult)messageEventResult);
            }
        } else {
            currentNode = this.nodesMap.get(event.getId());
            if (currentNode == null && event instanceof ProgressBuildEvent) {
                currentNode = new ExecutionNode(this.myProject, parentNode);
                this.nodesMap.put(event.getId(), currentNode);
                if (parentNode != null) {
                    parentNode.add(currentNode);
                }
            }
        }
        if (currentNode == null) {
            return;
        }
        currentNode.setName(event.getMessage());
        currentNode.setHint(event.getHint());
        if (currentNode.getStartTime() == 0L) {
            currentNode.setStartTime(event.getEventTime());
        }
        if (event instanceof FinishEvent) {
            currentNode.setEndTime(event.getEventTime());
            currentNode.setResult(((FinishEvent)event).getResult());
            int timeColumnWidth = new JLabel((String)new StringBuilder().append((String)"__").append((String)currentNode.getDuration()).toString(), (int)4).getPreferredSize().width;
            if (this.myTimeColumnWidth < timeColumnWidth) {
                this.myTimeColumnWidth = timeColumnWidth;
            }
        } else {
            this.scheduleUpdate(currentNode);
            if (event instanceof StartEvent) {
                this.myProgressAnimator.addNode(currentNode);
            }
        }
        if (event instanceof FinishBuildEvent) {
            JTree tree;
            String aHint = event.getHint();
            String time = DateFormatUtil.formatDateTime((long)event.getEventTime());
            aHint = aHint == null ? "  at " + time : aHint + "  at " + time;
            currentNode.setHint(aHint);
            this.updateTimeColumnWidth(this.myTimeColumnWidth);
            if (this.myDetailsHandler.myExecutionNode == null) {
                this.myDetailsHandler.setNode(this.getRootElement());
            }
            if (((FinishBuildEvent)event).getResult() instanceof FailureResult && (tree = this.myBuilder.getTree()) != null && !tree.isRootVisible()) {
                ExecutionNode rootElement = this.getRootElement();
                ExecutionNode resultNode = new ExecutionNode(this.myProject, rootElement);
                resultNode.setName(StringUtil.toTitleCase((String)rootElement.getName()));
                resultNode.setHint(rootElement.getHint());
                resultNode.setEndTime(rootElement.getEndTime());
                resultNode.setStartTime(rootElement.getStartTime());
                resultNode.setResult(rootElement.getResult());
                resultNode.setTooltip(rootElement.getTooltip());
                rootElement.add(resultNode);
                this.scheduleUpdate(resultNode);
            }
            this.myProgressAnimator.stopMovie();
            this.myBuilder.updateFromRoot();
        }
    }

    void scheduleUpdate(ExecutionNode executionNode) {
        ExecutionNode node = executionNode.getParent() == null ? executionNode : executionNode.getParent();
        Update update = new Update((Object)node, (SimpleNode)node){
            final /* synthetic */ SimpleNode val$node;
            {
                this.val$node = simpleNode;
                super(arg0);
            }

            public void run() {
                BuildTreeConsoleView.this.myBuilder.queueUpdateFrom((Object)this.val$node, false, true);
            }
        };
        this.myLaterInvocator.offerIfAbsent((Object)update);
    }

    private ExecutionNode createMessageParentNodes(MessageEvent messageEvent, ExecutionNode parentNode) {
        Object messageEventParentId = messageEvent.getParentId();
        if (messageEventParentId == null) {
            return null;
        }
        String group = messageEvent.getGroup();
        String groupNodeId = group.hashCode() + messageEventParentId.toString();
        ExecutionNode messagesGroupNode = BuildTreeConsoleView.getOrCreateMessagesNode(messageEvent, groupNodeId, parentNode, null, group, true, null, null, this.nodesMap, this.myProject);
        EventResult groupNodeResult = messagesGroupNode.getResult();
        final MessageEvent.Kind eventKind = messageEvent.getKind();
        if (!(groupNodeResult instanceof MessageEventResult) || ((MessageEventResult)groupNodeResult).getKind().compareTo((Enum)eventKind) > 0) {
            messagesGroupNode.setResult((EventResult)new MessageEventResult(){

                public MessageEvent.Kind getKind() {
                    return eventKind;
                }
            });
        }
        if (messageEvent instanceof FileMessageEvent) {
            VirtualFile sourceRootForFile;
            VirtualFile ioFile;
            ExecutionNode fileParentNode = messagesGroupNode;
            FilePosition filePosition = ((FileMessageEvent)messageEvent).getFilePosition();
            String filePath = FileUtil.toSystemIndependentName((String)filePosition.getFile().getPath());
            String parentsPath = "";
            String relativePath = FileUtil.getRelativePath((String)this.myWorkingDir, (String)filePath, (char)'/');
            if (relativePath != null) {
                String nodeId = group.hashCode() + this.myWorkingDir;
                ExecutionNode workingDirNode = BuildTreeConsoleView.getOrCreateMessagesNode(messageEvent, nodeId, messagesGroupNode, this.myWorkingDir, null, false, () -> AllIcons.Nodes.Module, null, this.nodesMap, this.myProject);
                parentsPath = this.myWorkingDir;
                fileParentNode = workingDirNode;
            }
            if ((ioFile = VfsUtil.findFileByIoFile((File)new File(filePath), (boolean)false)) != null && (sourceRootForFile = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).getSourceRootForFile(ioFile)) != null && (relativePath = FileUtil.getRelativePath((String)parentsPath, (String)sourceRootForFile.getPath(), (char)'/')) != null) {
                parentsPath = parentsPath + "/" + relativePath;
                String contentRootNodeId = group.hashCode() + sourceRootForFile.getPath();
                fileParentNode = BuildTreeConsoleView.getOrCreateMessagesNode(messageEvent, contentRootNodeId, fileParentNode, relativePath, null, false, () -> ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).isInTestSourceContent(ioFile) ? AllIcons.Modules.TestRoot : AllIcons.Modules.SourceRoot, null, this.nodesMap, this.myProject);
            }
            String fileNodeId = group.hashCode() + filePath;
            relativePath = StringUtil.isEmpty((String)parentsPath) ? filePath : FileUtil.getRelativePath((String)parentsPath, (String)filePath, (char)'/');
            parentNode = BuildTreeConsoleView.getOrCreateMessagesNode(messageEvent, fileNodeId, fileParentNode, relativePath, null, false, () -> {
                VirtualFile file2 = VfsUtil.findFileByIoFile((File)filePosition.getFile(), (boolean)false);
                if (file2 != null) {
                    return file2.getFileType().getIcon();
                }
                return null;
            }, messageEvent.getNavigatable(this.myProject), this.nodesMap, this.myProject);
        } else {
            parentNode = messagesGroupNode;
        }
        if (eventKind == MessageEvent.Kind.ERROR || eventKind == MessageEvent.Kind.WARNING) {
            ExecutionNode p = parentNode;
            do {
                p.reportChildMessageKind(eventKind);
            } while ((p = p.getParent()) instanceof ExecutionNode);
        }
        return parentNode;
    }

    @NotNull
    private static ExecutionNode getOrCreateMessagesNode(MessageEvent messageEvent, String nodeId, ExecutionNode parentNode, String nodeName, String nodeTitle, boolean autoExpandNode, @Nullable Supplier<Icon> iconProvider, @Nullable Navigatable navigatable, Map<Object, ExecutionNode> nodesMap, Project project) {
        ExecutionNode node = nodesMap.get(nodeId);
        if (node == null) {
            node = new ExecutionNode(project, parentNode);
            node.setName(nodeName);
            node.setTitle(nodeTitle);
            if (autoExpandNode) {
                node.setAutoExpandNode(true);
            }
            node.setStartTime(messageEvent.getEventTime());
            node.setEndTime(messageEvent.getEventTime());
            if (iconProvider != null) {
                node.setIconProvider(iconProvider);
            }
            if (navigatable != null) {
                node.setNavigatable(navigatable);
            }
            parentNode.add(node);
            nodesMap.put(nodeId, node);
        }
        ExecutionNode executionNode = node;
        if (executionNode == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(7);
        }
        return executionNode;
    }

    public void hideRootNode() {
        UIUtil.invokeLaterIfNeeded(() -> {
            JTree tree = this.myBuilder.getTree();
            if (tree != null) {
                tree.setRootVisible(false);
                tree.setShowsRootHandles(true);
            }
        });
    }

    private void updateTimeColumnWidth(String text2, boolean force) {
        int timeColumnWidth = new JLabel((String)text2, (int)4).getPreferredSize().width;
        if (this.myTimeColumnWidth > timeColumnWidth) {
            timeColumnWidth = this.myTimeColumnWidth;
        }
        if (force || this.myTimeColumn.getMaxWidth() < timeColumnWidth || this.myTimeColumn.getWidth() < timeColumnWidth) {
            this.updateTimeColumnWidth(timeColumnWidth);
        }
    }

    private void updateTimeColumnWidth(int width) {
        this.myTimeColumn.setPreferredWidth(width);
        this.myTimeColumn.setMinWidth(width);
        this.myTimeColumn.setMaxWidth(width);
    }

    @Nullable
    public Object getData(String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.build.tool.window";
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.extractNavigatables();
        }
        return null;
    }

    private Object extractNavigatables() {
        ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
        for (ExecutionNode each : this.getSelectedNodes()) {
            List<Navigatable> navigatable = each.getNavigatables();
            navigatables.addAll(navigatable);
        }
        return navigatables.isEmpty() ? null : navigatables.toArray(new Navigatable[0]);
    }

    private ExecutionNode[] getSelectedNodes() {
        JTree tree = this.myBuilder.getTree();
        if (tree instanceof Tree) {
            DefaultMutableTreeNode[] selectedNodes = (DefaultMutableTreeNode[])((Tree)tree).getSelectedNodes(DefaultMutableTreeNode.class, null);
            return (ExecutionNode[])Arrays.stream(selectedNodes).map(DefaultMutableTreeNode::getUserObject).filter(userObject -> userObject instanceof ExecutionNode).map(ExecutionNode.class::cast).distinct().toArray(ExecutionNode[]::new);
        }
        return new ExecutionNode[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/BuildTreeConsoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/BuildTreeConsoleView";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateMessagesNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DetailsHandler {
        private final ThreeComponentsSplitter mySplitter;
        @Nullable
        private ExecutionNode myExecutionNode;
        private final ConsoleView myConsole;
        private final JPanel myPanel;

        public DetailsHandler(Project project, TreeTableTree tree, ThreeComponentsSplitter threeComponentsSplitter) {
            this.myConsole = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
            this.mySplitter = threeComponentsSplitter;
            this.myPanel = new JPanel(new BorderLayout());
            JComponent consoleComponent = this.myConsole.getComponent();
            AnAction[] consoleActions = this.myConsole.createConsoleActions();
            consoleComponent.setFocusable(true);
            Color editorBackground = EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
            consoleComponent.setBorder(new CompoundBorder(IdeBorderFactory.createBorder((int)4), (Border)new SideBorder(editorBackground, 1)));
            this.myPanel.add((Component)consoleComponent, "Center");
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("BuildResults", (ActionGroup)new DefaultActionGroup(consoleActions), false);
            this.myPanel.add((Component)toolbar.getComponent(), "East");
            this.myPanel.setVisible(false);
            tree.addTreeSelectionListener(e -> {
                TreePath path = e.getPath();
                if (path == null || !e.isAddedPath()) {
                    return;
                }
                TreePath selectionPath = tree.getSelectionPath();
                this.setNode(selectionPath != null ? (DefaultMutableTreeNode)selectionPath.getLastPathComponent() : null);
            });
            Disposer.register((Disposable)threeComponentsSplitter, (Disposable)this.myConsole);
        }

        public boolean setNode(@NotNull ExecutionNode node) {
            if (node == null) {
                DetailsHandler.$$$reportNull$$$0(0);
            }
            EventResult eventResult = node.getResult();
            boolean hasChanged = false;
            if (eventResult instanceof FailureResult) {
                this.myConsole.clear();
                List failures = ((FailureResult)eventResult).getFailures();
                if (failures.isEmpty()) {
                    return false;
                }
                Iterator iterator = failures.iterator();
                while (iterator.hasNext()) {
                    Failure failure = (Failure)iterator.next();
                    String text2 = (String)ObjectUtils.chooseNotNull((Object)failure.getDescription(), (Object)failure.getMessage());
                    if (text2 == null && failure.getError() != null) {
                        text2 = failure.getError().getMessage();
                    }
                    if (text2 == null) continue;
                    this.printDetails(failure, text2);
                    hasChanged = true;
                    if (!iterator.hasNext()) continue;
                    this.myConsole.print("\n\n", ConsoleViewContentType.NORMAL_OUTPUT);
                }
            } else if (eventResult instanceof MessageEventResult) {
                String details = ((MessageEventResult)eventResult).getDetails();
                if (details == null) {
                    return false;
                }
                if (details.isEmpty()) {
                    return false;
                }
                this.myConsole.clear();
                this.printDetails(null, details);
                hasChanged = true;
            }
            if (!hasChanged) {
                return false;
            }
            this.myConsole.scrollTo(0);
            int firstSize = this.mySplitter.getFirstSize();
            int lastSize = this.mySplitter.getLastSize();
            if (firstSize == 0 && lastSize == 0) {
                int width = Math.round((float)this.mySplitter.getWidth() / 2.0f);
                this.mySplitter.setFirstSize(width);
            }
            this.myPanel.setVisible(true);
            return true;
        }

        private boolean printDetails(Failure failure, @Nullable String details) {
            return BuildConsoleUtils.printDetails(this.myConsole, failure, details);
        }

        public void setNode(@Nullable DefaultMutableTreeNode node) {
            if (node == null || node.getUserObject() == this.myExecutionNode) {
                return;
            }
            if (node.getUserObject() instanceof ExecutionNode) {
                this.myExecutionNode = (ExecutionNode)((Object)node.getUserObject());
                if (this.setNode((ExecutionNode)((Object)node.getUserObject()))) {
                    return;
                }
            }
            this.myExecutionNode = null;
            this.myPanel.setVisible(false);
        }

        public JComponent getComponent() {
            return this.myPanel;
        }

        public void clear() {
            this.myPanel.setVisible(false);
            this.myConsole.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/build/BuildTreeConsoleView$DetailsHandler", "setNode"));
        }
    }
}

