/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ComponentManagerSettings;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.impl.ComponentManagerSettingsImpl;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

public class ModuleSettingsImpl
extends ComponentManagerSettingsImpl
implements ModuleSettings {
    private final String myModuleName;

    public ModuleSettingsImpl(File moduleFile, ConversionContextImpl context) throws CannotConvertException {
        super(moduleFile, context);
        this.myModuleName = ModuleSettingsImpl.getModuleName(moduleFile);
    }

    public static String getModuleName(File moduleFile) {
        return StringUtil.trimEnd((String)moduleFile.getName(), (String)".iml");
    }

    @Override
    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    public String getModuleType() {
        return this.getRootElement().getAttributeValue("type");
    }

    @Override
    @NotNull
    public File getModuleFile() {
        File file2 = this.mySettingsFile.getFile();
        if (file2 == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(1);
        }
        return file2;
    }

    @Override
    @NotNull
    public Collection<? extends Element> getFacetElements(@NotNull String facetTypeId) {
        if (facetTypeId == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(2);
        }
        Element facetManager = this.getComponentElement("FacetManager");
        ArrayList<Element> elements = new ArrayList<Element>();
        ModuleSettingsImpl.addFacetTypes(facetTypeId, facetManager, elements);
        ArrayList<Element> arrayList = elements;
        if (arrayList == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static void addFacetTypes(@NotNull String facetTypeId, @Nullable Element parent, @NotNull ArrayList<Element> elements) {
        if (facetTypeId == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(5);
        }
        for (Element child : JDOMUtil.getChildren((Element)parent, (String)"facet")) {
            if (facetTypeId.equals(child.getAttributeValue("type"))) {
                elements.add(child);
                continue;
            }
            ModuleSettingsImpl.addFacetTypes(facetTypeId, child, elements);
        }
    }

    @Override
    public Element getFacetElement(@NotNull String facetTypeId) {
        if (facetTypeId == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(6);
        }
        return (Element)ContainerUtil.getFirstItem(this.getFacetElements(facetTypeId), null);
    }

    @Override
    public void addFacetElement(@NotNull String facetTypeId, @NotNull String facetName, Element configuration) {
        if (facetTypeId == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(7);
        }
        if (facetName == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(8);
        }
        Element componentElement = JDomSerializationUtil.findOrCreateComponentElement((Element)this.getRootElement(), (String)"FacetManager");
        Element facetElement = new Element("facet");
        facetElement.setAttribute("type", facetTypeId);
        facetElement.setAttribute("name", facetName);
        configuration.setName("configuration");
        facetElement.addContent(configuration);
        componentElement.addContent(facetElement);
    }

    @Override
    public void setModuleType(@NotNull String moduleType) {
        if (moduleType == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(9);
        }
        this.getRootElement().setAttribute("type", moduleType);
    }

    @Override
    @NotNull
    public String expandPath(@NotNull String path) {
        if (path == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(10);
        }
        String string = this.myContext.expandPath(path, this);
        if (string == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    public String collapsePath(@NotNull String path) {
        if (path == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(12);
        }
        String string = ConversionContextImpl.collapsePath(path, this);
        if (string == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @NotNull
    public Collection<File> getSourceRoots(boolean includeTests) {
        ArrayList<File> result2 = new ArrayList<File>();
        for (Element contentRoot : this.getContentRootElements()) {
            for (Element sourceFolder : JDOMUtil.getChildren((Element)contentRoot, (String)"sourceFolder")) {
                boolean isTestFolder = Boolean.parseBoolean(sourceFolder.getAttributeValue("isTestSource"));
                if (!includeTests && isTestFolder) continue;
                result2.add(this.getFile(sourceFolder.getAttributeValue("url")));
            }
        }
        ArrayList<File> arrayList = result2;
        if (arrayList == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private List<Element> getContentRootElements() {
        return JDOMUtil.getChildren((Element)this.getComponentElement("NewModuleRootManager"), (String)"content");
    }

    @Override
    @NotNull
    public Collection<File> getContentRoots() {
        ArrayList<File> result2 = new ArrayList<File>();
        for (Element contentRoot : this.getContentRootElements()) {
            String path = VfsUtil.urlToPath((String)contentRoot.getAttributeValue("url"));
            result2.add(new File(FileUtil.toSystemDependentName((String)this.expandPath(path))));
        }
        ArrayList<File> arrayList = result2;
        if (arrayList == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public String getProjectOutputUrl() {
        ComponentManagerSettings rootManagerSettings = this.myContext.getProjectRootManagerSettings();
        Element projectRootManager = rootManagerSettings == null ? null : rootManagerSettings.getComponentElement("ProjectRootManager");
        Element outputElement = projectRootManager == null ? null : projectRootManager.getChild("output");
        return outputElement == null ? null : outputElement.getAttributeValue("url");
    }

    @Override
    public void addExcludedFolder(@NotNull File directory2) {
        File outputFile;
        String outputUrl;
        Element outputElement;
        Element projectRootManager;
        ComponentManagerSettings rootManagerSettings;
        if (directory2 == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(16);
        }
        if ((rootManagerSettings = this.myContext.getProjectRootManagerSettings()) != null && (projectRootManager = rootManagerSettings.getComponentElement("ProjectRootManager")) != null && (outputElement = projectRootManager.getChild("output")) != null && (outputUrl = outputElement.getAttributeValue("url")) != null && FileUtil.isAncestor((File)(outputFile = this.getFile(outputUrl)), (File)directory2, (boolean)false)) {
            return;
        }
        for (Element contentRoot : this.getContentRootElements()) {
            File root = this.getFile(contentRoot.getAttributeValue("url"));
            if (!FileUtil.isAncestor((File)root, (File)directory2, (boolean)true)) continue;
            this.addExcludedFolder(directory2, contentRoot);
        }
    }

    @Override
    @NotNull
    public List<File> getModuleLibraryRoots(String libraryName) {
        Element library = this.findModuleLibraryElement(libraryName);
        List<File> list2 = library != null ? this.myContext.getClassRoots(library, this) : Collections.emptyList();
        if (list2 == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @Override
    public boolean hasModuleLibrary(String libraryName) {
        return this.findModuleLibraryElement(libraryName) != null;
    }

    @Nullable
    private Element findModuleLibraryElement(String libraryName) {
        for (Element element : this.getOrderEntries()) {
            Element library;
            if (!"module-library".equals(element.getAttributeValue("type")) || (library = element.getChild("library")) == null || !libraryName.equals(library.getAttributeValue("name"))) continue;
            return library;
        }
        return null;
    }

    @Override
    public List<Element> getOrderEntries() {
        Element component = this.getComponentElement("NewModuleRootManager");
        return JDOMUtil.getChildren((Element)component, (String)"orderEntry");
    }

    @Override
    @NotNull
    public Collection<ModuleSettings> getAllModuleDependencies() {
        HashSet<ModuleSettings> dependencies = new HashSet<ModuleSettings>();
        this.collectDependencies(dependencies);
        HashSet<ModuleSettings> hashSet = dependencies;
        if (hashSet == null) {
            ModuleSettingsImpl.$$$reportNull$$$0(18);
        }
        return hashSet;
    }

    private void collectDependencies(Set<ModuleSettings> dependencies) {
        if (!dependencies.add(this)) {
            return;
        }
        for (Element element : this.getOrderEntries()) {
            ModuleSettings moduleSettings;
            String moduleName;
            if (!"module".equals(element.getAttributeValue("type")) || (moduleName = element.getAttributeValue("module-name")) == null || (moduleSettings = this.myContext.getModuleSettings(moduleName)) == null) continue;
            ((ModuleSettingsImpl)moduleSettings).collectDependencies(dependencies);
        }
    }

    private void addExcludedFolder(File directory2, Element contentRoot) {
        for (Element excludedFolder : JDOMUtil.getChildren((Element)contentRoot, (String)"excludeFolder")) {
            File excludedDir = this.getFile(excludedFolder.getAttributeValue("url"));
            if (!FileUtil.isAncestor((File)excludedDir, (File)directory2, (boolean)false)) continue;
            return;
        }
        String path = ConversionContextImpl.collapsePath(FileUtil.toSystemIndependentName((String)directory2.getAbsolutePath()), this);
        contentRoot.addContent(new Element("excludeFolder").setAttribute("url", VfsUtil.pathToUrl((String)path)));
    }

    private File getFile(String url) {
        return new File(FileUtil.toSystemDependentName((String)this.expandPath(VfsUtil.urlToPath((String)url))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/conversion/impl/ModuleSettingsImpl";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetTypeId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleFile";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/conversion/impl/ModuleSettingsImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetElements";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "expandPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "collapsePath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleLibraryRoots";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModuleDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFacetElements";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFacetTypes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFacetElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addFacetElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setModuleType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "expandPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collapsePath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addExcludedFolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

