/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.AlignmentCyclesDetector;
import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.Block;
import com.intellij.formatting.BlockAlignmentProcessor;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.LeftEdgeAlignmentProcessor;
import com.intellij.formatting.RightEdgeAlignmentProcessor;
import com.intellij.formatting.engine.BlockIndentOptions;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AlignmentHelper {
    private static final Logger LOG = Logger.getInstance(AlignmentHelper.class);
    private static final Map<Alignment.Anchor, BlockAlignmentProcessor> ALIGNMENT_PROCESSORS = new EnumMap<Alignment.Anchor, BlockAlignmentProcessor>(Alignment.Anchor.class);
    private final Set<Alignment> myAlignmentsToSkip = ContainerUtil.newHashSet();
    private final Document myDocument;
    private final BlockIndentOptions myBlockIndentOptions;
    private final AlignmentCyclesDetector myCyclesDetector;
    private final Map<LeafBlockWrapper, Set<LeafBlockWrapper>> myBackwardShiftedAlignedBlocks = ContainerUtil.newHashMap();
    private final Map<AbstractBlockWrapper, Set<AbstractBlockWrapper>> myAlignmentMappings = ContainerUtil.newHashMap();

    public AlignmentHelper(Document document, MultiMap<Alignment, Block> blocksToAlign, BlockIndentOptions options) {
        this.myDocument = document;
        this.myBlockIndentOptions = options;
        int totalBlocks = blocksToAlign.values().size();
        this.myCyclesDetector = new AlignmentCyclesDetector(totalBlocks);
    }

    private static void reportAlignmentProcessingError(BlockAlignmentProcessor.Context context) {
        ASTNode node = context.targetBlock.getNode();
        Language language = node != null ? node.getPsi().getLanguage() : null;
        String message = (language != null ? language.getDisplayName() + ": " : "") + "Can't align block " + context.targetBlock;
        LOG.error(message, new Throwable(), new Attachment[]{AttachmentFactory.createAttachment(context.document)});
    }

    public LeafBlockWrapper applyAlignment(AlignmentImpl alignment, LeafBlockWrapper currentBlock) {
        BlockAlignmentProcessor alignmentProcessor = ALIGNMENT_PROCESSORS.get(alignment.getAnchor());
        if (alignmentProcessor == null) {
            LOG.error(String.format("Can't find alignment processor for alignment anchor %s", alignment.getAnchor()));
            return null;
        }
        BlockAlignmentProcessor.Context context = new BlockAlignmentProcessor.Context(this.myDocument, alignment, currentBlock, this.myAlignmentMappings, this.myBackwardShiftedAlignedBlocks, this.myBlockIndentOptions.getIndentOptions(currentBlock));
        LeafBlockWrapper offsetResponsibleBlock = alignment.getOffsetRespBlockBefore(currentBlock);
        if (offsetResponsibleBlock != null) {
            this.myCyclesDetector.registerOffsetResponsibleBlock(offsetResponsibleBlock);
        }
        BlockAlignmentProcessor.Result result2 = alignmentProcessor.applyAlignment(context);
        switch (result2) {
            case TARGET_BLOCK_PROCESSED_NOT_ALIGNED: {
                return null;
            }
            case TARGET_BLOCK_ALIGNED: {
                this.storeAlignmentMapping(currentBlock);
                return null;
            }
            case BACKWARD_BLOCK_ALIGNED: {
                if (offsetResponsibleBlock == null) {
                    return null;
                }
                HashSet<LeafBlockWrapper> blocksCausedRealignment = new HashSet<LeafBlockWrapper>();
                this.myBackwardShiftedAlignedBlocks.clear();
                this.myBackwardShiftedAlignedBlocks.put(offsetResponsibleBlock, blocksCausedRealignment);
                blocksCausedRealignment.add(currentBlock);
                this.storeAlignmentMapping(currentBlock, offsetResponsibleBlock);
                if (this.myCyclesDetector.isCycleDetected()) {
                    AlignmentHelper.reportAlignmentProcessingError(context);
                    return null;
                }
                this.myCyclesDetector.registerBlockRollback(currentBlock);
                return offsetResponsibleBlock.getNextBlock();
            }
            case RECURSION_DETECTED: {
                this.myAlignmentsToSkip.add(alignment);
                return offsetResponsibleBlock;
            }
            case UNABLE_TO_ALIGN_BACKWARD_BLOCK: {
                this.myAlignmentsToSkip.add(alignment);
                return null;
            }
        }
        return null;
    }

    public boolean shouldSkip(AlignmentImpl alignment) {
        return this.myAlignmentsToSkip.contains((Object)alignment);
    }

    private void storeAlignmentMapping(AbstractBlockWrapper block1, AbstractBlockWrapper block2) {
        this.doStoreAlignmentMapping(block1, block2);
        this.doStoreAlignmentMapping(block2, block1);
    }

    private void doStoreAlignmentMapping(AbstractBlockWrapper key, AbstractBlockWrapper value) {
        Set<AbstractBlockWrapper> wrappers = this.myAlignmentMappings.get(key);
        if (wrappers == null) {
            wrappers = new HashSet<AbstractBlockWrapper>();
            this.myAlignmentMappings.put(key, wrappers);
        }
        wrappers.add(value);
    }

    private void storeAlignmentMapping(LeafBlockWrapper currentBlock) {
        AbstractBlockWrapper block;
        AlignmentImpl alignment = null;
        for (block = currentBlock; alignment == null && block != null; block = block.getParent()) {
            alignment = block.getAlignment();
        }
        if (alignment != null && (block = alignment.getOffsetRespBlockBefore(currentBlock)) != null) {
            this.storeAlignmentMapping(currentBlock, block);
        }
    }

    public void reset() {
        this.myBackwardShiftedAlignedBlocks.clear();
        this.myAlignmentMappings.clear();
    }

    static {
        ALIGNMENT_PROCESSORS.put(Alignment.Anchor.LEFT, new LeftEdgeAlignmentProcessor());
        ALIGNMENT_PROCESSORS.put(Alignment.Anchor.RIGHT, new RightEdgeAlignmentProcessor());
    }
}

