/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.ide.ui.laf.IdeaBlueMetalTheme;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.metal.DefaultMetalTheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntelliJLaf
extends DarculaLaf {
    @Override
    public String getName() {
        return "IntelliJ";
    }

    @Override
    @NotNull
    protected String getPrefix() {
        String string = UIUtil.isUnderWin10LookAndFeel() ? "intellijlaf_native" : "intellijlaf";
        if (string == null) {
            IntelliJLaf.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected String getSystemPrefix() {
        if (SystemInfo.isLinux) {
            return super.getSystemPrefix();
        }
        if (SystemInfo.isWindows) {
            return UIUtil.isUnderWin10LookAndFeel() ? null : this.getPrefix() + "_windows";
        }
        if (SystemInfo.isMac) {
            return UIUtil.isUnderDefaultMacTheme() ? this.getPrefix() + "_mac" : null;
        }
        return null;
    }

    @Override
    protected BasicLookAndFeel createBaseLookAndFeel() {
        Registry.get((String)"ide.intellij.laf.win10.ui").addListener((RegistryValueListener)new RegistryValueListener.Adapter(){

            public void afterValueChanged(RegistryValue value) {
                try {
                    UIManager.setLookAndFeel(UIManager.getLookAndFeel());
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
            }
        }, this.myDisposable);
        if (UIUtil.isUnderWindowsLookAndFeel()) {
            try {
                String name = UIManager.getSystemLookAndFeelClassName();
                return (BasicLookAndFeel)Class.forName(name).newInstance();
            }
            catch (Exception e) {
                IntelliJLaf.log(e);
            }
        }
        return super.createBaseLookAndFeel();
    }

    @Override
    protected DefaultMetalTheme createMetalTheme() {
        return new IdeaBlueMetalTheme();
    }

    public static Color getSelectedControlColor() {
        return MacUtil.colorFromNative((ID)Foundation.invoke((String)"NSColor", (String)"alternateSelectedControlColor", (Object[])new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/laf/IntelliJLaf", "getPrefix"));
    }
}

