/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.jdom.Document;
import org.jdom.output.DOMOutputter;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public class LoggerFactory
implements Logger.Factory {
    private static final String SYSTEM_MACRO = "$SYSTEM_DIR$";
    private static final String APPLICATION_MACRO = "$APPLICATION_DIR$";
    private static final String LOG_DIR_MACRO = "$LOG_DIR$";
    private boolean myInitialized = false;

    private LoggerFactory() {
    }

    @NotNull
    public synchronized com.intellij.openapi.diagnostic.Logger getLoggerInstance(@NotNull String name) {
        if (name == null) {
            LoggerFactory.$$$reportNull$$$0(0);
        }
        try {
            if (!this.myInitialized) {
                this.init();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IdeaLogger ideaLogger = new IdeaLogger(Logger.getLogger((String)name));
        if (ideaLogger == null) {
            LoggerFactory.$$$reportNull$$$0(1);
        }
        return ideaLogger;
    }

    private void init() {
        try {
            System.setProperty("log4j.defaultInitOverride", "true");
            File logXmlFile = PathManager.findBinFileWithException((String)"log.xml");
            String text2 = FileUtil.loadFile((File)logXmlFile);
            text2 = StringUtil.replace((String)text2, (String)SYSTEM_MACRO, (String)StringUtil.replace((String)PathManager.getSystemPath(), (String)"\\", (String)"\\\\"));
            text2 = StringUtil.replace((String)text2, (String)APPLICATION_MACRO, (String)StringUtil.replace((String)PathManager.getHomePath(), (String)"\\", (String)"\\\\"));
            text2 = StringUtil.replace((String)text2, (String)LOG_DIR_MACRO, (String)StringUtil.replace((String)PathManager.getLogPath(), (String)"\\", (String)"\\\\"));
            File file2 = new File(PathManager.getLogPath());
            if (!file2.mkdirs() && !file2.exists()) {
                System.err.println("Cannot create log directory: " + file2);
            }
            Document document = JDOMUtil.loadDocument((CharSequence)text2);
            Element element = new DOMOutputter().output(document).getDocumentElement();
            new DOMConfigurator().doConfigure(element, LogManager.getLoggerRepository());
            this.myInitialized = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/LoggerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/LoggerFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerInstance";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

