/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.index;

import com.google.common.hash.HashCode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.stubs.FileContentHashing;
import com.intellij.psi.stubs.HashCodeDescriptor;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.PersistentHashMap;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 \"*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0014H\u0002J\u0015\u0010\u0019\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u0014H\u0016J\r\u0010\u001e\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u001fJ\u001e\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00112\u0006\u0010!\u001a\u00020\u0014H\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/index/PrebuiltIndexProviderBase;", "Value", "Lcom/intellij/openapi/Disposable;", "()V", "dirName", "", "getDirName", "()Ljava/lang/String;", "indexExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "getIndexExternalizer", "()Lcom/intellij/util/io/DataExternalizer;", "indexName", "getIndexName", "myFileContentHashing", "Lcom/intellij/psi/stubs/FileContentHashing;", "myPrebuiltIndexStorage", "Lcom/intellij/util/io/PersistentHashMap;", "Lcom/google/common/hash/HashCode;", "copyPrebuiltIndicesToIndexRoot", "Ljava/io/File;", "prebuiltIndicesRoot", "dispose", "", "findPrebuiltIndicesRoot", "get", "fileContent", "Lcom/intellij/util/indexing/FileContent;", "(Lcom/intellij/util/indexing/FileContent;)Ljava/lang/Object;", "indexRoot", "init", "init$intellij_platform_lang_impl", "openIndexStorage", "indexesRoot", "Companion", "intellij.platform.lang.impl"})
public abstract class PrebuiltIndexProviderBase<Value>
implements Disposable {
    private final FileContentHashing myFileContentHashing = new FileContentHashing();
    private PersistentHashMap<HashCode, Value> myPrebuiltIndexStorage;
    private static final Logger LOG;
    @JvmField
    public static final boolean DEBUG_PREBUILT_INDICES;
    public static final Companion Companion;

    @NotNull
    protected abstract String getDirName();

    @NotNull
    protected abstract String getIndexName();

    @NotNull
    protected abstract DataExternalizer<Value> getIndexExternalizer();

    public final void init$intellij_platform_lang_impl() {
        File indexesRoot = this.findPrebuiltIndicesRoot();
        try {
            if (indexesRoot != null && indexesRoot.exists()) {
                indexesRoot = this.copyPrebuiltIndicesToIndexRoot(indexesRoot);
                this.myPrebuiltIndexStorage = this.openIndexStorage(indexesRoot);
                StringBuilder stringBuilder = new StringBuilder().append("Using prebuilt ").append(this.getIndexName()).append(" from ");
                PersistentHashMap<HashCode, Value> persistentHashMap = this.myPrebuiltIndexStorage;
                if (persistentHashMap == null) {
                    Intrinsics.throwNpe();
                }
                File file2 = persistentHashMap.getBaseFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"myPrebuiltIndexStorage!!.baseFile");
                LOG.info(stringBuilder.append(file2.getAbsolutePath()).toString());
            } else {
                LOG.info("Prebuilt " + this.getIndexName() + " indices are missing for " + this.getDirName());
            }
        }
        catch (Exception e) {
            this.myPrebuiltIndexStorage = null;
            StringBuilder stringBuilder = new StringBuilder().append("Prebuilt indices can't be loaded at ");
            File file3 = indexesRoot;
            if (file3 == null) {
                Intrinsics.throwNpe();
            }
            LOG.warn(stringBuilder.append(file3).toString(), (Throwable)e);
        }
    }

    @Nullable
    public final Value get(@NotNull FileContent fileContent) {
        Intrinsics.checkParameterIsNotNull((Object)fileContent, (String)"fileContent");
        if (Registry.is((String)"use.prebuilt.indices") && this.myPrebuiltIndexStorage != null) {
            HashCode hashCode = this.myFileContentHashing.hashString(fileContent);
            try {
                PersistentHashMap<HashCode, Value> persistentHashMap = this.myPrebuiltIndexStorage;
                if (persistentHashMap == null) {
                    Intrinsics.throwNpe();
                }
                return (Value)persistentHashMap.get((Object)hashCode);
            }
            catch (Exception e) {
                StringBuilder stringBuilder = new StringBuilder().append("Error reading prebuilt stubs from ");
                PersistentHashMap<HashCode, Value> persistentHashMap = this.myPrebuiltIndexStorage;
                if (persistentHashMap == null) {
                    Intrinsics.throwNpe();
                }
                File file2 = persistentHashMap.getBaseFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"myPrebuiltIndexStorage!!.baseFile");
                LOG.error(stringBuilder.append(file2.getPath()).toString(), (Throwable)e);
                this.myPrebuiltIndexStorage = null;
            }
        }
        return null;
    }

    @Nullable
    public PersistentHashMap<HashCode, Value> openIndexStorage(@NotNull File indexesRoot) {
        Intrinsics.checkParameterIsNotNull((Object)indexesRoot, (String)"indexesRoot");
        return new PersistentHashMap<HashCode, Value>(this, indexesRoot, new File(indexesRoot, this.getIndexName() + ".input"), HashCodeDescriptor.Companion.getInstance(), this.getIndexExternalizer()){
            final /* synthetic */ PrebuiltIndexProviderBase this$0;
            final /* synthetic */ File $indexesRoot;

            protected boolean isReadOnly() {
                return true;
            }
            {
                this.this$0 = $outer;
                this.$indexesRoot = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        };
    }

    private final File copyPrebuiltIndicesToIndexRoot(File prebuiltIndicesRoot) throws IOException {
        File indexRoot = new File(IndexInfrastructure.getPersistentIndexRoot(), "prebuilt/" + this.getDirName());
        FileUtil.copyDir((File)prebuiltIndicesRoot, (File)indexRoot, (FileFilter)new FileFilter(this){
            final /* synthetic */ PrebuiltIndexProviderBase this$0;

            public final boolean accept(File f) {
                File file2 = f;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"f");
                String string = file2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"f.name");
                return StringsKt.startsWith$default((String)string, (String)this.this$0.getIndexName(), (boolean)false, (int)2, null);
            }
            {
                this.this$0 = prebuiltIndexProviderBase;
            }
        });
        return indexRoot;
    }

    private final File findPrebuiltIndicesRoot() {
        String path = System.getProperty("prebuilt_indices_path");
        if (path != null && new File(path).exists()) {
            return new File(path, this.getDirName());
        }
        File f = this.indexRoot();
        return f.exists() ? f : null;
    }

    @NotNull
    public File indexRoot() {
        return new File(PathManager.getHomePath(), "index/" + this.getDirName());
    }

    public void dispose() {
        if (this.myPrebuiltIndexStorage != null) {
            try {
                PersistentHashMap<HashCode, Value> persistentHashMap = this.myPrebuiltIndexStorage;
                if (persistentHashMap == null) {
                    Intrinsics.throwNpe();
                }
                persistentHashMap.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public PrebuiltIndexProviderBase() {
        this.init$intellij_platform_lang_impl();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance((String)"#com.intellij.index.PrebuiltIndexProviderBase");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#com\u2026ebuiltIndexProviderBase\")");
        LOG = logger;
        DEBUG_PREBUILT_INDICES = SystemProperties.getBooleanProperty((String)"debug.prebuilt.indices", (boolean)false);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/index/PrebuiltIndexProviderBase$Companion;", "", "()V", "DEBUG_PREBUILT_INDICES", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

