/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonParserDefinition;
import com.intellij.json.formatter.JsonCodeStyleSettings;
import com.intellij.json.formatter.JsonFormattingBuilderModel;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonBlock
implements ASTBlock {
    private static final TokenSet JSON_OPEN_BRACES = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.L_BRACKET, JsonElementTypes.L_CURLY});
    private static final TokenSet JSON_CLOSE_BRACES = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.R_BRACKET, JsonElementTypes.R_CURLY});
    private static final TokenSet JSON_ALL_BRACES = TokenSet.orSet((TokenSet[])new TokenSet[]{JSON_OPEN_BRACES, JSON_CLOSE_BRACES});
    private final JsonBlock myParent;
    private final ASTNode myNode;
    private final PsiElement myPsiElement;
    private final Alignment myAlignment;
    private final Indent myIndent;
    private final Wrap myWrap;
    private final JsonCodeStyleSettings myCustomSettings;
    private final SpacingBuilder mySpacingBuilder;
    private List<Block> mySubBlocks;
    private final Alignment myPropertyValueAlignment;
    private final Wrap myChildWrap;

    @Deprecated
    public JsonBlock(@Nullable JsonBlock parent, @NotNull ASTNode node, @NotNull CodeStyleSettings settings, @Nullable Alignment alignment, @NotNull Indent indent, @Nullable Wrap wrap) {
        if (node == null) {
            JsonBlock.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            JsonBlock.$$$reportNull$$$0(1);
        }
        if (indent == null) {
            JsonBlock.$$$reportNull$$$0(2);
        }
        this(parent, node, (JsonCodeStyleSettings)settings.getCustomSettings(JsonCodeStyleSettings.class), alignment, indent, wrap, JsonFormattingBuilderModel.createSpacingBuilder(settings));
    }

    public JsonBlock(@Nullable JsonBlock parent, @NotNull ASTNode node, @NotNull JsonCodeStyleSettings customSettings, @Nullable Alignment alignment, @NotNull Indent indent, @Nullable Wrap wrap, @NotNull SpacingBuilder spacingBuilder) {
        if (node == null) {
            JsonBlock.$$$reportNull$$$0(3);
        }
        if (customSettings == null) {
            JsonBlock.$$$reportNull$$$0(4);
        }
        if (indent == null) {
            JsonBlock.$$$reportNull$$$0(5);
        }
        if (spacingBuilder == null) {
            JsonBlock.$$$reportNull$$$0(6);
        }
        this.mySubBlocks = null;
        this.myParent = parent;
        this.myNode = node;
        this.myPsiElement = node.getPsi();
        this.myAlignment = alignment;
        this.myIndent = indent;
        this.myWrap = wrap;
        this.mySpacingBuilder = spacingBuilder;
        this.myCustomSettings = customSettings;
        this.myChildWrap = this.myPsiElement instanceof JsonObject ? Wrap.createWrap((int)this.myCustomSettings.OBJECT_WRAPPING, (boolean)true) : (this.myPsiElement instanceof JsonArray ? Wrap.createWrap((int)this.myCustomSettings.ARRAY_WRAPPING, (boolean)true) : null);
        this.myPropertyValueAlignment = this.myPsiElement instanceof JsonObject ? Alignment.createAlignment((boolean)true) : null;
    }

    public ASTNode getNode() {
        return this.myNode;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myNode.getTextRange();
        if (textRange == null) {
            JsonBlock.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.mySubBlocks == null) {
            int propertyAlignment = this.myCustomSettings.PROPERTY_ALIGNMENT;
            ASTNode[] children2 = this.myNode.getChildren(null);
            this.mySubBlocks = ContainerUtil.newArrayListWithCapacity((int)children2.length);
            for (ASTNode child : children2) {
                if (JsonBlock.isWhitespaceOrEmpty(child)) continue;
                this.mySubBlocks.add(this.makeSubBlock(child, propertyAlignment));
            }
        }
        List<Block> list2 = this.mySubBlocks;
        if (list2 == null) {
            JsonBlock.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private Block makeSubBlock(@NotNull ASTNode childNode, int propertyAlignment) {
        if (childNode == null) {
            JsonBlock.$$$reportNull$$$0(9);
        }
        Indent indent = Indent.getNoneIndent();
        Alignment alignment = null;
        Wrap wrap = null;
        if (JsonPsiUtil.hasElementType(this.myNode, JsonParserDefinition.JSON_CONTAINERS)) {
            if (JsonPsiUtil.hasElementType(childNode, JsonElementTypes.COMMA)) {
                wrap = Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
            } else if (!JsonPsiUtil.hasElementType(childNode, JSON_ALL_BRACES)) {
                assert (this.myChildWrap != null);
                wrap = this.myChildWrap;
                indent = Indent.getNormalIndent();
            } else if (JsonPsiUtil.hasElementType(childNode, JSON_OPEN_BRACES) && JsonPsiUtil.isPropertyValue(this.myPsiElement) && propertyAlignment == JsonCodeStyleSettings.ALIGN_PROPERTY_ON_VALUE) {
                assert (this.myParent != null && this.myParent.myParent != null && this.myParent.myParent.myPropertyValueAlignment != null);
                alignment = this.myParent.myParent.myPropertyValueAlignment;
            }
        } else if (JsonPsiUtil.hasElementType(this.myNode, JsonElementTypes.PROPERTY)) {
            assert (this.myParent != null && this.myParent.myPropertyValueAlignment != null);
            if (JsonPsiUtil.hasElementType(childNode, JsonElementTypes.COLON) && propertyAlignment == JsonCodeStyleSettings.ALIGN_PROPERTY_ON_COLON) {
                alignment = this.myParent.myPropertyValueAlignment;
            } else if (JsonPsiUtil.isPropertyValue(childNode.getPsi()) && propertyAlignment == JsonCodeStyleSettings.ALIGN_PROPERTY_ON_VALUE && !JsonPsiUtil.hasElementType(childNode, JsonParserDefinition.JSON_CONTAINERS)) {
                alignment = this.myParent.myPropertyValueAlignment;
            }
        }
        return new JsonBlock(this, childNode, this.myCustomSettings, alignment, indent, wrap, this.mySpacingBuilder);
    }

    @Nullable
    public Wrap getWrap() {
        return this.myWrap;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myAlignment;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            JsonBlock.$$$reportNull$$$0(10);
        }
        return this.mySpacingBuilder.getSpacing((Block)this, child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (JsonPsiUtil.hasElementType(this.myNode, JsonParserDefinition.JSON_CONTAINERS)) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                JsonBlock.$$$reportNull$$$0(11);
            }
            return childAttributes;
        }
        if (this.myNode.getPsi() instanceof PsiFile) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                JsonBlock.$$$reportNull$$$0(12);
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = new ChildAttributes(null, null);
        if (childAttributes == null) {
            JsonBlock.$$$reportNull$$$0(13);
        }
        return childAttributes;
    }

    public boolean isIncomplete() {
        ASTNode lastChildNode = this.myNode.getLastChildNode();
        if (JsonPsiUtil.hasElementType(this.myNode, JsonElementTypes.OBJECT)) {
            return lastChildNode != null && lastChildNode.getElementType() != JsonElementTypes.R_CURLY;
        }
        if (JsonPsiUtil.hasElementType(this.myNode, JsonElementTypes.ARRAY)) {
            return lastChildNode != null && lastChildNode.getElementType() != JsonElementTypes.R_BRACKET;
        }
        if (JsonPsiUtil.hasElementType(this.myNode, JsonElementTypes.PROPERTY)) {
            return ((JsonProperty)this.myPsiElement).getValue() == null;
        }
        return false;
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    private static boolean isWhitespaceOrEmpty(ASTNode node) {
        return node.getElementType() == TokenType.WHITE_SPACE || node.getTextLength() == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customSettings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spacingBuilder";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/formatter/JsonBlock";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNode";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/formatter/JsonBlock";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "makeSubBlock";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

