/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.actions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.util.messages.MessageBus;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationTestAction
extends AnAction
implements DumbAware {
    public static final String TEST_GROUP_ID = "Test Notification";
    private static final NotificationGroup TEST_STICKY_GROUP = new NotificationGroup("Test Sticky Notification", NotificationDisplayType.STICKY_BALLOON, true);
    private static final NotificationGroup TEST_TOOLWINDOW_GROUP = NotificationGroup.toolWindowGroup((String)"Test ToolWindow Notification", (String)ToolWindowId.TODO_VIEW, (boolean)true);
    private static final String MESSAGE_KEY = "NotificationTestAction_Message";

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            NotificationTestAction.$$$reportNull$$$0(0);
        }
        new NotificationDialog(event.getProject()).show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/notification/impl/actions/NotificationTestAction", "actionPerformed"));
    }

    private static class NotificationInfo
    implements NotificationListener {
        private String myGroupId;
        private String myTitle;
        private String mySubtitle;
        private List<String> myContent;
        private List<String> myActions;
        private NotificationType myType = NotificationType.INFORMATION;
        private boolean mySticky;
        private boolean myAddListener;
        private boolean myToolwindow;
        private Notification myNotification;

        private NotificationInfo() {
        }

        public Notification getNotification() {
            if (this.myNotification == null) {
                String displayId;
                Icon icon = null;
                if (!StringUtil.isEmpty((String)this.myGroupId)) {
                    icon = IconLoader.findIcon((String)this.myGroupId);
                }
                String string = displayId = this.mySticky ? TEST_STICKY_GROUP.getDisplayId() : NotificationTestAction.TEST_GROUP_ID;
                if (this.myToolwindow) {
                    displayId = TEST_TOOLWINDOW_GROUP.getDisplayId();
                }
                String content = this.myContent == null ? "" : StringUtil.join(this.myContent, (String)"\n");
                this.myNotification = icon == null ? new Notification(displayId, StringUtil.notNullize((String)this.myTitle), content, this.myType, this.getListener()) : new Notification(displayId, icon, this.myTitle, this.mySubtitle, content, this.myType, this.getListener());
                if (this.myActions != null) {
                    for (String action : this.myActions) {
                        this.myNotification.addAction((AnAction)new MyAnAction(action));
                    }
                }
            }
            return this.myNotification;
        }

        @Nullable
        private NotificationListener getListener() {
            return this.myAddListener ? this : null;
        }

        public void setGroupId(@Nullable String groupId) {
            this.myGroupId = groupId;
        }

        public void setTitle(@Nullable String title) {
            this.myTitle = title;
        }

        public void setSubtitle(@Nullable String subtitle) {
            this.mySubtitle = subtitle;
        }

        public void setAddListener(boolean addListener2) {
            this.myAddListener = addListener2;
        }

        public void addContent(@NotNull String content) {
            if (content == null) {
                NotificationInfo.$$$reportNull$$$0(0);
            }
            if (this.myContent == null) {
                this.myContent = new ArrayList<String>();
            }
            this.myContent.add(content);
        }

        public void setActions(@NotNull List<String> actions) {
            if (actions == null) {
                NotificationInfo.$$$reportNull$$$0(1);
            }
            this.myActions = actions;
        }

        public void setSticky(boolean sticky) {
            this.mySticky = sticky;
        }

        public void setToolwindow(boolean toolwindow) {
            this.myToolwindow = toolwindow;
        }

        public void setType(@Nullable String type) {
            if ("info".equals(type)) {
                this.myType = NotificationType.INFORMATION;
            } else if ("error".equals(type)) {
                this.myType = NotificationType.ERROR;
            } else if ("warn".equals(type)) {
                this.myType = NotificationType.WARNING;
            }
        }

        public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
            if (notification2 == null) {
                NotificationInfo.$$$reportNull$$$0(2);
            }
            if (event == null) {
                NotificationInfo.$$$reportNull$$$0(3);
            }
            if (MessageDialogBuilder.yesNo((String)"Notification Listener", (String)(event.getDescription() + "      Expire?")).isYes()) {
                this.myNotification.expire();
                this.myNotification = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/notification/impl/actions/NotificationTestAction$NotificationInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addContent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setActions";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MyAnAction
        extends AnAction {
            private MyAnAction(String text2) {
                if (text2 != null) {
                    Icon icon;
                    if (text2.endsWith(".png") && (icon = IconLoader.findIcon((String)text2)) != null) {
                        this.getTemplatePresentation().setIcon(icon);
                        return;
                    }
                    this.getTemplatePresentation().setText(text2);
                }
            }

            public void actionPerformed(AnActionEvent e) {
                Notification.get((AnActionEvent)e);
                if (MessageDialogBuilder.yesNo((String)"AnAction", (String)(this.getTemplatePresentation().getText() + "      Expire?")).isYes()) {
                    NotificationInfo.this.myNotification.expire();
                    NotificationInfo.this.myNotification = null;
                }
            }
        }
    }

    private static final class NotificationDialog
    extends DialogWrapper {
        private final JTextArea myMessage = new JTextArea(10, 50);
        private final MessageBus myMessageBus;

        private NotificationDialog(@Nullable Project project) {
            super(project, true, DialogWrapper.IdeModalityType.MODELESS);
            this.myMessageBus = project != null ? project.getMessageBus() : ApplicationManager.getApplication().getMessageBus();
            this.init();
            this.setOKButtonText("Notify");
            this.setTitle(NotificationTestAction.TEST_GROUP_ID);
            this.myMessage.setText(PropertiesComponent.getInstance().getValue(NotificationTestAction.MESSAGE_KEY, "GroupID:\nTitle:\nSubtitle:\nContent:\nContent:\nActions:\nSticky:\n"));
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return "NotificationTestAction";
        }

        protected JComponent createCenterPanel() {
            JPanel panel2 = new JPanel(new BorderLayout(10, 10));
            panel2.add("Center", new JScrollPane(this.myMessage));
            return panel2;
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
            if (actionArray == null) {
                NotificationDialog.$$$reportNull$$$0(0);
            }
            return actionArray;
        }

        public void doCancelAction() {
            PropertiesComponent.getInstance().setValue(NotificationTestAction.MESSAGE_KEY, this.myMessage.getText());
            super.doCancelAction();
        }

        protected void doOKAction() {
            this.newNotification(this.myMessage.getText());
        }

        private void newNotification(String text2) {
            ArrayList<NotificationInfo> notifications = new ArrayList<NotificationInfo>();
            NotificationInfo notification2 = null;
            for (String line : StringUtil.splitByLines((String)text2, (boolean)false)) {
                String value;
                if (line.length() == 0 && notification2 != null) {
                    notification2 = null;
                    continue;
                }
                if (line.startsWith("//")) continue;
                if (line.startsWith("--")) break;
                if (notification2 == null) {
                    notification2 = new NotificationInfo();
                    notifications.add(notification2);
                }
                if (line.startsWith("GroupID:")) {
                    notification2.setGroupId(StringUtil.substringAfter((String)line, (String)":"));
                    continue;
                }
                if (line.startsWith("Title:")) {
                    notification2.setTitle(StringUtil.substringAfter((String)line, (String)":"));
                    continue;
                }
                if (line.startsWith("Content:")) {
                    value = StringUtil.substringAfter((String)line, (String)":");
                    if (value == null) continue;
                    notification2.addContent(value);
                    continue;
                }
                if (line.startsWith("Subtitle:")) {
                    notification2.setSubtitle(StringUtil.substringAfter((String)line, (String)":"));
                    continue;
                }
                if (line.startsWith("Actions:")) {
                    value = StringUtil.substringAfter((String)line, (String)":");
                    if (value == null) continue;
                    notification2.setActions(StringUtil.split((String)value, (String)","));
                    continue;
                }
                if (line.startsWith("Type:")) {
                    notification2.setType(StringUtil.substringAfter((String)line, (String)":"));
                    continue;
                }
                if (line.startsWith("Sticky:")) {
                    notification2.setSticky("true".equals(StringUtil.substringAfter((String)line, (String)":")));
                    continue;
                }
                if (line.startsWith("Listener:")) {
                    notification2.setAddListener("true".equals(StringUtil.substringAfter((String)line, (String)":")));
                    continue;
                }
                if (!line.startsWith("Toolwindow:")) continue;
                notification2.setToolwindow("true".equals(StringUtil.substringAfter((String)line, (String)":")));
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                for (NotificationInfo info : notifications) {
                    ((Notifications)this.myMessageBus.syncPublisher(Notifications.TOPIC)).notify(info.getNotification());
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/actions/NotificationTestAction$NotificationDialog", "createActions"));
        }
    }
}

