/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.ide.diff.DiffElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffPanel;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.DirDiffManager;
import com.intellij.openapi.diff.FileContent;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileTypes.UIBasedFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Window;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class BinaryDiffTool
implements DiffTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.external.BinaryDiffTool");
    public static final DiffTool INSTANCE = new BinaryDiffTool();

    public void show(DiffRequest data) {
        DiffContent current = data.getContents()[0];
        DiffContent upToDate = data.getContents()[1];
        Project project = data.getProject();
        if (current instanceof FileContent && upToDate instanceof FileContent || current.getContentType() instanceof UIBasedFileType && upToDate.getContentType() instanceof UIBasedFileType) {
            VirtualFile src = current.getFile();
            VirtualFile trg = upToDate.getFile();
            if (src != null && trg != null) {
                final PanelCreator creator = new PanelCreator(data);
                if (creator.isCanCreatePanel()) {
                    new DialogWrapper(data.getProject()){
                        public DiffPanel myPanel;
                        {
                            super(arg0);
                            this.setModal(false);
                            this.init();
                        }

                        protected String getDimensionServiceKey() {
                            return "BinaryDiffDialog";
                        }

                        @NotNull
                        protected Action[] createActions() {
                            Action close2 = this.getCancelAction();
                            close2.putValue("Name", "&Close");
                            Action[] actionArray = new Action[]{close2};
                            if (actionArray == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return actionArray;
                        }

                        protected JComponent createCenterPanel() {
                            this.myPanel = creator.create(this.getWindow(), this.getDisposable(), BinaryDiffTool.this);
                            return this.myPanel.getComponent();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/external/BinaryDiffTool$1", "createActions"));
                        }
                    }.show();
                    return;
                }
                DirDiffManager diffManager = DirDiffManager.getInstance((Project)project);
                DiffElement before = diffManager.createDiffElement((Object)src);
                DiffElement after2 = diffManager.createDiffElement((Object)trg);
                if (before != null && after2 != null && diffManager.canShow(after2, before)) {
                    diffManager.showDiff(before, after2);
                    return;
                }
            }
        }
        try {
            boolean equal = Arrays.equals(current.getBytes(), upToDate.getBytes());
            Messages.showMessageDialog((String)(equal ? DiffBundle.message((String)"binary.files.are.identical.message", (Object[])new Object[0]) : DiffBundle.message((String)"binary.files.are.different.message", (Object[])new Object[0])), (String)(equal ? DiffBundle.message((String)"files.are.identical.dialog.title", (Object[])new Object[0]) : DiffBundle.message((String)"files.are.different.dialog.title", (Object[])new Object[0])), (Icon)Messages.getInformationIcon());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean canShow(DiffRequest data) {
        DiffContent[] contents = data.getContents();
        if (contents.length != 2) {
            return false;
        }
        for (DiffContent content : contents) {
            VirtualFile file2 = content.getFile();
            if (file2 == null) {
                if (content.isEmpty()) continue;
                return false;
            }
            if (!file2.isDirectory()) continue;
            return false;
        }
        return true;
    }

    public DiffViewer createComponent(String title, DiffRequest request, Window window, @NotNull Disposable parentDisposable) {
        PanelCreator creator;
        if (parentDisposable == null) {
            BinaryDiffTool.$$$reportNull$$$0(0);
        }
        if (!(creator = new PanelCreator(request)).isCanCreatePanel()) {
            return null;
        }
        return creator.create(window, parentDisposable, this);
    }

    public static boolean canShow(@NotNull Project project, VirtualFile file2) {
        if (project == null) {
            BinaryDiffTool.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            return false;
        }
        if (FileEditorProviderManager.getInstance().getProviders(project, file2).length > 0) {
            return true;
        }
        DirDiffManager diffManager = DirDiffManager.getInstance((Project)project);
        return diffManager.createDiffElement((Object)file2) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diff/impl/external/BinaryDiffTool";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canShow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PanelCreator {
        private final boolean myCanCreatePanel;
        private final DiffRequest myData;
        private final VirtualFile mySrc;
        private final VirtualFile myTrg;

        private PanelCreator(DiffRequest data) {
            this.myData = data;
            DiffContent current = data.getContents()[0];
            DiffContent upToDate = data.getContents()[1];
            Project project = data.getProject();
            this.mySrc = current.getFile();
            this.myTrg = upToDate.getFile();
            this.myCanCreatePanel = this.canShowContent(project, this.mySrc) && this.canShowContent(project, this.myTrg);
        }

        private boolean canShowContent(Project project, VirtualFile file2) {
            if (file2 == null) {
                return true;
            }
            return FileEditorProviderManager.getInstance().getProviders(project, file2).length > 0;
        }

        public boolean isCanCreatePanel() {
            return this.myCanCreatePanel;
        }

        public DiffPanel create(Window window, Disposable disposable, BinaryDiffTool tool) {
            if (!this.myCanCreatePanel) {
                return null;
            }
            Project project = this.myData.getProject();
            DiffPanel panel2 = DiffManager.getInstance().createDiffPanel(window, project, disposable, (DiffTool)tool);
            panel2.setDiffRequest(this.myData);
            panel2.removeStatusBar();
            return panel2;
        }
    }
}

