/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.progress.util.ProgressDialog;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.Semaphore;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.SunToolkit;

public class PotemkinProgress
extends ProgressWindow
implements PingProgress {
    private long myLastUiUpdate;
    private final LinkedBlockingQueue<InputEvent> myEventQueue;
    private long myLastShouldDispatchCheck;

    public PotemkinProgress(@NotNull String title, @Nullable Project project, @Nullable JComponent parentComponent, @Nullable String cancelText) {
        if (title == null) {
            PotemkinProgress.$$$reportNull$$$0(0);
        }
        super(cancelText != null, false, project, parentComponent, cancelText);
        this.myLastUiUpdate = System.currentTimeMillis();
        this.myEventQueue = new LinkedBlockingQueue();
        this.setTitle(title);
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.startStealingInputEvents();
    }

    private void startStealingInputEvents() {
        IdeEventQueue.getInstance().addPostEventListener(event -> {
            if (event instanceof InputEvent) {
                this.myEventQueue.offer((InputEvent)event);
                return true;
            }
            return false;
        }, this);
    }

    @Override
    @NotNull
    protected ProgressDialog getDialog() {
        ProgressDialog progressDialog = Objects.requireNonNull(super.getDialog());
        if (progressDialog == null) {
            PotemkinProgress.$$$reportNull$$$0(1);
        }
        return progressDialog;
    }

    @Override
    public void interact() {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            long now = System.currentTimeMillis();
            if (this.shouldDispatchAwtEvents(now)) {
                this.dispatchAwtEventsWithoutModelAccess(0);
            }
            this.updateUI(now);
        }
    }

    private void dispatchAwtEventsWithoutModelAccess(int timeoutMs) {
        SunToolkit.flushPendingEvents();
        try {
            while (true) {
                InputEvent event;
                if ((event = this.myEventQueue.poll(timeoutMs, TimeUnit.MILLISECONDS)) == null) {
                    return;
                }
                this.dispatchInputEvent(event);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean shouldDispatchAwtEvents(long now) {
        if (now == this.myLastShouldDispatchCheck) {
            return false;
        }
        this.myLastShouldDispatchCheck = now;
        return this.getDialog().getPanel().isShowing();
    }

    private void dispatchInputEvent(@NotNull InputEvent e) {
        if (e == null) {
            PotemkinProgress.$$$reportNull$$$0(2);
        }
        if (this.isCancellationEvent(e)) {
            this.cancel();
            return;
        }
        Object source = e.getSource();
        if (source instanceof Component && this.isInDialogWindow((Component)source)) {
            ((Component)source).dispatchEvent(e);
        }
    }

    private boolean isInDialogWindow(Component source) {
        Window dialogWindow = SwingUtilities.windowForComponent(this.getDialog().getPanel());
        return dialogWindow instanceof JDialog && SwingUtilities.isDescendingFrom(source, dialogWindow);
    }

    private void updateUI(long now) {
        JRootPane rootPane = this.getDialog().getPanel().getRootPane();
        if (rootPane == null) {
            rootPane = this.considerShowingDialog(now);
        }
        if (rootPane != null && this.timeToPaint(now)) {
            this.paintProgress();
        }
    }

    @Nullable
    private JRootPane considerShowingDialog(long now) {
        if (now - this.myLastUiUpdate > (long)this.myDelayInMillis) {
            this.getDialog().myRepaintRunnable.run();
            this.showDialog();
            return this.getDialog().getPanel().getRootPane();
        }
        return null;
    }

    private boolean timeToPaint(long now) {
        if (now - this.myLastUiUpdate <= 50L) {
            return false;
        }
        this.myLastUiUpdate = now;
        return true;
    }

    private void progressFinished() {
        this.getDialog().hideImmediately();
    }

    private void paintProgress() {
        this.getDialog().myRepaintRunnable.run();
        JPanel dialogPanel = this.getDialog().getPanel();
        dialogPanel.validate();
        dialogPanel.paintImmediately(dialogPanel.getBounds());
    }

    public void runInSwingThread(@NotNull Runnable action) {
        if (action == null) {
            PotemkinProgress.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        try {
            ProgressManager.getInstance().runProcess(action, (ProgressIndicator)this);
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        finally {
            this.progressFinished();
        }
    }

    public void runInBackground(@NotNull Runnable action) {
        if (action == null) {
            PotemkinProgress.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.enterModality();
        try {
            this.ensureBackgroundThreadStarted(action);
            while (this.isRunning()) {
                this.dispatchAwtEventsWithoutModelAccess(10);
                this.updateUI(System.currentTimeMillis());
            }
        }
        finally {
            this.exitModality();
            this.progressFinished();
        }
    }

    private void ensureBackgroundThreadStarted(@NotNull Runnable action) {
        if (action == null) {
            PotemkinProgress.$$$reportNull$$$0(5);
        }
        Semaphore started = new Semaphore();
        started.down();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (action == null) {
                PotemkinProgress.$$$reportNull$$$0(6);
            }
            ProgressManager.getInstance().runProcess(() -> {
                if (action == null) {
                    PotemkinProgress.$$$reportNull$$$0(7);
                }
                started.up();
                action.run();
            }, (ProgressIndicator)this);
        });
        started.waitFor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/util/PotemkinProgress";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/util/PotemkinProgress";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "dispatchInputEvent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runInSwingThread";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runInBackground";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ensureBackgroundThreadStarted";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$ensureBackgroundThreadStarted$2";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

