/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.header;

import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.header.InspectionProfileSchemesPanel;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class InspectionProfileSchemesModel
implements SchemesModel<InspectionProfileModifiableModel> {
    private final List<SingleInspectionProfilePanel> myProfilePanels;
    private final List<InspectionProfileImpl> myDeletedProfiles;
    private final InspectionProfileManager myApplicationProfileManager;
    private final InspectionProfileManager myProjectProfileManager;

    protected InspectionProfileSchemesModel(@NotNull InspectionProfileManager appProfileManager, @NotNull InspectionProfileManager projectProfileManager) {
        if (appProfileManager == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(0);
        }
        if (projectProfileManager == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(1);
        }
        this.myProfilePanels = new ArrayList<SingleInspectionProfilePanel>();
        this.myDeletedProfiles = new SmartList();
        this.myApplicationProfileManager = appProfileManager;
        this.myProjectProfileManager = projectProfileManager;
    }

    @Override
    public boolean canDuplicateScheme(@NotNull InspectionProfileModifiableModel profile2) {
        if (profile2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(2);
        }
        return true;
    }

    @Override
    public boolean canResetScheme(@NotNull InspectionProfileModifiableModel profile2) {
        if (profile2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(3);
        }
        return true;
    }

    @Override
    public boolean canDeleteScheme(@NotNull InspectionProfileModifiableModel candidateToDelete) {
        boolean isProjectProfile;
        SingleInspectionProfilePanel profilePanel;
        InspectionProfileModifiableModel profile2;
        if (candidateToDelete == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(4);
        }
        boolean projectProfileFound = false;
        boolean ideProfileFound = false;
        Iterator<SingleInspectionProfilePanel> iterator = this.myProfilePanels.iterator();
        while (!(!iterator.hasNext() || candidateToDelete != (profile2 = (profilePanel = iterator.next()).getProfile()) && (ideProfileFound |= !(isProjectProfile = profile2.getProfileManager() == this.myProjectProfileManager)) && (projectProfileFound |= isProjectProfile))) {
        }
        return candidateToDelete.getProfileManager() == this.myProjectProfileManager ? projectProfileFound : ideProfileFound;
    }

    @Override
    public boolean isProjectScheme(@NotNull InspectionProfileModifiableModel profile2) {
        if (profile2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(5);
        }
        return profile2.isProjectLevel();
    }

    @Override
    public boolean canRenameScheme(@NotNull InspectionProfileModifiableModel profile2) {
        if (profile2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(6);
        }
        return true;
    }

    @Override
    public boolean containsScheme(@NotNull String name, boolean isProjectProfile) {
        if (name == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(7);
        }
        return this.hasName(name, isProjectProfile);
    }

    @Override
    public boolean differsFromDefault(@NotNull InspectionProfileModifiableModel profile2) {
        if (profile2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(8);
        }
        return this.getProfilePanel(profile2).differsFromDefault();
    }

    @Override
    public void removeScheme(@NotNull InspectionProfileModifiableModel profile2) {
        if (profile2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(9);
        }
        SingleInspectionProfilePanel panel2 = this.getProfilePanel(profile2);
        this.removeProfile(profile2);
        this.myDeletedProfiles.add(profile2);
        this.onProfileRemoved(panel2);
    }

    protected abstract void onProfileRemoved(@NotNull SingleInspectionProfilePanel var1);

    void addProfile(InspectionProfileModifiableModel profile2) {
        this.myProfilePanels.add(this.createPanel(profile2));
    }

    void removeProfile(InspectionProfileImpl profile2) {
        for (SingleInspectionProfilePanel panel2 : this.myProfilePanels) {
            if (!panel2.getProfile().equals(profile2)) continue;
            this.myProfilePanels.remove(panel2);
            break;
        }
    }

    void updatePanel(@NotNull InspectionProfileSchemesPanel panel2) {
        if (panel2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(10);
        }
        List allProfiles = this.myProfilePanels.stream().map(p -> p.getProfile()).collect(Collectors.toList());
        panel2.resetSchemes(allProfiles);
    }

    void apply(InspectionProfileModifiableModel selected, Consumer<InspectionProfileImpl> applyRootProfileAction) {
        for (InspectionProfileImpl profile2 : this.myDeletedProfiles) {
            profile2.getProfileManager().deleteProfile(profile2);
        }
        this.myDeletedProfiles.clear();
        SingleInspectionProfilePanel selectedPanel = this.getProfilePanel(selected);
        for (SingleInspectionProfilePanel panel2 : this.getProfilePanels()) {
            panel2.apply();
            if (panel2 != selectedPanel) continue;
            applyRootProfileAction.consume((Object)panel2.getProfile());
        }
    }

    void reset() {
        this.disposeUI();
        this.myDeletedProfiles.clear();
        InspectionProfileSchemesModel.getSortedProfiles(this.myApplicationProfileManager, this.myProjectProfileManager).stream().map(InspectionProfileModifiableModel::new).forEach(this::addProfile);
    }

    void disposeUI() {
        for (SingleInspectionProfilePanel panel2 : this.myProfilePanels) {
            panel2.disposeUI();
        }
        this.myProfilePanels.clear();
    }

    public SingleInspectionProfilePanel getProfilePanel(InspectionProfileImpl profile2) {
        return this.myProfilePanels.stream().filter(panel2 -> panel2.getProfile().equals(profile2)).findFirst().orElse(null);
    }

    protected abstract SingleInspectionProfilePanel createPanel(InspectionProfileModifiableModel var1);

    boolean hasName(@NotNull String name, boolean shared) {
        boolean hasName;
        if (name == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(11);
        }
        if (hasName = this.myProfilePanels.stream().map(SingleInspectionProfilePanel::getProfile).anyMatch(p -> {
            if (name == null) {
                InspectionProfileSchemesModel.$$$reportNull$$$0(16);
            }
            return name.equals(p.getName()) && p.isProjectLevel() == shared;
        })) {
            return true;
        }
        return this.myProfilePanels.stream().anyMatch(p -> {
            InspectionProfileModifiableModel profile2;
            if (name == null) {
                InspectionProfileSchemesModel.$$$reportNull$$$0(15);
            }
            return name.equals((profile2 = p.getProfile()).getName()) && profile2.isProjectLevel() == shared;
        });
    }

    List<SingleInspectionProfilePanel> getProfilePanels() {
        return this.myProfilePanels;
    }

    int getSize() {
        return this.myProfilePanels.size();
    }

    boolean hasDeletedProfiles() {
        return !this.myDeletedProfiles.isEmpty();
    }

    @NotNull
    InspectionProfileModifiableModel getModifiableModelFor(@NotNull InspectionProfileImpl profile2) {
        if (profile2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(12);
        }
        if (profile2 instanceof InspectionProfileModifiableModel) {
            InspectionProfileModifiableModel inspectionProfileModifiableModel = (InspectionProfileModifiableModel)profile2;
            if (inspectionProfileModifiableModel == null) {
                InspectionProfileSchemesModel.$$$reportNull$$$0(13);
            }
            return inspectionProfileModifiableModel;
        }
        for (SingleInspectionProfilePanel panel2 : this.myProfilePanels) {
            InspectionProfileModifiableModel modifiableModel = panel2.getProfile();
            if (!modifiableModel.getSource().equals(profile2)) continue;
            InspectionProfileModifiableModel inspectionProfileModifiableModel = modifiableModel;
            if (inspectionProfileModifiableModel == null) {
                InspectionProfileSchemesModel.$$$reportNull$$$0(14);
            }
            return inspectionProfileModifiableModel;
        }
        throw new AssertionError((Object)("profile " + profile2.getName() + " is not present among profile panels" + Arrays.toString(this.myProfilePanels.stream().map(p -> p.getProfile().getName()).toArray(String[]::new))));
    }

    public static List<InspectionProfileImpl> getSortedProfiles(InspectionProfileManager appManager, InspectionProfileManager projectManager2) {
        return ContainerUtil.concat((List)ContainerUtil.sorted(appManager.getProfiles()), (List)ContainerUtil.sorted(projectManager2.getProfiles()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appProfileManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectProfileManager";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateToDelete";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModelFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canDuplicateScheme";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canResetScheme";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteScheme";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isProjectScheme";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canRenameScheme";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsScheme";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "differsFromDefault";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeScheme";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updatePanel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getModifiableModelFor";
                break;
            }
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$hasName$3";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$hasName$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

