/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyCallByClassInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.different.class.call", new Object[0]);
        if (string == null) {
            PyCallByClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            PyCallByClassInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PyCallByClassInspection.$$$reportNull$$$0(2);
        }
        if (session2 == null) {
            PyCallByClassInspection.$$$reportNull$$$0(3);
        }
        Visitor visitor2 = new Visitor(holder, session2);
        if (visitor2 == null) {
            PyCallByClassInspection.$$$reportNull$$$0(4);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyCallByClassInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyCallByClassInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(ProblemsHolder holder, LocalInspectionToolSession session2) {
            super(holder, session2);
        }

        @Override
        public void visitPyCallExpression(PyCallExpression call) {
            PyClassType qual_class_type;
            PyType qual_type;
            PyExpression qualifier;
            PyExpression callee = call.getCallee();
            if (callee instanceof PyQualifiedExpression && (qualifier = ((PyQualifiedExpression)callee).getQualifier()) != null && (qual_type = this.myTypeEvalContext.getType(qualifier)) instanceof PyClassType && (qual_class_type = (PyClassType)qual_type).isDefinition()) {
                PyCallableParameter firstParameter;
                PyCallExpression.PyMarkedCallee markedCallee;
                PyClass qual_class = qual_class_type.getPyClass();
                PyCallExpression.PyArgumentsMapping mapping = (PyCallExpression.PyArgumentsMapping)ContainerUtil.getFirstItem(call.multiMapArguments(this.getResolveContext()));
                PyCallExpression.PyMarkedCallee pyMarkedCallee = markedCallee = mapping == null ? null : mapping.getMarkedCallee();
                if (markedCallee != null && markedCallee.getModifier() != PyFunction.Modifier.STATICMETHOD && (firstParameter = (PyCallableParameter)ContainerUtil.getFirstItem(markedCallee.getCallableType().getParameters(this.myTypeEvalContext))) != null) {
                    for (Map.Entry<PyExpression, PyCallableParameter> entry : mapping.getMappedParameters().entrySet()) {
                        PyFunction method;
                        PyCallable callable;
                        PyClass first_arg_class;
                        if (!firstParameter.equals(entry.getValue())) continue;
                        PyExpression first_arg = entry.getKey();
                        assert (first_arg != null);
                        PyType first_arg_type = this.myTypeEvalContext.getType(first_arg);
                        if (!(first_arg_type instanceof PyClassType)) break;
                        PyClassType first_arg_class_type = (PyClassType)first_arg_type;
                        if (first_arg_class_type.isDefinition() && markedCallee.getModifier() != PyFunction.Modifier.CLASSMETHOD) {
                            this.registerProblem((PsiElement)first_arg, PyBundle.message("INSP.instance.of.$0.excpected", qual_class.getQualifiedName()));
                        }
                        if ((first_arg_class = first_arg_class_type.getPyClass()) == qual_class) break;
                        if (markedCallee.getElement() instanceof PyFunction && (callable = (PyCallable)PsiTreeUtil.getParentOfType((PsiElement)call, PyCallable.class)) != null && (method = callable.asMethod()) != null) {
                            PyClass calling_class = method.getContainingClass();
                            assert (calling_class != null);
                            if (first_arg_class.isSubclass(qual_class, this.myTypeEvalContext) && calling_class.isSubclass(qual_class, this.myTypeEvalContext)) break;
                        }
                        this.registerProblem((PsiElement)first_arg, PyBundle.message("INSP.passing.$0.instead.of.$1", first_arg_class.getQualifiedName(), qual_class.getQualifiedName()));
                        break;
                    }
                }
            }
        }
    }
}

