/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.StubBasedPsiElement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.stubs.PyClassStub;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;

public class PyElementNode
extends BasePsiNode<PyElement> {
    public PyElementNode(Project project, PyElement value, ViewSettings viewSettings) {
        super(project, value, viewSettings);
    }

    @Override
    protected Collection<AbstractTreeNode> getChildrenImpl() {
        PyElement value = (PyElement)this.getValue();
        if (value instanceof PyClass) {
            PyClass pyClass = (PyClass)value;
            ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
            for (PyClass pyClass2 : pyClass.getNestedClasses()) {
                result2.add((AbstractTreeNode)new PyElementNode(this.myProject, pyClass2, this.getSettings()));
            }
            for (StubBasedPsiElement<PyClassStub> stubBasedPsiElement : pyClass.getMethods()) {
                result2.add((AbstractTreeNode)new PyElementNode(this.myProject, (PyElement)stubBasedPsiElement, this.getSettings()));
            }
            return result2;
        }
        return Collections.emptyList();
    }

    @Override
    protected void updateImpl(PresentationData data) {
        PyElement value = (PyElement)this.getValue();
        String name = value.getName();
        ItemPresentation presentation = value.getPresentation();
        String presentableText2 = name != null ? name : "<unnamed>";
        Icon presentableIcon = value.getIcon(0);
        if (presentation != null) {
            Icon icon;
            String text2 = presentation.getPresentableText();
            if (text2 != null) {
                presentableText2 = text2;
            }
            if ((icon = presentation.getIcon(false)) != null) {
                presentableIcon = icon;
            }
        }
        data.setPresentableText(presentableText2);
        data.setIcon(presentableIcon);
    }

    public int getTypeSortWeight(boolean sortByType) {
        if (!sortByType) {
            return 0;
        }
        return this.getValue() instanceof PyClass ? 10 : 20;
    }

    public boolean expandOnDoubleClick() {
        return false;
    }
}

