/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.refactoring.classes.membersManager.ClassFieldsManager;
import com.jetbrains.python.refactoring.classes.membersManager.MembersManager;
import com.jetbrains.python.refactoring.classes.membersManager.MethodsManager;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.PyRecursiveElementVisitorWithResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class PropertiesManager
extends MembersManager<PyElement> {
    PropertiesManager() {
        super(PyElement.class);
    }

    @Override
    @NotNull
    protected List<? extends PyElement> getMembersCouldBeMoved(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            PropertiesManager.$$$reportNull$$$0(0);
        }
        ArrayList<PyElement> elements = new ArrayList<PyElement>(pyClass.getProperties().size());
        for (Property property : pyClass.getProperties().values()) {
            elements.add(PropertiesManager.getElement(property));
        }
        ArrayList<PyElement> arrayList = elements;
        if (arrayList == null) {
            PropertiesManager.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    private static PyElement getElement(@NotNull Property property) {
        if (property == null) {
            PropertiesManager.$$$reportNull$$$0(2);
        }
        PyCallable getter = property.getGetter().valueOrNull();
        PyCallable setter = property.getSetter().valueOrNull();
        PyCallable deleter = property.getDeleter().valueOrNull();
        if (getter != null) {
            PyCallable pyCallable = getter;
            if (pyCallable == null) {
                PropertiesManager.$$$reportNull$$$0(3);
            }
            return pyCallable;
        }
        if (setter != null) {
            PyCallable pyCallable = setter;
            if (pyCallable == null) {
                PropertiesManager.$$$reportNull$$$0(4);
            }
            return pyCallable;
        }
        if (deleter != null) {
            PyCallable pyCallable = deleter;
            if (pyCallable == null) {
                PropertiesManager.$$$reportNull$$$0(5);
            }
            return pyCallable;
        }
        PyTargetExpression site = property.getDefinitionSite();
        assert (site != null) : "Property has no methods nor declaration. That is not property";
        PyTargetExpression pyTargetExpression = site;
        if (pyTargetExpression == null) {
            PropertiesManager.$$$reportNull$$$0(6);
        }
        return pyTargetExpression;
    }

    @NotNull
    private static Property getProperty(@NotNull PyClass pyClass, @NotNull PyElement element) {
        if (pyClass == null) {
            PropertiesManager.$$$reportNull$$$0(7);
        }
        if (element == null) {
            PropertiesManager.$$$reportNull$$$0(8);
        }
        Collection<Property> properties = pyClass.getProperties().values();
        if (element instanceof PyTargetExpression) {
            Property property = PropertiesManager.getPropertyByTargetExpression(properties, (PyTargetExpression)element);
            if (property == null) {
                PropertiesManager.$$$reportNull$$$0(9);
            }
            return property;
        }
        if (element instanceof PyFunction) {
            Property property = PropertiesManager.getPropertyByFunction(properties, (PyFunction)element);
            if (property == null) {
                PropertiesManager.$$$reportNull$$$0(10);
            }
            return property;
        }
        throw new IllegalArgumentException("Not function nor target");
    }

    @NotNull
    private static Property getPropertyByFunction(@NotNull Collection<Property> properties, @NotNull PyFunction functionToSearch) {
        if (properties == null) {
            PropertiesManager.$$$reportNull$$$0(11);
        }
        if (functionToSearch == null) {
            PropertiesManager.$$$reportNull$$$0(12);
        }
        for (Property property : properties) {
            for (PyFunction function : PropertiesManager.getAllFunctions(property)) {
                if (!function.equals(functionToSearch)) continue;
                Property property2 = property;
                if (property2 == null) {
                    PropertiesManager.$$$reportNull$$$0(13);
                }
                return property2;
            }
        }
        throw new IllegalArgumentException("No property found");
    }

    @NotNull
    private static Property getPropertyByTargetExpression(@NotNull Iterable<Property> properties, @NotNull PyTargetExpression element) {
        if (properties == null) {
            PropertiesManager.$$$reportNull$$$0(14);
        }
        if (element == null) {
            PropertiesManager.$$$reportNull$$$0(15);
        }
        for (Property property : properties) {
            if (!element.equals(property.getDefinitionSite())) continue;
            Property property2 = property;
            if (property2 == null) {
                PropertiesManager.$$$reportNull$$$0(16);
            }
            return property2;
        }
        throw new IllegalArgumentException("No property found");
    }

    @NotNull
    private static Collection<PyFunction> getAllFunctions(@NotNull Property property) {
        if (property == null) {
            PropertiesManager.$$$reportNull$$$0(17);
        }
        ArrayList<PyFunction> result2 = new ArrayList<PyFunction>(3);
        PyCallable getter = property.getGetter().valueOrNull();
        PyCallable setter = property.getSetter().valueOrNull();
        PyCallable deleter = property.getDeleter().valueOrNull();
        if (getter instanceof PyFunction) {
            result2.add((PyFunction)getter);
        }
        if (setter instanceof PyFunction) {
            result2.add((PyFunction)setter);
        }
        if (deleter instanceof PyFunction) {
            result2.add((PyFunction)deleter);
        }
        ArrayList<PyFunction> arrayList = result2;
        if (arrayList == null) {
            PropertiesManager.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @Override
    protected Collection<PyElement> moveMembers(@NotNull PyClass from, @NotNull Collection<PyMemberInfo<PyElement>> members, PyClass ... to) {
        if (from == null) {
            PropertiesManager.$$$reportNull$$$0(19);
        }
        if (members == null) {
            PropertiesManager.$$$reportNull$$$0(20);
        }
        if (to == null) {
            PropertiesManager.$$$reportNull$$$0(21);
        }
        ArrayList<PyElement> result2 = new ArrayList<PyElement>();
        Collection<PyElement> elements = PropertiesManager.fetchElements(members);
        for (PyElement element : elements) {
            Property property = PropertiesManager.getProperty(from, element);
            Collection<PyFunction> functions = PropertiesManager.getAllFunctions(property);
            MethodsManager.moveMethods(from, functions, false, to);
            PyTargetExpression definitionSite = property.getDefinitionSite();
            if (definitionSite == null) continue;
            PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)definitionSite, PyAssignmentStatement.class);
            ClassFieldsManager.moveAssignmentsImpl(from, Collections.singleton(assignmentStatement), to);
        }
        return result2;
    }

    @Override
    @NotNull
    public PyMemberInfo<PyElement> apply(@NotNull PyElement input) {
        if (input == null) {
            PropertiesManager.$$$reportNull$$$0(22);
        }
        PyMemberInfo<PyElement> pyMemberInfo = new PyMemberInfo<PyElement>(input, false, PropertiesManager.getName(input), false, this, false);
        if (pyMemberInfo == null) {
            PropertiesManager.$$$reportNull$$$0(23);
        }
        return pyMemberInfo;
    }

    private static String getName(@NotNull PyElement input) {
        if (input == null) {
            PropertiesManager.$$$reportNull$$$0(24);
        }
        PyClass clazz = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)input, PyClass.class);
        assert (clazz != null) : "Element not declared in class";
        Property property = PropertiesManager.getProperty(clazz, input);
        return property.getName();
    }

    @Override
    public boolean hasConflict(@NotNull PyElement member, @NotNull PyClass aClass) {
        if (member == null) {
            PropertiesManager.$$$reportNull$$$0(25);
        }
        if (aClass == null) {
            PropertiesManager.$$$reportNull$$$0(26);
        }
        return false;
    }

    @Override
    @NotNull
    protected MultiMap<PyClass, PyElement> getDependencies(@NotNull PyElement member) {
        if (member == null) {
            PropertiesManager.$$$reportNull$$$0(27);
        }
        PyReferenceVisitor visitor2 = new PyReferenceVisitor();
        member.accept(visitor2);
        MultiMap<PyClass, PyElement> multiMap = visitor2.myResult;
        if (multiMap == null) {
            PropertiesManager.$$$reportNull$$$0(28);
        }
        return multiMap;
    }

    @Override
    @NotNull
    protected Collection<PyElement> getDependencies(@NotNull MultiMap<PyClass, PyElement> usedElements) {
        if (usedElements == null) {
            PropertiesManager.$$$reportNull$$$0(29);
        }
        List<PyElement> list2 = Collections.emptyList();
        if (list2 == null) {
            PropertiesManager.$$$reportNull$$$0(30);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 23: 
            case 28: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 23: 
            case 28: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 23: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionToSearch";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembersCouldBeMoved";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperty";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyByFunction";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyByTargetExpression";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFunctions";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMembersCouldBeMoved";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 23: 
            case 28: 
            case 30: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyByFunction";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyByTargetExpression";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAllFunctions";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "moveMembers";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hasConflict";
                break;
            }
            case 27: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 23: 
            case 28: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PyReferenceVisitor
    extends PyRecursiveElementVisitorWithResult {
        private PyReferenceVisitor() {
        }

        @Override
        public void visitPyExpression(PyExpression node) {
            PyClass pyClass;
            PsiReference reference = node.getReference();
            if (reference == null) {
                return;
            }
            PsiElement declaration = reference.resolve();
            if (!(declaration instanceof PyFunction)) {
                return;
            }
            PyFunction function = (PyFunction)declaration;
            Property property = function.getProperty();
            if (property == null) {
                return;
            }
            PyClass aClass = function.getContainingClass();
            if (aClass == null) {
                return;
            }
            Collection functions = PropertiesManager.getAllFunctions(property);
            for (PyFunction pyFunction : functions) {
                PyClass functionClass = pyFunction.getContainingClass();
                if (functionClass == null) continue;
                this.myResult.putValue((Object)functionClass, (Object)pyFunction);
            }
            PyTargetExpression definitionSite = property.getDefinitionSite();
            if (definitionSite != null && (pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)definitionSite, PyClass.class)) != null) {
                this.myResult.putValue((Object)pyClass, (Object)definitionSite);
            }
        }
    }
}

