/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.SystemProperties;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySdkUtil {
    protected static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.sdk.SdkVersionUtil");
    public static final int SUBSTITUTE = 26;
    public static final String PATH_ENV_VARIABLE = "PATH";

    private PySdkUtil() {
    }

    @NotNull
    public static ProcessOutput getProcessOutput(String homePath, @NonNls String[] command) {
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(homePath, command, -1);
        if (processOutput == null) {
            PySdkUtil.$$$reportNull$$$0(0);
        }
        return processOutput;
    }

    @NotNull
    public static ProcessOutput getProcessOutput(String homePath, @NonNls String[] command, int timeout) {
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(homePath, command, null, timeout);
        if (processOutput == null) {
            PySdkUtil.$$$reportNull$$$0(1);
        }
        return processOutput;
    }

    @NotNull
    public static ProcessOutput getProcessOutput(String homePath, @NonNls String[] command, @Nullable @NonNls Map<String, String> extraEnv, int timeout) {
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(homePath, command, extraEnv, timeout, null, true);
        if (processOutput == null) {
            PySdkUtil.$$$reportNull$$$0(2);
        }
        return processOutput;
    }

    @NotNull
    public static ProcessOutput getProcessOutput(String homePath, @NonNls String[] command, @Nullable @NonNls Map<String, String> extraEnv, int timeout, @Nullable byte[] stdin, boolean needEOFMarker) {
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(new GeneralCommandLine(command), homePath, extraEnv, timeout, stdin, needEOFMarker);
        if (processOutput == null) {
            PySdkUtil.$$$reportNull$$$0(3);
        }
        return processOutput;
    }

    public static ProcessOutput getProcessOutput(@NotNull GeneralCommandLine cmd, @Nullable String homePath, @Nullable @NonNls Map<String, String> extraEnv, int timeout) {
        if (cmd == null) {
            PySdkUtil.$$$reportNull$$$0(4);
        }
        return PySdkUtil.getProcessOutput(cmd, homePath, extraEnv, timeout, null, true);
    }

    public static ProcessOutput getProcessOutput(@NotNull GeneralCommandLine cmd, @Nullable String homePath, @Nullable @NonNls Map<String, String> extraEnv, int timeout, @Nullable byte[] stdin, boolean needEOFMarker) {
        if (cmd == null) {
            PySdkUtil.$$$reportNull$$$0(5);
        }
        if (homePath == null || !new File(homePath).exists()) {
            return new ProcessOutput();
        }
        Map<String, String> systemEnv = System.getenv();
        Map<String, String> expandedCmdEnv = PySdkUtil.mergeEnvVariables(systemEnv, cmd.getEnvironment());
        Map<String, String> env = extraEnv != null ? PySdkUtil.mergeEnvVariables(expandedCmdEnv, extraEnv) : expandedCmdEnv;
        PythonEnvUtil.resetHomePathChanges(homePath, env);
        try {
            ProgressIndicator indicator;
            CommandLinePatcher cmdLinePatcher;
            GeneralCommandLine commandLine = cmd.withWorkDirectory(homePath).withEnvironment(env);
            PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(commandLine.getExePath());
            CommandLinePatcher commandLinePatcher = cmdLinePatcher = flavor != null ? flavor.commandLinePatcher() : null;
            if (cmdLinePatcher != null) {
                cmdLinePatcher.patchCommandLine(cmd);
            }
            CapturingProcessHandler processHandler2 = new CapturingProcessHandler(commandLine);
            if (stdin != null) {
                OutputStream processInput = processHandler2.getProcessInput();
                assert (processInput != null);
                processInput.write(stdin);
                if (SystemInfo.isWindows && needEOFMarker) {
                    processInput.write(26);
                    processInput.flush();
                } else {
                    processInput.close();
                }
            }
            return processHandler2.runProcessWithProgressIndicator((ProgressIndicator)((indicator = ProgressManager.getInstance().getProgressIndicator()) != null ? indicator : new EmptyProgressIndicator()), timeout);
        }
        catch (ExecutionException | IOException e) {
            return PySdkUtil.getOutputForException((Exception)e);
        }
    }

    private static ProcessOutput getOutputForException(final Exception e) {
        LOG.warn((Throwable)e);
        return new ProcessOutput(){

            @NotNull
            public String getStderr() {
                String err = super.getStderr();
                err = !StringUtil.isEmpty((String)err) ? err + "\n" + e.getMessage() : e.getMessage();
                String string = err;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PySdkUtil$1", "getStderr"));
            }
        };
    }

    @NotNull
    public static Map<String, String> mergeEnvVariables(@NotNull Map<String, String> environment, @NotNull Map<String, String> extraEnvironment) {
        if (environment == null) {
            PySdkUtil.$$$reportNull$$$0(6);
        }
        if (extraEnvironment == null) {
            PySdkUtil.$$$reportNull$$$0(7);
        }
        HashMap<String, String> result2 = new HashMap<String, String>(environment);
        for (Map.Entry<String, String> entry : extraEnvironment.entrySet()) {
            String name = entry.getKey();
            if (PATH_ENV_VARIABLE.equals(name) || "PYTHONPATH".equals(name)) {
                PythonEnvUtil.addPathToEnv(result2, name, entry.getValue());
                continue;
            }
            result2.put(name, entry.getValue());
        }
        HashMap<String, String> hashMap = result2;
        if (hashMap == null) {
            PySdkUtil.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    public static boolean isRemote(@Nullable Sdk sdk) {
        return sdk != null && sdk.getSdkAdditionalData() instanceof RemoteSdkAdditionalData;
    }

    public static String getUserSite() {
        if (SystemInfo.isWindows) {
            String appdata = System.getenv("APPDATA");
            return appdata + File.separator + "Python";
        }
        String userHome = SystemProperties.getUserHome();
        return userHome + File.separator + ".local";
    }

    public static boolean isElementInSkeletons(@NotNull PsiElement element) {
        VirtualFile skeletonsDir;
        Sdk sdk;
        VirtualFile virtualFile;
        PsiFile file2;
        if (element == null) {
            PySdkUtil.$$$reportNull$$$0(9);
        }
        return (file2 = element.getContainingFile()) != null && (virtualFile = file2.getVirtualFile()) != null && (sdk = PythonSdkType.findPythonSdk(element)) != null && (skeletonsDir = PySdkUtil.findSkeletonsDir(sdk)) != null && VfsUtilCore.isAncestor((VirtualFile)skeletonsDir, (VirtualFile)virtualFile, (boolean)false);
    }

    public static String getRemoteSourcesLocalPath(String sdkHome) {
        String sep = File.separator;
        String basePath = PathManager.getSystemPath();
        return basePath + File.separator + "remote_sources" + sep + FileUtil.toSystemIndependentName((String)sdkHome).hashCode() + sep;
    }

    @Nullable
    public static VirtualFile findSkeletonsDir(@NotNull Sdk sdk) {
        if (sdk == null) {
            PySdkUtil.$$$reportNull$$$0(10);
        }
        return PySdkUtil.findLibraryDir(sdk, "python_stubs", PythonSdkType.BUILTIN_ROOT_TYPE);
    }

    @Nullable
    public static VirtualFile findAnyRemoteLibrary(@NotNull Sdk sdk) {
        if (sdk == null) {
            PySdkUtil.$$$reportNull$$$0(11);
        }
        return PySdkUtil.findLibraryDir(sdk, "remote_sources", OrderRootType.CLASSES);
    }

    private static VirtualFile findLibraryDir(Sdk sdk, String dirName, OrderRootType rootType) {
        VirtualFile[] virtualFiles;
        for (VirtualFile virtualFile : virtualFiles = sdk.getRootProvider().getFiles(rootType)) {
            if (!virtualFile.isValid() || !virtualFile.getPath().contains(dirName)) continue;
            return virtualFile;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PySdkUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraEnvironment";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PySdkUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeEnvVariables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mergeEnvVariables";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isElementInSkeletons";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findSkeletonsDir";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findAnyRemoteLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

