/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.xml.XmlPropertiesFile;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class I18nUtil {
    @NotNull
    public static List<PropertiesFile> propertiesFilesByBundleName(String resourceBundleName, @NotNull PsiElement context) {
        Project project;
        Module module;
        VirtualFile virtualFile;
        PsiFile containingFile;
        PsiLanguageInjectionHost containingFileContext;
        if (context == null) {
            I18nUtil.$$$reportNull$$$0(0);
        }
        if ((containingFileContext = InjectedLanguageManager.getInstance((Project)(containingFile = context.getContainingFile()).getProject()).getInjectionHost((PsiElement)containingFile)) != null) {
            containingFile = containingFileContext.getContainingFile();
        }
        if ((virtualFile = containingFile.getVirtualFile()) == null) {
            virtualFile = containingFile.getOriginalFile().getVirtualFile();
        }
        if (virtualFile != null && (module = ProjectRootManager.getInstance((Project)(project = containingFile.getProject())).getFileIndex().getModuleForFile(virtualFile)) != null) {
            PropertiesReferenceManager refManager = PropertiesReferenceManager.getInstance(project);
            List<PropertiesFile> list = refManager.findPropertiesFiles(module, resourceBundleName);
            if (list == null) {
                I18nUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<PropertiesFile> list = Collections.emptyList();
        if (list == null) {
            I18nUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    public static void createProperty(@NotNull Project project, @NotNull Collection<PropertiesFile> propertiesFiles, @NotNull String key, @NotNull String value) throws IncorrectOperationException {
        if (project == null) {
            I18nUtil.$$$reportNull$$$0(3);
        }
        if (propertiesFiles == null) {
            I18nUtil.$$$reportNull$$$0(4);
        }
        if (key == null) {
            I18nUtil.$$$reportNull$$$0(5);
        }
        if (value == null) {
            I18nUtil.$$$reportNull$$$0(6);
        }
        I18nUtil.createProperty(project, propertiesFiles, key, value, false);
    }

    public static void createProperty(@NotNull Project project, @NotNull Collection<PropertiesFile> propertiesFiles, @NotNull String key, @NotNull String value, boolean replaceIfExist) throws IncorrectOperationException {
        if (project == null) {
            I18nUtil.$$$reportNull$$$0(7);
        }
        if (propertiesFiles == null) {
            I18nUtil.$$$reportNull$$$0(8);
        }
        if (key == null) {
            I18nUtil.$$$reportNull$$$0(9);
        }
        if (value == null) {
            I18nUtil.$$$reportNull$$$0(10);
        }
        for (PropertiesFile file : propertiesFiles) {
            IProperty existingProperty;
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            Document document = documentManager.getDocument(file.getContainingFile());
            if (document != null) {
                documentManager.commitDocument(document);
            }
            if ((existingProperty = file.findPropertyByKey(key)) == null) {
                file.addProperty(key, value);
                continue;
            }
            if (!replaceIfExist) continue;
            existingProperty.setValue(value);
        }
    }

    public static List<String> defaultSuggestPropertiesFiles(@NotNull Project project) {
        if (project == null) {
            I18nUtil.$$$reportNull$$$0(11);
        }
        ArrayList<String> paths = new ArrayList<String>();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        PropertiesReferenceManager.getInstance(project).processAllPropertiesFiles((baseName, propertiesFile) -> {
            if (propertiesFile instanceof XmlPropertiesFile) {
                return true;
            }
            VirtualFile virtualFile = propertiesFile.getVirtualFile();
            if (projectFileIndex.isInContent(virtualFile)) {
                String path = FileUtil.toSystemDependentName((String)virtualFile.getPath());
                paths.add(path);
            }
            return true;
        });
        return paths;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/references/I18nUtil";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesFiles";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/references/I18nUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "propertiesFilesByBundleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "propertiesFilesByBundleName";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createProperty";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "defaultSuggestPropertiesFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

