/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.experimental;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.coroutines.experimental.Continuation;
import kotlin.coroutines.experimental.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.experimental.Cancelled;
import kotlinx.coroutines.experimental.CompletedExceptionally;
import kotlinx.coroutines.experimental.CoroutineExceptionHandlerKt;
import kotlinx.coroutines.experimental.DispatchedKt;
import kotlinx.coroutines.experimental.DispatchedTask;
import kotlinx.coroutines.experimental.JobSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\b \u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u001b\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0001J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0010\u00a2\u0006\u0002\b\u0015J\u001f\u0010\u0016\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0019J\u0015\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u001a\u0010\u001d\u001a\u00020\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\"H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Lkotlinx/coroutines/experimental/AbstractContinuation;", "T", "Lkotlinx/coroutines/experimental/JobSupport;", "Lkotlin/coroutines/experimental/Continuation;", "Lkotlinx/coroutines/experimental/DispatchedTask;", "delegate", "resumeMode", "", "(Lkotlin/coroutines/experimental/Continuation;I)V", "_decision", "Lkotlinx/atomicfu/AtomicInt;", "getDelegate", "()Lkotlin/coroutines/experimental/Continuation;", "getResumeMode", "()I", "getResult", "", "handleException", "", "exception", "", "handleException$kotlinx_coroutines_core", "onCompletionInternal", "state", "mode", "onCompletionInternal$kotlinx_coroutines_core", "resume", "value", "(Ljava/lang/Object;)V", "resumeImpl", "proposedUpdate", "resumeWithException", "takeState", "tryResume", "", "trySuspend", "kotlinx-coroutines-core"})
public abstract class AbstractContinuation<T>
extends JobSupport
implements Continuation<T>,
DispatchedTask<T> {
    private volatile int _decision;
    private static final AtomicIntegerFieldUpdater _decision$FU = AtomicIntegerFieldUpdater.newUpdater(AbstractContinuation.class, "_decision");
    @NotNull
    private final Continuation<T> delegate;
    private final int resumeMode;

    @Override
    @Nullable
    public Object takeState() {
        return this.getState$kotlinx_coroutines_core();
    }

    private final boolean trySuspend() {
        AbstractContinuation $receiver$iv = this;
        block4: while (true) {
            int decision = $receiver$iv._decision;
            switch (decision) {
                case 0: {
                    if (!_decision$FU.compareAndSet(this, 0, 1)) continue block4;
                    return true;
                }
                case 2: {
                    return false;
                }
                default: {
                    String string = "Already suspended";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
            break;
        }
    }

    private final boolean tryResume() {
        AbstractContinuation $receiver$iv = this;
        block4: while (true) {
            int decision = $receiver$iv._decision;
            switch (decision) {
                case 0: {
                    if (!_decision$FU.compareAndSet(this, 0, 2)) continue block4;
                    return true;
                }
                case 1: {
                    return false;
                }
                default: {
                    String string = "Already resumed";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
            break;
        }
    }

    @PublishedApi
    @Nullable
    public final Object getResult() {
        if (this.trySuspend()) {
            return IntrinsicsKt.getCOROUTINE_SUSPENDED();
        }
        Object state = this.getState$kotlinx_coroutines_core();
        if (state instanceof CompletedExceptionally) {
            throw ((CompletedExceptionally)state).getException();
        }
        return this.getSuccessfulResult(state);
    }

    @Override
    public final void onCompletionInternal$kotlinx_coroutines_core(@Nullable Object state, int mode) {
        if (this.tryResume()) {
            return;
        }
        DispatchedKt.dispatch(this, mode);
    }

    public void resume(T value) {
        this.resumeImpl(value, this.resumeMode);
    }

    public void resumeWithException(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        this.resumeImpl(new CompletedExceptionally(exception), this.resumeMode);
    }

    protected final void resumeImpl(@Nullable Object proposedUpdate, int resumeMode) {
        Object state;
        Object object;
        AbstractContinuation this_$iv = this;
        while ((object = (state = this_$iv.getState$kotlinx_coroutines_core())) instanceof JobSupport.Incomplete) {
            if (!this.updateState$kotlinx_coroutines_core((JobSupport.Incomplete)state, proposedUpdate, resumeMode)) continue;
            return;
        }
        if (object instanceof Cancelled) {
            if (proposedUpdate instanceof CompletedExceptionally && Intrinsics.areEqual((Object)((CompletedExceptionally)proposedUpdate).getException(), (Object)((Cancelled)state).getException()) ^ true) {
                this.handleException$kotlinx_coroutines_core(((CompletedExceptionally)proposedUpdate).getException());
            }
            return;
        }
        String string = "Already resumed, but got " + proposedUpdate;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Override
    public void handleException$kotlinx_coroutines_core(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        CoroutineExceptionHandlerKt.handleCoroutineException(this.getContext(), exception);
    }

    @Override
    @NotNull
    public final Continuation<T> getDelegate() {
        return this.delegate;
    }

    @Override
    public final int getResumeMode() {
        return this.resumeMode;
    }

    public AbstractContinuation(@NotNull Continuation<? super T> delegate, int resumeMode) {
        Intrinsics.checkParameterIsNotNull(delegate, (String)"delegate");
        super(true);
        this.delegate = delegate;
        this.resumeMode = resumeMode;
        this._decision = 0;
    }

    @Override
    public <T> T getSuccessfulResult(@Nullable Object state) {
        return DispatchedTask.DefaultImpls.getSuccessfulResult(this, state);
    }

    @Override
    @Nullable
    public Throwable getExceptionalResult(@Nullable Object state) {
        return DispatchedTask.DefaultImpls.getExceptionalResult(this, state);
    }

    @Override
    public void run() {
        DispatchedTask.DefaultImpls.run(this);
    }
}

