/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.core.Diagram;

public class GeneratedImageImpl
implements GeneratedImage {
    private final File pngFile;
    private final String description;
    private final BlockUml blockUml;

    public GeneratedImageImpl(File pngFile, String description, BlockUml blockUml) {
        this.blockUml = blockUml;
        this.pngFile = pngFile;
        this.description = description;
    }

    @Override
    public File getPngFile() {
        return this.pngFile;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int lineErrorRaw() {
        Diagram system = this.blockUml.getDiagram();
        if (system instanceof PSystemError) {
            return ((PSystemError)system).getHigherErrorPosition2().getPosition();
        }
        return -1;
    }

    public String toString() {
        return this.pngFile.getAbsolutePath() + " " + this.description;
    }

    @Override
    public int compareTo(GeneratedImage this2) {
        int cmp = this.pngFile.compareTo(this2.getPngFile());
        if (cmp != 0) {
            return cmp;
        }
        return this.description.compareTo(this2.getDescription());
    }

    public int hashCode() {
        return this.pngFile.hashCode() + this.description.hashCode();
    }

    public boolean equals(Object obj) {
        GeneratedImageImpl this2 = (GeneratedImageImpl)obj;
        return this2.pngFile.equals(this.pngFile) && this2.description.equals(this.description);
    }

    public BlockUml getBlockUml() {
        return this.blockUml;
    }
}

