/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class FtileSplit1
extends AbstractFtile {
    private final List<Ftile> forks = new ArrayList<Ftile>();

    public FtileSplit1(List<Ftile> forks) {
        super(forks.get(0).skinParam());
        for (Ftile ftile : forks) {
            this.forks.add(ftile);
        }
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.forks.get(0).getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return null;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return FtileSplit1.mergeSwimlanes(this.forks);
    }

    public static Set<Swimlane> mergeSwimlanes(List<Ftile> tiles) {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        for (Ftile tile : tiles) {
            result.addAll(tile.getSwimlanes());
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        for (Ftile ftile : this.forks) {
            ug.apply(this.getTranslateFor(ftile, stringBounder)).draw(ftile);
        }
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        double height = 0.0;
        double width = 0.0;
        for (Ftile ftile : this.forks) {
            FtileGeometry dim = ftile.calculateDimension(stringBounder);
            if (((Dimension2D)dim).getWidth() > width) {
                width = ((Dimension2D)dim).getWidth();
            }
            if (!(((Dimension2D)dim).getHeight() > height)) continue;
            height = ((Dimension2D)dim).getHeight();
        }
        Dimension2DDouble dimTotal = new Dimension2DDouble(width, height);
        return new FtileGeometry(dimTotal, ((Dimension2D)dimTotal).getWidth() / 2.0, 0.0, ((Dimension2D)dimTotal).getHeight());
    }

    @Override
    public UTranslate getTranslateFor(Ftile searched, StringBounder stringBounder) {
        FtileGeometry dim = searched.calculateDimension(stringBounder);
        double xpos = this.calculateDimension(stringBounder).getWidth() - ((Dimension2D)dim).getWidth();
        return new UTranslate(xpos / 2.0, 0.0);
    }
}

