/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.CharSequence2Impl;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.IfManager;
import net.sourceforge.plantuml.preproc.PreprocessorInclude;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineInsertable;
import net.sourceforge.plantuml.utils.StartUtils;

public class Preprocessor
implements ReadLine {
    private static final String END_DEFINE_LONG = "!enddefinelong";
    private static final String ID = "[A-Za-z_][A-Za-z_0-9]*";
    private static final String ID_ARG = "\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?";
    private static final String ARG = "(?:\\(\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?(?:,\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?)*?\\))?";
    private static final Pattern2 definePattern = MyPattern.cmpile("^[%s]*!define[%s]+([A-Za-z_][A-Za-z_0-9]*(?:\\(\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?(?:,\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?)*?\\))?)(?:[%s]+(.*))?$");
    private static final Pattern2 undefPattern = MyPattern.cmpile("^[%s]*!undef[%s]+([A-Za-z_][A-Za-z_0-9]*)$");
    private static final Pattern2 definelongPattern = MyPattern.cmpile("^[%s]*!definelong[%s]+([A-Za-z_][A-Za-z_0-9]*(?:\\(\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?(?:,\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?)*?\\))?)");
    private static final Pattern2 enddefinelongPattern = MyPattern.cmpile("^[%s]*!enddefinelong[%s]*$");
    private final Defines defines;
    private final PreprocessorInclude rawSource;
    private final ReadLineInsertable source;
    private int ignoreDefineDuringSeveralLines = 0;

    public Preprocessor(ReadLine reader, String charset, Defines defines, File newCurrentDir, DefinitionsContainer definitionsContainer) {
        this.defines = defines;
        this.defines.saveState();
        this.rawSource = new PreprocessorInclude(reader, defines, charset, newCurrentDir, definitionsContainer);
        this.source = new ReadLineInsertable(new IfManager(this.rawSource, defines));
    }

    @Override
    public CharSequence2 readLine() throws IOException {
        Matcher2 m;
        CharSequence2 s = this.source.readLine();
        if (s == null) {
            return null;
        }
        if (StartUtils.isArobaseStartDiagram(s)) {
            this.defines.restoreState();
        }
        if ((m = definePattern.matcher(s)).find()) {
            return this.manageDefine(m, s.toString().trim().endsWith("()"));
        }
        m = definelongPattern.matcher(s);
        if (m.find()) {
            return this.manageDefineLong(m, s.toString().trim().endsWith("()"));
        }
        m = undefPattern.matcher(s);
        if (m.find()) {
            return this.manageUndef(m);
        }
        if (this.ignoreDefineDuringSeveralLines > 0) {
            --this.ignoreDefineDuringSeveralLines;
            return s;
        }
        List<String> result = this.defines.applyDefines(s.toString2());
        if (result.size() > 1) {
            result = this.cleanEndDefineLong(result);
            List<String> inserted = this.cleanEndDefineLong(result.subList(1, result.size()));
            this.ignoreDefineDuringSeveralLines = inserted.size();
            this.source.insert(inserted, s.getLocation());
        }
        return new CharSequence2Impl(result.get(0), s.getLocation(), s.getPreprocessorError());
    }

    private List<String> cleanEndDefineLong(List<String> data) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : data) {
            String clean = this.cleanEndDefineLong(s);
            if (clean == null) continue;
            result.add(clean);
        }
        return result;
    }

    private String cleanEndDefineLong(String s) {
        if (s.trim().startsWith(END_DEFINE_LONG) && (s = s.trim().substring(END_DEFINE_LONG.length())).length() == 0) {
            return null;
        }
        return s;
    }

    private CharSequence2 manageUndef(Matcher2 m) throws IOException {
        this.defines.undefine(m.group(1));
        return this.readLine();
    }

    private CharSequence2 manageDefineLong(Matcher2 m, boolean emptyParentheses) throws IOException {
        CharSequence2 read;
        String group1 = m.group(1);
        ArrayList<String> def = new ArrayList<String>();
        do {
            if ((read = this.readLine()) == null) {
                return null;
            }
            def.add(read.toString2());
        } while (!enddefinelongPattern.matcher(read).find());
        this.defines.define(group1, def, emptyParentheses);
        return this.readLine();
    }

    private CharSequence2 manageDefine(Matcher2 m, boolean emptyParentheses) throws IOException {
        String group1 = m.group(1);
        String group2 = m.group(2);
        if (group2 == null) {
            this.defines.define(group1, null, emptyParentheses);
        } else {
            List<String> strings = this.defines.applyDefines(group2);
            if (strings.size() > 1) {
                this.defines.define(group1, strings, emptyParentheses);
            } else {
                StringBuilder value = new StringBuilder(strings.get(0));
                while (StringUtils.endsWithBackslash(value.toString())) {
                    value.setLength(value.length() - 1);
                    CharSequence2 read = this.readLine();
                    value.append(read.toString2());
                }
                ArrayList<String> li = new ArrayList<String>();
                li.add(value.toString());
                this.defines.define(group1, li, emptyParentheses);
            }
        }
        return this.readLine();
    }

    public int getLineNumber() {
        return this.rawSource.getLineNumber();
    }

    @Override
    public void close() throws IOException {
        this.rawSource.close();
    }

    public Set<FileWithSuffix> getFilesUsed() {
        return Collections.unmodifiableSet(this.rawSource.getFilesUsedGlobal());
    }
}

