/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project2;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project2.Row;
import net.sourceforge.plantuml.project2.TimeConverter;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class RowMerge
implements Row {
    private final Row r1;
    private final Row r2;

    public RowMerge(Row r1, Row r2) {
        this.r1 = r1;
        this.r2 = r2;
    }

    @Override
    public TextBlock asTextBloc(final TimeConverter timeConverter) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                RowMerge.this.r1.asTextBloc(timeConverter).drawU(ug);
                RowMerge.this.r2.asTextBloc(timeConverter).drawU(ug.apply(new UTranslate(0.0, RowMerge.this.r1.getHeight())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                double width = RowMerge.this.getMaxXwithoutHeader(timeConverter) - RowMerge.this.getMinXwithoutHeader(timeConverter);
                double height = RowMerge.this.getHeight();
                return new Dimension2DDouble(width, height);
            }
        };
    }

    @Override
    public double getMinXwithoutHeader(TimeConverter timeConverter) {
        return Math.min(this.r1.getMinXwithoutHeader(timeConverter), this.r2.getMinXwithoutHeader(timeConverter));
    }

    @Override
    public double getMaxXwithoutHeader(TimeConverter timeConverter) {
        return Math.max(this.r1.getMaxXwithoutHeader(timeConverter), this.r2.getMaxXwithoutHeader(timeConverter));
    }

    @Override
    public double getHeight() {
        return this.r1.getHeight() + this.r2.getHeight();
    }

    @Override
    public TextBlock header() {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                RowMerge.this.r1.header().drawU(ug);
                RowMerge.this.r2.header().drawU(ug.apply(new UTranslate(0.0, RowMerge.this.r1.getHeight())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                double width = Math.max(RowMerge.this.r1.header().calculateDimension(stringBounder).getWidth(), RowMerge.this.r2.header().calculateDimension(stringBounder).getWidth());
                double height = RowMerge.this.getHeight();
                return new Dimension2DDouble(width, height);
            }
        };
    }
}

