/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import org.apache.solr.cloud.CloudUtil;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.util.RTimer;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LeaderInitiatedRecoveryThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected ZkController zkController;
    protected CoreContainer coreContainer;
    protected String collection;
    protected String shardId;
    protected ZkCoreNodeProps nodeProps;
    protected int maxTries;
    private CoreDescriptor leaderCd;

    public LeaderInitiatedRecoveryThread(ZkController zkController, CoreContainer cc, String collection, String shardId, ZkCoreNodeProps nodeProps, int maxTries, CoreDescriptor leaderCd) {
        super("LeaderInitiatedRecoveryThread-" + nodeProps.getCoreName());
        this.zkController = zkController;
        this.coreContainer = cc;
        this.collection = collection;
        this.shardId = shardId;
        this.nodeProps = nodeProps;
        this.maxTries = maxTries;
        this.leaderCd = leaderCd;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        boolean sendRecoveryCommand;
        RTimer timer = new RTimer();
        String replicaCoreName = this.nodeProps.getCoreName();
        String replicaCoreNodeName = ((Replica)this.nodeProps.getNodeProps()).getName();
        String replicaNodeName = this.nodeProps.getNodeName();
        String replicaUrl = this.nodeProps.getCoreUrl();
        if (!this.zkController.isReplicaInRecoveryHandling(replicaUrl)) {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Replica: " + replicaUrl + " should have been marked under leader initiated recovery in ZkController but wasn't.");
        }
        if (!CloudUtil.replicaExists(this.zkController.getClusterState(), this.collection, this.shardId, replicaCoreNodeName)) {
            log.info("Replica does not exist, skip doing LIR");
        }
        if (sendRecoveryCommand = this.publishDownState(replicaCoreName, replicaCoreNodeName, replicaNodeName, replicaUrl, false)) {
            try {
                this.sendRecoveryCommandWithRetry();
            }
            catch (Exception exc) {
                log.error(this.getName() + " failed due to: " + exc, (Throwable)exc);
                if (exc instanceof SolrException) {
                    throw (SolrException)((Object)exc);
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)exc);
            }
            finally {
                this.zkController.removeReplicaFromLeaderInitiatedRecoveryHandling(replicaUrl);
            }
        } else {
            this.zkController.removeReplicaFromLeaderInitiatedRecoveryHandling(replicaUrl);
        }
        log.info("{} completed successfully after running for {}ms", (Object)this.getName(), (Object)timer.getTime());
    }

    public boolean publishDownState(String replicaCoreName, String replicaCoreNodeName, String replicaNodeName, String replicaUrl, boolean forcePublishState) {
        boolean sendRecoveryCommand = true;
        boolean publishDownState = false;
        if (this.zkController.getZkStateReader().getClusterState().liveNodesContain(replicaNodeName)) {
            try {
                this.updateLIRState(replicaCoreNodeName);
                log.info("Put replica core={} coreNodeName={} on " + replicaNodeName + " into leader-initiated recovery.", (Object)replicaCoreName, (Object)replicaCoreNodeName);
                publishDownState = true;
            }
            catch (Exception e) {
                Throwable setLirZnodeFailedCause = SolrException.getRootCause((Throwable)e);
                log.error("Leader failed to set replica " + this.nodeProps.getCoreUrl() + " state to DOWN due to: " + setLirZnodeFailedCause, setLirZnodeFailedCause);
                if (setLirZnodeFailedCause instanceof KeeperException.SessionExpiredException || setLirZnodeFailedCause instanceof KeeperException.ConnectionLossException || setLirZnodeFailedCause instanceof ZkController.NotLeaderException) {
                    sendRecoveryCommand = false;
                    forcePublishState = false;
                }
            }
        } else {
            log.info("Node " + replicaNodeName + " is not live, so skipping leader-initiated recovery for replica: core={} coreNodeName={}", (Object)replicaCoreName, (Object)replicaCoreNodeName);
            forcePublishState = false;
            sendRecoveryCommand = false;
        }
        try {
            if (publishDownState || forcePublishState) {
                ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "state", "state", Replica.State.DOWN.toString(), "base_url", this.nodeProps.getBaseUrl(), "core", this.nodeProps.getCoreName(), "core_node_name", replicaCoreNodeName, "node_name", this.nodeProps.getNodeName(), "shard", this.shardId, "collection", this.collection, "force_set_state", "false"});
                log.warn("Leader is publishing core={} coreNodeName ={} state={} on behalf of un-reachable replica {}", new Object[]{replicaCoreName, replicaCoreNodeName, Replica.State.DOWN.toString(), replicaUrl});
                this.zkController.getOverseerJobQueue().offer(Utils.toJSON((Object)m));
            }
        }
        catch (Exception e) {
            log.error("Could not publish 'down' state for replicaUrl: {}", (Object)replicaUrl, (Object)e);
        }
        return sendRecoveryCommand;
    }

    private void removeLIRState(String replicaCoreNodeName) {
        this.zkController.updateLeaderInitiatedRecoveryState(this.collection, this.shardId, replicaCoreNodeName, Replica.State.ACTIVE, this.leaderCd, true);
    }

    protected void updateLIRState(String replicaCoreNodeName) {
        this.zkController.updateLeaderInitiatedRecoveryState(this.collection, this.shardId, replicaCoreNodeName, Replica.State.DOWN, this.leaderCd, true);
    }

    /*
     * Exception decompiling
     */
    protected void sendRecoveryCommandWithRetry() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

