/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import com.codahale.metrics.MetricSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.lucene.util.Version;
import org.apache.solr.api.V2HttpCall;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.SolrXmlConfig;
import org.apache.solr.metrics.AltBufferPoolMetricSet;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.OperatingSystemMetricSet;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.servlet.BaseSolrFilter;
import org.apache.solr.servlet.HttpSolrCall;
import org.apache.solr.servlet.ServletInputStreamWrapper;
import org.apache.solr.servlet.ServletOutputStreamWrapper;
import org.apache.solr.servlet.SolrRequestParsers;
import org.apache.solr.util.SolrFileCleaningTracker;
import org.apache.solr.util.StartupLoggingUtils;
import org.apache.solr.util.configuration.SSLConfigurationsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrDispatchFilter
extends BaseSolrFilter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected volatile CoreContainer cores;
    protected final CountDownLatch init = new CountDownLatch(1);
    protected String abortErrorMessage = null;
    protected HttpClient httpClient;
    private ArrayList<Pattern> excludePatterns;
    private boolean isV2Enabled = !"true".equals(System.getProperty("disable.v2.api", "false"));
    private final String metricTag = Integer.toHexString(this.hashCode());
    private SolrMetricManager metricManager;
    private String registryName;
    public static final String PROPERTIES_ATTRIBUTE = "solr.properties";
    public static final String SOLRHOME_ATTRIBUTE = "solr.solr.home";
    public static final String SOLR_INSTALL_DIR_ATTRIBUTE = "solr.install.dir";
    public static final String SOLR_DEFAULT_CONFDIR_ATTRIBUTE = "solr.default.confdir";
    public static final String SOLR_LOG_MUTECONSOLE = "solr.log.muteconsole";
    public static final String SOLR_LOG_LEVEL = "solr.log.level";
    private static String CLOSE_STREAM_MSG = "Attempted close of http request or response stream - in general you should not do this, you may spoil connection reuse and possibly disrupt a client. If you must close without actually needing to close, use a CloseShield*Stream. Closing or flushing the response stream commits the response and prevents us from modifying it. Closing the request stream prevents us from gauranteeing ourselves that streams are fully read for proper connection reuse.Let the container manage the lifecycle of these streams when possible.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig config) throws ServletException {
        SSLConfigurationsFactory.current().init();
        log.trace("SolrDispatchFilter.init(): {}", (Object)this.getClass().getClassLoader());
        CoreContainer coresInit = null;
        try {
            String exclude;
            String logLevel;
            SolrRequestParsers.fileCleaningTracker = new SolrFileCleaningTracker();
            StartupLoggingUtils.checkLogDir();
            log.info("Using logger factory {}", (Object)StartupLoggingUtils.getLoggerImplStr());
            this.logWelcomeBanner();
            String muteConsole = System.getProperty(SOLR_LOG_MUTECONSOLE);
            if (muteConsole != null && !Arrays.asList("false", "0", "off", "no").contains(muteConsole.toLowerCase(Locale.ROOT))) {
                StartupLoggingUtils.muteConsole();
            }
            if ((logLevel = System.getProperty(SOLR_LOG_LEVEL)) != null) {
                log.info("Log level override, property solr.log.level=" + logLevel);
                StartupLoggingUtils.changeLogLevel(logLevel);
            }
            if ((exclude = config.getInitParameter("excludePatterns")) != null) {
                String[] excludeArray = exclude.split(",");
                this.excludePatterns = new ArrayList();
                for (String element : excludeArray) {
                    this.excludePatterns.add(Pattern.compile(element));
                }
            }
            try {
                Properties extraProperties = (Properties)config.getServletContext().getAttribute(PROPERTIES_ATTRIBUTE);
                if (extraProperties == null) {
                    extraProperties = new Properties();
                }
                String solrHome = (String)config.getServletContext().getAttribute(SOLRHOME_ATTRIBUTE);
                ExecutorUtil.addThreadLocalProvider((ExecutorUtil.InheritableThreadLocalProvider)SolrRequestInfo.getInheritableThreadLocalProvider());
                coresInit = this.createCoreContainer(solrHome == null ? SolrResourceLoader.locateSolrHome() : Paths.get(solrHome, new String[0]), extraProperties);
                this.httpClient = coresInit.getUpdateShardHandler().getDefaultHttpClient();
                this.setupJvmMetrics(coresInit);
                log.debug("user.dir=" + System.getProperty("user.dir"));
            }
            catch (Throwable t) {
                log.error("Could not start Solr. Check solr/home property and the logs");
                SolrCore.log(t);
                if (t instanceof Error) {
                    throw (Error)t;
                }
            }
        }
        finally {
            log.trace("SolrDispatchFilter.init() done");
            this.cores = coresInit;
            this.init.countDown();
        }
    }

    private void setupJvmMetrics(CoreContainer coresInit) {
        this.metricManager = coresInit.getMetricManager();
        this.registryName = SolrMetricManager.getRegistryName(SolrInfoBean.Group.jvm, new String[0]);
        Set<String> hiddenSysProps = coresInit.getConfig().getMetricsConfig().getHiddenSysProps();
        try {
            this.metricManager.registerAll(this.registryName, new AltBufferPoolMetricSet(), true, "buffers");
            this.metricManager.registerAll(this.registryName, (MetricSet)new ClassLoadingGaugeSet(), true, "classes");
            this.metricManager.registerAll(this.registryName, new OperatingSystemMetricSet(), true, "os");
            this.metricManager.registerAll(this.registryName, (MetricSet)new GarbageCollectorMetricSet(), true, "gc");
            this.metricManager.registerAll(this.registryName, (MetricSet)new MemoryUsageGaugeSet(), true, "memory");
            this.metricManager.registerAll(this.registryName, (MetricSet)new ThreadStatesGaugeSet(), true, "threads");
            MetricsMap sysprops = new MetricsMap((detailed, map) -> System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                if (!hiddenSysProps.contains(k)) {
                    map.put(String.valueOf(k), v);
                }
            })));
            this.metricManager.registerGauge(null, this.registryName, sysprops, this.metricTag, true, "properties", "system");
        }
        catch (Exception e) {
            log.warn("Error registering JVM metrics", (Throwable)e);
        }
    }

    private void logWelcomeBanner() {
        log.info(" ___      _       Welcome to Apache Solr\u2122 version {}", (Object)this.solrVersion());
        log.info("/ __| ___| |_ _   Starting in {} mode on port {}", (Object)(this.isCloudMode() ? "cloud" : "standalone"), (Object)this.getSolrPort());
        log.info("\\__ \\/ _ \\ | '_|  Install dir: {}", (Object)System.getProperty(SOLR_INSTALL_DIR_ATTRIBUTE));
        log.info("|___/\\___/_|_|    Start time: {}", (Object)Instant.now().toString());
    }

    private String solrVersion() {
        String specVer = Version.LATEST.toString();
        try {
            String implVer = SolrCore.class.getPackage().getImplementationVersion();
            return specVer.equals(implVer.split(" ")[0]) ? specVer : implVer;
        }
        catch (Exception e) {
            return specVer;
        }
    }

    private String getSolrPort() {
        return System.getProperty("jetty.port");
    }

    private boolean isCloudMode() {
        return System.getProperty("zkHost") != null && !StringUtils.isEmpty((String)System.getProperty("zkHost")) || System.getProperty("zkRun") != null;
    }

    protected CoreContainer createCoreContainer(Path solrHome, Properties extraProperties) {
        NodeConfig nodeConfig = SolrDispatchFilter.loadNodeConfig(solrHome, extraProperties);
        CoreContainer coreContainer = new CoreContainer(nodeConfig, extraProperties, true);
        coreContainer.load();
        return coreContainer;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NodeConfig loadNodeConfig(Path solrHome, Properties nodeProperties) {
        NodeConfig cfg = null;
        try (SolrResourceLoader loader = new SolrResourceLoader(solrHome, SolrDispatchFilter.class.getClassLoader(), nodeProperties);){
            String zkHost;
            if (!StringUtils.isEmpty((String)System.getProperty("solr.solrxml.location"))) {
                log.warn("Solr property solr.solrxml.location is no longer supported. Will automatically load solr.xml from ZooKeeper if it exists");
            }
            if (!StringUtils.isEmpty((String)(zkHost = System.getProperty("zkHost")))) {
                block37: {
                    int startUpZkTimeOut = Integer.getInteger("waitForZk", 30);
                    startUpZkTimeOut *= 1000;
                    try {
                        Throwable throwable;
                        SolrZkClient zkClient;
                        block35: {
                            NodeConfig nodeConfig;
                            block36: {
                                zkClient = new SolrZkClient(zkHost, startUpZkTimeOut);
                                throwable = null;
                                if (!zkClient.exists("/solr.xml", true).booleanValue()) break block35;
                                log.info("solr.xml found in ZooKeeper. Loading...");
                                byte[] data = zkClient.getData("/solr.xml", null, null, true);
                                nodeConfig = SolrXmlConfig.fromInputStream(loader, new ByteArrayInputStream(data));
                                if (zkClient == null) return nodeConfig;
                                if (throwable == null) break block36;
                                try {
                                    zkClient.close();
                                    return nodeConfig;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                    return nodeConfig;
                                }
                            }
                            zkClient.close();
                            return nodeConfig;
                        }
                        if (zkClient == null) break block37;
                        if (throwable != null) {
                            try {
                                zkClient.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            break block37;
                        } else {
                            zkClient.close();
                        }
                        break block37;
                        catch (Throwable throwable4) {
                            try {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (zkClient == null) throw throwable5;
                                if (throwable == null) {
                                    zkClient.close();
                                    throw throwable5;
                                }
                                try {
                                    zkClient.close();
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                    throw throwable5;
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error occurred while loading solr.xml from zookeeper", (Throwable)e);
                    }
                }
                log.info("Loading solr.xml from SolrHome (not found in ZooKeeper)");
            }
            cfg = SolrXmlConfig.fromSolrHome(loader, loader.getInstancePath());
            return cfg;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cfg;
    }

    public CoreContainer getCores() {
        return this.cores;
    }

    public void destroy() {
        try {
            SolrFileCleaningTracker fileCleaningTracker = SolrRequestParsers.fileCleaningTracker;
            if (fileCleaningTracker != null) {
                fileCleaningTracker.exitWhenFinished();
            }
        }
        catch (Exception e) {
            log.warn("Exception closing FileCleaningTracker", (Throwable)e);
        }
        finally {
            SolrRequestParsers.fileCleaningTracker = null;
        }
        if (this.metricManager != null) {
            this.metricManager.unregisterGauges(this.registryName, this.metricTag);
        }
        if (this.cores != null) {
            try {
                this.cores.shutdown();
            }
            finally {
                this.cores = null;
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter(request, response, chain, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest _request, ServletResponse _response, FilterChain chain, boolean retry) throws IOException, ServletException {
        if (!(_request instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = SolrDispatchFilter.closeShield((HttpServletRequest)_request, retry);
        HttpServletResponse response = SolrDispatchFilter.closeShield((HttpServletResponse)_response, retry);
        try {
            AtomicReference<HttpServletRequest> wrappedRequest;
            if (this.cores == null || this.cores.isShutDown()) {
                try {
                    this.init.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                String msg = "Error processing the request. CoreContainer is either not initialized or shutting down.";
                if (this.cores == null || this.cores.isShutDown()) {
                    log.error("Error processing the request. CoreContainer is either not initialized or shutting down.");
                    throw new UnavailableException("Error processing the request. CoreContainer is either not initialized or shutting down.");
                }
            }
            if (!this.authenticateRequest(request, response, wrappedRequest = new AtomicReference<HttpServletRequest>())) {
                return;
            }
            if (wrappedRequest.get() != null) {
                request = wrappedRequest.get();
            }
            if (this.cores.getAuthenticationPlugin() != null) {
                log.debug("User principal: {}", (Object)request.getUserPrincipal());
            }
            if (this.excludePatterns != null) {
                String requestPath = request.getServletPath();
                String extraPath = request.getPathInfo();
                if (extraPath != null) {
                    requestPath = requestPath + extraPath;
                }
                for (Pattern p : this.excludePatterns) {
                    Matcher matcher = p.matcher(requestPath);
                    if (!matcher.lookingAt()) continue;
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
            }
            HttpSolrCall call = this.getHttpSolrCall(request, response, retry);
            ExecutorUtil.setServerThreadFlag((Boolean)Boolean.TRUE);
            try {
                Action result = call.call();
                switch (result) {
                    case PASSTHROUGH: {
                        chain.doFilter((ServletRequest)request, (ServletResponse)response);
                        return;
                    }
                    case RETRY: {
                        this.doFilter((ServletRequest)request, (ServletResponse)response, chain, true);
                        return;
                    }
                    case FORWARD: {
                        request.getRequestDispatcher(call.getPath()).forward((ServletRequest)request, (ServletResponse)response);
                        return;
                    }
                }
                return;
            }
            finally {
                call.destroy();
                ExecutorUtil.setServerThreadFlag(null);
            }
        }
        finally {
            this.consumeInputFully(request);
        }
    }

    private void consumeInputFully(HttpServletRequest req) {
        try {
            ServletInputStream is = req.getInputStream();
            while (!is.isFinished() && is.read() != -1) {
            }
        }
        catch (IOException e) {
            log.info("Could not consume full client request", (Throwable)e);
        }
    }

    protected HttpSolrCall getHttpSolrCall(HttpServletRequest request, HttpServletResponse response, boolean retry) {
        String path = request.getServletPath();
        if (request.getPathInfo() != null) {
            path = path + request.getPathInfo();
        }
        if (this.isV2Enabled && (path.startsWith("/____v2/") || path.equals("/____v2"))) {
            return new V2HttpCall(this, this.cores, request, response, false);
        }
        return new HttpSolrCall(this, this.cores, request, response, retry);
    }

    private boolean authenticateRequest(HttpServletRequest request, HttpServletResponse response, AtomicReference<HttpServletRequest> wrappedRequest) throws IOException {
        boolean requestContinues = false;
        AtomicBoolean isAuthenticated = new AtomicBoolean(false);
        AuthenticationPlugin authenticationPlugin = this.cores.getAuthenticationPlugin();
        if (authenticationPlugin == null) {
            return true;
        }
        if ("/admin/info/key".equals(request.getServletPath()) || "/admin/info/key".equals(request.getPathInfo())) {
            return true;
        }
        String header = request.getHeader("SolrAuth");
        if (header != null && this.cores.getPkiAuthenticationPlugin() != null) {
            authenticationPlugin = this.cores.getPkiAuthenticationPlugin();
        }
        try {
            log.debug("Request to authenticate: {}, domain: {}, port: {}", new Object[]{request, request.getLocalName(), request.getLocalPort()});
            requestContinues = authenticationPlugin.doAuthenticate((ServletRequest)request, (ServletResponse)response, (req, rsp) -> {
                isAuthenticated.set(true);
                wrappedRequest.set((HttpServletRequest)req);
            });
        }
        catch (Exception e) {
            log.info("Error authenticating", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error during request authentication, ", (Throwable)e);
        }
        if (!requestContinues || !isAuthenticated.get()) {
            response.flushBuffer();
            return false;
        }
        return true;
    }

    public static HttpServletRequest closeShield(HttpServletRequest request, boolean retry) {
        if (!retry) {
            return new HttpServletRequestWrapper(request){

                public ServletInputStream getInputStream() throws IOException {
                    return new ServletInputStreamWrapper(super.getInputStream()){

                        @Override
                        public void close() {
                            assert (!Thread.currentThread().getStackTrace()[2].getClassName().matches("org\\.apache\\.(?:solr|lucene).*")) : SolrDispatchFilter.access$000();
                            this.stream = ClosedServletInputStream.CLOSED_SERVLET_INPUT_STREAM;
                        }
                    };
                }
            };
        }
        return request;
    }

    public static HttpServletResponse closeShield(HttpServletResponse response, boolean retry) {
        if (!retry) {
            return new HttpServletResponseWrapper(response){

                public ServletOutputStream getOutputStream() throws IOException {
                    return new ServletOutputStreamWrapper(super.getOutputStream()){

                        @Override
                        public void close() {
                            assert (!Thread.currentThread().getStackTrace()[2].getClassName().matches("org\\.apache\\.(?:solr|lucene).*")) : SolrDispatchFilter.access$000();
                            this.stream = ClosedServletOutputStream.CLOSED_SERVLET_OUTPUT_STREAM;
                        }
                    };
                }
            };
        }
        return response;
    }

    static /* synthetic */ String access$000() {
        return CLOSE_STREAM_MSG;
    }

    public static class ClosedServletOutputStream
    extends ServletOutputStream {
        public static final ClosedServletOutputStream CLOSED_SERVLET_OUTPUT_STREAM = new ClosedServletOutputStream();

        public void write(int b) throws IOException {
            throw new IOException("write(" + b + ") failed: stream is closed");
        }

        public void flush() throws IOException {
            throw new IOException("flush() failed: stream is closed");
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener arg0) {
            throw new RuntimeException("setWriteListener() failed: stream is closed");
        }
    }

    public static class ClosedServletInputStream
    extends ServletInputStream {
        public static final ClosedServletInputStream CLOSED_SERVLET_INPUT_STREAM = new ClosedServletInputStream();

        public int read() {
            return -1;
        }

        public boolean isFinished() {
            return false;
        }

        public boolean isReady() {
            return false;
        }

        public void setReadListener(ReadListener arg0) {
        }
    }

    public static enum Action {
        PASSTHROUGH,
        FORWARD,
        RETURN,
        RETRY,
        ADMIN,
        REMOTEQUERY,
        PROCESS;

    }
}

