/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.record;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.poi.common.usermodel.fonts.FontCharset;
import org.apache.poi.common.usermodel.fonts.FontFamily;
import org.apache.poi.common.usermodel.fonts.FontInfo;
import org.apache.poi.common.usermodel.fonts.FontPitch;
import org.apache.poi.util.LittleEndianInputStream;

public class HwmfFont
implements FontInfo {
    int height;
    int width;
    int escapement;
    int orientation;
    int weight;
    boolean italic;
    boolean underline;
    boolean strikeOut;
    FontCharset charSet;
    WmfOutPrecision outPrecision;
    WmfClipPrecision clipPrecision;
    WmfFontQuality quality;
    int pitchAndFamily;
    FontFamily family;
    FontPitch pitch;
    String facename;

    public int init(LittleEndianInputStream leis) throws IOException {
        byte b;
        this.height = leis.readShort();
        this.width = leis.readShort();
        this.escapement = leis.readShort();
        this.orientation = leis.readShort();
        this.weight = leis.readShort();
        this.italic = leis.readByte() != 0;
        this.underline = leis.readByte() != 0;
        this.strikeOut = leis.readByte() != 0;
        this.charSet = FontCharset.valueOf((int)leis.readUByte());
        this.outPrecision = WmfOutPrecision.valueOf(leis.readUByte());
        this.clipPrecision = WmfClipPrecision.valueOf(leis.readUByte());
        this.quality = WmfFontQuality.valueOf(leis.readUByte());
        this.pitchAndFamily = leis.readUByte();
        byte[] buf = new byte[32];
        int readBytes = 0;
        do {
            if (readBytes == 32) {
                throw new IOException("Font facename can't be determined.");
            }
            int n = readBytes;
            readBytes = (byte)(readBytes + 1);
            buf[n] = b = leis.readByte();
        } while (b != 0 && b != -1 && readBytes <= 32);
        this.facename = new String(buf, 0, readBytes - 1, Charset.forName("ISO-8859-1"));
        return 18 + readBytes;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getEscapement() {
        return this.escapement;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public boolean isStrikeOut() {
        return this.strikeOut;
    }

    public WmfOutPrecision getOutPrecision() {
        return this.outPrecision;
    }

    public WmfClipPrecision getClipPrecision() {
        return this.clipPrecision;
    }

    public WmfFontQuality getQuality() {
        return this.quality;
    }

    public int getPitchAndFamily() {
        return this.pitchAndFamily;
    }

    public FontFamily getFamily() {
        return FontFamily.valueOf((int)(this.pitchAndFamily & 0xF));
    }

    public void setFamily(FontFamily family) {
        throw new UnsupportedOperationException("setCharset not supported by HwmfFont.");
    }

    public FontPitch getPitch() {
        return FontPitch.valueOf((int)(this.pitchAndFamily >>> 6 & 3));
    }

    public void setPitch(FontPitch pitch) {
        throw new UnsupportedOperationException("setPitch not supported by HwmfFont.");
    }

    public Integer getIndex() {
        return null;
    }

    public void setIndex(int index) {
        throw new UnsupportedOperationException("setIndex not supported by HwmfFont.");
    }

    public String getTypeface() {
        return this.facename;
    }

    public void setTypeface(String typeface) {
        throw new UnsupportedOperationException("setTypeface not supported by HwmfFont.");
    }

    public FontCharset getCharset() {
        return this.charSet;
    }

    public void setCharset(FontCharset charset) {
        throw new UnsupportedOperationException("setCharset not supported by HwmfFont.");
    }

    public static enum WmfFontQuality {
        DEFAULT_QUALITY(0),
        DRAFT_QUALITY(1),
        PROOF_QUALITY(2),
        NONANTIALIASED_QUALITY(3),
        ANTIALIASED_QUALITY(4),
        CLEARTYPE_QUALITY(5);

        int flag;

        private WmfFontQuality(int flag) {
            this.flag = flag;
        }

        static WmfFontQuality valueOf(int flag) {
            for (WmfFontQuality fq : WmfFontQuality.values()) {
                if (fq.flag != flag) continue;
                return fq;
            }
            return null;
        }
    }

    public static enum WmfClipPrecision {
        CLIP_DEFAULT_PRECIS(0),
        CLIP_CHARACTER_PRECIS(1),
        CLIP_STROKE_PRECIS(2),
        CLIP_LH_ANGLES(16),
        CLIP_TT_ALWAYS(32),
        CLIP_DFA_DISABLE(64),
        CLIP_EMBEDDED(128);

        int flag;

        private WmfClipPrecision(int flag) {
            this.flag = flag;
        }

        static WmfClipPrecision valueOf(int flag) {
            for (WmfClipPrecision cp : WmfClipPrecision.values()) {
                if (cp.flag != flag) continue;
                return cp;
            }
            return null;
        }
    }

    public static enum WmfOutPrecision {
        OUT_DEFAULT_PRECIS(0),
        OUT_STRING_PRECIS(1),
        OUT_STROKE_PRECIS(3),
        OUT_TT_PRECIS(4),
        OUT_DEVICE_PRECIS(5),
        OUT_RASTER_PRECIS(6),
        OUT_TT_ONLY_PRECIS(7),
        OUT_OUTLINE_PRECIS(8),
        OUT_SCREEN_OUTLINE_PRECIS(9),
        OUT_PS_ONLY_PRECIS(10);

        int flag;

        private WmfOutPrecision(int flag) {
            this.flag = flag;
        }

        static WmfOutPrecision valueOf(int flag) {
            for (WmfOutPrecision op : WmfOutPrecision.values()) {
                if (op.flag != flag) continue;
                return op;
            }
            return null;
        }
    }
}

