/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.JoinQParserPlugin;
import org.apache.solr.search.QueryContext;
import org.apache.solr.search.SolrConstantScoreQuery;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.facet.AggValueSource;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetDebugInfo;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetParser;
import org.apache.solr.search.facet.FacetProcessor;
import org.apache.solr.search.facet.FacetTopParser;
import org.apache.solr.search.join.GraphQuery;
import org.apache.solr.search.join.GraphQueryParser;
import org.apache.solr.util.RTimer;

public abstract class FacetRequest {
    protected Map<String, AggValueSource> facetStats = new LinkedHashMap<String, AggValueSource>();
    protected Map<String, FacetRequest> subFacets = new LinkedHashMap<String, FacetRequest>();
    protected boolean processEmpty;
    protected Domain domain;

    public static FacetRequest parse(SolrQueryRequest req, Map<String, Object> params) {
        FacetTopParser parser = new FacetTopParser(req);
        try {
            return ((FacetParser)parser).parse(params);
        }
        catch (SyntaxError syntaxError) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)syntaxError);
        }
    }

    public static FacetRequest parseOneFacetReq(SolrQueryRequest req, Map<String, Object> params) {
        FacetTopParser parser = new FacetTopParser(req);
        try {
            return (FacetRequest)parser.parseFacetOrStat("", params);
        }
        catch (SyntaxError syntaxError) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)syntaxError);
        }
    }

    public Map<String, AggValueSource> getFacetStats() {
        return this.facetStats;
    }

    public Map<String, FacetRequest> getSubFacets() {
        return this.subFacets;
    }

    public RefineMethod getRefineMethod() {
        return null;
    }

    public boolean doRefine() {
        return this.getRefineMethod() != null && this.getRefineMethod() != RefineMethod.NONE;
    }

    public boolean returnsPartial() {
        return false;
    }

    public boolean canProduceFromEmpty() {
        if (this.domain != null && this.domain.canBecomeNonEmpty()) {
            return true;
        }
        for (FacetRequest freq : this.subFacets.values()) {
            if (!freq.canProduceFromEmpty()) continue;
            return true;
        }
        return false;
    }

    public void addStat(String key, AggValueSource stat) {
        this.facetStats.put(key, stat);
    }

    public void addSubFacet(String key, FacetRequest facetRequest) {
        this.subFacets.put(key, facetRequest);
    }

    public String toString() {
        Map<String, Object> descr = this.getFacetDescription();
        String s = "facet request: { ";
        for (String key : descr.keySet()) {
            s = s + key + ":" + descr.get(key) + ",";
        }
        s = s + "}";
        return s;
    }

    public final Object process(SolrQueryRequest req, DocSet domain) throws IOException {
        FacetContext fcontext = new FacetContext();
        fcontext.base = domain;
        fcontext.req = req;
        fcontext.searcher = req.getSearcher();
        fcontext.qcontext = QueryContext.newContext(fcontext.searcher);
        return this.process(fcontext);
    }

    final Object process(FacetContext fcontext) throws IOException {
        FacetProcessor facetProcessor = this.createFacetProcessor(fcontext);
        FacetDebugInfo debugInfo = fcontext.getDebugInfo();
        if (debugInfo == null) {
            facetProcessor.process();
        } else {
            if (fcontext.filter != null) {
                debugInfo.setFilter(fcontext.filter.toString());
            }
            debugInfo.setReqDescription(this.getFacetDescription());
            debugInfo.setProcessor(this.getClass().getSimpleName());
            debugInfo.putInfoItem("domainSize", fcontext.base.size());
            RTimer timer = new RTimer();
            facetProcessor.process();
            debugInfo.setElapse((long)timer.getTime());
        }
        return facetProcessor.getResponse();
    }

    public abstract FacetProcessor createFacetProcessor(FacetContext var1);

    public abstract FacetMerger createFacetMerger(Object var1);

    public abstract Map<String, Object> getFacetDescription();

    public static class Domain {
        public List<Object> explicitQueries;
        public List<String> excludeTags;
        public JoinField joinField;
        public GraphField graphField;
        public boolean toParent;
        public boolean toChildren;
        public String parents;
        public List<Object> filters;

        public boolean canTransformDomain() {
            return this.toParent || this.toChildren || this.explicitQueries != null || this.excludeTags != null || this.joinField != null;
        }

        public boolean canBecomeNonEmpty() {
            return this.explicitQueries != null || this.excludeTags != null;
        }

        public static class GraphField {
            public final SolrParams localParams;

            private GraphField(SolrParams localParams) {
                assert (null != localParams);
                this.localParams = localParams;
            }

            public static void createGraphField(Domain domain, Map<String, Object> domainMap) {
                assert (null != domain);
                assert (null != domainMap);
                Object queryGraph = domainMap.get("graph");
                if (null != queryGraph) {
                    if (!(queryGraph instanceof Map)) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'graph' domain change requires a map containing the 'from' and 'to' fields");
                    }
                    Map graph = (Map)queryGraph;
                    if (!graph.containsKey("from") || !graph.containsKey("to") || null == graph.get("from") || null == graph.get("to")) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'graph' domain change requires non-null 'from' and 'to' field names");
                    }
                    domain.graphField = new GraphField(FacetParser.jsonToSolrParams(graph));
                }
            }

            public Query createDomainQuery(FacetContext fcontext) throws IOException {
                SolrConstantScoreQuery fromQuery = new SolrConstantScoreQuery(fcontext.base.getTopFilter());
                fromQuery.setCache(false);
                GraphQueryParser graphParser = new GraphQueryParser(null, this.localParams, null, fcontext.req);
                try {
                    GraphQuery graphQuery = (GraphQuery)graphParser.parse();
                    graphQuery.setQ(fromQuery);
                    return graphQuery;
                }
                catch (SyntaxError syntaxError) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)syntaxError);
                }
            }
        }

        public static class JoinField {
            public final String from;
            public final String to;

            private JoinField(String from, String to) {
                assert (null != from);
                assert (null != to);
                this.from = from;
                this.to = to;
            }

            public static void createJoinField(Domain domain, Map<String, Object> domainMap) {
                assert (null != domain);
                assert (null != domainMap);
                Object queryJoin = domainMap.get("join");
                if (null != queryJoin) {
                    if (!(queryJoin instanceof Map)) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'join' domain change requires a map containing the 'from' and 'to' fields");
                    }
                    Map join = (Map)queryJoin;
                    if (!join.containsKey("from") || !join.containsKey("to") || null == join.get("from") || null == join.get("to")) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'join' domain change requires non-null 'from' and 'to' field names");
                    }
                    if (2 != join.size()) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'join' domain change contains unexpected keys, only 'from' and 'to' supported: " + join.toString());
                    }
                    domain.joinField = new JoinField((String)join.get("from"), (String)join.get("to"));
                }
            }

            public Query createDomainQuery(FacetContext fcontext) throws IOException {
                SolrConstantScoreQuery fromQuery = new SolrConstantScoreQuery(fcontext.base.getTopFilter());
                fromQuery.setCache(false);
                return JoinQParserPlugin.createJoinQuery(fromQuery, this.from, this.to);
            }
        }
    }

    public static enum RefineMethod {
        NONE,
        SIMPLE;


        public static RefineMethod fromObj(Object method) {
            if (method == null) {
                return null;
            }
            if (method instanceof Boolean) {
                return (Boolean)method != false ? SIMPLE : NONE;
            }
            if ("simple".equals(method)) {
                return SIMPLE;
            }
            if ("none".equals(method)) {
                return NONE;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown RefineMethod method " + method);
        }
    }

    public static enum SortDirection {
        asc(-1),
        desc(1);

        private final int multiplier;

        private SortDirection(int multiplier) {
            this.multiplier = multiplier;
        }

        public int getMultiplier() {
            return this.multiplier;
        }
    }
}

