/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.rendering;

import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.rendering.Glyph2D;

final class Type1Glyph2D
implements Glyph2D {
    private static final Log LOG = LogFactory.getLog(Type1Glyph2D.class);
    private final Map<Integer, GeneralPath> cache = new HashMap<Integer, GeneralPath>();
    private final PDSimpleFont font;

    Type1Glyph2D(PDSimpleFont font) {
        this.font = font;
    }

    @Override
    public GeneralPath getPathForCharacterCode(int code) {
        GeneralPath path = this.cache.get(code);
        if (path == null) {
            try {
                String name = this.font.getEncoding().getName(code);
                if (!this.font.hasGlyph(name)) {
                    LOG.warn((Object)("No glyph for code " + code + " (" + name + ") in font " + this.font.getName()));
                    if (code == 10 && this.font.isStandard14()) {
                        path = new GeneralPath();
                        this.cache.put(code, path);
                        return path;
                    }
                }
                if ((path = this.font.getPath(name)) == null) {
                    path = this.font.getPath(".notdef");
                }
                this.cache.put(code, path);
                return path;
            }
            catch (IOException e) {
                LOG.error((Object)"Glyph rendering failed", (Throwable)e);
                path = new GeneralPath();
            }
        }
        return path;
    }

    @Override
    public void dispose() {
        this.cache.clear();
    }
}

