/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.arnx.jsonic.util.BeanInfo;
import net.arnx.jsonic.util.PropertyInfo;

public final class ClassUtil {
    private static final Map<ClassLoader, Map<String, Class<?>>> cache = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> findClass(String name) {
        LinkedHashMap map;
        ClassLoader cl;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException e) {
            cl = null;
        }
        Map<Object, Object> map2 = cache;
        synchronized (map2) {
            map = cache.get(cl);
            if (map == null) {
                map = new LinkedHashMap<String, Class<?>>(16, 0.75f, true){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<String, Class<?>> eldest) {
                        return this.size() > 1024;
                    }
                };
                cache.put(cl, map);
            }
        }
        map2 = map;
        synchronized (map2) {
            if (!map.containsKey(name)) {
                Class<?> target;
                try {
                    target = cl != null ? cl.loadClass(name) : Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    target = null;
                }
                map.put(name, target);
            }
            return (Class)map.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<ClassLoader, Map<String, Class<?>>> map = cache;
        synchronized (map) {
            cache.clear();
        }
    }

    public static String toUpperCamel(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        boolean toUpperCase = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == ' ' || c == '_' || c == '-') {
                toUpperCase = true;
                continue;
            }
            if (toUpperCase) {
                sb.append(Character.toUpperCase(c));
                toUpperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toLowerCamel(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        boolean toUpperCase = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == ' ' || c == '_' || c == '-') {
                toUpperCase = true;
                continue;
            }
            if (toUpperCase) {
                sb.append(Character.toUpperCase(c));
                toUpperCase = false;
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 1 && Character.isUpperCase(sb.charAt(0)) && !Character.isUpperCase(sb.charAt(1))) {
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        }
        return sb.toString();
    }

    public static Class<?> getRawType(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        if (t instanceof GenericArrayType) {
            Class<?> cls = null;
            try {
                cls = Array.newInstance(ClassUtil.getRawType(((GenericArrayType)t).getGenericComponentType()), 0).getClass();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return cls;
        }
        if (t instanceof WildcardType) {
            Type[] types = ((WildcardType)t).getUpperBounds();
            return types.length > 0 ? ClassUtil.getRawType(types[0]) : Object.class;
        }
        return Object.class;
    }

    public static Type getResolvedType(Type ptype, Class<?> pcls, Type type) {
        Type result;
        HashMap<Type, Type> map = new HashMap<Type, Type>();
        ClassUtil.collectTypeVariableMap(ptype, pcls, map);
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type[] paramTypeArgs = paramType.getActualTypeArguments();
            for (int i = 0; i < paramTypeArgs.length; ++i) {
                Type next;
                Type iresult = paramTypeArgs[i];
                while (iresult instanceof TypeVariable && (next = (Type)map.get(iresult)) != null) {
                    iresult = next;
                }
                paramTypeArgs[i] = iresult;
            }
            result = new ParameterizedTypeImpl(paramType, paramTypeArgs);
        } else {
            Type next;
            result = type;
            while (result instanceof TypeVariable && (next = (Type)map.get(result)) != null) {
                result = next;
            }
        }
        return result;
    }

    private static void collectTypeVariableMap(Type t, Class<?> c, Map<Type, Type> map) {
        Type[] its;
        if (t instanceof ParameterizedType) {
            Type ot;
            TypeVariable<Class<?>>[] vs = c.getTypeParameters();
            Type[] as = ((ParameterizedType)t).getActualTypeArguments();
            if (vs != null && as != null && vs.length == as.length) {
                for (int i = 0; i < vs.length; ++i) {
                    map.put(vs[i], as[i]);
                }
            }
            if ((ot = ((ParameterizedType)t).getOwnerType()) instanceof ParameterizedType) {
                vs = ClassUtil.getRawType(ot).getTypeParameters();
                as = ((ParameterizedType)ot).getActualTypeArguments();
                if (vs != null && as != null && vs.length == as.length) {
                    for (int i = 0; i < vs.length; ++i) {
                        map.put(vs[i], as[i]);
                    }
                }
            }
        }
        if ((its = c.getGenericInterfaces()) != null) {
            for (Type it : its) {
                Class<?> ic = ClassUtil.getRawType(it);
                ClassUtil.collectTypeVariableMap(it, ic, map);
            }
        }
        Type st = c.getGenericSuperclass();
        while (st != null && st != Object.class) {
            Class<?> sc = ClassUtil.getRawType(st);
            ClassUtil.collectTypeVariableMap(st, sc, map);
            st = sc.getGenericSuperclass();
        }
    }

    public static byte[] serialize(Object o) throws ObjectStreamException {
        ByteArrayOutputStream array = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(array);
            out.writeObject(o);
            out.close();
        }
        catch (ObjectStreamException e) {
            throw e;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return array.toByteArray();
    }

    public static Object deserialize(byte[] data) throws ObjectStreamException, ClassNotFoundException {
        Object ret = null;
        ContextObjectInputStream in = null;
        try {
            in = new ContextObjectInputStream(new ByteArrayInputStream(data));
            ret = in.readObject();
            in.close();
        }
        catch (ObjectStreamException e) {
            throw e;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public static int hashCode(Object target) {
        if (target == null) {
            return 0;
        }
        int prime = 31;
        int result = 1;
        Class<?> current = target.getClass();
        do {
            for (Field f : current.getDeclaredFields()) {
                Object self;
                if (Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers()) || f.isSynthetic()) continue;
                try {
                    f.setAccessible(true);
                    self = f.get(target);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                result = self == null ? 31 * result + 0 : (self.getClass().isArray() ? (self.getClass() == boolean[].class ? 31 * result + Arrays.hashCode((boolean[])self) : (self.getClass() == char[].class ? 31 * result + Arrays.hashCode((char[])self) : (self.getClass() == byte[].class ? 31 * result + Arrays.hashCode((byte[])self) : (self.getClass() == short[].class ? 31 * result + Arrays.hashCode((short[])self) : (self.getClass() == int[].class ? 31 * result + Arrays.hashCode((int[])self) : (self.getClass() == long[].class ? 31 * result + Arrays.hashCode((long[])self) : (self.getClass() == float[].class ? 31 * result + Arrays.hashCode((float[])self) : (self.getClass() == double[].class ? 31 * result + Arrays.hashCode((double[])self) : 31 * result + Arrays.hashCode((Object[])self))))))))) : 31 * result + self.hashCode());
                System.out.println(f.getName() + ": " + result);
            }
        } while ((current = current.getSuperclass()) != Object.class);
        return result;
    }

    public static boolean equals(Object target, Object o) {
        if (target == o) {
            return true;
        }
        if (target == null || o == null) {
            return false;
        }
        if (target.getClass() != o.getClass()) {
            return false;
        }
        Class<?> current = target.getClass();
        do {
            for (Field f : current.getDeclaredFields()) {
                Object other;
                Object self;
                if (Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers()) || f.isSynthetic()) continue;
                try {
                    f.setAccessible(true);
                    self = f.get(target);
                    other = f.get(o);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                if (!(self == null ? other != null : (self.getClass().isArray() ? (self.getClass() == boolean[].class ? !Arrays.equals((boolean[])self, (boolean[])other) : (self.getClass() == char[].class ? !Arrays.equals((char[])self, (char[])other) : (self.getClass() == byte[].class ? !Arrays.equals((byte[])self, (byte[])other) : (self.getClass() == short[].class ? !Arrays.equals((short[])self, (short[])other) : (self.getClass() == int[].class ? !Arrays.equals((int[])self, (int[])other) : (self.getClass() == long[].class ? !Arrays.equals((long[])self, (long[])other) : (self.getClass() == float[].class ? !Arrays.equals((float[])self, (float[])other) : (self.getClass() == double[].class ? !Arrays.equals((double[])self, (double[])other) : !Arrays.equals((Object[])self, (Object[])other))))))))) : !self.equals(other)))) continue;
                return false;
            }
        } while ((current = current.getSuperclass()) != Object.class);
        return true;
    }

    public static String toString(Object target) {
        if (target == null) {
            return "null";
        }
        BeanInfo info = BeanInfo.get(target.getClass());
        StringBuilder sb = new StringBuilder(10 * info.getProperties().size() + 20);
        sb.append(target.getClass().getSimpleName()).append(" [");
        boolean first = true;
        for (PropertyInfo prop : info.getProperties()) {
            if (!prop.isReadable() || prop.getName().equals("class")) continue;
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(prop.getName()).append("=");
            try {
                Object value = prop.get(target);
                if (value.getClass().isArray()) {
                    if (value instanceof boolean[]) {
                        Arrays.toString((boolean[])value);
                        continue;
                    }
                    if (value instanceof char[]) {
                        Arrays.toString((char[])value);
                        continue;
                    }
                    if (value instanceof byte[]) {
                        Arrays.toString((byte[])value);
                        continue;
                    }
                    if (value instanceof short[]) {
                        Arrays.toString((short[])value);
                        continue;
                    }
                    if (value instanceof int[]) {
                        Arrays.toString((int[])value);
                        continue;
                    }
                    if (value instanceof long[]) {
                        Arrays.toString((long[])value);
                        continue;
                    }
                    if (value instanceof float[]) {
                        Arrays.toString((float[])value);
                        continue;
                    }
                    if (value instanceof double[]) {
                        Arrays.toString((double[])value);
                        continue;
                    }
                    Arrays.toString((Object[])value);
                    continue;
                }
                sb.append(value);
            }
            catch (Exception e) {
                sb.append("?");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private ClassUtil() {
    }

    private static class ParameterizedTypeImpl
    implements ParameterizedType {
        private ParameterizedType parent;
        private Type[] args;

        public ParameterizedTypeImpl(ParameterizedType parent, Type[] args) {
            this.parent = parent;
            this.args = args;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.args;
        }

        @Override
        public Type getRawType() {
            return this.parent.getRawType();
        }

        @Override
        public Type getOwnerType() {
            return this.parent.getOwnerType();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            result = 31 * result + Arrays.hashCode(this.args);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParameterizedTypeImpl other = (ParameterizedTypeImpl)obj;
            if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
                return false;
            }
            return Arrays.equals(this.args, other.args);
        }
    }

    private static class ContextObjectInputStream
    extends ObjectInputStream {
        public ContextObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                return Class.forName(desc.getName(), true, cl);
            }
            catch (Exception e) {
                return super.resolveClass(desc);
            }
        }
    }
}

