"""Generated message classes for containeranalysis version v1beta1.

An implementation of the Grafeas API, which stores, and enables querying and
retrieval of critical metadata about all of your software artifacts.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'containeranalysis'


class AliasContext(_messages.Message):
  r"""An alias to a repo revision.

  Enums:
    KindValueValuesEnum: The alias kind.

  Fields:
    kind: The alias kind.
    name: The alias name.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      KIND_UNSPECIFIED: Unknown.
      FIXED: Git tag.
      MOVABLE: Git branch.
      OTHER: Used to specify non-standard aliases. For example, if a Git repo
        has a ref named "refs/foo/bar".
    """
    KIND_UNSPECIFIED = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  kind = _messages.EnumField('KindValueValuesEnum', 1)
  name = _messages.StringField(2)


class Artifact(_messages.Message):
  r"""Artifact describes a build product.

  Fields:
    checksum: Hash or checksum value of a binary, or Docker Registry 2.0
      digest of a container.
    id: Artifact ID, if any; for container images, this will be a URL by
      digest like `gcr.io/projectID/imagename@sha256:123456`.
    names: Related artifact names. This may be the path to a binary or jar
      file, or in the case of a container build, the name used to push the
      container image to Google Container Registry, as presented to `docker
      push`. Note that a single Artifact ID can have multiple names, for
      example if two tags are applied to one image.
  """

  checksum = _messages.StringField(1)
  id = _messages.StringField(2)
  names = _messages.StringField(3, repeated=True)


class Attestation(_messages.Message):
  r"""Occurrence that represents a single "attestation". The authenticity of
  an attestation can be verified using the attached signature. If the verifier
  trusts the public key of the signer, then verifying the signature is
  sufficient to establish trust. In this circumstance, the authority to which
  this attestation is attached is primarily useful for look-up (how to find
  this attestation if you already know the authority and artifact to be
  verified) and intent (which authority was this attestation intended to sign
  for).

  Fields:
    pgpSignedAttestation: A PGP signed attestation.
  """

  pgpSignedAttestation = _messages.MessageField('PgpSignedAttestation', 1)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.  Example Policy with
  multiple AuditConfigs:      {       "audit_configs": [         {
  "service": "allServices"           "audit_log_configs": [             {
  "log_type": "DATA_READ",               "exempted_members": [
  "user:foo@gmail.com"               ]             },             {
  "log_type": "DATA_WRITE",             },             {
  "log_type": "ADMIN_READ",             }           ]         },         {
  "service": "fooservice.googleapis.com"           "audit_log_configs": [
  {               "log_type": "DATA_READ",             },             {
  "log_type": "DATA_WRITE",               "exempted_members": [
  "user:bar@gmail.com"               ]             }           ]         }
  ]     }  For fooservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts foo@gmail.com from DATA_READ logging,
  and bar@gmail.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:foo@gmail.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  foo@gmail.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Authority(_messages.Message):
  r"""Note kind that represents a logical attestation "role" or "authority".
  For example, an organization might have one `Authority` for "QA" and one for
  "build". This note is intended to act strictly as a grouping mechanism for
  the attached occurrences (Attestations). This grouping mechanism also
  provides a security boundary, since IAM ACLs gate the ability for a
  principle to attach an occurrence to a given note. It also provides a single
  point of lookup to find all attached attestation occurrences, even if they
  don't all live in the same project.

  Fields:
    hint: Hint hints at the purpose of the attestation authority.
  """

  hint = _messages.MessageField('Hint', 1)


class Basis(_messages.Message):
  r"""Basis describes the base image portion (Note) of the DockerImage
  relationship. Linked occurrences are derived from this or an equivalent
  image via:   FROM <Basis.resource_url> Or an equivalent reference, e.g. a
  tag of the resource_url.

  Fields:
    fingerprint: Required. Immutable. The fingerprint of the base image.
    resourceUrl: Required. Immutable. The resource_url for the resource
      representing the basis of associated occurrence images.
  """

  fingerprint = _messages.MessageField('Fingerprint', 1)
  resourceUrl = _messages.StringField(2)


class BatchCreateNotesRequest(_messages.Message):
  r"""Request to create notes in batch.

  Messages:
    NotesValue: The notes to create. Max allowed length is 1000.

  Fields:
    notes: The notes to create. Max allowed length is 1000.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class NotesValue(_messages.Message):
    r"""The notes to create. Max allowed length is 1000.

    Messages:
      AdditionalProperty: An additional property for a NotesValue object.

    Fields:
      additionalProperties: Additional properties of type NotesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a NotesValue object.

      Fields:
        key: Name of the additional property.
        value: A Note attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Note', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  notes = _messages.MessageField('NotesValue', 1)


class BatchCreateNotesResponse(_messages.Message):
  r"""Response for creating notes in batch.

  Fields:
    notes: The notes that were created.
  """

  notes = _messages.MessageField('Note', 1, repeated=True)


class BatchCreateOccurrencesRequest(_messages.Message):
  r"""Request to create occurrences in batch.

  Fields:
    occurrences: The occurrences to create. Max allowed length is 1000.
  """

  occurrences = _messages.MessageField('Occurrence', 1, repeated=True)


class BatchCreateOccurrencesResponse(_messages.Message):
  r"""Response for creating occurrences in batch.

  Fields:
    occurrences: The occurrences that were created.
  """

  occurrences = _messages.MessageField('Occurrence', 1, repeated=True)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: Unimplemented. The condition that is associated with this
      binding. NOTE: an unsatisfied condition will not allow user access via
      current binding. Different bindings, including their conditions, are
      examined independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example, `alice@gmail.com`
      .   * `serviceAccount:{emailid}`: An email address that represents a
      service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.
      * `domain:{domain}`: A Google Apps domain name that represents all the
      users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class Build(_messages.Message):
  r"""Note holding the version of the provider's builder and the signature of
  the provenance message in the build details occurrence.

  Fields:
    builderVersion: Required. Immutable. Version of the builder which produced
      this build.
    signature: Signature of the build in occurrences pointing to this build
      note containing build details.
  """

  builderVersion = _messages.StringField(1)
  signature = _messages.MessageField('BuildSignature', 2)


class BuildProvenance(_messages.Message):
  r"""Provenance of a build. Contains all information needed to verify the
  full details about the build from source to completion.

  Messages:
    BuildOptionsValue: Special options applied to this build. This is a catch-
      all field where build providers can enter any desired additional
      details.

  Fields:
    buildOptions: Special options applied to this build. This is a catch-all
      field where build providers can enter any desired additional details.
    builderVersion: Version string of the builder at the time this build was
      executed.
    builtArtifacts: Output of the build.
    commands: Commands requested by the build.
    createTime: Time at which the build was created.
    creator: E-mail address of the user who initiated this build. Note that
      this was the user's e-mail address at the time the build was initiated;
      this address may not represent the same end-user for all time.
    endTime: Time at which execution of the build was finished.
    id: Required. Unique identifier of the build.
    logsUri: URI where any logs for this provenance were written.
    projectId: ID of the project.
    sourceProvenance: Details of the Source input to the build.
    startTime: Time at which execution of the build was started.
    triggerId: Trigger identifier if the build was triggered automatically;
      empty if not.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class BuildOptionsValue(_messages.Message):
    r"""Special options applied to this build. This is a catch-all field where
    build providers can enter any desired additional details.

    Messages:
      AdditionalProperty: An additional property for a BuildOptionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type BuildOptionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a BuildOptionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  buildOptions = _messages.MessageField('BuildOptionsValue', 1)
  builderVersion = _messages.StringField(2)
  builtArtifacts = _messages.MessageField('Artifact', 3, repeated=True)
  commands = _messages.MessageField('Command', 4, repeated=True)
  createTime = _messages.StringField(5)
  creator = _messages.StringField(6)
  endTime = _messages.StringField(7)
  id = _messages.StringField(8)
  logsUri = _messages.StringField(9)
  projectId = _messages.StringField(10)
  sourceProvenance = _messages.MessageField('Source', 11)
  startTime = _messages.StringField(12)
  triggerId = _messages.StringField(13)


class BuildSignature(_messages.Message):
  r"""Message encapsulating the signature of the verified build.

  Enums:
    KeyTypeValueValuesEnum: The type of the key, either stored in `public_key`
      or referenced in `key_id`.

  Fields:
    keyId: An ID for the key used to sign. This could be either an ID for the
      key stored in `public_key` (such as the ID or fingerprint for a PGP key,
      or the CN for a cert), or a reference to an external key (such as a
      reference to a key in Cloud Key Management Service).
    keyType: The type of the key, either stored in `public_key` or referenced
      in `key_id`.
    publicKey: Public key of the builder which can be used to verify that the
      related findings are valid and unchanged. If `key_type` is empty, this
      defaults to PEM encoded public keys.  This field may be empty if
      `key_id` references an external key.  For Cloud Build based signatures,
      this is a PEM encoded public key. To verify the Cloud Build signature,
      place the contents of this field into a file (public.pem). The signature
      field is base64-decoded into its binary representation in signature.bin,
      and the provenance bytes from `BuildDetails` are base64-decoded into a
      binary representation in signed.bin. OpenSSL can then verify the
      signature: `openssl sha256 -verify public.pem -signature signature.bin
      signed.bin`
    signature: Required. Signature of the related `BuildProvenance`. In JSON,
      this is base-64 encoded.
  """

  class KeyTypeValueValuesEnum(_messages.Enum):
    r"""The type of the key, either stored in `public_key` or referenced in
    `key_id`.

    Values:
      KEY_TYPE_UNSPECIFIED: `KeyType` is not set.
      PGP_ASCII_ARMORED: `PGP ASCII Armored` public key.
      PKIX_PEM: `PKIX PEM` public key.
    """
    KEY_TYPE_UNSPECIFIED = 0
    PGP_ASCII_ARMORED = 1
    PKIX_PEM = 2

  keyId = _messages.StringField(1)
  keyType = _messages.EnumField('KeyTypeValueValuesEnum', 2)
  publicKey = _messages.StringField(3)
  signature = _messages.BytesField(4)


class CloudRepoSourceContext(_messages.Message):
  r"""A CloudRepoSourceContext denotes a particular revision in a Google Cloud
  Source Repo.

  Fields:
    aliasContext: An alias, which may be a branch or tag.
    repoId: The ID of the repo.
    revisionId: A revision ID.
  """

  aliasContext = _messages.MessageField('AliasContext', 1)
  repoId = _messages.MessageField('RepoId', 2)
  revisionId = _messages.StringField(3)


class Command(_messages.Message):
  r"""Command describes a step performed as part of the build pipeline.

  Fields:
    args: Command-line arguments used when executing this command.
    dir: Working directory (relative to project source root) used when running
      this command.
    env: Environment variables set before running this command.
    id: Optional unique identifier for this command, used in wait_for to
      reference this command as a dependency.
    name: Required. Name of the command, as presented on the command line, or
      if the command is packaged as a Docker container, as presented to
      `docker pull`.
    waitFor: The ID(s) of the command(s) that this command depends on.
  """

  args = _messages.StringField(1, repeated=True)
  dir = _messages.StringField(2)
  env = _messages.StringField(3, repeated=True)
  id = _messages.StringField(4)
  name = _messages.StringField(5)
  waitFor = _messages.StringField(6, repeated=True)


class ContaineranalysisProjectsNotesBatchCreateRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesBatchCreateRequest object.

  Fields:
    batchCreateNotesRequest: A BatchCreateNotesRequest resource to be passed
      as the request body.
    parent: The name of the project in the form of `projects/[PROJECT_ID]`,
      under which the notes are to be created.
  """

  batchCreateNotesRequest = _messages.MessageField('BatchCreateNotesRequest', 1)
  parent = _messages.StringField(2, required=True)


class ContaineranalysisProjectsNotesCreateRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesCreateRequest object.

  Fields:
    note: A Note resource to be passed as the request body.
    noteId: The ID to use for this note.
    parent: The name of the project in the form of `projects/[PROJECT_ID]`,
      under which the note is to be created.
  """

  note = _messages.MessageField('Note', 1)
  noteId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ContaineranalysisProjectsNotesDeleteRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesDeleteRequest object.

  Fields:
    name: The name of the note in the form of
      `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsNotesGetIamPolicyRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class ContaineranalysisProjectsNotesGetRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesGetRequest object.

  Fields:
    name: The name of the note in the form of
      `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsNotesListRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesListRequest object.

  Fields:
    filter: The filter expression.
    pageSize: Number of notes to return in the list. Must be positive. Max
      allowed page size is 1000. If not specified, page size defaults to 20.
    pageToken: Token to provide to skip to a particular spot in the list.
    parent: The name of the project to list notes for in the form of
      `projects/[PROJECT_ID]`.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class ContaineranalysisProjectsNotesOccurrencesListRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesOccurrencesListRequest object.

  Fields:
    filter: The filter expression.
    name: The name of the note to list occurrences for in the form of
      `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
    pageSize: Number of occurrences to return in the list.
    pageToken: Token to provide to skip to a particular spot in the list.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ContaineranalysisProjectsNotesPatchRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesPatchRequest object.

  Fields:
    name: The name of the note in the form of
      `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
    note: A Note resource to be passed as the request body.
    updateMask: The fields to update.
  """

  name = _messages.StringField(1, required=True)
  note = _messages.MessageField('Note', 2)
  updateMask = _messages.StringField(3)


class ContaineranalysisProjectsNotesSetIamPolicyRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ContaineranalysisProjectsNotesTestIamPermissionsRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ContaineranalysisProjectsOccurrencesBatchCreateRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesBatchCreateRequest object.

  Fields:
    batchCreateOccurrencesRequest: A BatchCreateOccurrencesRequest resource to
      be passed as the request body.
    parent: The name of the project in the form of `projects/[PROJECT_ID]`,
      under which the occurrences are to be created.
  """

  batchCreateOccurrencesRequest = _messages.MessageField('BatchCreateOccurrencesRequest', 1)
  parent = _messages.StringField(2, required=True)


class ContaineranalysisProjectsOccurrencesCreateRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesCreateRequest object.

  Fields:
    occurrence: A Occurrence resource to be passed as the request body.
    parent: The name of the project in the form of `projects/[PROJECT_ID]`,
      under which the occurrence is to be created.
  """

  occurrence = _messages.MessageField('Occurrence', 1)
  parent = _messages.StringField(2, required=True)


class ContaineranalysisProjectsOccurrencesDeleteRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesDeleteRequest object.

  Fields:
    name: The name of the occurrence in the form of
      `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsOccurrencesGetIamPolicyRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class ContaineranalysisProjectsOccurrencesGetNotesRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesGetNotesRequest object.

  Fields:
    name: The name of the occurrence in the form of
      `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsOccurrencesGetRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesGetRequest object.

  Fields:
    name: The name of the occurrence in the form of
      `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsOccurrencesGetVulnerabilitySummaryRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesGetVulnerabilitySummaryRequest
  object.

  Fields:
    filter: The filter expression.
    parent: The name of the project to get a vulnerability summary for in the
      form of `projects/[PROJECT_ID]`.
  """

  filter = _messages.StringField(1)
  parent = _messages.StringField(2, required=True)


class ContaineranalysisProjectsOccurrencesListRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesListRequest object.

  Fields:
    filter: The filter expression.
    pageSize: Number of occurrences to return in the list. Must be positive.
      Max allowed page size is 1000. If not specified, page size defaults to
      20.
    pageToken: Token to provide to skip to a particular spot in the list.
    parent: The name of the project to list occurrences for in the form of
      `projects/[PROJECT_ID]`.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class ContaineranalysisProjectsOccurrencesPatchRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesPatchRequest object.

  Fields:
    name: The name of the occurrence in the form of
      `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
    occurrence: A Occurrence resource to be passed as the request body.
    updateMask: The fields to update.
  """

  name = _messages.StringField(1, required=True)
  occurrence = _messages.MessageField('Occurrence', 2)
  updateMask = _messages.StringField(3)


class ContaineranalysisProjectsOccurrencesSetIamPolicyRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ContaineranalysisProjectsOccurrencesTestIamPermissionsRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ContaineranalysisProjectsScanConfigsGetRequest(_messages.Message):
  r"""A ContaineranalysisProjectsScanConfigsGetRequest object.

  Fields:
    name: The name of the scan configuration in the form of
      `projects/[PROJECT_ID]/scanConfigs/[SCAN_CONFIG_ID]`.
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsScanConfigsListRequest(_messages.Message):
  r"""A ContaineranalysisProjectsScanConfigsListRequest object.

  Fields:
    filter: The filter expression.
    pageSize: The number of scan configs to return in the list.
    pageToken: Token to provide to skip to a particular spot in the list.
    parent: The name of the project to list scan configurations for in the
      form of `projects/[PROJECT_ID]`.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class Deployable(_messages.Message):
  r"""An artifact that can be deployed in some runtime.

  Fields:
    resourceUri: Required. Resource URI for the artifact being deployed.
  """

  resourceUri = _messages.StringField(1, repeated=True)


class Deployment(_messages.Message):
  r"""The period during which some deployable was active in a runtime.

  Enums:
    PlatformValueValuesEnum: Platform hosting this deployment.

  Fields:
    address: Address of the runtime element hosting this deployment.
    config: Configuration used to create this deployment.
    deployTime: Required. Beginning of the lifetime of this deployment.
    platform: Platform hosting this deployment.
    resourceUri: Output only. Resource URI for the artifact being deployed
      taken from the deployable field with the same name.
    undeployTime: End of the lifetime of this deployment.
    userEmail: Identity of the user that triggered this deployment.
  """

  class PlatformValueValuesEnum(_messages.Enum):
    r"""Platform hosting this deployment.

    Values:
      PLATFORM_UNSPECIFIED: Unknown.
      GKE: Google Container Engine.
      FLEX: Google App Engine: Flexible Environment.
      CUSTOM: Custom user-defined platform.
    """
    PLATFORM_UNSPECIFIED = 0
    GKE = 1
    FLEX = 2
    CUSTOM = 3

  address = _messages.StringField(1)
  config = _messages.StringField(2)
  deployTime = _messages.StringField(3)
  platform = _messages.EnumField('PlatformValueValuesEnum', 4)
  resourceUri = _messages.StringField(5, repeated=True)
  undeployTime = _messages.StringField(6)
  userEmail = _messages.StringField(7)


class Derived(_messages.Message):
  r"""Derived describes the derived image portion (Occurrence) of the
  DockerImage relationship. This image would be produced from a Dockerfile
  with FROM <DockerImage.Basis in attached Note>.

  Fields:
    baseResourceUrl: Output only. This contains the base image URL for the
      derived image occurrence.
    distance: Output only. The number of layers by which this image differs
      from the associated image basis.
    fingerprint: Required. The fingerprint of the derived image.
    layerInfo: This contains layer-specific metadata, if populated it has
      length "distance" and is ordered with [distance] being the layer
      immediately following the base image and [1] being the final layer.
  """

  baseResourceUrl = _messages.StringField(1)
  distance = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  fingerprint = _messages.MessageField('Fingerprint', 3)
  layerInfo = _messages.MessageField('Layer', 4, repeated=True)


class Detail(_messages.Message):
  r"""Identifies all occurrences of this vulnerability in the package for a
  specific distro/location. For example: glibc in cpe:/o:debian:debian_linux:8
  for versions 2.1 - 2.2

  Fields:
    cpeUri: Required. The CPE URI in [cpe
      format](https://cpe.mitre.org/specification/) in which the vulnerability
      manifests. Examples include distro or storage location for vulnerable
      jar.
    description: A vendor-specific description of this note.
    fixedLocation: The fix for this specific package version.
    isObsolete: Whether this detail is obsolete. Occurrences are expected not
      to point to obsolete details.
    maxAffectedVersion: The max version of the package in which the
      vulnerability exists.
    minAffectedVersion: The min version of the package in which the
      vulnerability exists.
    package: Required. The name of the package where the vulnerability was
      found.
    packageType: The type of package; whether native or non native(ruby gems,
      node.js packages etc).
    severityName: The severity (eg: distro assigned severity) for this
      vulnerability.
  """

  cpeUri = _messages.StringField(1)
  description = _messages.StringField(2)
  fixedLocation = _messages.MessageField('VulnerabilityLocation', 3)
  isObsolete = _messages.BooleanField(4)
  maxAffectedVersion = _messages.MessageField('Version', 5)
  minAffectedVersion = _messages.MessageField('Version', 6)
  package = _messages.StringField(7)
  packageType = _messages.StringField(8)
  severityName = _messages.StringField(9)


class Details(_messages.Message):
  r"""Details of an attestation occurrence.

  Fields:
    attestation: Required. Attestation for the resource.
  """

  attestation = _messages.MessageField('Attestation', 1)


class Discovered(_messages.Message):
  r"""Provides information about the analysis status of a discovered resource.

  Enums:
    AnalysisStatusValueValuesEnum: The status of discovery for the resource.
    ContinuousAnalysisValueValuesEnum: Whether the resource is continuously
      analyzed.

  Fields:
    analysisStatus: The status of discovery for the resource.
    analysisStatusError: When an error is encountered this will contain a
      LocalizedMessage under details to show to the user. The LocalizedMessage
      is output only and populated by the API.
    continuousAnalysis: Whether the resource is continuously analyzed.
    lastAnalysisTime: The last time continuous analysis was done for this
      resource. Deprecated, do not use.
  """

  class AnalysisStatusValueValuesEnum(_messages.Enum):
    r"""The status of discovery for the resource.

    Values:
      ANALYSIS_STATUS_UNSPECIFIED: Unknown.
      PENDING: Resource is known but no action has been taken yet.
      SCANNING: Resource is being analyzed.
      FINISHED_SUCCESS: Analysis has finished successfully.
      FINISHED_FAILED: Analysis has finished unsuccessfully, the analysis
        itself is in a bad state.
      FINISHED_UNSUPPORTED: The resource is known not to be supported
    """
    ANALYSIS_STATUS_UNSPECIFIED = 0
    PENDING = 1
    SCANNING = 2
    FINISHED_SUCCESS = 3
    FINISHED_FAILED = 4
    FINISHED_UNSUPPORTED = 5

  class ContinuousAnalysisValueValuesEnum(_messages.Enum):
    r"""Whether the resource is continuously analyzed.

    Values:
      CONTINUOUS_ANALYSIS_UNSPECIFIED: Unknown.
      ACTIVE: The resource is continuously analyzed.
      INACTIVE: The resource is ignored for continuous analysis.
    """
    CONTINUOUS_ANALYSIS_UNSPECIFIED = 0
    ACTIVE = 1
    INACTIVE = 2

  analysisStatus = _messages.EnumField('AnalysisStatusValueValuesEnum', 1)
  analysisStatusError = _messages.MessageField('Status', 2)
  continuousAnalysis = _messages.EnumField('ContinuousAnalysisValueValuesEnum', 3)
  lastAnalysisTime = _messages.StringField(4)


class Discovery(_messages.Message):
  r"""A note that indicates a type of analysis a provider would perform. This
  note exists in a provider's project. A `Discovery` occurrence is created in
  a consumer's project at the start of analysis.

  Enums:
    AnalysisKindValueValuesEnum: Required. Immutable. The kind of analysis
      that is handled by this discovery.

  Fields:
    analysisKind: Required. Immutable. The kind of analysis that is handled by
      this discovery.
  """

  class AnalysisKindValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. The kind of analysis that is handled by this
    discovery.

    Values:
      NOTE_KIND_UNSPECIFIED: Unknown.
      VULNERABILITY: The note and occurrence represent a package
        vulnerability.
      BUILD: The note and occurrence assert build provenance.
      IMAGE: This represents an image basis relationship.
      PACKAGE: This represents a package installed via a package manager.
      DEPLOYMENT: The note and occurrence track deployment events.
      DISCOVERY: The note and occurrence track the initial discovery status of
        a resource.
      ATTESTATION: This represents a logical "role" that can attest to
        artifacts.
    """
    NOTE_KIND_UNSPECIFIED = 0
    VULNERABILITY = 1
    BUILD = 2
    IMAGE = 3
    PACKAGE = 4
    DEPLOYMENT = 5
    DISCOVERY = 6
    ATTESTATION = 7

  analysisKind = _messages.EnumField('AnalysisKindValueValuesEnum', 1)


class Distribution(_messages.Message):
  r"""This represents a particular channel of distribution for a given
  package. E.g., Debian's jessie-backports dpkg mirror.

  Enums:
    ArchitectureValueValuesEnum: The CPU architecture for which packages in
      this distribution channel were built.

  Fields:
    architecture: The CPU architecture for which packages in this distribution
      channel were built.
    cpeUri: Required. The cpe_uri in [CPE
      format](https://cpe.mitre.org/specification/) denoting the package
      manager version distributing a package.
    description: The distribution channel-specific description of this
      package.
    latestVersion: The latest available version of this package in this
      distribution channel.
    maintainer: A freeform string denoting the maintainer of this package.
    url: The distribution channel-specific homepage for this package.
  """

  class ArchitectureValueValuesEnum(_messages.Enum):
    r"""The CPU architecture for which packages in this distribution channel
    were built.

    Values:
      ARCHITECTURE_UNSPECIFIED: Unknown architecture.
      X86: X86 architecture.
      X64: X64 architecture.
    """
    ARCHITECTURE_UNSPECIFIED = 0
    X86 = 1
    X64 = 2

  architecture = _messages.EnumField('ArchitectureValueValuesEnum', 1)
  cpeUri = _messages.StringField(2)
  description = _messages.StringField(3)
  latestVersion = _messages.MessageField('Version', 4)
  maintainer = _messages.StringField(5)
  url = _messages.StringField(6)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class Expr(_messages.Message):
  r"""Represents an expression text. Example:      title: "User account
  presence"     description: "Determines whether the request has a user
  account"     expression: "size(request.user) > 0"

  Fields:
    description: An optional description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.  The application context of the containing message
      determines which well-known feature set of CEL is supported.
    location: An optional string indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: An optional title for the expression, i.e. a short string
      describing its purpose. This can be used e.g. in UIs which allow to
      enter the expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class FileHashes(_messages.Message):
  r"""Container message for hashes of byte content of files, used in source
  messages to verify integrity of source input to the build.

  Fields:
    fileHash: Required. Collection of file hashes.
  """

  fileHash = _messages.MessageField('Hash', 1, repeated=True)


class Fingerprint(_messages.Message):
  r"""A set of properties that uniquely identify a given Docker image.

  Fields:
    v1Name: Required. The layer ID of the final layer in the Docker image's v1
      representation.
    v2Blob: Required. The ordered list of v2 blobs that represent a given
      image.
    v2Name: Output only. The name of the image's v2 blobs computed via:
      [bottom] := v2_blobbottom := sha256(v2_blob[N] + " " + v2_name[N+1])
      Only the name of the final blob is kept.
  """

  v1Name = _messages.StringField(1)
  v2Blob = _messages.StringField(2, repeated=True)
  v2Name = _messages.StringField(3)


class FixableTotalByDigest(_messages.Message):
  r"""Per resource and severity counts of fixable and total vulnerabilites.

  Enums:
    SeverityValueValuesEnum: The severity for this count. SEVERITY_UNSPECIFIED
      indicates total across all severities.

  Fields:
    fixableCount: The number of fixable vulnerabilities associated with this
      resource.
    resource: The affected resource.
    severity: The severity for this count. SEVERITY_UNSPECIFIED indicates
      total across all severities.
    totalCount: The total number of vulnerabilities associated with this
      resource.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""The severity for this count. SEVERITY_UNSPECIFIED indicates total
    across all severities.

    Values:
      SEVERITY_UNSPECIFIED: Unknown.
      MINIMAL: Minimal severity.
      LOW: Low severity.
      MEDIUM: Medium severity.
      HIGH: High severity.
      CRITICAL: Critical severity.
    """
    SEVERITY_UNSPECIFIED = 0
    MINIMAL = 1
    LOW = 2
    MEDIUM = 3
    HIGH = 4
    CRITICAL = 5

  fixableCount = _messages.IntegerField(1)
  resource = _messages.MessageField('Resource', 2)
  severity = _messages.EnumField('SeverityValueValuesEnum', 3)
  totalCount = _messages.IntegerField(4)


class GerritSourceContext(_messages.Message):
  r"""A SourceContext referring to a Gerrit project.

  Fields:
    aliasContext: An alias, which may be a branch or tag.
    gerritProject: The full project name within the host. Projects may be
      nested, so "project/subproject" is a valid project name. The "repo name"
      is the hostURI/project.
    hostUri: The URI of a running Gerrit instance.
    revisionId: A revision (commit) ID.
  """

  aliasContext = _messages.MessageField('AliasContext', 1)
  gerritProject = _messages.StringField(2)
  hostUri = _messages.StringField(3)
  revisionId = _messages.StringField(4)


class GetIamPolicyRequest(_messages.Message):
  r"""Request message for `GetIamPolicy` method."""


class GitSourceContext(_messages.Message):
  r"""A GitSourceContext denotes a particular revision in a third party Git
  repository (e.g., GitHub).

  Fields:
    revisionId: Git commit hash.
    url: Git repository URL.
  """

  revisionId = _messages.StringField(1)
  url = _messages.StringField(2)


class GoogleDevtoolsContaineranalysisV1alpha1OperationMetadata(_messages.Message):
  r"""Metadata for all operations used and required for all operations that
  created by Container Analysis Providers

  Fields:
    createTime: Output only. The time this operation was created.
    endTime: Output only. The time that this operation was marked completed or
      failed.
  """

  createTime = _messages.StringField(1)
  endTime = _messages.StringField(2)


class GrafeasV1beta1BuildDetails(_messages.Message):
  r"""Details of a build occurrence.

  Fields:
    provenance: Required. The actual provenance for the build.
    provenanceBytes: Serialized JSON representation of the provenance, used in
      generating the build signature in the corresponding build note. After
      verifying the signature, `provenance_bytes` can be unmarshalled and
      compared to the provenance to confirm that it is unchanged. A
      base64-encoded string representation of the provenance bytes is used for
      the signature in order to interoperate with openssl which expects this
      format for signature verification.  The serialized form is captured both
      to avoid ambiguity in how the provenance is marshalled to json as well
      to prevent incompatibilities with future changes.
  """

  provenance = _messages.MessageField('BuildProvenance', 1)
  provenanceBytes = _messages.StringField(2)


class GrafeasV1beta1DeploymentDetails(_messages.Message):
  r"""Details of a deployment occurrence.

  Fields:
    deployment: Required. Deployment history for the resource.
  """

  deployment = _messages.MessageField('Deployment', 1)


class GrafeasV1beta1DiscoveryDetails(_messages.Message):
  r"""Details of a discovery occurrence.

  Fields:
    discovered: Required. Analysis status for the discovered resource.
  """

  discovered = _messages.MessageField('Discovered', 1)


class GrafeasV1beta1ImageDetails(_messages.Message):
  r"""Details of an image occurrence.

  Fields:
    derivedImage: Required. Immutable. The child image derived from the base
      image.
  """

  derivedImage = _messages.MessageField('Derived', 1)


class GrafeasV1beta1PackageDetails(_messages.Message):
  r"""Details of a package occurrence.

  Fields:
    installation: Required. Where the package was installed.
  """

  installation = _messages.MessageField('Installation', 1)


class GrafeasV1beta1VulnerabilityDetails(_messages.Message):
  r"""Details of a vulnerability occurrence.

  Enums:
    SeverityValueValuesEnum: Output only. The note provider assigned Severity
      of the vulnerability.

  Fields:
    cvssScore: Output only. The CVSS score of this vulnerability. CVSS score
      is on a scale of 0-10 where 0 indicates low severity and 10 indicates
      high severity.
    longDescription: Output only. A detailed description of this
      vulnerability.
    packageIssue: Required. The set of affected locations and their fixes (if
      available) within the associated resource.
    relatedUrls: Output only. URLs related to this vulnerability.
    severity: Output only. The note provider assigned Severity of the
      vulnerability.
    shortDescription: Output only. A one sentence description of this
      vulnerability.
    type: The type of package; whether native or non native(ruby gems, node.js
      packages etc)
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""Output only. The note provider assigned Severity of the vulnerability.

    Values:
      SEVERITY_UNSPECIFIED: Unknown.
      MINIMAL: Minimal severity.
      LOW: Low severity.
      MEDIUM: Medium severity.
      HIGH: High severity.
      CRITICAL: Critical severity.
    """
    SEVERITY_UNSPECIFIED = 0
    MINIMAL = 1
    LOW = 2
    MEDIUM = 3
    HIGH = 4
    CRITICAL = 5

  cvssScore = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  longDescription = _messages.StringField(2)
  packageIssue = _messages.MessageField('PackageIssue', 3, repeated=True)
  relatedUrls = _messages.MessageField('RelatedUrl', 4, repeated=True)
  severity = _messages.EnumField('SeverityValueValuesEnum', 5)
  shortDescription = _messages.StringField(6)
  type = _messages.StringField(7)


class Hash(_messages.Message):
  r"""Container message for hash values.

  Enums:
    TypeValueValuesEnum: Required. The type of hash that was performed.

  Fields:
    type: Required. The type of hash that was performed.
    value: Required. The hash value.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of hash that was performed.

    Values:
      HASH_TYPE_UNSPECIFIED: Unknown.
      SHA256: A SHA-256 hash.
    """
    HASH_TYPE_UNSPECIFIED = 0
    SHA256 = 1

  type = _messages.EnumField('TypeValueValuesEnum', 1)
  value = _messages.BytesField(2)


class Hint(_messages.Message):
  r"""This submessage provides human-readable hints about the purpose of the
  authority. Because the name of a note acts as its resource reference, it is
  important to disambiguate the canonical name of the Note (which might be a
  UUID for security purposes) from "readable" names more suitable for debug
  output. Note that these hints should not be used to look up authorities in
  security sensitive contexts, such as when looking up attestations to verify.

  Fields:
    humanReadableName: Required. The human readable name of this attestation
      authority, for example "qa".
  """

  humanReadableName = _messages.StringField(1)


class Installation(_messages.Message):
  r"""This represents how a particular software package may be installed on a
  system.

  Fields:
    location: Required. All of the places within the filesystem versions of
      this package have been found.
    name: Output only. The name of the installed package.
  """

  location = _messages.MessageField('Location', 1, repeated=True)
  name = _messages.StringField(2)


class Layer(_messages.Message):
  r"""Layer holds metadata specific to a layer of a Docker image.

  Enums:
    DirectiveValueValuesEnum: Required. The recovered Dockerfile directive
      used to construct this layer.

  Fields:
    arguments: The recovered arguments to the Dockerfile directive.
    directive: Required. The recovered Dockerfile directive used to construct
      this layer.
  """

  class DirectiveValueValuesEnum(_messages.Enum):
    r"""Required. The recovered Dockerfile directive used to construct this
    layer.

    Values:
      DIRECTIVE_UNSPECIFIED: Default value for unsupported/missing directive.
      MAINTAINER: https://docs.docker.com/reference/builder/#maintainer
      RUN: https://docs.docker.com/reference/builder/#run
      CMD: https://docs.docker.com/reference/builder/#cmd
      LABEL: https://docs.docker.com/reference/builder/#label
      EXPOSE: https://docs.docker.com/reference/builder/#expose
      ENV: https://docs.docker.com/reference/builder/#env
      ADD: https://docs.docker.com/reference/builder/#add
      COPY: https://docs.docker.com/reference/builder/#copy
      ENTRYPOINT: https://docs.docker.com/reference/builder/#entrypoint
      VOLUME: https://docs.docker.com/reference/builder/#volume
      USER: https://docs.docker.com/reference/builder/#user
      WORKDIR: https://docs.docker.com/reference/builder/#workdir
      ARG: https://docs.docker.com/reference/builder/#arg
      ONBUILD: https://docs.docker.com/reference/builder/#onbuild
      STOPSIGNAL: https://docs.docker.com/reference/builder/#stopsignal
      HEALTHCHECK: https://docs.docker.com/reference/builder/#healthcheck
      SHELL: https://docs.docker.com/reference/builder/#shell
    """
    DIRECTIVE_UNSPECIFIED = 0
    MAINTAINER = 1
    RUN = 2
    CMD = 3
    LABEL = 4
    EXPOSE = 5
    ENV = 6
    ADD = 7
    COPY = 8
    ENTRYPOINT = 9
    VOLUME = 10
    USER = 11
    WORKDIR = 12
    ARG = 13
    ONBUILD = 14
    STOPSIGNAL = 15
    HEALTHCHECK = 16
    SHELL = 17

  arguments = _messages.StringField(1)
  directive = _messages.EnumField('DirectiveValueValuesEnum', 2)


class ListNoteOccurrencesResponse(_messages.Message):
  r"""Response for listing occurrences for a note.

  Fields:
    nextPageToken: Token to provide to skip to a particular spot in the list.
    occurrences: The occurrences attached to the specified note.
  """

  nextPageToken = _messages.StringField(1)
  occurrences = _messages.MessageField('Occurrence', 2, repeated=True)


class ListNotesResponse(_messages.Message):
  r"""Response for listing notes.

  Fields:
    nextPageToken: The next pagination token in the list response. It should
      be used as `page_token` for the following request. An empty value means
      no more results.
    notes: The notes requested.
  """

  nextPageToken = _messages.StringField(1)
  notes = _messages.MessageField('Note', 2, repeated=True)


class ListOccurrencesResponse(_messages.Message):
  r"""Response for listing occurrences.

  Fields:
    nextPageToken: The next pagination token in the list response. It should
      be used as `page_token` for the following request. An empty value means
      no more results.
    occurrences: The occurrences requested.
  """

  nextPageToken = _messages.StringField(1)
  occurrences = _messages.MessageField('Occurrence', 2, repeated=True)


class ListScanConfigsResponse(_messages.Message):
  r"""Response for listing scan configurations.

  Fields:
    nextPageToken: The next pagination token in the list response. It should
      be used as `page_token` for the following request. An empty value means
      no more results.
    scanConfigs: The scan configurations requested.
  """

  nextPageToken = _messages.StringField(1)
  scanConfigs = _messages.MessageField('ScanConfig', 2, repeated=True)


class Location(_messages.Message):
  r"""An occurrence of a particular package installation found within a
  system's filesystem. E.g., glibc was found in `/var/lib/dpkg/status`.

  Fields:
    cpeUri: Required. The CPE URI in [CPE
      format](https://cpe.mitre.org/specification/) denoting the package
      manager version distributing a package.
    path: The path from which we gathered that this package/version is
      installed.
    version: The version installed at this location.
  """

  cpeUri = _messages.StringField(1)
  path = _messages.StringField(2)
  version = _messages.MessageField('Version', 3)


class Note(_messages.Message):
  r"""A type of analysis that can be done for a resource.

  Enums:
    KindValueValuesEnum: Output only. The type of analysis. This field can be
      used as a filter in list requests.

  Fields:
    attestationAuthority: A note describing an attestation role.
    baseImage: A note describing a base image.
    build: A note describing build provenance for a verifiable build.
    createTime: Output only. The time this note was created. This field can be
      used as a filter in list requests.
    deployable: A note describing something that can be deployed.
    discovery: A note describing the initial analysis of a resource.
    expirationTime: Time of expiration for this note. Empty if note does not
      expire.
    kind: Output only. The type of analysis. This field can be used as a
      filter in list requests.
    longDescription: A detailed description of this note.
    name: Output only. The name of the note in the form of
      `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
    package: A note describing a package hosted by various package managers.
    relatedNoteNames: Other notes related to this note.
    relatedUrl: URLs associated with this note.
    shortDescription: A one sentence description of this note.
    updateTime: Output only. The time this note was last updated. This field
      can be used as a filter in list requests.
    vulnerability: A note describing a package vulnerability.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""Output only. The type of analysis. This field can be used as a filter
    in list requests.

    Values:
      NOTE_KIND_UNSPECIFIED: Unknown.
      VULNERABILITY: The note and occurrence represent a package
        vulnerability.
      BUILD: The note and occurrence assert build provenance.
      IMAGE: This represents an image basis relationship.
      PACKAGE: This represents a package installed via a package manager.
      DEPLOYMENT: The note and occurrence track deployment events.
      DISCOVERY: The note and occurrence track the initial discovery status of
        a resource.
      ATTESTATION: This represents a logical "role" that can attest to
        artifacts.
    """
    NOTE_KIND_UNSPECIFIED = 0
    VULNERABILITY = 1
    BUILD = 2
    IMAGE = 3
    PACKAGE = 4
    DEPLOYMENT = 5
    DISCOVERY = 6
    ATTESTATION = 7

  attestationAuthority = _messages.MessageField('Authority', 1)
  baseImage = _messages.MessageField('Basis', 2)
  build = _messages.MessageField('Build', 3)
  createTime = _messages.StringField(4)
  deployable = _messages.MessageField('Deployable', 5)
  discovery = _messages.MessageField('Discovery', 6)
  expirationTime = _messages.StringField(7)
  kind = _messages.EnumField('KindValueValuesEnum', 8)
  longDescription = _messages.StringField(9)
  name = _messages.StringField(10)
  package = _messages.MessageField('Package', 11)
  relatedNoteNames = _messages.StringField(12, repeated=True)
  relatedUrl = _messages.MessageField('RelatedUrl', 13, repeated=True)
  shortDescription = _messages.StringField(14)
  updateTime = _messages.StringField(15)
  vulnerability = _messages.MessageField('Vulnerability', 16)


class Occurrence(_messages.Message):
  r"""An instance of an analysis type that has been found on a resource.

  Enums:
    KindValueValuesEnum: Output only. This explicitly denotes which of the
      occurrence details are specified. This field can be used as a filter in
      list requests.

  Fields:
    attestation: Describes an attestation of an artifact.
    build: Describes a verifiable build.
    createTime: Output only. The time this occurrence was created.
    deployment: Describes the deployment of an artifact on a runtime.
    derivedImage: Describes how this resource derives from the basis in the
      associated note.
    discovered: Describes when a resource was discovered.
    installation: Describes the installation of a package on the linked
      resource.
    kind: Output only. This explicitly denotes which of the occurrence details
      are specified. This field can be used as a filter in list requests.
    name: Output only. The name of the occurrence in the form of
      `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
    noteName: Required. Immutable. The analysis note associated with this
      occurrence, in the form of `projects[PROVIDER_ID]/notes/[NOTE_ID]`. This
      field can be used as a filter in list requests.
    remediation: A description of actions that can be taken to remedy the
      note.
    resource: Required. Immutable. The resource for which the occurrence
      applies.
    updateTime: Output only. The time this occurrence was last updated.
    vulnerability: Describes a security vulnerability.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""Output only. This explicitly denotes which of the occurrence details
    are specified. This field can be used as a filter in list requests.

    Values:
      NOTE_KIND_UNSPECIFIED: Unknown.
      VULNERABILITY: The note and occurrence represent a package
        vulnerability.
      BUILD: The note and occurrence assert build provenance.
      IMAGE: This represents an image basis relationship.
      PACKAGE: This represents a package installed via a package manager.
      DEPLOYMENT: The note and occurrence track deployment events.
      DISCOVERY: The note and occurrence track the initial discovery status of
        a resource.
      ATTESTATION: This represents a logical "role" that can attest to
        artifacts.
    """
    NOTE_KIND_UNSPECIFIED = 0
    VULNERABILITY = 1
    BUILD = 2
    IMAGE = 3
    PACKAGE = 4
    DEPLOYMENT = 5
    DISCOVERY = 6
    ATTESTATION = 7

  attestation = _messages.MessageField('Details', 1)
  build = _messages.MessageField('GrafeasV1beta1BuildDetails', 2)
  createTime = _messages.StringField(3)
  deployment = _messages.MessageField('GrafeasV1beta1DeploymentDetails', 4)
  derivedImage = _messages.MessageField('GrafeasV1beta1ImageDetails', 5)
  discovered = _messages.MessageField('GrafeasV1beta1DiscoveryDetails', 6)
  installation = _messages.MessageField('GrafeasV1beta1PackageDetails', 7)
  kind = _messages.EnumField('KindValueValuesEnum', 8)
  name = _messages.StringField(9)
  noteName = _messages.StringField(10)
  remediation = _messages.StringField(11)
  resource = _messages.MessageField('Resource', 12)
  updateTime = _messages.StringField(13)
  vulnerability = _messages.MessageField('GrafeasV1beta1VulnerabilityDetails', 14)


class Package(_messages.Message):
  r"""This represents a particular package that is distributed over various
  channels. E.g., glibc (aka libc6) is distributed by many, at various
  versions.

  Fields:
    distribution: The various channels by which a package is distributed.
    name: Required. Immutable. The name of the package.
  """

  distribution = _messages.MessageField('Distribution', 1, repeated=True)
  name = _messages.StringField(2)


class PackageIssue(_messages.Message):
  r"""This message wraps a location affected by a vulnerability and its
  associated fix (if one is available).

  Fields:
    affectedLocation: Required. The location of the vulnerability.
    fixedLocation: The location of the available fix for vulnerability.
    severityName: The severity (e.g., distro assigned severity) for this
      vulnerability.
  """

  affectedLocation = _messages.MessageField('VulnerabilityLocation', 1)
  fixedLocation = _messages.MessageField('VulnerabilityLocation', 2)
  severityName = _messages.StringField(3)


class PgpSignedAttestation(_messages.Message):
  r"""An attestation wrapper with a PGP-compatible signature. This message
  only supports `ATTACHED` signatures, where the payload that is signed is
  included alongside the signature itself in the same file.

  Enums:
    ContentTypeValueValuesEnum: Type (for example schema) of the attestation
      payload that was signed. The verifier must ensure that the provided type
      is one that the verifier supports, and that the attestation payload is a
      valid instantiation of that type (for example by validating a JSON
      schema).

  Fields:
    contentType: Type (for example schema) of the attestation payload that was
      signed. The verifier must ensure that the provided type is one that the
      verifier supports, and that the attestation payload is a valid
      instantiation of that type (for example by validating a JSON schema).
    pgpKeyId: The cryptographic fingerprint of the key used to generate the
      signature, as output by, e.g. `gpg --list-keys`. This should be the
      version 4, full 160-bit fingerprint, expressed as a 40 character
      hexidecimal string. See https://tools.ietf.org/html/rfc4880#section-12.2
      for details. Implementations may choose to acknowledge "LONG", "SHORT",
      or other abbreviated key IDs, but only the full fingerprint is
      guaranteed to work. In gpg, the full fingerprint can be retrieved from
      the `fpr` field returned when calling --list-keys with --with-colons.
      For example: ``` gpg --with-colons --with-fingerprint --force-v4-certs \
      --list-keys attester@example.com tru::1:1513631572:0:3:1:5
      pub:...<SNIP>... fpr:::::::::24FF6481B76AC91E66A00AC657A93A81EF3AE6FB:
      ``` Above, the fingerprint is
      `24FF6481B76AC91E66A00AC657A93A81EF3AE6FB`.
    signature: Required. The raw content of the signature, as output by GNU
      Privacy Guard (GPG) or equivalent. Since this message only supports
      attached signatures, the payload that was signed must be attached. While
      the signature format supported is dependent on the verification
      implementation, currently only ASCII-armored (`--armor` to gpg), non-
      clearsigned (`--sign` rather than `--clearsign` to gpg) are supported.
      Concretely, `gpg --sign --armor --output=signature.gpg payload.json`
      will create the signature content expected in this field in
      `signature.gpg` for the `payload.json` attestation payload.
  """

  class ContentTypeValueValuesEnum(_messages.Enum):
    r"""Type (for example schema) of the attestation payload that was signed.
    The verifier must ensure that the provided type is one that the verifier
    supports, and that the attestation payload is a valid instantiation of
    that type (for example by validating a JSON schema).

    Values:
      CONTENT_TYPE_UNSPECIFIED: `ContentType` is not set.
      SIMPLE_SIGNING_JSON: Atomic format attestation signature. See https://gi
        thub.com/containers/image/blob/8a5d2f82a6e3263290c8e0276c3e0f64e77723e
        7/docs/atomic-signature.md The payload extracted from `signature` is a
        JSON blob conforming to the linked schema.
    """
    CONTENT_TYPE_UNSPECIFIED = 0
    SIMPLE_SIGNING_JSON = 1

  contentType = _messages.EnumField('ContentTypeValueValuesEnum', 1)
  pgpKeyId = _messages.StringField(2)
  signature = _messages.StringField(3)


class Policy(_messages.Message):
  r"""Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **JSON Example**      {       "bindings": [         {
  "role": "roles/owner",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-other-
  app@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/viewer",           "members": ["user:sean@example.com"]
  }       ]     }  **YAML Example**      bindings:     - members:       -
  user:mike@example.com       - group:admins@example.com       -
  domain:google.com       - serviceAccount:my-other-
  app@appspot.gserviceaccount.com       role: roles/owner     - members:
  - user:sean@example.com       role: roles/viewer   For a description of IAM
  and its features, see the [IAM developer's
  guide](https://cloud.google.com/iam/docs).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. `bindings` with no
      members will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten blindly.
    version: Deprecated.
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class ProjectRepoId(_messages.Message):
  r"""Selects a repo using a Google Cloud Platform project ID (e.g., winged-
  cargo-31) and a repo name within that project.

  Fields:
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
  """

  projectId = _messages.StringField(1)
  repoName = _messages.StringField(2)


class RelatedUrl(_messages.Message):
  r"""Metadata for any related URL information.

  Fields:
    label: Label to describe usage of the URL.
    url: Specific URL associated with the resource.
  """

  label = _messages.StringField(1)
  url = _messages.StringField(2)


class RepoId(_messages.Message):
  r"""A unique identifier for a Cloud Repo.

  Fields:
    projectRepoId: A combination of a project ID and a repo name.
    uid: A server-assigned, globally unique identifier.
  """

  projectRepoId = _messages.MessageField('ProjectRepoId', 1)
  uid = _messages.StringField(2)


class Resource(_messages.Message):
  r"""An entity that can have metadata. For example, a Docker image.

  Fields:
    contentHash: The hash of the resource content. For example, the Docker
      digest.
    name: The name of the resource. For example, the name of a Docker image -
      "Debian".
    uri: Required. The unique URI of the resource. For example,
      `https://gcr.io/project/image@sha256:foo` for a Docker image.
  """

  contentHash = _messages.MessageField('Hash', 1)
  name = _messages.StringField(2)
  uri = _messages.StringField(3)


class ScanConfig(_messages.Message):
  r"""A scan configuration specifies whether Cloud components in a project
  have a particular type of analysis being run. For example, it can configure
  whether vulnerability scanning is being done on Docker images or not.

  Fields:
    createTime: Output only. The time this scan config was created.
    description: Output only. A human-readable description of what the scan
      configuration does.
    enabled: Whether the scan is enabled.
    name: Output only. The name of the scan configuration in the form of
      `projects/[PROJECT_ID]/scanConfigs/[SCAN_CONFIG_ID]`.
    updateTime: Output only. The time this scan config was last updated.
  """

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  enabled = _messages.BooleanField(3)
  name = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: paths: "bindings, etag"
      This field is only used by Cloud IAM.
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class Source(_messages.Message):
  r"""Source describes the location of the source used for the build.

  Messages:
    FileHashesValue: Hash(es) of the build source, which can be used to verify
      that the original source integrity was maintained in the build.  The
      keys to this map are file paths used as build source and the values
      contain the hash values for those files.  If the build source came in a
      single package such as a gzipped tarfile (.tar.gz), the FileHash will be
      for the single path to that file.

  Fields:
    additionalContexts: If provided, some of the source code used for the
      build may be found in these locations, in the case where the source
      repository had multiple remotes or submodules. This list will not
      include the context specified in the context field.
    artifactStorageSourceUri: If provided, the input binary artifacts for the
      build came from this location.
    context: If provided, the source code used for the build came from this
      location.
    fileHashes: Hash(es) of the build source, which can be used to verify that
      the original source integrity was maintained in the build.  The keys to
      this map are file paths used as build source and the values contain the
      hash values for those files.  If the build source came in a single
      package such as a gzipped tarfile (.tar.gz), the FileHash will be for
      the single path to that file.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FileHashesValue(_messages.Message):
    r"""Hash(es) of the build source, which can be used to verify that the
    original source integrity was maintained in the build.  The keys to this
    map are file paths used as build source and the values contain the hash
    values for those files.  If the build source came in a single package such
    as a gzipped tarfile (.tar.gz), the FileHash will be for the single path
    to that file.

    Messages:
      AdditionalProperty: An additional property for a FileHashesValue object.

    Fields:
      additionalProperties: Additional properties of type FileHashesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FileHashesValue object.

      Fields:
        key: Name of the additional property.
        value: A FileHashes attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('FileHashes', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalContexts = _messages.MessageField('SourceContext', 1, repeated=True)
  artifactStorageSourceUri = _messages.StringField(2)
  context = _messages.MessageField('SourceContext', 3)
  fileHashes = _messages.MessageField('FileHashesValue', 4)


class SourceContext(_messages.Message):
  r"""A SourceContext is a reference to a tree of files. A SourceContext
  together with a path point to a unique revision of a single file or
  directory.

  Messages:
    LabelsValue: Labels with user defined metadata.

  Fields:
    cloudRepo: A SourceContext referring to a revision in a Google Cloud
      Source Repo.
    gerrit: A SourceContext referring to a Gerrit project.
    git: A SourceContext referring to any third party Git repo (e.g., GitHub).
    labels: Labels with user defined metadata.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels with user defined metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  cloudRepo = _messages.MessageField('CloudRepoSourceContext', 1)
  gerrit = _messages.MessageField('GerritSourceContext', 2)
  git = _messages.MessageField('GitSourceContext', 3)
  labels = _messages.MessageField('LabelsValue', 4)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` that can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting.  - Batch operations. If a
  client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class Version(_messages.Message):
  r"""Version contains structured information about the version of a package.

  Enums:
    KindValueValuesEnum: Required. Distinguishes between sentinel MIN/MAX
      versions and normal versions.

  Fields:
    epoch: Used to correct mistakes in the version numbering scheme.
    kind: Required. Distinguishes between sentinel MIN/MAX versions and normal
      versions.
    name: Required only when version kind is NORMAL. The main part of the
      version name.
    revision: The iteration of the package build from the above version.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""Required. Distinguishes between sentinel MIN/MAX versions and normal
    versions.

    Values:
      VERSION_KIND_UNSPECIFIED: Unknown.
      NORMAL: A standard package version.
      MINIMUM: A special version representing negative infinity.
      MAXIMUM: A special version representing positive infinity.
    """
    VERSION_KIND_UNSPECIFIED = 0
    NORMAL = 1
    MINIMUM = 2
    MAXIMUM = 3

  epoch = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  kind = _messages.EnumField('KindValueValuesEnum', 2)
  name = _messages.StringField(3)
  revision = _messages.StringField(4)


class Vulnerability(_messages.Message):
  r"""Vulnerability provides metadata about a security vulnerability.

  Enums:
    SeverityValueValuesEnum: Note provider assigned impact of the
      vulnerability.

  Fields:
    cvssScore: The CVSS score for this vulnerability.
    details: All information about the package to specifically identify this
      vulnerability. One entry per (version range and cpe_uri) the package
      vulnerability has manifested in.
    severity: Note provider assigned impact of the vulnerability.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""Note provider assigned impact of the vulnerability.

    Values:
      SEVERITY_UNSPECIFIED: Unknown.
      MINIMAL: Minimal severity.
      LOW: Low severity.
      MEDIUM: Medium severity.
      HIGH: High severity.
      CRITICAL: Critical severity.
    """
    SEVERITY_UNSPECIFIED = 0
    MINIMAL = 1
    LOW = 2
    MEDIUM = 3
    HIGH = 4
    CRITICAL = 5

  cvssScore = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  details = _messages.MessageField('Detail', 2, repeated=True)
  severity = _messages.EnumField('SeverityValueValuesEnum', 3)


class VulnerabilityLocation(_messages.Message):
  r"""The location of the vulnerability.

  Fields:
    cpeUri: Required. The CPE URI in [cpe
      format](https://cpe.mitre.org/specification/) format. Examples include
      distro or storage location for vulnerable jar.
    package: Required. The package being described.
    version: Required. The version of the package being described.
  """

  cpeUri = _messages.StringField(1)
  package = _messages.StringField(2)
  version = _messages.MessageField('Version', 3)


class VulnerabilityOccurrencesSummary(_messages.Message):
  r"""A summary of how many vulnerability occurrences there are per resource
  and severity type.

  Fields:
    counts: A listing by resource of the number of fixable and total
      vulnerabilities.
  """

  counts = _messages.MessageField('FixableTotalByDigest', 1, repeated=True)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
