/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.Format;
import jalview.MSFfile;
import jalview.ResidueProperties;
import jalview.Sequence;
import jalview.ick;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class AlignSeq {
    int[][] score;
    int[][] E;
    int[][] F;
    int[][] traceback;
    int[] seq1;
    int[] seq2;
    Sequence s1;
    Sequence s2;
    String s1str;
    String s2str;
    int maxi;
    int maxj;
    int[] aseq1;
    int[] aseq2;
    String astr1 = "";
    String astr2 = "";
    int seq1start;
    int seq1end;
    int seq2start;
    int seq2end;
    int count;
    int maxscore;
    float pid;
    int prev;
    public static Hashtable dnaHash = new Hashtable();
    static String[] dna;
    static String[] pep;
    int gapOpen = 120;
    int gapExtend = 20;
    int[][] lookup = ResidueProperties.BLOSUM62;
    String[] intToStr = pep;
    int defInt = 23;
    String output = "";
    String type;
    Runtime rt;

    public AlignSeq() {
    }

    public AlignSeq(Sequence sequence, Sequence sequence2, String string) {
        this.rt = Runtime.getRuntime();
        this.SeqInit(sequence, sequence2, string);
    }

    public void SeqInit(Sequence sequence, Sequence sequence2, String string) {
        System.out.println(sequence.getSequence());
        System.out.println(sequence2.getSequence());
        this.s1str = AlignSeq.extractGaps(".", sequence.getSequence());
        this.s2str = AlignSeq.extractGaps(".", sequence2.getSequence());
        this.s1str = AlignSeq.extractGaps("-", this.s1str);
        this.s2str = AlignSeq.extractGaps("-", this.s2str);
        this.s1str = AlignSeq.extractGaps(" ", this.s1str);
        this.s2str = AlignSeq.extractGaps(" ", this.s2str);
        this.s1 = sequence;
        this.s2 = sequence2;
        this.type = string;
        if (string.equals("pep")) {
            this.lookup = ResidueProperties.BLOSUM62;
            this.intToStr = pep;
            this.defInt = 23;
        } else if (string.equals("dna")) {
            this.lookup = ResidueProperties.DNA;
            this.intToStr = dna;
            this.defInt = 4;
        } else {
            this.output = String.valueOf(this.output) + "Wrong type = dna or pep only";
            System.exit(0);
        }
        this.seq1 = new int[this.s1str.length()];
        this.seq2 = new int[this.s2str.length()];
        this.score = new int[this.s1str.length()][this.s2str.length()];
        this.E = new int[this.s1str.length()][this.s2str.length()];
        this.F = new int[this.s1str.length()][this.s2str.length()];
        this.traceback = new int[this.s1str.length()][this.s2str.length()];
        this.seq1 = this.stringToInt(this.s1str, string);
        this.seq2 = this.stringToInt(this.s2str, string);
    }

    public void traceAlignment() {
        int n = -9999;
        int n2 = 0;
        while (n2 < this.seq1.length) {
            if (this.score[n2][this.seq2.length - 1] > n) {
                n = this.score[n2][this.seq2.length - 1];
                this.maxi = n2;
                this.maxj = this.seq2.length - 1;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.seq2.length) {
            if (this.score[this.seq1.length - 1][n3] > n) {
                n = this.score[this.seq1.length - 1][n3];
                this.maxi = this.seq1.length - 1;
                this.maxj = n3;
            }
            ++n3;
        }
        int n4 = this.maxi;
        int n5 = this.maxj;
        this.maxscore = this.score[n4][n5] / 10;
        this.seq1end = this.maxi + 1;
        this.seq2end = this.maxj + 1;
        this.aseq1 = new int[this.seq1.length + this.seq2.length];
        this.aseq2 = new int[this.seq1.length + this.seq2.length];
        this.count = this.seq1.length + this.seq2.length - 1;
        while (n4 > 0 && n5 > 0) {
            int n6;
            if (this.aseq1[this.count] != this.defInt && n4 >= 0) {
                this.aseq1[this.count] = this.seq1[n4];
                this.astr1 = String.valueOf(this.intToStr[this.seq1[n4]]) + this.astr1;
            }
            if (this.aseq2[this.count] != this.defInt && n5 > 0) {
                this.aseq2[this.count] = this.seq2[n5];
                this.astr2 = String.valueOf(this.intToStr[this.seq2[n5]]) + this.astr2;
            }
            if ((n6 = this.findTrace(n4, n5)) == 0) {
                --n4;
                --n5;
            } else if (n6 == 1) {
                --n5;
                this.aseq1[this.count] = this.defInt;
                this.astr1 = "-" + this.astr1.substring(1);
            } else if (n6 == -1) {
                --n4;
                this.aseq2[this.count] = this.defInt;
                this.astr2 = "-" + this.astr2.substring(1);
            }
            --this.count;
        }
        this.seq1start = n4 + 1;
        this.seq2start = n5 + 1;
        if (this.aseq1[this.count] != this.defInt) {
            this.aseq1[this.count] = this.seq1[n4];
            this.astr1 = String.valueOf(this.intToStr[this.seq1[n4]]) + this.astr1;
        }
        if (this.aseq2[this.count] != this.defInt) {
            this.aseq2[this.count] = this.seq2[n5];
            this.astr2 = String.valueOf(this.intToStr[this.seq2[n5]]) + this.astr2;
        }
    }

    public void printAlignment() {
        int n = this.s1.getName().length();
        if (this.s2.getName().length() > n) {
            n = this.s2.getName().length();
        }
        int n2 = 72 - n - 1;
        int n3 = (this.aseq1.length - this.count) / n2 + 1;
        this.pid = 0.0f;
        this.output = String.valueOf(this.output) + "Score = " + this.score[this.maxi][this.maxj] + "\n";
        this.output = String.valueOf(this.output) + "Length of alignment = " + (this.aseq1.length - this.count) + "\n";
        this.output = String.valueOf(this.output) + "Sequence ";
        this.output = String.valueOf(this.output) + new Format("%" + n + "s").form(this.s1.getName());
        this.output = String.valueOf(this.output) + " :  " + this.seq1start + " - " + this.seq1end + " (Sequence length = " + this.s1str.length() + ")\n";
        this.output = String.valueOf(this.output) + "Sequence ";
        this.output = String.valueOf(this.output) + new Format("%" + n + "s").form(this.s2.getName());
        this.output = String.valueOf(this.output) + " :  " + this.seq2start + " - " + this.seq2end + " (Sequence length = " + this.s2str.length() + ")\n\n";
        int n4 = 0;
        while (n4 < n3) {
            this.output = String.valueOf(this.output) + new Format("%" + n + "s").form(this.s1.getName()) + " ";
            int n5 = 0;
            while (n5 < n2) {
                if (this.count + n5 + n4 * n2 < this.aseq1.length) {
                    this.output = String.valueOf(this.output) + new Format("%s").form(this.intToStr[this.aseq1[this.count + n5 + n4 * n2]]);
                }
                ++n5;
            }
            this.output = String.valueOf(this.output) + "\n";
            this.output = String.valueOf(this.output) + new Format("%" + n + "s").form(" ") + " ";
            int n6 = 0;
            while (n6 < n2) {
                if (this.count + n6 + n4 * n2 < this.aseq1.length) {
                    if (this.intToStr[this.aseq1[this.count + n6 + n4 * n2]].equals(this.intToStr[this.aseq2[this.count + n6 + n4 * n2]]) && !this.intToStr[this.aseq1[this.count + n6 + n4 * n2]].equals("-")) {
                        this.pid += 1.0f;
                        this.output = String.valueOf(this.output) + "|";
                    } else {
                        this.output = this.type.equals("pep") ? (ResidueProperties.getPAM250(this.intToStr[this.aseq1[this.count + n6 + n4 * n2]], this.intToStr[this.aseq2[this.count + n6 + n4 * n2]]) > 0 ? String.valueOf(this.output) + "." : String.valueOf(this.output) + " ") : String.valueOf(this.output) + " ";
                    }
                }
                ++n6;
            }
            this.output = String.valueOf(this.output) + "\n";
            this.output = String.valueOf(this.output) + new Format("%" + n + "s").form(this.s2.getName()) + " ";
            int n7 = 0;
            while (n7 < n2) {
                if (this.count + n7 + n4 * n2 < this.aseq1.length) {
                    this.output = String.valueOf(this.output) + new Format("%s").form(this.intToStr[this.aseq2[this.count + n7 + n4 * n2]]);
                }
                ++n7;
            }
            this.output = String.valueOf(this.output) + "\n\n";
            ++n4;
        }
        this.pid = this.pid / (float)(this.aseq1.length - this.count) * 100.0f;
        this.output = String.valueOf(this.output) + new Format("Percentage ID = %2.2f\n\n").form(this.pid);
    }

    public void printScoreMatrix(int[][] nArray) {
        int n = this.seq1.length;
        int n2 = this.seq2.length;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            if (n3 == 0) {
                Format.print(System.out, "%8s", this.s2str.substring(0, 1));
                n4 = 1;
                while (n4 < n2) {
                    Format.print(System.out, "%5s", this.s2str.substring(n4, n4 + 1));
                    ++n4;
                }
                System.out.println();
            }
            n4 = 0;
            while (n4 < n2) {
                if (n4 == 0) {
                    Format.print(System.out, "%3s", this.s1str.substring(n3, n3 + 1));
                }
                Format.print(System.out, "%3d ", nArray[n3][n4] / 10);
                ++n4;
            }
            System.out.println();
            ++n3;
        }
    }

    public int findTrace(int n, int n2) {
        int n3 = 0;
        int n4 = this.score[n - 1][n2 - 1] + this.lookup[this.seq1[n]][this.seq2[n2]] * 10;
        if (this.F[n][n2] > n4) {
            n4 = this.F[n][n2];
            n3 = -1;
        } else if (this.F[n][n2] == n4 && this.prev == -1) {
            n4 = this.F[n][n2];
            n3 = -1;
        }
        if (this.E[n][n2] >= n4) {
            n4 = this.E[n][n2];
            n3 = 1;
        } else if (this.E[n][n2] == n4 && this.prev == 1) {
            n4 = this.E[n][n2];
            n3 = 1;
        }
        this.prev = n3;
        return n3;
    }

    public void calcScoreMatrix() {
        int n = this.seq1.length;
        int n2 = this.seq2.length;
        this.score[0][0] = this.lookup[this.seq1[0]][this.seq2[0]] * 10;
        this.E[0][0] = -this.gapExtend;
        this.F[0][0] = 0;
        int n3 = 1;
        while (n3 < n2) {
            this.E[0][n3] = this.max(this.score[0][n3 - 1] - this.gapOpen, this.E[0][n3 - 1] - this.gapExtend);
            this.F[0][n3] = -this.gapExtend;
            this.score[0][n3] = this.max(this.lookup[this.seq1[0]][this.seq2[n3]] * 10, -this.gapOpen, -this.gapExtend);
            this.traceback[0][n3] = 1;
            ++n3;
        }
        int n4 = 1;
        while (n4 < n) {
            this.E[n4][0] = -this.gapOpen;
            this.F[n4][0] = this.max(this.score[n4 - 1][0] - this.gapOpen, this.F[n4 - 1][0] - this.gapExtend);
            this.score[n4][0] = this.max(this.lookup[this.seq1[n4]][this.seq2[0]] * 10, this.E[n4][0], this.F[n4][0]);
            this.traceback[n4][0] = -1;
            ++n4;
        }
        int n5 = 1;
        while (n5 < n) {
            int n6 = 1;
            while (n6 < n2) {
                this.E[n5][n6] = this.max(this.score[n5][n6 - 1] - this.gapOpen, this.E[n5][n6 - 1] - this.gapExtend);
                this.F[n5][n6] = this.max(this.score[n5 - 1][n6] - this.gapOpen, this.F[n5 - 1][n6] - this.gapExtend);
                this.score[n5][n6] = this.max(this.score[n5 - 1][n6 - 1] + this.lookup[this.seq1[n5]][this.seq2[n6]] * 10, this.E[n5][n6], this.F[n5][n6]);
                this.traceback[n5][n6] = this.findTrace(n5, n6);
                ++n6;
            }
            ++n5;
        }
    }

    public static String extractChars(String string, String string2) {
        String string3 = string2;
        int n = 0;
        while (n < string.length()) {
            String string4 = string.substring(n, n + 1);
            string3 = AlignSeq.extractGaps(string4, string3);
            ++n;
        }
        return string3;
    }

    public static String extractGaps(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string);
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string3 = String.valueOf(string3) + stringTokenizer.nextToken();
        }
        return string3;
    }

    public int max(int n, int n2, int n3) {
        int n4 = n;
        if (n2 > n) {
            n4 = n2;
        }
        if (n3 > n4) {
            n4 = n3;
        }
        return n4;
    }

    public int max(int n, int n2) {
        int n3 = n;
        if (n2 > n) {
            n3 = n2;
        }
        return n3;
    }

    public int[] stringToInt(String string, String string2) {
        int[] nArray = new int[string.length()];
        int n = 0;
        while (n < string.length()) {
            String string3 = string.substring(n, n + 1).toUpperCase();
            try {
                if (string2.equals("pep")) {
                    nArray[n] = (Integer)ResidueProperties.aaHash.get(string3);
                } else if (string2.equals("dna")) {
                    nArray[n] = (Integer)dnaHash.get(string3);
                }
                if (nArray[n] > 23) {
                    nArray[n] = 23;
                }
            }
            catch (Exception exception) {
                nArray[n] = string2.equals("dna") ? 4 : 23;
            }
            ++n;
        }
        return nArray;
    }

    public static void displayMatrix(Graphics graphics, int[][] nArray, int n, int n2, int n3) {
        int n4;
        int n5 = -1000;
        int n6 = 1000;
        int n7 = 0;
        while (n7 < n) {
            n4 = 0;
            while (n4 < n2) {
                if (nArray[n7][n4] >= n5) {
                    n5 = nArray[n7][n4];
                }
                if (nArray[n7][n4] <= n6) {
                    n6 = nArray[n7][n4];
                }
                ++n4;
            }
            ++n7;
        }
        System.out.println(String.valueOf(n5) + " " + n6);
        n4 = 0;
        while (n4 < n) {
            int n8 = 0;
            while (n8 < n2) {
                int n9 = n3 * n4;
                int n10 = n3 * n8;
                float f = (float)(nArray[n4][n8] - n6) / (float)(n5 - n6);
                graphics.setColor(new Color(f, 0.0f, 0.0f));
                graphics.fillRect(n9, n10, n3, n3);
                ++n8;
            }
            ++n4;
        }
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            if (stringArray.length != 3) {
                System.out.println("args: <msffile> <File|URL> <pep|dna>");
                System.exit(0);
            }
            MSFfile mSFfile = new MSFfile(stringArray[0], stringArray[1]);
            Sequence[] sequenceArray = new Sequence[mSFfile.seqs.size()];
            int[][] nArray = new int[mSFfile.seqs.size()][mSFfile.seqs.size()];
            int n2 = 0;
            int n3 = 0;
            while (n3 < mSFfile.seqs.size()) {
                sequenceArray[n3] = (Sequence)mSFfile.seqs.elementAt(n3);
                ++n3;
            }
            int n4 = 1;
            while (n4 < 2) {
                n = 0;
                while (n < n4) {
                    AlignSeq alignSeq = new AlignSeq(sequenceArray[n4], sequenceArray[n], stringArray[2]);
                    alignSeq.calcScoreMatrix();
                    alignSeq.traceAlignment();
                    alignSeq.printAlignment();
                    nArray[n4][n] = alignSeq.maxscore;
                    n2 += alignSeq.maxscore;
                    System.out.println(alignSeq.output);
                    Frame frame = new Frame("Score matrix");
                    Panel panel = new Panel();
                    panel.setLayout(new BorderLayout());
                    ick ick2 = new ick(alignSeq);
                    panel.add("Center", ick2);
                    frame.setLayout(new BorderLayout());
                    frame.add("Center", panel);
                    frame.resize(500, 500);
                    frame.show();
                    ++n;
                }
                ++n4;
            }
            System.out.println();
            System.out.print("      ");
            n = 1;
            while (n < mSFfile.seqs.size()) {
                Format.print(System.out, "%6d ", n);
                ++n;
            }
            System.out.println();
            int n5 = 1;
            while (n5 < mSFfile.seqs.size()) {
                Format.print(System.out, "%6d", n5 + 1);
                int n6 = 0;
                while (n6 < n5) {
                    Format.print(System.out, "%7.3f", (float)nArray[n5][n6] / (float)n2);
                    ++n6;
                }
                System.out.println();
                ++n5;
            }
            return;
        }
        catch (Exception exception) {
            System.out.println("Exception : " + exception);
            return;
        }
    }

    static {
        dnaHash.put("C", new Integer(0));
        dnaHash.put("T", new Integer(1));
        dnaHash.put("A", new Integer(2));
        dnaHash.put("G", new Integer(3));
        dnaHash.put("-", new Integer(4));
        dna = new String[]{"C", "T", "A", "G", "-"};
        pep = new String[]{"A", "R", "N", "D", "C", "Q", "E", "G", "H", "I", "L", "K", "M", "F", "P", "S", "T", "W", "Y", "V", "B", "Z", "X", "-"};
    }
}

