/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene53;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.IOUtils;

class Lucene53NormsProducer
extends NormsProducer {
    private final Map<Integer, NormsEntry> norms;
    private final IndexInput data;
    private final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene53NormsProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        int version;
        block20: {
            this.norms = new HashMap<Integer, NormsEntry>();
            this.maxDoc = state.segmentInfo.maxDoc();
            String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
            version = -1;
            try (ChecksumIndexInput in = state.directory.openChecksumInput(metaName, state.context);){
                Throwable priorE = null;
                try {
                    version = CodecUtil.checkIndexHeader((DataInput)in, (String)metaCodec, (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    this.readFields((IndexInput)in, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block20;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter((ChecksumIndexInput)in, (Throwable)priorE);
                    }
                }
                CodecUtil.checkFooter((ChecksumIndexInput)in, (Throwable)priorE);
            }
        }
        String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        boolean success = false;
        try {
            int version2 = CodecUtil.checkIndexHeader((DataInput)this.data, (String)dataCodec, (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            if (version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + version + ",data=" + version2, (DataInput)this.data);
            }
            CodecUtil.retrieveChecksum((IndexInput)this.data);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data});
            throw throwable;
        }
    }

    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, (DataInput)meta);
            }
            if (!info.hasNorms()) {
                throw new CorruptIndexException("Invalid field: " + info.name, (DataInput)meta);
            }
            NormsEntry entry = new NormsEntry();
            entry.bytesPerValue = meta.readByte();
            switch (entry.bytesPerValue) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    break;
                }
                default: {
                    throw new CorruptIndexException("Invalid bytesPerValue: " + entry.bytesPerValue + ", field: " + info.name, (DataInput)meta);
                }
            }
            entry.offset = meta.readLong();
            this.norms.put(info.number, entry);
            fieldNumber = meta.readVInt();
        }
    }

    public NumericDocValues getNorms(FieldInfo field) throws IOException {
        NormsEntry entry = this.norms.get(field.number);
        if (entry.bytesPerValue == 0) {
            final long value = entry.offset;
            return new NormsIterator(this.maxDoc){

                public long longValue() {
                    return value;
                }
            };
        }
        IndexInput indexInput = this.data;
        synchronized (indexInput) {
            switch (entry.bytesPerValue) {
                case 1: {
                    final RandomAccessInput slice = this.data.randomAccessSlice(entry.offset, (long)this.maxDoc);
                    return new NormsIterator(this.maxDoc){

                        public long longValue() throws IOException {
                            return slice.readByte((long)this.docID);
                        }
                    };
                }
                case 2: {
                    final RandomAccessInput slice = this.data.randomAccessSlice(entry.offset, (long)this.maxDoc * 2L);
                    return new NormsIterator(this.maxDoc){

                        public long longValue() throws IOException {
                            return slice.readShort((long)this.docID << 1);
                        }
                    };
                }
                case 4: {
                    final RandomAccessInput slice = this.data.randomAccessSlice(entry.offset, (long)this.maxDoc * 4L);
                    return new NormsIterator(this.maxDoc){

                        public long longValue() throws IOException {
                            return slice.readInt((long)this.docID << 2);
                        }
                    };
                }
                case 8: {
                    final RandomAccessInput slice = this.data.randomAccessSlice(entry.offset, (long)this.maxDoc * 8L);
                    return new NormsIterator(this.maxDoc){

                        public long longValue() throws IOException {
                            return slice.readLong((long)this.docID << 3);
                        }
                    };
                }
            }
            throw new AssertionError();
        }
    }

    public void close() throws IOException {
        this.data.close();
    }

    public long ramBytesUsed() {
        return 64L * (long)this.norms.size();
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.data);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(fields=" + this.norms.size() + ")";
    }

    private static abstract class NormsIterator
    extends NumericDocValues {
        private final int maxDoc;
        protected int docID = -1;

        public NormsIterator(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        public int docID() {
            return this.docID;
        }

        public int nextDoc() {
            ++this.docID;
            if (this.docID == this.maxDoc) {
                this.docID = Integer.MAX_VALUE;
            }
            return this.docID;
        }

        public int advance(int target) {
            this.docID = target;
            if (this.docID >= this.maxDoc) {
                this.docID = Integer.MAX_VALUE;
            }
            return this.docID;
        }

        public boolean advanceExact(int target) throws IOException {
            this.docID = target;
            return true;
        }

        public long cost() {
            return 0L;
        }
    }

    static class NormsEntry {
        byte bytesPerValue;
        long offset;

        NormsEntry() {
        }
    }
}

