/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.type;

import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeVisitor;

public class PrimitiveType
implements Type {
    public static final int FLAG_BOOLEAN = 1;
    public static final int FLAG_CHAR = 2;
    public static final int FLAG_FLOAT = 4;
    public static final int FLAG_DOUBLE = 8;
    public static final int FLAG_BYTE = 16;
    public static final int FLAG_SHORT = 32;
    public static final int FLAG_INT = 64;
    public static final int FLAG_LONG = 128;
    public static final int FLAG_VOID = 256;
    public static final PrimitiveType TYPE_BOOLEAN = new PrimitiveType("boolean", 1, 1, 1);
    public static final PrimitiveType TYPE_BYTE = new PrimitiveType("byte", 16, 16, 112);
    public static final PrimitiveType TYPE_CHAR = new PrimitiveType("char", 2, 2, 66);
    public static final PrimitiveType TYPE_DOUBLE = new PrimitiveType("double", 8, 8, 8);
    public static final PrimitiveType TYPE_FLOAT = new PrimitiveType("float", 4, 4, 4);
    public static final PrimitiveType TYPE_INT = new PrimitiveType("int", 64, 114, 64);
    public static final PrimitiveType TYPE_LONG = new PrimitiveType("long", 128, 128, 128);
    public static final PrimitiveType TYPE_SHORT = new PrimitiveType("short", 32, 48, 96);
    public static final PrimitiveType TYPE_VOID = new PrimitiveType("void", 256, 256, 256);
    public static final PrimitiveType MAYBE_CHAR_TYPE = new PrimitiveType("maybe_char", 66, 66, 66);
    public static final PrimitiveType MAYBE_SHORT_TYPE = new PrimitiveType("maybe_short", 98, 98, 98);
    public static final PrimitiveType MAYBE_BYTE_TYPE = new PrimitiveType("maybe_byte", 114, 114, 114);
    public static final PrimitiveType MAYBE_BOOLEAN_TYPE = new PrimitiveType("maybe_boolean", 115, 115, 115);
    public static final PrimitiveType MAYBE_NEGATIVE_BYTE_TYPE = new PrimitiveType("maybe_negative_byte", 112, 112, 112);
    public static final PrimitiveType MAYBE_NEGATIVE_SHORT_TYPE = new PrimitiveType("maybe_negative_short", 96, 96, 96);
    public static final PrimitiveType MAYBE_INT_TYPE = new PrimitiveType("maybe_int", 64, 64, 64);
    public static final PrimitiveType MAYBE_NEGATIVE_BOOLEAN_TYPE = new PrimitiveType("maybe_negative_boolean", 113, 113, 113);
    protected String name;
    protected int dimension;
    protected int flags;
    protected int leftFlags;
    protected int rightFlags;
    protected String descriptor;

    protected PrimitiveType(String name, int flags, int leftFlags, int rightFlags) {
        this(name, flags, leftFlags, rightFlags, 0);
    }

    protected PrimitiveType(PrimitiveType primitiveType, int dimension) {
        this(primitiveType.name, primitiveType.flags, primitiveType.leftFlags, primitiveType.rightFlags, dimension);
    }

    protected PrimitiveType(String name, int flags, int leftFlags, int rightFlags, int dimension) {
        this.name = name;
        this.dimension = dimension;
        this.flags = flags;
        this.leftFlags = leftFlags;
        this.rightFlags = rightFlags;
        StringBuilder sb = new StringBuilder();
        switch (dimension) {
            case 0: {
                break;
            }
            case 1: {
                sb.append('[');
                break;
            }
            case 2: {
                sb.append("[[");
                break;
            }
            default: {
                for (int i = 0; i < dimension; ++i) {
                    sb.append('[');
                }
            }
        }
        if ((flags & 8) != 0) {
            sb.append('D');
        } else if ((flags & 4) != 0) {
            sb.append('F');
        } else if ((flags & 0x80) != 0) {
            sb.append('J');
        } else if ((flags & 1) != 0) {
            sb.append('Z');
        } else if ((flags & 0x10) != 0) {
            sb.append('B');
        } else if ((flags & 2) != 0) {
            sb.append('C');
        } else if ((flags & 0x20) != 0) {
            sb.append('S');
        } else {
            sb.append('I');
        }
        this.descriptor = sb.toString();
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public String getDescriptor() {
        return this.descriptor;
    }

    public String getName() {
        return this.name;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getLeftFlags() {
        return this.leftFlags;
    }

    public int getRightFlags() {
        return this.rightFlags;
    }

    @Override
    public PrimitiveType createType(int dimension) {
        assert (dimension >= 0);
        if (this.dimension == dimension) {
            return this;
        }
        return new PrimitiveType(this, dimension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimitiveType that = (PrimitiveType)o;
        if (this.dimension != that.dimension) {
            return false;
        }
        return this.flags == that.flags;
    }

    public int hashCode() {
        return 31 * this.dimension + this.flags;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public String toString() {
        if (this.dimension == 0) {
            return "PrimitiveType{primitive=" + this.name + "}";
        }
        return "PrimitiveType{primitive=" + this.name + ", dimension=" + this.dimension + "}";
    }
}

