/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.processor;

import java.util.List;
import org.jd.core.v1.model.classfile.ClassFile;
import org.jd.core.v1.model.classfile.Field;
import org.jd.core.v1.model.classfile.Method;
import org.jd.core.v1.model.classfile.attribute.Annotations;
import org.jd.core.v1.model.classfile.attribute.AttributeAnnotationDefault;
import org.jd.core.v1.model.classfile.attribute.AttributeCode;
import org.jd.core.v1.model.classfile.attribute.AttributeConstantValue;
import org.jd.core.v1.model.classfile.attribute.AttributeLineNumberTable;
import org.jd.core.v1.model.classfile.attribute.AttributeModule;
import org.jd.core.v1.model.classfile.attribute.ModuleInfo;
import org.jd.core.v1.model.classfile.attribute.PackageInfo;
import org.jd.core.v1.model.classfile.attribute.ServiceInfo;
import org.jd.core.v1.model.classfile.constant.ConstantDouble;
import org.jd.core.v1.model.classfile.constant.ConstantFloat;
import org.jd.core.v1.model.classfile.constant.ConstantInteger;
import org.jd.core.v1.model.classfile.constant.ConstantLong;
import org.jd.core.v1.model.classfile.constant.ConstantUtf8;
import org.jd.core.v1.model.classfile.constant.ConstantValue;
import org.jd.core.v1.model.javasyntax.CompilationUnit;
import org.jd.core.v1.model.javasyntax.declaration.ExpressionVariableInitializer;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.ModuleDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.TypeDeclaration;
import org.jd.core.v1.model.javasyntax.expression.AbstractLineNumberExpression;
import org.jd.core.v1.model.javasyntax.expression.DoubleConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.FloatConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.LongConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.StringConstantExpression;
import org.jd.core.v1.model.javasyntax.reference.BaseAnnotationReference;
import org.jd.core.v1.model.javasyntax.reference.ElementValue;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.message.Message;
import org.jd.core.v1.model.processor.Processor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileAnnotationDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileClassDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileEnumDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileFieldDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileInterfaceDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMemberDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileStaticInitializerDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.processor.ConvertClassFileException;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.AnnotationConverter;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ObjectTypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.SignatureParser;
import org.jd.core.v1.util.DefaultList;

public class ConvertClassFileProcessor
implements Processor {
    @Override
    public void process(Message message) throws Exception {
        ObjectTypeMaker objectTypeMaker = (ObjectTypeMaker)message.getHeader("objectTypeMaker");
        SignatureParser signatureParser = (SignatureParser)message.getHeader("signatureParser");
        ClassFile classFile = (ClassFile)message.getBody();
        AnnotationConverter annotationConverter = new AnnotationConverter(objectTypeMaker);
        int flags = classFile.getAccessFlags();
        TypeDeclaration typeDeclaration = (flags & 0x4000) != 0 ? this.convertEnumDeclaration(signatureParser, annotationConverter, classFile, null) : ((flags & 0x2000) != 0 ? this.convertAnnotationDeclaration(signatureParser, annotationConverter, classFile, null) : ((flags & 0x8000) != 0 ? this.convertModuleDeclaration(classFile) : ((flags & 0x200) != 0 ? this.convertInterfaceDeclaration(signatureParser, annotationConverter, classFile, null) : this.convertClassDeclaration(signatureParser, annotationConverter, classFile, null))));
        message.setHeader("majorVersion", classFile.getMajorVersion());
        message.setHeader("minorVersion", classFile.getMinorVersion());
        message.setBody(new CompilationUnit(typeDeclaration));
    }

    protected ClassFileInterfaceDeclaration convertInterfaceDeclaration(SignatureParser parser, AnnotationConverter converter, ClassFile classFile, ClassFileBodyDeclaration outerClassFileBodyDeclaration) {
        BaseAnnotationReference annotationReferences = this.convertAnnotationReferences(converter, classFile);
        SignatureParser.TypeTypes typeTypes = parser.parseClassFileSignature(classFile);
        ClassFileBodyDeclaration bodyDeclaration = this.convertBodyDeclaration(parser, converter, classFile, outerClassFileBodyDeclaration);
        return new ClassFileInterfaceDeclaration(annotationReferences, classFile.getAccessFlags(), typeTypes.thisType.getInternalName(), typeTypes.thisType.getName(), typeTypes.typeParameters, typeTypes.interfaces, bodyDeclaration);
    }

    protected ClassFileEnumDeclaration convertEnumDeclaration(SignatureParser parser, AnnotationConverter converter, ClassFile classFile, ClassFileBodyDeclaration outerClassFileBodyDeclaration) {
        BaseAnnotationReference annotationReferences = this.convertAnnotationReferences(converter, classFile);
        SignatureParser.TypeTypes typeTypes = parser.parseClassFileSignature(classFile);
        ClassFileBodyDeclaration bodyDeclaration = this.convertBodyDeclaration(parser, converter, classFile, outerClassFileBodyDeclaration);
        return new ClassFileEnumDeclaration(annotationReferences, classFile.getAccessFlags(), typeTypes.thisType.getInternalName(), typeTypes.thisType.getName(), typeTypes.interfaces, bodyDeclaration);
    }

    protected ClassFileAnnotationDeclaration convertAnnotationDeclaration(SignatureParser parser, AnnotationConverter converter, ClassFile classFile, ClassFileBodyDeclaration outerClassFileBodyDeclaration) {
        BaseAnnotationReference annotationReferences = this.convertAnnotationReferences(converter, classFile);
        SignatureParser.TypeTypes typeTypes = parser.parseClassFileSignature(classFile);
        ClassFileBodyDeclaration bodyDeclaration = this.convertBodyDeclaration(parser, converter, classFile, outerClassFileBodyDeclaration);
        return new ClassFileAnnotationDeclaration(annotationReferences, classFile.getAccessFlags(), typeTypes.thisType.getInternalName(), typeTypes.thisType.getName(), bodyDeclaration);
    }

    protected ClassFileClassDeclaration convertClassDeclaration(SignatureParser parser, AnnotationConverter converter, ClassFile classFile, ClassFileBodyDeclaration outerClassFileBodyDeclaration) {
        BaseAnnotationReference annotationReferences = this.convertAnnotationReferences(converter, classFile);
        SignatureParser.TypeTypes typeTypes = parser.parseClassFileSignature(classFile);
        ClassFileBodyDeclaration bodyDeclaration = this.convertBodyDeclaration(parser, converter, classFile, outerClassFileBodyDeclaration);
        return new ClassFileClassDeclaration(annotationReferences, classFile.getAccessFlags(), typeTypes.thisType.getInternalName(), typeTypes.thisType.getName(), typeTypes.typeParameters, typeTypes.superType, typeTypes.interfaces, bodyDeclaration);
    }

    protected ClassFileBodyDeclaration convertBodyDeclaration(SignatureParser parser, AnnotationConverter converter, ClassFile classFile, ClassFileBodyDeclaration outerClassFileBodyDeclaration) {
        ClassFileBodyDeclaration bodyDeclaration = new ClassFileBodyDeclaration(classFile.getInternalTypeName(), outerClassFileBodyDeclaration);
        bodyDeclaration.setFieldDeclarations(this.convertFields(parser, converter, classFile));
        bodyDeclaration.setMethodDeclarations(this.convertMethods(parser, converter, bodyDeclaration, classFile));
        bodyDeclaration.setInnerTypeDeclarations(this.convertInnerTypes(parser, converter, classFile, bodyDeclaration));
        return bodyDeclaration;
    }

    protected List<ClassFileFieldDeclaration> convertFields(SignatureParser parser, AnnotationConverter converter, ClassFile classFile) {
        Field[] fields = classFile.getFields();
        if (fields == null) {
            return null;
        }
        DefaultList<ClassFileFieldDeclaration> list = new DefaultList<ClassFileFieldDeclaration>(fields.length);
        for (Field field : fields) {
            BaseAnnotationReference annotationReferences = this.convertAnnotationReferences(converter, field);
            Type typeField = parser.parseFieldSignature(field);
            ExpressionVariableInitializer variableInitializer = this.convertFieldInitializer(field, typeField);
            FieldDeclarator fieldDeclarator = new FieldDeclarator(field.getName(), variableInitializer);
            list.add(new ClassFileFieldDeclaration(annotationReferences, field.getAccessFlags(), typeField, fieldDeclarator));
        }
        return list;
    }

    protected List<ClassFileConstructorOrMethodDeclaration> convertMethods(SignatureParser parser, AnnotationConverter converter, ClassFileBodyDeclaration bodyDeclaration, ClassFile classFile) {
        Method[] methods = classFile.getMethods();
        if (methods == null) {
            return null;
        }
        DefaultList<ClassFileConstructorOrMethodDeclaration> list = new DefaultList<ClassFileConstructorOrMethodDeclaration>(methods.length);
        for (Method method : methods) {
            AttributeLineNumberTable lineNumberTable;
            String name = method.getName();
            BaseAnnotationReference annotationReferences = this.convertAnnotationReferences(converter, method);
            AttributeAnnotationDefault annotationDefault = (AttributeAnnotationDefault)method.getAttribute("AnnotationDefault");
            ElementValue defaultAnnotationValue = null;
            if (annotationDefault != null) {
                defaultAnnotationValue = converter.convert(annotationDefault.getDefaultValue());
            }
            AttributeCode code = (AttributeCode)method.getAttribute("Code");
            int firstLineNumber = 0;
            if (code != null && (lineNumberTable = (AttributeLineNumberTable)code.getAttribute("LineNumberTable")) != null) {
                firstLineNumber = lineNumberTable.getLineNumberTable()[0].getLineNumber();
            }
            if ("<init>".equals(name)) {
                SignatureParser.MethodTypes methodTypes = parser.parseConstructorSignature(method);
                list.add(new ClassFileConstructorDeclaration(bodyDeclaration, classFile, method, annotationReferences, methodTypes.typeParameters, methodTypes.parameters, methodTypes.exceptions, firstLineNumber));
                continue;
            }
            if ("<clinit>".equals(name)) {
                list.add(new ClassFileStaticInitializerDeclaration(bodyDeclaration, classFile, method, firstLineNumber));
                continue;
            }
            SignatureParser.MethodTypes methodTypes = parser.parseMethodSignature(method);
            ClassFileMethodDeclaration methodDeclaration = new ClassFileMethodDeclaration(bodyDeclaration, classFile, method, annotationReferences, name, methodTypes.typeParameters, methodTypes.returned, methodTypes.parameters, methodTypes.exceptions, defaultAnnotationValue, firstLineNumber);
            list.add(methodDeclaration);
            if ((classFile.getAccessFlags() & 0x200) == 0 || methodDeclaration.getFlags() != 1) continue;
            methodDeclaration.setFlags(65537);
        }
        return list;
    }

    protected List<ClassFileMemberDeclaration> convertInnerTypes(SignatureParser parser, AnnotationConverter converter, ClassFile classFile, ClassFileBodyDeclaration outerClassFileBodyDeclaration) {
        List<ClassFile> innerClassFiles = classFile.getInnerClassFiles();
        if (innerClassFiles == null) {
            return null;
        }
        DefaultList<ClassFileMemberDeclaration> list = new DefaultList<ClassFileMemberDeclaration>(innerClassFiles.size());
        for (ClassFile innerClassFile : innerClassFiles) {
            int flags = innerClassFile.getAccessFlags();
            TypeDeclaration innerTypeDeclaration = (flags & 0x4000) != 0 ? this.convertEnumDeclaration(parser, converter, innerClassFile, outerClassFileBodyDeclaration) : ((flags & 0x2000) != 0 ? this.convertAnnotationDeclaration(parser, converter, innerClassFile, outerClassFileBodyDeclaration) : ((flags & 0x200) != 0 ? this.convertInterfaceDeclaration(parser, converter, innerClassFile, outerClassFileBodyDeclaration) : this.convertClassDeclaration(parser, converter, innerClassFile, outerClassFileBodyDeclaration)));
            list.add((ClassFileMemberDeclaration)((Object)innerTypeDeclaration));
        }
        return list;
    }

    protected BaseAnnotationReference convertAnnotationReferences(AnnotationConverter converter, ClassFile classFile) {
        Annotations visibles = (Annotations)classFile.getAttribute("RuntimeVisibleAnnotations");
        Annotations invisibles = (Annotations)classFile.getAttribute("RuntimeInvisibleAnnotations");
        return converter.convert(visibles, invisibles);
    }

    protected BaseAnnotationReference convertAnnotationReferences(AnnotationConverter converter, Field field) {
        Annotations visibles = (Annotations)field.getAttribute("RuntimeVisibleAnnotations");
        Annotations invisibles = (Annotations)field.getAttribute("RuntimeInvisibleAnnotations");
        return converter.convert(visibles, invisibles);
    }

    protected BaseAnnotationReference convertAnnotationReferences(AnnotationConverter converter, Method method) {
        Annotations visibles = (Annotations)method.getAttribute("RuntimeVisibleAnnotations");
        Annotations invisibles = (Annotations)method.getAttribute("RuntimeInvisibleAnnotations");
        return converter.convert(visibles, invisibles);
    }

    protected ExpressionVariableInitializer convertFieldInitializer(Field field, Type typeField) {
        AbstractLineNumberExpression expression;
        AttributeConstantValue acv = (AttributeConstantValue)field.getAttribute("ConstantValue");
        if (acv == null) {
            return null;
        }
        ConstantValue constantValue = acv.getConstantValue();
        switch (constantValue.getTag()) {
            case 3: {
                expression = new IntegerConstantExpression(typeField, ((ConstantInteger)constantValue).getValue());
                break;
            }
            case 4: {
                expression = new FloatConstantExpression(((ConstantFloat)constantValue).getValue());
                break;
            }
            case 5: {
                expression = new LongConstantExpression(((ConstantLong)constantValue).getValue());
                break;
            }
            case 6: {
                expression = new DoubleConstantExpression(((ConstantDouble)constantValue).getValue());
                break;
            }
            case 1: {
                expression = new StringConstantExpression(((ConstantUtf8)constantValue).getValue());
                break;
            }
            default: {
                throw new ConvertClassFileException("Invalid attributes");
            }
        }
        return new ExpressionVariableInitializer(expression);
    }

    protected ModuleDeclaration convertModuleDeclaration(ClassFile classFile) {
        AttributeModule attributeModule = (AttributeModule)classFile.getAttribute("Module");
        List<ModuleDeclaration.ModuleInfo> requires = this.convertModuleDeclarationModuleInfo(attributeModule.getRequires());
        List<ModuleDeclaration.PackageInfo> exports = this.convertModuleDeclarationPackageInfo(attributeModule.getExports());
        List<ModuleDeclaration.PackageInfo> opens = this.convertModuleDeclarationPackageInfo(attributeModule.getOpens());
        DefaultList<String> uses = new DefaultList<String>(attributeModule.getUses());
        List<ModuleDeclaration.ServiceInfo> provides = this.convertModuleDeclarationServiceInfo(attributeModule.getProvides());
        return new ModuleDeclaration(attributeModule.getFlags(), classFile.getInternalTypeName(), attributeModule.getName(), attributeModule.getVersion(), requires, exports, opens, uses, provides);
    }

    protected List<ModuleDeclaration.ModuleInfo> convertModuleDeclarationModuleInfo(ModuleInfo[] moduleInfos) {
        if (moduleInfos == null || moduleInfos.length == 0) {
            return null;
        }
        DefaultList<ModuleDeclaration.ModuleInfo> list = new DefaultList<ModuleDeclaration.ModuleInfo>(moduleInfos.length);
        for (ModuleInfo moduleInfo : moduleInfos) {
            list.add(new ModuleDeclaration.ModuleInfo(moduleInfo.getName(), moduleInfo.getFlags(), moduleInfo.getVersion()));
        }
        return list;
    }

    protected List<ModuleDeclaration.PackageInfo> convertModuleDeclarationPackageInfo(PackageInfo[] packageInfos) {
        if (packageInfos == null || packageInfos.length == 0) {
            return null;
        }
        DefaultList<ModuleDeclaration.PackageInfo> list = new DefaultList<ModuleDeclaration.PackageInfo>(packageInfos.length);
        for (PackageInfo packageInfo : packageInfos) {
            DefaultList<String> moduleInfoNames = packageInfo.getModuleInfoNames() == null ? null : new DefaultList<String>(packageInfo.getModuleInfoNames());
            list.add(new ModuleDeclaration.PackageInfo(packageInfo.getInternalName(), packageInfo.getFlags(), moduleInfoNames));
        }
        return list;
    }

    protected List<ModuleDeclaration.ServiceInfo> convertModuleDeclarationServiceInfo(ServiceInfo[] serviceInfos) {
        if (serviceInfos == null || serviceInfos.length == 0) {
            return null;
        }
        DefaultList<ModuleDeclaration.ServiceInfo> list = new DefaultList<ModuleDeclaration.ServiceInfo>(serviceInfos.length);
        for (ServiceInfo serviceInfo : serviceInfos) {
            DefaultList<String> implementationTypeNames = serviceInfo.getImplementationTypeNames() == null ? null : new DefaultList<String>(serviceInfo.getImplementationTypeNames());
            list.add(new ModuleDeclaration.ServiceInfo(serviceInfo.getInterfaceTypeName(), implementationTypeNames));
        }
        return list;
    }
}

