/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.android;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.SketchException;
import processing.core.PApplet;
import processing.mode.java.JavaBuild;
import processing.mode.java.preproc.PdePreprocessor;
import processing.mode.java.preproc.PreprocessorResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidPreprocessor
extends PdePreprocessor {
    Sketch sketch;
    String packageName;
    String sizeStatement;
    String sketchWidth;
    String sketchHeight;
    String sketchRenderer;

    public AndroidPreprocessor(Sketch sketch, String packageName) throws IOException {
        super(sketch.getName());
        this.sketch = sketch;
        this.packageName = packageName;
    }

    protected boolean parseSketchSize() {
        String scrubbed = JavaBuild.scrubComments(this.sketch.getCode(0).getProgram());
        String[] matches = PApplet.match((String)scrubbed, (String)"(?:^|\\s|;)size\\s*\\(\\s*([^\\s,]+)\\s*,\\s*([^\\s,\\)]+),?\\s*([^\\)]*)\\s*\\)\\s*\\;");
        if (matches != null) {
            boolean badSize = false;
            if (!matches[1].equals("screenWidth") && !matches[1].equals("screenHeight") && PApplet.parseInt((String)matches[1], (int)-1) == -1) {
                badSize = true;
            }
            if (!matches[2].equals("screenWidth") && !matches[2].equals("screenHeight") && PApplet.parseInt((String)matches[2], (int)-1) == -1) {
                badSize = true;
            }
            if (badSize) {
                String message = "The size of this applet could not automatically be determined\nfrom your code. Use only numeric values (not variables) for the\nsize() command. See the size() reference for more information.";
                Base.showWarning("Could not find sketch size", "The size of this applet could not automatically be determined\nfrom your code. Use only numeric values (not variables) for the\nsize() command. See the size() reference for more information.", null);
                System.out.println("More about the size() command on Android can be");
                System.out.println("found here: http://wiki.processing.org/w/Android");
                return false;
            }
            this.sizeStatement = matches[0];
            this.sketchWidth = matches[1];
            this.sketchHeight = matches[2];
            this.sketchRenderer = matches[3].trim();
            if (this.sketchRenderer.length() == 0) {
                this.sketchRenderer = null;
            }
        } else {
            this.sizeStatement = null;
            this.sketchWidth = null;
            this.sketchHeight = null;
            this.sketchRenderer = null;
        }
        return true;
    }

    @Override
    public PreprocessorResult write(Writer out, String program, String[] codeFolderPackages) throws SketchException, RecognitionException, TokenStreamException {
        if (this.sizeStatement != null) {
            int start = program.indexOf(this.sizeStatement);
            program = program.substring(0, start) + program.substring(start + this.sizeStatement.length());
        }
        program = program.replaceAll("import\\s+processing\\.opengl\\.\\S+;", "");
        return super.write(out, program, codeFolderPackages);
    }

    @Override
    protected int writeImports(PrintWriter out, List<String> programImports, List<String> codeFolderImports) {
        out.println("package " + this.packageName + ";");
        out.println();
        return 2 + super.writeImports(out, programImports, codeFolderImports);
    }

    @Override
    protected void writeFooter(PrintWriter out, String className) {
        if (this.mode == PdePreprocessor.Mode.STATIC) {
            out.println("noLoop();");
            out.println(this.indent + "}");
        }
        if (this.mode == PdePreprocessor.Mode.STATIC || this.mode == PdePreprocessor.Mode.ACTIVE) {
            out.println();
            if (this.sketchWidth != null) {
                out.println(this.indent + "public int sketchWidth() { return " + this.sketchWidth + "; }");
            }
            if (this.sketchHeight != null) {
                out.println(this.indent + "public int sketchHeight() { return " + this.sketchHeight + "; }");
            }
            if (this.sketchRenderer != null) {
                out.println(this.indent + "public String sketchRenderer() { return " + this.sketchRenderer + "; }");
            }
            out.println("}");
        }
    }

    @Override
    public String[] getCoreImports() {
        return new String[]{"processing.core.*", "processing.xml.*"};
    }

    @Override
    public String[] getDefaultImports() {
        String prefsLine = Preferences.get("android.preproc.imports.list");
        if (prefsLine != null) {
            return PApplet.splitTokens((String)prefsLine, (String)", ");
        }
        String[] androidImports = new String[]{"android.view.MotionEvent", "android.view.KeyEvent", "android.graphics.Bitmap", "java.io.*", "java.util.*"};
        Preferences.set("android.preproc.imports.list", PApplet.join((String[])androidImports, (String)","));
        return androidImports;
    }
}

