/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import org.ice4j.attribute.Attribute;

public class ErrorCodeAttribute
extends Attribute {
    public static final String NAME = "ERROR-CODE";
    public static final char TRY_ALTERNATE = '\u012c';
    public static final char BAD_REQUEST = '\u0190';
    public static final char UNAUTHORIZED = '\u0191';
    public static final char FORBIDDEN = '\u0193';
    public static final char UNKNOWN_ATTRIBUTE = '\u01a4';
    public static final char STALE_CREDENTIALS = '\u01ae';
    public static final char INTEGRITY_CHECK_FAILURE = '\u01af';
    public static final char MISSING_USERNAME = '\u01b0';
    public static final char USE_TLS = '\u01b1';
    public static final char ALLOCATION_MISMATCH = '\u01b5';
    public static final char STALE_NONCE = '\u01b6';
    public static final char ADDRESS_FAMILY_NOT_SUPPORTED = '\u01b8';
    public static final char WRONG_CREDENTIALS = '\u01b9';
    public static final char UNSUPPORTED_TRANSPORT_PROTOCOL = '\u01ba';
    public static final char PEER_ADDRESS_FAMILY_MISMATCH = '\u01bb';
    public static final char CONNECTION_ALREADY_EXISTS = '\u01be';
    public static final char CONNECTION_TIMEOUT_OR_FAILURE = '\u01bf';
    public static final char ALLOCATION_QUOTA_REACHED = '\u01e6';
    public static final char ROLE_CONFLICT = '\u01e7';
    public static final char SERVER_ERROR = '\u01f4';
    public static final char INSUFFICIENT_CAPACITY = '\u01fc';
    public static final char GLOBAL_FAILURE = '\u0258';
    private byte errorClass = 0;
    private byte errorNumber = 0;
    private byte[] reasonPhrase = null;

    ErrorCodeAttribute() {
        super('\t');
    }

    public void setErrorCode(char errorCode) throws IllegalArgumentException {
        this.setErrorClass((byte)(errorCode / 100));
        this.setErrorNumber((byte)(errorCode % 100));
    }

    public char getErrorCode() {
        return (char)(this.getErrorClass() * 100 + this.getErrorNumber());
    }

    public void setErrorNumber(byte errorNumber) throws IllegalArgumentException {
        this.errorNumber = errorNumber;
    }

    public byte getErrorNumber() {
        return this.errorNumber;
    }

    public void setErrorClass(byte errorClass) throws IllegalArgumentException {
        if (errorClass < 0 || errorClass > 99) {
            throw new IllegalArgumentException(errorClass + " is not a valid error number!");
        }
        this.errorClass = errorClass;
    }

    public byte getErrorClass() {
        return this.errorClass;
    }

    public static String getDefaultReasonPhrase(char errorCode) {
        switch (errorCode) {
            case '\u012c': {
                return "(Try Alternate): The server would like the client to use the server specified in the ALTERNATE-SERVER attribute instead.";
            }
            case '\u0190': {
                return "(Bad Request): The request was malformed.  The client should not retry the request without modification from the previous attempt.";
            }
            case '\u0191': {
                return "(Unauthorized): The Binding Request did not contain a MESSAGE-INTEGRITY attribute.";
            }
            case '\u0193': {
                return "(Forbidden): The request was valid but cannot be performed due to administrative or similar restrictions.";
            }
            case '\u01a4': {
                return "(Unknown Attribute): The server did not understand a mandatory attribute in the request.";
            }
            case '\u01ae': {
                return "(Stale Credentials): The Binding Request did contain a MESSAGE-INTEGRITY attribute, but it used a shared secret that has expired.";
            }
            case '\u01af': {
                return "(Integrity Check Failure): The Binding Request contained a MESSAGE-INTEGRITY attribute, but the HMAC failed verification.";
            }
            case '\u01b0': {
                return "(Missing Username): The Binding Request contained a MESSAGE-INTEGRITY attribute, but not a USERNAME attribute.";
            }
            case '\u01b1': {
                return "(Use TLS): The Shared Secret request has to be sent over TLS, but was not received over TLS.";
            }
            case '\u01b5': {
                return "(Allocation Mismatch): A request was received by the server that requires an allocation to be in place, but no allocation exists, or a request was received that requires no allocation, but an allocation exists.";
            }
            case '\u01b6': {
                return "(Stale Nonce): See the procedures for the long-term credential mechanism.";
            }
            case '\u01b8': {
                return "(Address Family not Supported):  The server does not support the address family requested by the client.";
            }
            case '\u01b9': {
                return "(Wrong Credentials): The credentials in the (non-Allocate) request do not match those used to create the allocation.";
            }
            case '\u01ba': {
                return "(Unsupported Transport Protocol): The Allocate request asked the server to use a transport protocol between the server and the peer that the server does not support.";
            }
            case '\u01bb': {
                return "Peer Address Family Mismatch):  A peer address was of a different address family than that of the relayed transport address of the allocation.";
            }
            case '\u01be': {
                return "Connection Already Exists";
            }
            case '\u01bf': {
                return "Connection Timeout or Failure";
            }
            case '\u01e6': {
                return "(Allocation Quota Reached): No more allocations using this username can be created at the present time.";
            }
            case '\u01f4': {
                return "(Server Error): The server has suffered a temporary error. The client should try again.";
            }
            case '\u01fc': {
                return "(Insufficient Capacity): The server is unable to carry out the request due to some capacity limit being reached.";
            }
            case '\u0258': {
                return "(Global Failure:) The server is refusing to fulfill the request. The client should not retry.";
            }
        }
        return "Unknown Error";
    }

    public void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase.getBytes();
    }

    public String getReasonPhrase() {
        if (this.reasonPhrase == null) {
            return null;
        }
        return new String(this.reasonPhrase);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public char getDataLength() {
        char len = (char)(4 + (char)(this.reasonPhrase == null ? 0 : this.reasonPhrase.length));
        return len;
    }

    @Override
    public byte[] encode() {
        byte[] binValue = new byte[4 + this.getDataLength() + (4 - this.getDataLength() % 4) % 4];
        binValue[0] = (byte)(this.getAttributeType() >> 8);
        binValue[1] = (byte)(this.getAttributeType() & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        binValue[4] = 0;
        binValue[5] = 0;
        binValue[6] = this.getErrorClass();
        binValue[7] = this.getErrorNumber();
        if (this.reasonPhrase != null) {
            System.arraycopy(this.reasonPhrase, 0, binValue, 8, this.reasonPhrase.length);
        }
        return binValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ErrorCodeAttribute) || obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ErrorCodeAttribute att = (ErrorCodeAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && att.getErrorClass() == this.getErrorClass() && att.getErrorNumber() == this.getErrorNumber() && (att.getReasonPhrase() == null || att.getReasonPhrase().equals(this.getReasonPhrase()));
    }

    @Override
    void decodeAttributeBody(byte[] attributeValue, char offset, char length) {
        char c = offset = (char)(offset + 2);
        offset = (char)(offset + '\u0001');
        this.setErrorClass(attributeValue[c]);
        char c2 = offset;
        offset = (char)(offset + '\u0001');
        this.setErrorNumber(attributeValue[c2]);
        byte[] reasonBytes = new byte[length - 4];
        System.arraycopy(attributeValue, offset, reasonBytes, 0, reasonBytes.length);
        this.setReasonPhrase(new String(reasonBytes));
    }
}

