/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.IsSingleton;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.NamedNode;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.StartupListener;
import org.apache.camel.StatefulService;
import org.apache.camel.SuspendableService;
import org.apache.camel.TypeConverter;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.impl.ActiveMQUuidGenerator;
import org.apache.camel.impl.CamelContextTrackerRegistry;
import org.apache.camel.impl.CompositeRegistry;
import org.apache.camel.impl.DefaultAsyncProcessorAwaitManager;
import org.apache.camel.impl.DefaultCamelContextNameStrategy;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.impl.DefaultComponentResolver;
import org.apache.camel.impl.DefaultConsumerTemplate;
import org.apache.camel.impl.DefaultDataFormatResolver;
import org.apache.camel.impl.DefaultEndpointRegistry;
import org.apache.camel.impl.DefaultExecutorServiceManager;
import org.apache.camel.impl.DefaultExecutorServiceStrategy;
import org.apache.camel.impl.DefaultFactoryFinderResolver;
import org.apache.camel.impl.DefaultInflightRepository;
import org.apache.camel.impl.DefaultInjector;
import org.apache.camel.impl.DefaultLanguageResolver;
import org.apache.camel.impl.DefaultManagementNameStrategy;
import org.apache.camel.impl.DefaultModelJAXBContextFactory;
import org.apache.camel.impl.DefaultNodeIdFactory;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.impl.DefaultProducerTemplate;
import org.apache.camel.impl.DefaultRestRegistry;
import org.apache.camel.impl.DefaultRouteStartupOrder;
import org.apache.camel.impl.DefaultRuntimeEndpointRegistry;
import org.apache.camel.impl.DefaultShutdownStrategy;
import org.apache.camel.impl.DefaultStreamCachingStrategy;
import org.apache.camel.impl.DefaultUnitOfWorkFactory;
import org.apache.camel.impl.DeferServiceStartupListener;
import org.apache.camel.impl.EndpointKey;
import org.apache.camel.impl.ExplicitCamelContextNameStrategy;
import org.apache.camel.impl.InterceptSendToEndpoint;
import org.apache.camel.impl.JavaUuidGenerator;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.impl.PropertyPlaceholderDelegateRegistry;
import org.apache.camel.impl.RouteService;
import org.apache.camel.impl.SharedPollingConsumerServicePool;
import org.apache.camel.impl.SharedProducerServicePool;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.impl.WebSpherePackageScanClassResolver;
import org.apache.camel.impl.converter.BaseTypeConverterRegistry;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.impl.converter.LazyLoadingTypeConverter;
import org.apache.camel.management.DefaultManagementMBeanAssembler;
import org.apache.camel.management.DefaultManagementStrategy;
import org.apache.camel.management.ManagementStrategyFactory;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.processor.interceptor.BacklogDebugger;
import org.apache.camel.processor.interceptor.BacklogTracer;
import org.apache.camel.processor.interceptor.Debug;
import org.apache.camel.processor.interceptor.Delayer;
import org.apache.camel.processor.interceptor.HandleFault;
import org.apache.camel.processor.interceptor.StreamCaching;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.Container;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.ExecutorServiceStrategy;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementMBeanAssembler;
import org.apache.camel.spi.ManagementNameStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestRegistry;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.ServicePool;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.JsonSchemaHelper;
import org.apache.camel.util.LoadPropertiesException;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.StringQuoteHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCamelContext
extends ServiceSupport
implements ModelCamelContext,
SuspendableService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JAXBContext jaxbContext;
    private CamelContextNameStrategy nameStrategy = new DefaultCamelContextNameStrategy();
    private ManagementNameStrategy managementNameStrategy = new DefaultManagementNameStrategy(this);
    private String managementName;
    private ClassLoader applicationContextClassLoader;
    private EndpointRegistry<EndpointKey> endpoints;
    private final AtomicInteger endpointKeyCounter = new AtomicInteger();
    private final List<EndpointStrategy> endpointStrategies = new ArrayList<EndpointStrategy>();
    private final Map<String, Component> components = new HashMap<String, Component>();
    private final Set<Route> routes = new LinkedHashSet<Route>();
    private final List<Service> servicesToStop = new CopyOnWriteArrayList<Service>();
    private final Set<StartupListener> startupListeners = new LinkedHashSet<StartupListener>();
    private final DeferServiceStartupListener deferStartupListener = new DeferServiceStartupListener();
    private TypeConverter typeConverter;
    private TypeConverterRegistry typeConverterRegistry;
    private Injector injector;
    private ComponentResolver componentResolver;
    private boolean autoCreateComponents = true;
    private LanguageResolver languageResolver = new DefaultLanguageResolver();
    private final Map<String, Language> languages = new HashMap<String, Language>();
    private Registry registry;
    private List<LifecycleStrategy> lifecycleStrategies = new CopyOnWriteArrayList<LifecycleStrategy>();
    private ManagementStrategy managementStrategy;
    private ManagementMBeanAssembler managementMBeanAssembler;
    private final List<RouteDefinition> routeDefinitions = new ArrayList<RouteDefinition>();
    private final List<RestDefinition> restDefinitions = new ArrayList<RestDefinition>();
    private Map<String, RestConfiguration> restConfigurations = new ConcurrentHashMap<String, RestConfiguration>();
    private RestRegistry restRegistry = new DefaultRestRegistry();
    private List<InterceptStrategy> interceptStrategies = new ArrayList<InterceptStrategy>();
    private List<RoutePolicyFactory> routePolicyFactories = new ArrayList<RoutePolicyFactory>();
    private volatile boolean firstStartDone;
    private volatile boolean doNotStartRoutesOnFirstStart;
    private final ThreadLocal<Boolean> isStartingRoutes = new ThreadLocal();
    private final ThreadLocal<Boolean> isSetupRoutes = new ThreadLocal();
    private Boolean autoStartup = Boolean.TRUE;
    private Boolean trace = Boolean.FALSE;
    private Boolean messageHistory = Boolean.TRUE;
    private Boolean streamCache = Boolean.FALSE;
    private Boolean handleFault = Boolean.FALSE;
    private Boolean disableJMX = Boolean.FALSE;
    private Boolean lazyLoadTypeConverters = Boolean.FALSE;
    private Boolean typeConverterStatisticsEnabled = Boolean.FALSE;
    private Boolean useMDCLogging = Boolean.FALSE;
    private Boolean useBreadcrumb = Boolean.TRUE;
    private Boolean allowUseOriginalMessage = Boolean.TRUE;
    private Long delay;
    private ErrorHandlerFactory errorHandlerBuilder;
    private final Object errorHandlerExecutorServiceLock = new Object();
    private ScheduledExecutorService errorHandlerExecutorService;
    private Map<String, DataFormatDefinition> dataFormats = new HashMap<String, DataFormatDefinition>();
    private DataFormatResolver dataFormatResolver = new DefaultDataFormatResolver();
    private Map<String, String> properties = new HashMap<String, String>();
    private FactoryFinderResolver factoryFinderResolver = new DefaultFactoryFinderResolver();
    private FactoryFinder defaultFactoryFinder;
    private PropertiesComponent propertiesComponent;
    private StreamCachingStrategy streamCachingStrategy;
    private final Map<String, FactoryFinder> factories = new HashMap<String, FactoryFinder>();
    private final Map<String, RouteService> routeServices = new LinkedHashMap<String, RouteService>();
    private final Map<String, RouteService> suspendedRouteServices = new LinkedHashMap<String, RouteService>();
    private ClassResolver classResolver = new DefaultClassResolver(this);
    private PackageScanClassResolver packageScanClassResolver;
    private ServicePool<Endpoint, Producer> producerServicePool = new SharedProducerServicePool(100);
    private ServicePool<Endpoint, PollingConsumer> pollingConsumerServicePool = new SharedPollingConsumerServicePool(100);
    private NodeIdFactory nodeIdFactory = new DefaultNodeIdFactory();
    private ProcessorFactory processorFactory;
    private InterceptStrategy defaultTracer;
    private InterceptStrategy defaultBacklogTracer;
    private InterceptStrategy defaultBacklogDebugger;
    private InflightRepository inflightRepository = new DefaultInflightRepository();
    private AsyncProcessorAwaitManager asyncProcessorAwaitManager = new DefaultAsyncProcessorAwaitManager();
    private RuntimeEndpointRegistry runtimeEndpointRegistry = new DefaultRuntimeEndpointRegistry();
    private final List<RouteStartupOrder> routeStartupOrder = new ArrayList<RouteStartupOrder>();
    private int defaultRouteStartupOrder = 1000;
    private ShutdownStrategy shutdownStrategy = new DefaultShutdownStrategy(this);
    private ShutdownRoute shutdownRoute = ShutdownRoute.Default;
    private ShutdownRunningTask shutdownRunningTask = ShutdownRunningTask.CompleteCurrentTaskOnly;
    private ExecutorServiceManager executorServiceManager;
    private Debugger debugger;
    private UuidGenerator uuidGenerator = DefaultCamelContext.createDefaultUuidGenerator();
    private UnitOfWorkFactory unitOfWorkFactory = new DefaultUnitOfWorkFactory();
    private final StopWatch stopWatch = new StopWatch(false);
    private Date startDate;
    private ModelJAXBContextFactory modelJAXBContextFactory;

    public DefaultCamelContext() {
        this.executorServiceManager = new DefaultExecutorServiceManager(this);
        this.endpoints = new DefaultEndpointRegistry(this);
        this.startupListeners.add(this.deferStartupListener);
        if (WebSpherePackageScanClassResolver.isWebSphereClassLoader(this.getClass().getClassLoader())) {
            this.log.info("Using WebSphere specific PackageScanClassResolver");
            this.packageScanClassResolver = new WebSpherePackageScanClassResolver("META-INF/services/org/apache/camel/TypeConverter");
        } else {
            this.packageScanClassResolver = new DefaultPackageScanClassResolver();
        }
        this.managementStrategy = this.createManagementStrategy();
        this.managementMBeanAssembler = this.createManagementMBeanAssembler();
        CamelContextTrackerRegistry.INSTANCE.contextCreated(this);
    }

    public DefaultCamelContext(Context jndiContext) {
        this();
        this.setJndiContext(jndiContext);
    }

    public DefaultCamelContext(Registry registry) {
        this();
        this.setRegistry(registry);
    }

    @Override
    public <T extends CamelContext> T adapt(Class<T> type) {
        return (T)((CamelContext)type.cast(this));
    }

    @Override
    public String getName() {
        return this.getNameStrategy().getName();
    }

    public void setName(String name) {
        this.nameStrategy = new ExplicitCamelContextNameStrategy(name);
    }

    @Override
    public CamelContextNameStrategy getNameStrategy() {
        return this.nameStrategy;
    }

    @Override
    public void setNameStrategy(CamelContextNameStrategy nameStrategy) {
        this.nameStrategy = nameStrategy;
    }

    @Override
    public ManagementNameStrategy getManagementNameStrategy() {
        return this.managementNameStrategy;
    }

    @Override
    public void setManagementNameStrategy(ManagementNameStrategy managementNameStrategy) {
        this.managementNameStrategy = managementNameStrategy;
    }

    @Override
    public String getManagementName() {
        return this.managementName;
    }

    public void setManagementName(String managementName) {
        this.managementName = managementName;
    }

    @Override
    public Component hasComponent(String componentName) {
        return this.components.get(componentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addComponent(String componentName, Component component) {
        ObjectHelper.notNull(component, "component");
        Map<String, Component> map = this.components;
        synchronized (map) {
            if (this.components.containsKey(componentName)) {
                throw new IllegalArgumentException("Cannot add component as its already previously added: " + componentName);
            }
            component.setCamelContext(this);
            this.components.put(componentName, component);
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onComponentAdd(componentName, component);
            }
            if (component instanceof PropertiesComponent && "properties".equals(componentName)) {
                this.propertiesComponent = (PropertiesComponent)component;
            }
        }
    }

    @Override
    public Component getComponent(String name) {
        return this.getComponent(name, this.autoCreateComponents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getComponent(String name, boolean autoCreateComponents) {
        Map<String, Component> map = this.components;
        synchronized (map) {
            Component component = this.components.get(name);
            if (component == null && autoCreateComponents) {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Using ComponentResolver: {} to resolve component with name: {}", (Object)this.getComponentResolver(), (Object)name);
                    }
                    if ((component = this.getComponentResolver().resolveComponent(name, this)) != null) {
                        this.addComponent(name, component);
                        if ((this.isStarted() || this.isStarting()) && component instanceof Service) {
                            this.startService((Service)((Object)component));
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Cannot auto create component: " + name, e);
                }
            }
            this.log.trace("getComponent({}) -> {}", (Object)name, (Object)component);
            return component;
        }
    }

    @Override
    public <T extends Component> T getComponent(String name, Class<T> componentType) {
        Component component = this.getComponent(name);
        if (componentType.isInstance(component)) {
            return (T)((Component)componentType.cast(component));
        }
        String message = component == null ? "Did not find component given by the name: " + name : "Found component of type: " + component.getClass() + " instead of expected: " + componentType;
        throw new IllegalArgumentException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component removeComponent(String componentName) {
        Map<String, Component> map = this.components;
        synchronized (map) {
            Component oldComponent = this.components.remove(componentName);
            if (oldComponent != null) {
                try {
                    this.stopServices(oldComponent);
                }
                catch (Exception e) {
                    this.log.warn("Error stopping component " + oldComponent + ". This exception will be ignored.", e);
                }
                for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                    strategy.onComponentRemove(componentName, oldComponent);
                }
            }
            if (oldComponent != null && "properties".equals(componentName)) {
                this.propertiesComponent = null;
            }
            return oldComponent;
        }
    }

    public EndpointRegistry getEndpointRegistry() {
        return this.endpoints;
    }

    @Override
    public Collection<Endpoint> getEndpoints() {
        return new ArrayList<Endpoint>(this.endpoints.values());
    }

    @Override
    public Map<String, Endpoint> getEndpointMap() {
        TreeMap<String, Endpoint> answer = new TreeMap<String, Endpoint>();
        for (Map.Entry entry : this.endpoints.entrySet()) {
            answer.put((String)((EndpointKey)entry.getKey()).get(), (Endpoint)entry.getValue());
        }
        return answer;
    }

    @Override
    public Endpoint hasEndpoint(String uri) {
        return (Endpoint)this.endpoints.get(this.getEndpointKey(uri));
    }

    @Override
    public Endpoint addEndpoint(String uri, Endpoint endpoint) throws Exception {
        this.startService(endpoint);
        Endpoint oldEndpoint = (Endpoint)this.endpoints.remove(this.getEndpointKey(uri));
        for (LifecycleStrategy strategy : this.lifecycleStrategies) {
            strategy.onEndpointAdd(endpoint);
        }
        this.addEndpointToRegistry(uri, endpoint);
        if (oldEndpoint != null) {
            this.stopServices(oldEndpoint);
        }
        return oldEndpoint;
    }

    @Override
    public void removeEndpoint(Endpoint endpoint) throws Exception {
        this.removeEndpoints(endpoint.getEndpointUri());
    }

    @Override
    public Collection<Endpoint> removeEndpoints(String uri) throws Exception {
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        Endpoint oldEndpoint = (Endpoint)this.endpoints.remove(this.getEndpointKey(uri));
        if (oldEndpoint != null) {
            answer.add(oldEndpoint);
            this.stopServices(oldEndpoint);
        } else {
            for (Map.Entry entry : this.endpoints.entrySet()) {
                oldEndpoint = (Endpoint)entry.getValue();
                if (!EndpointHelper.matchEndpoint(this, oldEndpoint.getEndpointUri(), uri)) continue;
                try {
                    this.stopServices(oldEndpoint);
                }
                catch (Exception e) {
                    this.log.warn("Error stopping endpoint " + oldEndpoint + ". This exception will be ignored.", e);
                }
                answer.add(oldEndpoint);
                this.endpoints.remove(entry.getKey());
            }
        }
        for (Endpoint endpoint : answer) {
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onEndpointRemove(endpoint);
            }
        }
        return answer;
    }

    @Override
    public Endpoint getEndpoint(String uri) {
        ObjectHelper.notEmpty(uri, "uri");
        this.log.trace("Getting endpoint with uri: {}", (Object)uri);
        try {
            uri = this.resolvePropertyPlaceholders(uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, e);
        }
        String rawUri = uri;
        uri = DefaultCamelContext.normalizeEndpointUri(uri);
        this.log.trace("Getting endpoint with raw uri: {}, normalized uri: {}", (Object)rawUri, (Object)uri);
        String scheme = null;
        EndpointKey key = this.getEndpointKey(uri);
        Endpoint answer = (Endpoint)this.endpoints.get(key);
        if (answer == null) {
            try {
                String[] splitURI = ObjectHelper.splitOnCharacter(uri, ":", 2);
                if (splitURI[1] != null) {
                    scheme = splitURI[0];
                    this.log.trace("Endpoint uri: {} is from component with name: {}", (Object)uri, (Object)scheme);
                    Component component = this.getComponent(scheme);
                    if (component != null) {
                        this.log.trace("Creating endpoint from uri: {} using component: {}", (Object)uri, (Object)component);
                        answer = component.useRawUri() ? component.createEndpoint(rawUri) : component.createEndpoint(uri);
                        if (answer != null && this.log.isDebugEnabled()) {
                            this.log.debug("{} converted to endpoint: {} by component: {}", URISupport.sanitizeUri(uri), answer, component);
                        }
                    }
                }
                if (answer == null) {
                    answer = this.createEndpoint(uri);
                    this.log.trace("No component to create endpoint from uri: {} fallback lookup in registry -> {}", (Object)uri, (Object)answer);
                }
                if (answer != null) {
                    this.addService(answer);
                    answer = this.addEndpointToRegistry(uri, answer);
                }
            }
            catch (Exception e) {
                throw new ResolveEndpointFailedException(uri, e);
            }
        }
        if (answer == null && scheme != null) {
            throw new ResolveEndpointFailedException(uri, "No component found with scheme: " + scheme);
        }
        return answer;
    }

    @Override
    public <T extends Endpoint> T getEndpoint(String name, Class<T> endpointType) {
        Endpoint endpoint = this.getEndpoint(name);
        if (endpoint == null) {
            throw new NoSuchEndpointException(name);
        }
        if (endpoint instanceof InterceptSendToEndpoint) {
            endpoint = ((InterceptSendToEndpoint)endpoint).getDelegate();
        }
        if (endpointType.isInstance(endpoint)) {
            return (T)((Endpoint)endpointType.cast(endpoint));
        }
        throw new IllegalArgumentException("The endpoint is not of type: " + endpointType + " but is: " + endpoint.getClass().getCanonicalName());
    }

    @Override
    public void addRegisterEndpointCallback(EndpointStrategy strategy) {
        if (!this.endpointStrategies.contains(strategy)) {
            this.endpointStrategies.add(strategy);
            for (Endpoint endpoint : this.getEndpoints()) {
                Endpoint newEndpoint = strategy.registerEndpoint(endpoint.getEndpointUri(), endpoint);
                if (newEndpoint == null) continue;
                this.endpoints.put(this.getEndpointKey(endpoint.getEndpointUri()), newEndpoint);
            }
        }
    }

    protected Endpoint addEndpointToRegistry(String uri, Endpoint endpoint) {
        ObjectHelper.notEmpty(uri, "uri");
        ObjectHelper.notNull(endpoint, "endpoint");
        for (EndpointStrategy strategy : this.endpointStrategies) {
            endpoint = strategy.registerEndpoint(uri, endpoint);
        }
        this.endpoints.put(this.getEndpointKey(uri, endpoint), endpoint);
        return endpoint;
    }

    protected static String normalizeEndpointUri(String uri) {
        try {
            uri = URISupport.normalizeUri(uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, e);
        }
        return uri;
    }

    protected EndpointKey getEndpointKey(String uri) {
        return new EndpointKey(uri);
    }

    protected EndpointKey getEndpointKey(String uri, Endpoint endpoint) {
        if (endpoint != null && !endpoint.isSingleton()) {
            int counter = this.endpointKeyCounter.incrementAndGet();
            return new EndpointKey(uri + ":" + counter);
        }
        return new EndpointKey(uri);
    }

    @Override
    public List<RouteStartupOrder> getRouteStartupOrder() {
        return this.routeStartupOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Route> getRoutes() {
        if (this.routes.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Route> set = this.routes;
        synchronized (set) {
            return new ArrayList<Route>(this.routes);
        }
    }

    @Override
    public Route getRoute(String id) {
        for (Route route : this.getRoutes()) {
            if (!route.getId().equals(id)) continue;
            return route;
        }
        return null;
    }

    @Override
    public Processor getProcessor(String id) {
        for (Route route : this.getRoutes()) {
            List<Processor> list = route.filter(id);
            if (list.size() != 1) continue;
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T extends Processor> T getProcessor(String id, Class<T> type) {
        Processor answer = this.getProcessor(id);
        if (answer != null) {
            return (T)((Processor)type.cast(answer));
        }
        return null;
    }

    @Override
    public <T extends ManagedProcessorMBean> T getManagedProcessor(String id, Class<T> type) {
        if (this.getManagementStrategy().getManagementAgent() == null) {
            return null;
        }
        Processor processor = this.getProcessor(id);
        ProcessorDefinition def = this.getProcessorDefinition(id);
        if (processor != null && def != null) {
            try {
                ObjectName on = this.getManagementStrategy().getManagementNamingStrategy().getObjectNameForProcessor(this, processor, def);
                return (T)((ManagedProcessorMBean)this.getManagementStrategy().getManagementAgent().newProxyClient(on, type));
            }
            catch (MalformedObjectNameException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return null;
    }

    @Override
    public <T extends ManagedRouteMBean> T getManagedRoute(String routeId, Class<T> type) {
        if (this.getManagementStrategy().getManagementAgent() == null) {
            return null;
        }
        Route route = this.getRoute(routeId);
        if (route != null) {
            try {
                ObjectName on = this.getManagementStrategy().getManagementNamingStrategy().getObjectNameForRoute(route);
                return (T)((ManagedRouteMBean)this.getManagementStrategy().getManagementAgent().newProxyClient(on, type));
            }
            catch (MalformedObjectNameException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return null;
    }

    @Override
    public ManagedCamelContextMBean getManagedCamelContext() {
        if (this.getManagementStrategy().getManagementAgent() == null) {
            return null;
        }
        try {
            ObjectName on = this.getManagementStrategy().getManagementNamingStrategy().getObjectNameForCamelContext(this);
            return this.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedCamelContextMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public ProcessorDefinition getProcessorDefinition(String id) {
        for (RouteDefinition route : this.getRouteDefinitions()) {
            Iterator<ProcessorDefinition> it = ProcessorDefinitionHelper.filterTypeInOutputs(route.getOutputs(), ProcessorDefinition.class);
            while (it.hasNext()) {
                ProcessorDefinition proc = it.next();
                if (!id.equals(proc.getId())) continue;
                return proc;
            }
        }
        return null;
    }

    @Override
    public <T extends ProcessorDefinition> T getProcessorDefinition(String id, Class<T> type) {
        ProcessorDefinition answer = this.getProcessorDefinition(id);
        if (answer != null) {
            return (T)((ProcessorDefinition)type.cast(answer));
        }
        return null;
    }

    @Deprecated
    public void setRoutes(List<Route> routes) {
        throw new UnsupportedOperationException("Overriding existing routes is not supported yet, use addRouteCollection instead");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRouteCollection(Collection<Route> routes) {
        Set<Route> set = this.routes;
        synchronized (set) {
            this.routes.removeAll(routes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRouteCollection(Collection<Route> routes) throws Exception {
        Set<Route> set = this.routes;
        synchronized (set) {
            this.routes.addAll(routes);
        }
    }

    @Override
    public void addRoutes(final RoutesBuilder builder) throws Exception {
        this.log.debug("Adding routes from builder: {}", (Object)builder);
        this.doWithDefinedClassLoader(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                builder.addRoutesToCamelContext(DefaultCamelContext.this);
                return null;
            }
        });
    }

    @Override
    public synchronized RoutesDefinition loadRoutesDefinition(InputStream is) throws Exception {
        RoutesDefinition answer;
        Unmarshaller unmarshaller;
        Object result;
        if (this.jaxbContext == null) {
            this.jaxbContext = this.getModelJAXBContextFactory().newJAXBContext();
        }
        if ((result = (unmarshaller = this.jaxbContext.createUnmarshaller()).unmarshal(is)) == null) {
            throw new IOException("Cannot unmarshal to routes using JAXB from input stream: " + is);
        }
        if (result instanceof RouteDefinition) {
            RouteDefinition route = (RouteDefinition)result;
            answer = new RoutesDefinition();
            answer.getRoutes().add(route);
        } else if (result instanceof RoutesDefinition) {
            answer = (RoutesDefinition)result;
        } else {
            throw new IllegalArgumentException("Unmarshalled object is an unsupported type: " + ObjectHelper.className(result) + " -> " + result);
        }
        return answer;
    }

    @Override
    public synchronized void addRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        if (routeDefinitions == null || routeDefinitions.isEmpty()) {
            return;
        }
        for (RouteDefinition routeDefinition : routeDefinitions) {
            this.removeRouteDefinition(routeDefinition);
        }
        this.routeDefinitions.addAll(routeDefinitions);
        if (this.shouldStartRoutes()) {
            this.startRouteDefinitions(routeDefinitions);
        }
    }

    @Override
    public void addRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        this.addRouteDefinitions(Arrays.asList(routeDefinition));
    }

    protected boolean removeRouteDefinition(String key) {
        boolean answer = false;
        Iterator<RouteDefinition> iter = this.routeDefinitions.iterator();
        while (iter.hasNext()) {
            RouteDefinition route = iter.next();
            if (!route.idOrCreate(this.nodeIdFactory).equals(key)) continue;
            iter.remove();
            answer = true;
        }
        return answer;
    }

    @Override
    public synchronized void removeRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        for (RouteDefinition routeDefinition : routeDefinitions) {
            this.removeRouteDefinition(routeDefinition);
        }
    }

    @Override
    public synchronized void removeRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        String id = routeDefinition.getId();
        if (id != null) {
            this.stopRoute(id);
            this.removeRoute(id);
        }
        this.routeDefinitions.remove(routeDefinition);
    }

    @Override
    public ServiceStatus getRouteStatus(String key) {
        RouteService routeService = this.routeServices.get(key);
        if (routeService != null) {
            return routeService.getStatus();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startRoute(RouteDefinition route) throws Exception {
        RouteDefinitionHelper.forceAssignIds((CamelContext)this, this.routeDefinitions);
        String duplicate = RouteDefinitionHelper.validateUniqueIds(route, this.routeDefinitions);
        if (duplicate != null) {
            throw new FailedToStartRouteException(route.getId(), "duplicate id detected: " + duplicate + ". Please correct ids to be unique among all your routes.");
        }
        this.isStartingRoutes.set(true);
        try {
            route.prepare(this);
            ArrayList<Route> routes = new ArrayList<Route>();
            List<RouteContext> routeContexts = route.addRoutes(this, routes);
            RouteService routeService = new RouteService(this, route, routeContexts, routes);
            this.startRouteService(routeService, true);
        }
        finally {
            this.isStartingRoutes.remove();
        }
    }

    @Override
    public boolean isStartingRoutes() {
        Boolean answer = this.isStartingRoutes.get();
        return answer != null && answer != false;
    }

    @Override
    public boolean isSetupRoutes() {
        Boolean answer = this.isSetupRoutes.get();
        return answer != null && answer != false;
    }

    @Override
    public void stopRoute(RouteDefinition route) throws Exception {
        this.stopRoute(route.idOrCreate(this.nodeIdFactory));
    }

    @Override
    public void startAllRoutes() throws Exception {
        this.doStartOrResumeRoutes(this.routeServices, true, true, false, false);
    }

    @Override
    public synchronized void startRoute(String routeId) throws Exception {
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            this.startRouteService(routeService, false);
        }
    }

    @Override
    public synchronized void resumeRoute(String routeId) throws Exception {
        if (!this.routeSupportsSuspension(routeId)) {
            this.startRoute(routeId);
            return;
        }
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            this.resumeRouteService(routeService);
            Route route = this.getRoute(routeId);
            ServiceHelper.resumeService(route);
        }
    }

    @Override
    public synchronized boolean stopRoute(String routeId, long timeout, TimeUnit timeUnit, boolean abortAfterTimeout) throws Exception {
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            DefaultRouteStartupOrder route = new DefaultRouteStartupOrder(1, routeService.getRoutes().iterator().next(), routeService);
            boolean completed = this.getShutdownStrategy().shutdown(this, route, timeout, timeUnit, abortAfterTimeout);
            if (completed) {
                this.stopRouteService(routeService, false);
            } else {
                this.startRouteService(routeService, false);
            }
            return completed;
        }
        return false;
    }

    @Override
    public synchronized void stopRoute(String routeId) throws Exception {
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            ArrayList<RouteStartupOrder> routes = new ArrayList<RouteStartupOrder>(1);
            DefaultRouteStartupOrder order = new DefaultRouteStartupOrder(1, routeService.getRoutes().iterator().next(), routeService);
            routes.add(order);
            this.getShutdownStrategy().shutdown(this, routes);
            this.stopRouteService(routeService, false);
        }
    }

    @Override
    public synchronized void stopRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            ArrayList<RouteStartupOrder> routes = new ArrayList<RouteStartupOrder>(1);
            DefaultRouteStartupOrder order = new DefaultRouteStartupOrder(1, routeService.getRoutes().iterator().next(), routeService);
            routes.add(order);
            this.getShutdownStrategy().shutdown(this, routes, timeout, timeUnit);
            this.stopRouteService(routeService, false);
        }
    }

    @Override
    public synchronized void shutdownRoute(String routeId) throws Exception {
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            ArrayList<RouteStartupOrder> routes = new ArrayList<RouteStartupOrder>(1);
            DefaultRouteStartupOrder order = new DefaultRouteStartupOrder(1, routeService.getRoutes().iterator().next(), routeService);
            routes.add(order);
            this.getShutdownStrategy().shutdown(this, routes);
            this.stopRouteService(routeService, true);
        }
    }

    @Override
    public synchronized void shutdownRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            ArrayList<RouteStartupOrder> routes = new ArrayList<RouteStartupOrder>(1);
            DefaultRouteStartupOrder order = new DefaultRouteStartupOrder(1, routeService.getRoutes().iterator().next(), routeService);
            routes.add(order);
            this.getShutdownStrategy().shutdown(this, routes, timeout, timeUnit);
            this.stopRouteService(routeService, true);
        }
    }

    @Override
    public synchronized boolean removeRoute(String routeId) throws Exception {
        if (this.getErrorHandlerBuilder() instanceof ErrorHandlerBuilderSupport) {
            ErrorHandlerBuilderSupport builder = (ErrorHandlerBuilderSupport)this.getErrorHandlerBuilder();
            builder.removeOnExceptionList(routeId);
        }
        HashMap<String, Set<Endpoint>> endpointsInUse = new HashMap<String, Set<Endpoint>>();
        for (Map.Entry<String, RouteService> entry : this.routeServices.entrySet()) {
            endpointsInUse.put(entry.getKey(), entry.getValue().gatherEndpoints());
        }
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            if (this.getRouteStatus(routeId).isStopped()) {
                routeService.setRemovingRoutes(true);
                this.shutdownRouteService(routeService);
                this.removeRouteDefinition(routeId);
                this.routeServices.remove(routeId);
                Iterator<RouteStartupOrder> it = this.routeStartupOrder.iterator();
                while (it.hasNext()) {
                    RouteStartupOrder order = it.next();
                    if (!order.getRoute().getId().equals(routeId)) continue;
                    it.remove();
                }
                LinkedHashSet<Endpoint> toRemove = new LinkedHashSet<Endpoint>();
                for (Endpoint endpoint : (Set)endpointsInUse.get(routeId)) {
                    int count = 0;
                    for (Set endpoints : endpointsInUse.values()) {
                        if (!endpoints.contains(endpoint)) continue;
                        ++count;
                    }
                    if (count > true) continue;
                    toRemove.add(endpoint);
                }
                for (Endpoint endpoint : toRemove) {
                    this.log.debug("Removing: {} which was only in use by route: {}", (Object)endpoint, (Object)routeId);
                    this.removeEndpoint(endpoint);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public synchronized void suspendRoute(String routeId) throws Exception {
        if (!this.routeSupportsSuspension(routeId)) {
            this.stopRoute(routeId);
            return;
        }
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            ArrayList<RouteStartupOrder> routes = new ArrayList<RouteStartupOrder>(1);
            Route route = routeService.getRoutes().iterator().next();
            DefaultRouteStartupOrder order = new DefaultRouteStartupOrder(1, route, routeService);
            routes.add(order);
            this.getShutdownStrategy().suspend(this, routes);
            this.suspendRouteService(routeService);
            ServiceHelper.suspendService(route);
        }
    }

    @Override
    public synchronized void suspendRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        if (!this.routeSupportsSuspension(routeId)) {
            this.stopRoute(routeId, timeout, timeUnit);
            return;
        }
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            ArrayList<RouteStartupOrder> routes = new ArrayList<RouteStartupOrder>(1);
            Route route = routeService.getRoutes().iterator().next();
            DefaultRouteStartupOrder order = new DefaultRouteStartupOrder(1, route, routeService);
            routes.add(order);
            this.getShutdownStrategy().suspend(this, routes, timeout, timeUnit);
            this.suspendRouteService(routeService);
            ServiceHelper.suspendService(route);
        }
    }

    @Override
    public void addService(Object object) throws Exception {
        this.addService(object, true);
    }

    @Override
    public void addService(Object object, boolean stopOnShutdown) throws Exception {
        this.doAddService(object, stopOnShutdown);
    }

    private void doAddService(Object object, boolean stopOnShutdown) throws Exception {
        if (object instanceof CamelContextAware) {
            CamelContextAware aware = (CamelContextAware)object;
            aware.setCamelContext(this);
        }
        if (object instanceof Service) {
            Service service = (Service)object;
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                if (service instanceof Endpoint) {
                    strategy.onEndpointAdd((Endpoint)service);
                    continue;
                }
                strategy.onServiceAdd(this, service, null);
            }
            boolean singleton = true;
            if (service instanceof IsSingleton) {
                singleton = ((IsSingleton)((Object)service)).isSingleton();
            }
            if (singleton && !(service instanceof Endpoint) && stopOnShutdown && !this.hasService(service)) {
                this.servicesToStop.add(service);
            }
        }
        if (object instanceof Service) {
            this.startService((Service)object);
        } else if (object instanceof Collection) {
            this.startServices((Collection)object);
        }
    }

    @Override
    public boolean removeService(Object object) throws Exception {
        if (object instanceof Endpoint) {
            this.removeEndpoint((Endpoint)object);
            return true;
        }
        if (object instanceof Service) {
            Service service = (Service)object;
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onServiceRemove(this, service, null);
            }
            return this.servicesToStop.remove(service);
        }
        return false;
    }

    @Override
    public boolean hasService(Object object) {
        if (object instanceof Service) {
            Service service = (Service)object;
            return this.servicesToStop.contains(service);
        }
        return false;
    }

    @Override
    public <T> T hasService(Class<T> type) {
        for (Service service : this.servicesToStop) {
            if (!type.isInstance(service)) continue;
            return type.cast(service);
        }
        return null;
    }

    @Override
    public void deferStartService(Object object, boolean stopOnShutdown) throws Exception {
        if (object instanceof Service) {
            Service service = (Service)object;
            boolean singleton = true;
            if (object instanceof IsSingleton) {
                singleton = ((IsSingleton)((Object)service)).isSingleton();
            }
            if (singleton && !(service instanceof Endpoint) && stopOnShutdown && !this.hasService(service)) {
                this.servicesToStop.add(service);
            }
            if (this.isStarted()) {
                ServiceHelper.startService(service);
            } else {
                this.deferStartupListener.addService(service);
            }
        }
    }

    @Override
    public void addStartupListener(StartupListener listener) throws Exception {
        if (this.isStarted()) {
            listener.onCamelContextStarted(this, true);
        } else {
            this.startupListeners.add(listener);
        }
    }

    @Override
    public String resolveComponentDefaultName(String javaType) {
        if ("org.apache.activemq.camel.component.ActiveMQComponent".equals(javaType)) {
            return "jms";
        }
        if (javaType != null) {
            try {
                SortedMap<String, Properties> all = CamelContextHelper.findComponents(this);
                for (Map.Entry entry : all.entrySet()) {
                    String name;
                    String json;
                    String fqn = (String)((Properties)entry.getValue()).get("class");
                    if (!javaType.equals(fqn) || (json = this.getComponentParameterJsonSchema(name = (String)entry.getKey())) == null) continue;
                    return name;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Map<String, Properties> findComponents() throws LoadPropertiesException, IOException {
        return CamelContextHelper.findComponents(this);
    }

    @Override
    public Map<String, Properties> findEips() throws LoadPropertiesException, IOException {
        return CamelContextHelper.findEips(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getComponentDocumentation(String componentName) throws IOException {
        FactoryFinder finder = this.getFactoryFinder("META-INF/services/org/apache/camel/component/");
        try {
            Class<?> clazz = finder.findClass(componentName);
            if (clazz == null) {
                Component existing = this.hasComponent(componentName);
                if (existing == null) return null;
                clazz = existing.getClass();
            }
            String packageName = clazz.getPackage().getName();
            packageName = packageName.replace('.', '/');
            String path = packageName + "/" + componentName + ".html";
            ClassResolver resolver = this.getClassResolver();
            InputStream inputStream = resolver.loadResourceAsStream(path);
            this.log.debug("Loading component documentation for: {} using class resolver: {} -> {}", componentName, resolver, inputStream);
            if (inputStream == null) {
                if (!"ActiveMQComponent".equals(clazz.getSimpleName())) return null;
                return this.getComponentDocumentation("jms");
            }
            try {
                String string = IOHelper.loadText(inputStream);
                return string;
            }
            finally {
                IOHelper.close((Closeable)inputStream);
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getComponentParameterJsonSchema(String componentName) throws IOException {
        FactoryFinder finder = this.getFactoryFinder("META-INF/services/org/apache/camel/component/");
        try {
            Class<?> clazz = finder.findClass(componentName);
            if (clazz == null) {
                Component existing = this.hasComponent(componentName);
                if (existing == null) return null;
                clazz = existing.getClass();
            }
            String packageName = clazz.getPackage().getName();
            packageName = packageName.replace('.', '/');
            String path = packageName + "/" + componentName + ".json";
            ClassResolver resolver = this.getClassResolver();
            InputStream inputStream = resolver.loadResourceAsStream(path);
            this.log.debug("Loading component JSON Schema for: {} using class resolver: {} -> {}", componentName, resolver, inputStream);
            if (inputStream == null) {
                if (!"ActiveMQComponent".equals(clazz.getSimpleName())) return null;
                return this.getComponentParameterJsonSchema("jms");
            }
            try {
                String string = IOHelper.loadText(inputStream);
                return string;
            }
            finally {
                IOHelper.close((Closeable)inputStream);
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getDataFormatParameterJsonSchema(String dataFormatName) throws IOException {
        String string;
        FactoryFinder finder = this.getFactoryFinder("META-INF/services/org/apache/camel/dataformat/");
        Class<?> clazz = finder.findClass(dataFormatName);
        if (clazz == null) {
            return null;
        }
        String packageName = clazz.getPackage().getName();
        packageName = packageName.replace('.', '/');
        String path = packageName + "/" + dataFormatName + ".json";
        ClassResolver resolver = this.getClassResolver();
        InputStream inputStream = resolver.loadResourceAsStream(path);
        this.log.debug("Loading dataformat JSON Schema for: {} using class resolver: {} -> {}", dataFormatName, resolver, inputStream);
        if (inputStream == null) return null;
        try {
            string = IOHelper.loadText(inputStream);
        }
        catch (Throwable throwable) {
            try {
                IOHelper.close((Closeable)inputStream);
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        IOHelper.close((Closeable)inputStream);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getLanguageParameterJsonSchema(String languageName) throws IOException {
        String string;
        FactoryFinder finder = this.getFactoryFinder("META-INF/services/org/apache/camel/language/");
        Class<?> clazz = finder.findClass(languageName);
        if (clazz == null) {
            return null;
        }
        String packageName = clazz.getPackage().getName();
        packageName = packageName.replace('.', '/');
        String path = packageName + "/" + languageName + ".json";
        ClassResolver resolver = this.getClassResolver();
        InputStream inputStream = resolver.loadResourceAsStream(path);
        this.log.debug("Loading language JSON Schema for: {} using class resolver: {} -> {}", languageName, resolver, inputStream);
        if (inputStream == null) return null;
        try {
            string = IOHelper.loadText(inputStream);
        }
        catch (Throwable throwable) {
            try {
                IOHelper.close((Closeable)inputStream);
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        IOHelper.close((Closeable)inputStream);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEipParameterJsonSchema(String eipName) throws IOException {
        String[] subPackages;
        for (String sub : subPackages = new String[]{"", "/config", "/dataformat", "/language", "/loadbalancer", "/rest"}) {
            String path = "org/apache/camel/model/" + sub + "/" + eipName + ".json";
            ClassResolver resolver = this.getClassResolver();
            InputStream inputStream = resolver.loadResourceAsStream(path);
            if (inputStream == null) continue;
            this.log.debug("Loading eip JSON Schema for: {} using class resolver: {} -> {}", eipName, resolver, inputStream);
            try {
                String string = IOHelper.loadText(inputStream);
                return string;
            }
            finally {
                IOHelper.close((Closeable)inputStream);
            }
        }
        return null;
    }

    @Override
    public String explainEipJson(String nameOrId, boolean includeAllOptions) {
        try {
            String json;
            String eipName = nameOrId;
            NamedNode target = null;
            for (RouteDefinition route : this.getRouteDefinitions()) {
                if (route.getId().equals(nameOrId)) {
                    target = route;
                    break;
                }
                for (FromDefinition from : route.getInputs()) {
                    if (!nameOrId.equals(from.getId())) continue;
                    target = route;
                    break;
                }
                Iterator<ProcessorDefinition> it = ProcessorDefinitionHelper.filterTypeInOutputs(route.getOutputs(), ProcessorDefinition.class);
                while (it.hasNext()) {
                    ProcessorDefinition def = it.next();
                    if (!nameOrId.equals(def.getId())) continue;
                    target = def;
                    break;
                }
                if (target == null) continue;
                break;
            }
            if (target != null) {
                eipName = target.getShortName();
            }
            if ((json = this.getEipParameterJsonSchema(eipName)) == null) {
                return null;
            }
            if (target != null) {
                String deprecated;
                String javaType;
                String type;
                List<Map<String, String>> rows = JsonSchemaHelper.parseJsonSchema("properties", json, true);
                LinkedHashMap<String, String[]> selected = new LinkedHashMap<String, String[]>();
                LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
                IntrospectionSupport.getProperties(target, options, "", false);
                options.remove("outputs");
                for (Map<String, String> row : rows) {
                    String name = row.get("name");
                    String kind = row.get("kind");
                    String label = row.get("label");
                    String required = row.get("required");
                    String value = row.get("value");
                    String defaultValue = row.get("defaultValue");
                    type = row.get("type");
                    javaType = row.get("javaType");
                    deprecated = row.get("deprecated");
                    String description = row.get("description");
                    Object o = options.get(name);
                    if (o != null) {
                        value = o.toString();
                    }
                    value = URISupport.sanitizePath(value);
                    if (!includeAllOptions && o == null || selected.containsKey(name)) continue;
                    selected.put(name, new String[]{name, kind, label, required, type, javaType, deprecated, value, defaultValue, description});
                }
                json = ObjectHelper.before(json, "  \"properties\": {");
                StringBuilder buffer = new StringBuilder("  \"properties\": {");
                boolean first = true;
                for (String[] row : selected.values()) {
                    if (first) {
                        first = false;
                    } else {
                        buffer.append(",");
                    }
                    buffer.append("\n    ");
                    String name = row[0];
                    String kind = row[1];
                    String label = row[2];
                    String required = row[3];
                    type = row[4];
                    javaType = row[5];
                    deprecated = row[6];
                    String value = row[7];
                    String defaultValue = row[8];
                    String description = row[9];
                    buffer.append(StringQuoteHelper.doubleQuote(name)).append(": { ");
                    CollectionStringBuffer csb = new CollectionStringBuffer();
                    if (kind != null) {
                        csb.append("\"kind\": \"" + kind + "\"");
                    }
                    if (label != null) {
                        csb.append("\"label\": \"" + label + "\"");
                    }
                    if (required != null) {
                        csb.append("\"required\": \"" + required + "\"");
                    }
                    if (type != null) {
                        csb.append("\"type\": \"" + type + "\"");
                    }
                    if (javaType != null) {
                        csb.append("\"javaType\": \"" + javaType + "\"");
                    }
                    if (deprecated != null) {
                        csb.append("\"deprecated\": \"" + deprecated + "\"");
                    }
                    if (value != null) {
                        csb.append("\"value\": \"" + value + "\"");
                    }
                    if (defaultValue != null) {
                        csb.append("\"defaultValue\": \"" + defaultValue + "\"");
                    }
                    if (description != null) {
                        csb.append("\"description\": \"" + description + "\"");
                    }
                    if (!csb.isEmpty()) {
                        buffer.append(csb.toString());
                    }
                    buffer.append(" }");
                }
                buffer.append("\n  }\n}\n");
                buffer.insert(0, json);
                return buffer.toString();
            }
            return json;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String explainDataFormatJson(String dataFormatName, DataFormat dataFormat, boolean includeAllOptions) {
        try {
            String deprecated;
            String javaType;
            String type;
            String description;
            String required;
            String label;
            String kind;
            String name;
            String json = this.getDataFormatParameterJsonSchema(dataFormatName);
            if (json == null) {
                if (dataFormatName.contains("-")) {
                    dataFormatName = ObjectHelper.before(dataFormatName, "-");
                    json = this.getDataFormatParameterJsonSchema(dataFormatName);
                }
                if (json == null) {
                    return null;
                }
            }
            List<Map<String, String>> rows = JsonSchemaHelper.parseJsonSchema("properties", json, true);
            LinkedHashMap<String, Object> selected = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, String[]> dataFormatOptions = new LinkedHashMap<String, String[]>();
            LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
            IntrospectionSupport.getProperties(dataFormat, options, "", false);
            for (Map.Entry entry : options.entrySet()) {
                name = (String)entry.getKey();
                String value = "";
                if (entry.getValue() != null) {
                    value = entry.getValue().toString();
                }
                value = URISupport.sanitizePath(value);
                String type2 = null;
                kind = null;
                label = null;
                required = null;
                String javaType2 = null;
                String deprecated2 = null;
                String defaultValue = null;
                description = null;
                for (Map<String, String> row : rows) {
                    if (!name.equals(row.get("name"))) continue;
                    type2 = row.get("type");
                    kind = row.get("kind");
                    label = row.get("label");
                    required = row.get("required");
                    javaType2 = row.get("javaType");
                    deprecated2 = row.get("deprecated");
                    defaultValue = row.get("defaultValue");
                    description = row.get("description");
                    break;
                }
                dataFormatOptions.put(name, new String[]{name, kind, label, required, type2, javaType2, deprecated2, value, defaultValue, description});
            }
            for (Map map : rows) {
                name = (String)map.get("name");
                String kind2 = (String)map.get("kind");
                String label2 = (String)map.get("label");
                String required2 = (String)map.get("required");
                String value = (String)map.get("value");
                String defaultValue = (String)map.get("defaultValue");
                type = (String)map.get("type");
                javaType = (String)map.get("javaType");
                deprecated = (String)map.get("deprecated");
                value = URISupport.sanitizePath(value);
                description = (String)map.get("description");
                boolean isDataFormatOption = dataFormatOptions.containsKey(name);
                if (!includeAllOptions && !isDataFormatOption || selected.containsKey(name)) continue;
                if (isDataFormatOption) {
                    selected.put(name, dataFormatOptions.get(name));
                    continue;
                }
                selected.put(name, new String[]{name, kind2, label2, required2, type, javaType, deprecated, value, defaultValue, description});
            }
            json = ObjectHelper.before(json, "  \"properties\": {");
            StringBuilder buffer = new StringBuilder("  \"properties\": {");
            boolean bl = true;
            for (String[] row : selected.values()) {
                boolean bl2;
                if (bl2) {
                    bl2 = false;
                } else {
                    buffer.append(",");
                }
                buffer.append("\n    ");
                String name2 = row[0];
                kind = row[1];
                label = row[2];
                required = row[3];
                type = row[4];
                javaType = row[5];
                deprecated = row[6];
                String value = row[7];
                String defaultValue = row[8];
                String description2 = row[9];
                buffer.append(StringQuoteHelper.doubleQuote(name2)).append(": { ");
                CollectionStringBuffer csb = new CollectionStringBuffer();
                if (kind != null) {
                    csb.append("\"kind\": \"" + kind + "\"");
                }
                if (label != null) {
                    csb.append("\"label\": \"" + label + "\"");
                }
                if (required != null) {
                    csb.append("\"required\": \"" + required + "\"");
                }
                if (type != null) {
                    csb.append("\"type\": \"" + type + "\"");
                }
                if (javaType != null) {
                    csb.append("\"javaType\": \"" + javaType + "\"");
                }
                if (deprecated != null) {
                    csb.append("\"deprecated\": \"" + deprecated + "\"");
                }
                if (value != null) {
                    csb.append("\"value\": \"" + value + "\"");
                }
                if (defaultValue != null) {
                    csb.append("\"defaultValue\": \"" + defaultValue + "\"");
                }
                if (description2 != null) {
                    csb.append("\"description\": \"" + description2 + "\"");
                }
                if (!csb.isEmpty()) {
                    buffer.append(csb.toString());
                }
                buffer.append(" }");
            }
            buffer.append("\n  }\n}\n");
            buffer.insert(0, json);
            return buffer.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String explainComponentJson(String componentName, boolean includeAllOptions) {
        try {
            String deprecated;
            String javaType;
            String type;
            String description;
            String required;
            String label;
            String group;
            String kind;
            String name;
            String json = this.getComponentParameterJsonSchema(componentName);
            if (json == null) {
                return null;
            }
            List<Map<String, String>> rows = JsonSchemaHelper.parseJsonSchema("componentProperties", json, true);
            LinkedHashMap<String, String[]> selected = new LinkedHashMap<String, String[]>();
            Component component = this.getComponent(componentName);
            HashMap<String, Object> options = new HashMap<String, Object>();
            IntrospectionSupport.getProperties(component, options, null);
            for (Map.Entry entry : options.entrySet()) {
                name = (String)entry.getKey();
                if ("camelContext".equals(name) || "endpointClass".equals(name)) continue;
                String value = "";
                if (entry.getValue() != null) {
                    value = entry.getValue().toString();
                }
                value = URISupport.sanitizePath(value);
                String type2 = null;
                kind = null;
                group = null;
                label = null;
                required = null;
                String javaType2 = null;
                String deprecated2 = null;
                String defaultValue = null;
                description = null;
                for (Map<String, String> row : rows) {
                    if (!name.equals(row.get("name"))) continue;
                    type2 = row.get("type");
                    kind = row.get("kind");
                    group = row.get("group");
                    label = row.get("label");
                    required = row.get("required");
                    javaType2 = row.get("javaType");
                    deprecated2 = row.get("deprecated");
                    defaultValue = row.get("defaultValue");
                    description = row.get("description");
                    break;
                }
                selected.put(name, new String[]{name, kind, group, label, required, type2, javaType2, deprecated2, value, defaultValue, description});
            }
            for (Map map : rows) {
                name = (String)map.get("name");
                String kind2 = (String)map.get("kind");
                String group2 = (String)map.get("group");
                String label2 = (String)map.get("label");
                String required2 = (String)map.get("required");
                String value = (String)map.get("value");
                String defaultValue = (String)map.get("defaultValue");
                type = (String)map.get("type");
                javaType = (String)map.get("javaType");
                deprecated = (String)map.get("deprecated");
                value = URISupport.sanitizePath(value);
                description = (String)map.get("description");
                if (!includeAllOptions || selected.containsKey(name)) continue;
                selected.put(name, new String[]{name, kind2, group2, label2, required2, type, javaType, deprecated, value, defaultValue, description});
            }
            json = ObjectHelper.before(json, "  \"componentProperties\": {");
            StringBuilder buffer = new StringBuilder("  \"componentProperties\": {");
            boolean bl = true;
            for (String[] row : selected.values()) {
                boolean bl2;
                if (bl2) {
                    bl2 = false;
                } else {
                    buffer.append(",");
                }
                buffer.append("\n    ");
                String name2 = row[0];
                kind = row[1];
                group = row[2];
                label = row[3];
                required = row[4];
                type = row[5];
                javaType = row[6];
                deprecated = row[7];
                String value = row[8];
                String defaultValue = row[9];
                String description2 = row[10];
                buffer.append(StringQuoteHelper.doubleQuote(name2)).append(": { ");
                CollectionStringBuffer csb = new CollectionStringBuffer();
                if (kind != null) {
                    csb.append("\"kind\": \"" + kind + "\"");
                }
                if (group != null) {
                    csb.append("\"group\": \"" + group + "\"");
                }
                if (label != null) {
                    csb.append("\"label\": \"" + label + "\"");
                }
                if (required != null) {
                    csb.append("\"required\": \"" + required + "\"");
                }
                if (type != null) {
                    csb.append("\"type\": \"" + type + "\"");
                }
                if (javaType != null) {
                    csb.append("\"javaType\": \"" + javaType + "\"");
                }
                if (deprecated != null) {
                    csb.append("\"deprecated\": \"" + deprecated + "\"");
                }
                if (value != null) {
                    csb.append("\"value\": \"" + value + "\"");
                }
                if (defaultValue != null) {
                    csb.append("\"defaultValue\": \"" + defaultValue + "\"");
                }
                if (description2 != null) {
                    csb.append("\"description\": \"" + description2 + "\"");
                }
                if (!csb.isEmpty()) {
                    buffer.append(csb.toString());
                }
                buffer.append(" }");
            }
            buffer.append("\n  }\n}\n");
            buffer.insert(0, json);
            return buffer.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String explainEndpointJson(String uri, boolean includeAllOptions) {
        try {
            String deprecated;
            String javaType;
            String type;
            String description;
            String required;
            String label;
            String group;
            String kind;
            String name;
            URI u = new URI(uri);
            String json = this.getComponentParameterJsonSchema(u.getScheme());
            if (json == null) {
                return null;
            }
            List<Map<String, String>> rows = JsonSchemaHelper.parseJsonSchema("properties", json, true);
            LinkedHashMap<String, Object> selected = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, String[]> uriOptions = new LinkedHashMap<String, String[]>();
            Map<String, Object> options = EndpointHelper.endpointProperties(this, uri);
            Map<String, Object> consumerOptions = IntrospectionSupport.extractProperties(options, "consumer.");
            options.putAll(consumerOptions);
            for (Map.Entry<String, Object> entry : options.entrySet()) {
                name = entry.getKey();
                String value = "";
                if (entry.getValue() != null) {
                    value = entry.getValue().toString();
                }
                value = URISupport.sanitizePath(value);
                String type2 = null;
                kind = null;
                group = null;
                label = null;
                required = null;
                String javaType2 = null;
                String deprecated2 = null;
                String defaultValue = null;
                description = null;
                for (Map<String, String> row : rows) {
                    if (!name.equals(row.get("name"))) continue;
                    type2 = row.get("type");
                    kind = row.get("kind");
                    group = row.get("group");
                    label = row.get("label");
                    required = row.get("required");
                    javaType2 = row.get("javaType");
                    deprecated2 = row.get("deprecated");
                    defaultValue = row.get("defaultValue");
                    description = row.get("description");
                    break;
                }
                uriOptions.put(name, new String[]{name, kind, group, label, required, type2, javaType2, deprecated2, value, defaultValue, description});
            }
            for (Map map : rows) {
                name = (String)map.get("name");
                String kind2 = (String)map.get("kind");
                String group2 = (String)map.get("group");
                String label2 = (String)map.get("label");
                String required2 = (String)map.get("required");
                String value = (String)map.get("value");
                String defaultValue = (String)map.get("defaultValue");
                type = (String)map.get("type");
                javaType = (String)map.get("javaType");
                deprecated = (String)map.get("deprecated");
                value = URISupport.sanitizePath(value);
                description = (String)map.get("description");
                boolean isUriOption = uriOptions.containsKey(name);
                if (!includeAllOptions && !isUriOption && !"path".equals(kind2) || selected.containsKey(name)) continue;
                if (isUriOption) {
                    selected.put(name, uriOptions.get(name));
                    continue;
                }
                selected.put(name, new String[]{name, kind2, group2, label2, required2, type, javaType, deprecated, value, defaultValue, description});
            }
            json = ObjectHelper.before(json, "  \"componentProperties\": {");
            StringBuilder buffer = new StringBuilder("  \"properties\": {");
            boolean bl = true;
            for (String[] row : selected.values()) {
                boolean bl2;
                if (bl2) {
                    bl2 = false;
                } else {
                    buffer.append(",");
                }
                buffer.append("\n    ");
                String name2 = row[0];
                kind = row[1];
                group = row[2];
                label = row[3];
                required = row[4];
                type = row[5];
                javaType = row[6];
                deprecated = row[7];
                String value = row[8];
                String defaultValue = row[9];
                String description2 = row[10];
                buffer.append(StringQuoteHelper.doubleQuote(name2)).append(": { ");
                CollectionStringBuffer csb = new CollectionStringBuffer();
                if (kind != null) {
                    csb.append("\"kind\": \"" + kind + "\"");
                }
                if (group != null) {
                    csb.append("\"group\": \"" + group + "\"");
                }
                if (label != null) {
                    csb.append("\"label\": \"" + label + "\"");
                }
                if (required != null) {
                    csb.append("\"required\": \"" + required + "\"");
                }
                if (type != null) {
                    csb.append("\"type\": \"" + type + "\"");
                }
                if (javaType != null) {
                    csb.append("\"javaType\": \"" + javaType + "\"");
                }
                if (deprecated != null) {
                    csb.append("\"deprecated\": \"" + deprecated + "\"");
                }
                if (value != null) {
                    csb.append("\"value\": \"" + value + "\"");
                }
                if (defaultValue != null) {
                    csb.append("\"defaultValue\": \"" + defaultValue + "\"");
                }
                if (description2 != null) {
                    csb.append("\"description\": \"" + description2 + "\"");
                }
                if (!csb.isEmpty()) {
                    buffer.append(csb.toString());
                }
                buffer.append(" }");
            }
            buffer.append("\n  }\n}\n");
            buffer.insert(0, json);
            return buffer.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String createRouteStaticEndpointJson(String routeId) {
        return this.createRouteStaticEndpointJson(routeId, true);
    }

    @Override
    public String createRouteStaticEndpointJson(String routeId, boolean includeDynamic) {
        ArrayList<RouteDefinition> routes = new ArrayList<RouteDefinition>();
        if (routeId != null) {
            RouteDefinition route = this.getRouteDefinition(routeId);
            if (route == null) {
                throw new IllegalArgumentException("Route with id " + routeId + " does not exist");
            }
            routes.add(route);
        } else {
            routes.addAll(this.getRouteDefinitions());
        }
        StringBuilder buffer = new StringBuilder("{\n  \"routes\": {");
        boolean firstRoute = true;
        for (RouteDefinition route : routes) {
            if (!firstRoute) {
                buffer.append("\n    },");
            } else {
                firstRoute = false;
            }
            String id = route.getId();
            buffer.append("\n    \"").append(id).append("\": {");
            buffer.append("\n      \"inputs\": [");
            Set<String> inputs = RouteDefinitionHelper.gatherAllStaticEndpointUris(this, route, true, false);
            boolean first = true;
            for (String input : inputs) {
                if (!first) {
                    buffer.append(",");
                } else {
                    first = false;
                }
                buffer.append("\n        ");
                buffer.append(StringHelper.toJson("uri", input, true));
            }
            buffer.append("\n      ]");
            buffer.append(",");
            buffer.append("\n      \"outputs\": [");
            Set<String> outputs = RouteDefinitionHelper.gatherAllEndpointUris(this, route, false, true, includeDynamic);
            first = true;
            for (String output : outputs) {
                if (!first) {
                    buffer.append(",");
                } else {
                    first = false;
                }
                buffer.append("\n        ");
                buffer.append(StringHelper.toJson("uri", output, true));
            }
            buffer.append("\n      ]");
        }
        if (!firstRoute) {
            buffer.append("\n    }");
        }
        buffer.append("\n  }\n}\n");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Language resolveLanguage(String language) {
        Language answer;
        Map<String, Language> map = this.languages;
        synchronized (map) {
            boolean singleton;
            answer = this.languages.get(language);
            if (answer instanceof IsSingleton && (singleton = ((IsSingleton)((Object)answer)).isSingleton())) {
                return answer;
            }
            answer = this.getLanguageResolver().resolveLanguage(language, this);
            if (answer != null) {
                if (answer instanceof CamelContextAware) {
                    ((CamelContextAware)((Object)answer)).setCamelContext(this);
                }
                if (answer instanceof Service) {
                    try {
                        this.startService((Service)((Object)answer));
                    }
                    catch (Exception e) {
                        throw ObjectHelper.wrapRuntimeCamelException(e);
                    }
                }
                this.languages.put(language, answer);
            }
        }
        return answer;
    }

    @Override
    public String getPropertyPrefixToken() {
        PropertiesComponent pc = this.getPropertiesComponent();
        if (pc != null) {
            return pc.getPrefixToken();
        }
        return null;
    }

    @Override
    public String getPropertySuffixToken() {
        PropertiesComponent pc = this.getPropertiesComponent();
        if (pc != null) {
            return pc.getSuffixToken();
        }
        return null;
    }

    @Override
    public String resolvePropertyPlaceholders(String text) throws Exception {
        PropertiesComponent pc = this.getPropertiesComponent();
        if (text != null && !text.startsWith("properties:")) {
            if (pc == null && text.contains("{{")) {
                pc = (PropertiesComponent)CamelContextHelper.lookupPropertiesComponent(this, true);
            }
            if (pc != null && text.contains(pc.getPrefixToken())) {
                String answer = pc.parseUri(text);
                this.log.debug("Resolved text: {} -> {}", (Object)text, (Object)answer);
                return answer;
            }
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeConverter getTypeConverter() {
        if (this.typeConverter == null) {
            DefaultCamelContext defaultCamelContext = this;
            synchronized (defaultCamelContext) {
                this.typeConverter = this.createTypeConverter();
                try {
                    this.addService(this.typeConverter);
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
            }
        }
        return this.typeConverter;
    }

    public void setTypeConverter(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
        try {
            this.addService(typeConverter);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public TypeConverterRegistry getTypeConverterRegistry() {
        if (this.typeConverterRegistry == null) {
            if (this.typeConverter == null) {
                this.getTypeConverter();
            }
            if (this.typeConverter instanceof TypeConverterRegistry) {
                this.typeConverterRegistry = (TypeConverterRegistry)((Object)this.typeConverter);
            }
        }
        return this.typeConverterRegistry;
    }

    public void setTypeConverterRegistry(TypeConverterRegistry typeConverterRegistry) {
        this.typeConverterRegistry = typeConverterRegistry;
    }

    @Override
    public Injector getInjector() {
        if (this.injector == null) {
            this.injector = this.createInjector();
        }
        return this.injector;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    @Override
    public ManagementMBeanAssembler getManagementMBeanAssembler() {
        return this.managementMBeanAssembler;
    }

    public void setManagementMBeanAssembler(ManagementMBeanAssembler managementMBeanAssembler) {
        this.managementMBeanAssembler = managementMBeanAssembler;
    }

    public ComponentResolver getComponentResolver() {
        if (this.componentResolver == null) {
            this.componentResolver = this.createComponentResolver();
        }
        return this.componentResolver;
    }

    public void setComponentResolver(ComponentResolver componentResolver) {
        this.componentResolver = componentResolver;
    }

    public LanguageResolver getLanguageResolver() {
        if (this.languageResolver == null) {
            this.languageResolver = new DefaultLanguageResolver();
        }
        return this.languageResolver;
    }

    public void setLanguageResolver(LanguageResolver languageResolver) {
        this.languageResolver = languageResolver;
    }

    public boolean isAutoCreateComponents() {
        return this.autoCreateComponents;
    }

    public void setAutoCreateComponents(boolean autoCreateComponents) {
        this.autoCreateComponents = autoCreateComponents;
    }

    @Override
    public Registry getRegistry() {
        if (this.registry == null) {
            this.registry = this.createRegistry();
            this.setRegistry(this.registry);
        }
        return this.registry;
    }

    @Override
    public <T> T getRegistry(Class<T> type) {
        Registry reg = this.getRegistry();
        if (reg instanceof PropertyPlaceholderDelegateRegistry) {
            reg = ((PropertyPlaceholderDelegateRegistry)reg).getRegistry();
        }
        if (type.isAssignableFrom(reg.getClass())) {
            return type.cast(reg);
        }
        if (reg instanceof CompositeRegistry) {
            List<Registry> list = ((CompositeRegistry)reg).getRegistryList();
            for (Registry r : list) {
                if (!type.isAssignableFrom(r.getClass())) continue;
                return type.cast(r);
            }
        }
        return null;
    }

    public void setJndiContext(Context jndiContext) {
        this.setRegistry(new JndiRegistry(jndiContext));
    }

    public void setRegistry(Registry registry) {
        if (!(registry instanceof PropertyPlaceholderDelegateRegistry)) {
            registry = new PropertyPlaceholderDelegateRegistry(this, registry);
        }
        this.registry = registry;
    }

    @Override
    public List<LifecycleStrategy> getLifecycleStrategies() {
        return this.lifecycleStrategies;
    }

    public void setLifecycleStrategies(List<LifecycleStrategy> lifecycleStrategies) {
        this.lifecycleStrategies = lifecycleStrategies;
    }

    @Override
    public void addLifecycleStrategy(LifecycleStrategy lifecycleStrategy) {
        this.lifecycleStrategies.add(lifecycleStrategy);
    }

    @Override
    public void setupRoutes(boolean done) {
        if (done) {
            this.isSetupRoutes.remove();
        } else {
            this.isSetupRoutes.set(true);
        }
    }

    @Override
    public synchronized List<RouteDefinition> getRouteDefinitions() {
        return this.routeDefinitions;
    }

    @Override
    public synchronized RouteDefinition getRouteDefinition(String id) {
        for (RouteDefinition route : this.routeDefinitions) {
            if (!route.idOrCreate(this.nodeIdFactory).equals(id)) continue;
            return route;
        }
        return null;
    }

    @Override
    public synchronized List<RestDefinition> getRestDefinitions() {
        return this.restDefinitions;
    }

    @Override
    public void addRestDefinitions(Collection<RestDefinition> restDefinitions) throws Exception {
        if (restDefinitions == null || restDefinitions.isEmpty()) {
            return;
        }
        this.restDefinitions.addAll(restDefinitions);
    }

    @Override
    public RestConfiguration getRestConfiguration() {
        RestConfiguration config = this.restConfigurations.get("");
        if (config == null) {
            config = new RestConfiguration();
            this.setRestConfiguration(config);
        }
        return config;
    }

    @Override
    public void setRestConfiguration(RestConfiguration restConfiguration) {
        this.restConfigurations.put("", restConfiguration);
    }

    @Override
    public Collection<RestConfiguration> getRestConfigurations() {
        return this.restConfigurations.values();
    }

    @Override
    public void addRestConfiguration(RestConfiguration restConfiguration) {
        this.restConfigurations.put(restConfiguration.getComponent(), restConfiguration);
    }

    @Override
    public RestConfiguration getRestConfiguration(String component, boolean defaultIfNotExist) {
        RestConfiguration config;
        if (component == null) {
            component = "";
        }
        if ((config = this.restConfigurations.get(component)) == null && defaultIfNotExist && (config = this.getRestConfiguration()) != null && config.getComponent() != null && !config.getComponent().equals(component)) {
            config = new RestConfiguration();
            this.restConfigurations.put(component, config);
        }
        return config;
    }

    @Override
    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptStrategies;
    }

    public void setInterceptStrategies(List<InterceptStrategy> interceptStrategies) {
        this.interceptStrategies = interceptStrategies;
    }

    @Override
    public void addInterceptStrategy(InterceptStrategy interceptStrategy) {
        this.getInterceptStrategies().add(interceptStrategy);
        if (interceptStrategy instanceof Tracer) {
            this.setTracing(true);
        } else if (interceptStrategy instanceof HandleFault) {
            this.setHandleFault(true);
        } else if (interceptStrategy instanceof StreamCaching) {
            this.setStreamCaching(true);
        } else if (interceptStrategy instanceof Delayer) {
            this.setDelayer(((Delayer)interceptStrategy).getDelay());
        }
    }

    @Override
    public List<RoutePolicyFactory> getRoutePolicyFactories() {
        return this.routePolicyFactories;
    }

    public void setRoutePolicyFactories(List<RoutePolicyFactory> routePolicyFactories) {
        this.routePolicyFactories = routePolicyFactories;
    }

    @Override
    public void addRoutePolicyFactory(RoutePolicyFactory routePolicyFactory) {
        this.getRoutePolicyFactories().add(routePolicyFactory);
    }

    @Override
    public void setStreamCaching(Boolean cache) {
        this.streamCache = cache;
    }

    @Override
    public Boolean isStreamCaching() {
        return this.streamCache;
    }

    @Override
    public void setTracing(Boolean tracing) {
        this.trace = tracing;
    }

    @Override
    public Boolean isTracing() {
        return this.trace;
    }

    @Override
    public Boolean isMessageHistory() {
        return this.messageHistory;
    }

    @Override
    public void setMessageHistory(Boolean messageHistory) {
        this.messageHistory = messageHistory;
    }

    @Override
    public Boolean isHandleFault() {
        return this.handleFault;
    }

    @Override
    public void setHandleFault(Boolean handleFault) {
        this.handleFault = handleFault;
    }

    @Override
    public Long getDelayer() {
        return this.delay;
    }

    @Override
    public void setDelayer(Long delay) {
        this.delay = delay;
    }

    @Override
    public ProducerTemplate createProducerTemplate() {
        int size2 = CamelContextHelper.getMaximumCachePoolSize(this);
        return this.createProducerTemplate(size2);
    }

    @Override
    public ProducerTemplate createProducerTemplate(int maximumCacheSize) {
        DefaultProducerTemplate answer = new DefaultProducerTemplate(this);
        answer.setMaximumCacheSize(maximumCacheSize);
        try {
            this.startService(answer);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        return answer;
    }

    @Override
    public ConsumerTemplate createConsumerTemplate() {
        int size2 = CamelContextHelper.getMaximumCachePoolSize(this);
        return this.createConsumerTemplate(size2);
    }

    @Override
    public ConsumerTemplate createConsumerTemplate(int maximumCacheSize) {
        DefaultConsumerTemplate answer = new DefaultConsumerTemplate(this);
        answer.setMaximumCacheSize(maximumCacheSize);
        try {
            this.startService(answer);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        return answer;
    }

    @Override
    public ErrorHandlerBuilder getErrorHandlerBuilder() {
        return (ErrorHandlerBuilder)this.errorHandlerBuilder;
    }

    @Override
    public void setErrorHandlerBuilder(ErrorHandlerFactory errorHandlerBuilder) {
        this.errorHandlerBuilder = errorHandlerBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledExecutorService getErrorHandlerExecutorService() {
        Object object = this.errorHandlerExecutorServiceLock;
        synchronized (object) {
            if (this.errorHandlerExecutorService == null) {
                this.errorHandlerExecutorService = this.getExecutorServiceManager().newDefaultScheduledThreadPool("ErrorHandlerRedeliveryThreadPool", "ErrorHandlerRedeliveryTask");
            }
        }
        return this.errorHandlerExecutorService;
    }

    @Override
    public void setProducerServicePool(ServicePool<Endpoint, Producer> producerServicePool) {
        this.producerServicePool = producerServicePool;
    }

    @Override
    public ServicePool<Endpoint, Producer> getProducerServicePool() {
        return this.producerServicePool;
    }

    @Override
    public ServicePool<Endpoint, PollingConsumer> getPollingConsumerServicePool() {
        return this.pollingConsumerServicePool;
    }

    @Override
    public void setPollingConsumerServicePool(ServicePool<Endpoint, PollingConsumer> pollingConsumerServicePool) {
        this.pollingConsumerServicePool = pollingConsumerServicePool;
    }

    @Override
    public UnitOfWorkFactory getUnitOfWorkFactory() {
        return this.unitOfWorkFactory;
    }

    @Override
    public void setUnitOfWorkFactory(UnitOfWorkFactory unitOfWorkFactory) {
        this.unitOfWorkFactory = unitOfWorkFactory;
    }

    @Override
    public RuntimeEndpointRegistry getRuntimeEndpointRegistry() {
        return this.runtimeEndpointRegistry;
    }

    @Override
    public void setRuntimeEndpointRegistry(RuntimeEndpointRegistry runtimeEndpointRegistry) {
        this.runtimeEndpointRegistry = runtimeEndpointRegistry;
    }

    @Override
    public String getUptime() {
        if (this.startDate == null) {
            return "";
        }
        long delta = new Date().getTime() - this.startDate.getTime();
        return TimeUtils.printDuration(delta);
    }

    @Override
    protected void doSuspend() throws Exception {
        EventHelper.notifyCamelContextSuspending(this);
        this.log.info("Apache Camel " + this.getVersion() + " (CamelContext: " + this.getName() + ") is suspending");
        StopWatch watch = new StopWatch();
        for (Map.Entry<String, RouteService> entry : this.getRouteServices().entrySet()) {
            if (!entry.getValue().getStatus().isStarted()) continue;
            this.suspendedRouteServices.put(entry.getKey(), entry.getValue());
        }
        ArrayList<RouteStartupOrder> orders = new ArrayList<RouteStartupOrder>();
        for (Map.Entry<String, RouteService> entry : this.suspendedRouteServices.entrySet()) {
            Route route = entry.getValue().getRoutes().iterator().next();
            Integer order = entry.getValue().getRouteDefinition().getStartupOrder();
            if (order == null) {
                order = this.defaultRouteStartupOrder++;
            }
            orders.add(new DefaultRouteStartupOrder(order, route, entry.getValue()));
        }
        this.getShutdownStrategy().suspend(this, orders);
        for (RouteService service : this.suspendedRouteServices.values()) {
            if (this.routeSupportsSuspension(service.getId())) {
                service.suspend();
                continue;
            }
            service.stop();
        }
        watch.stop();
        if (this.log.isInfoEnabled()) {
            this.log.info("Apache Camel " + this.getVersion() + " (CamelContext: " + this.getName() + ") is suspended in " + TimeUtils.printDuration(watch.taken()));
        }
        EventHelper.notifyCamelContextSuspended(this);
    }

    @Override
    protected void doResume() throws Exception {
        try {
            EventHelper.notifyCamelContextResuming(this);
            this.log.info("Apache Camel " + this.getVersion() + " (CamelContext: " + this.getName() + ") is resuming");
            StopWatch watch = new StopWatch();
            this.doStartOrResumeRoutes(this.suspendedRouteServices, false, true, true, false);
            for (RouteService service : this.suspendedRouteServices.values()) {
                if (this.routeSupportsSuspension(service.getId())) {
                    service.resume();
                    continue;
                }
                service.start();
            }
            watch.stop();
            if (this.log.isInfoEnabled()) {
                this.log.info("Resumed " + this.suspendedRouteServices.size() + " routes");
                this.log.info("Apache Camel " + this.getVersion() + " (CamelContext: " + this.getName() + ") resumed in " + TimeUtils.printDuration(watch.taken()));
            }
            this.suspendedRouteServices.clear();
            EventHelper.notifyCamelContextResumed(this);
        }
        catch (Exception e) {
            EventHelper.notifyCamelContextResumeFailed(this, e);
            throw e;
        }
    }

    @Override
    public void start() throws Exception {
        this.startDate = new Date();
        this.stopWatch.restart();
        this.log.info("Apache Camel " + this.getVersion() + " (CamelContext: " + this.getName() + ") is starting");
        Container.Instance.manage(this);
        boolean bl = this.doNotStartRoutesOnFirstStart = !this.firstStartDone && this.isAutoStartup() == false;
        if (this.firstStartDone && !this.isAutoStartup().booleanValue() && this.isStarted()) {
            this.doStartOrResumeRoutes(this.routeServices, true, true, false, true);
        }
        try {
            this.firstStartDone = true;
            super.start();
        }
        catch (VetoCamelContextStartException e) {
            if (e.isRethrowException()) {
                throw e;
            }
            this.log.info("CamelContext ({}) vetoed to not start due {}", (Object)this.getName(), (Object)e.getMessage());
            this.stop();
            return;
        }
        this.stopWatch.stop();
        if (this.log.isInfoEnabled()) {
            int started = 0;
            for (Route route : this.getRoutes()) {
                if (!this.getRouteStatus(route.getId()).isStarted()) continue;
                ++started;
            }
            this.log.info("Total " + this.getRoutes().size() + " routes, of which " + started + " is started.");
            this.log.info("Apache Camel " + this.getVersion() + " (CamelContext: " + this.getName() + ") started in " + TimeUtils.printDuration(this.stopWatch.taken()));
        }
        EventHelper.notifyCamelContextStarted(this);
    }

    @Override
    protected synchronized void doStart() throws Exception {
        this.doWithDefinedClassLoader(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    DefaultCamelContext.this.doStartCamel();
                    return null;
                }
                catch (Exception e) {
                    EventHelper.notifyCamelContextStartupFailed(DefaultCamelContext.this, e);
                    throw e;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doWithDefinedClassLoader(Callable<T> callable) throws Exception {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            if (this.applicationContextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(this.applicationContextClassLoader);
            }
            T t = callable.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private void doStartCamel() throws Exception {
        Component existing;
        ManagementStrategy managementStrategy;
        if (this.properties != null && !this.properties.isEmpty()) {
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                String replaced;
                String key = entry.getKey();
                String value = entry.getValue();
                if (value == null || value.equals(replaced = this.resolvePropertyPlaceholders(value))) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Camel property with key {} replaced value from {} -> {}", key, value, replaced);
                }
                entry.setValue(replaced);
            }
        }
        if (this.classResolver instanceof CamelContextAware) {
            ((CamelContextAware)((Object)this.classResolver)).setCamelContext(this);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Using ClassResolver={}, PackageScanClassResolver={}, ApplicationContextClassLoader={}", this.getClassResolver(), this.getPackageScanClassResolver(), this.getApplicationContextClassLoader());
        }
        if (this.isStreamCaching().booleanValue()) {
            this.log.info("StreamCaching is enabled on CamelContext: {}", (Object)this.getName());
        }
        if (this.isTracing().booleanValue()) {
            this.log.info("Tracing is enabled on CamelContext: {}", (Object)this.getName());
        }
        if (this.isUseMDCLogging().booleanValue()) {
            this.log.info("MDC logging is enabled on CamelContext: {}", (Object)this.getName());
        }
        if (this.isHandleFault().booleanValue() && HandleFault.getHandleFault(this) == null) {
            this.log.info("HandleFault is enabled on CamelContext: {}", (Object)this.getName());
            this.addInterceptStrategy(new HandleFault());
        }
        if (this.getDelayer() != null && this.getDelayer() > 0L) {
            this.log.info("Delayer is enabled with: {} ms. on CamelContext: {}", (Object)this.getDelayer(), (Object)this.getName());
        }
        if (this.getDebugger() != null) {
            this.log.info("Debugger: {} is enabled on CamelContext: {}", (Object)this.getDebugger(), (Object)this.getName());
            this.getDebugger().setCamelContext(this);
            this.startService(this.getDebugger());
            this.addInterceptStrategy(new Debug(this.getDebugger()));
        }
        if ((managementStrategy = this.getManagementStrategy()) instanceof CamelContextAware) {
            ((CamelContextAware)((Object)managementStrategy)).setCamelContext(this);
        }
        ServiceHelper.startService(managementStrategy);
        ServiceHelper.startServices(this.lifecycleStrategies);
        for (LifecycleStrategy strategy : this.lifecycleStrategies) {
            try {
                strategy.onContextStart(this);
            }
            catch (VetoCamelContextStartException e) {
                this.log.warn("Lifecycle strategy vetoed starting CamelContext ({}) due {}", (Object)this.getName(), (Object)e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this.log.warn("Lifecycle strategy " + strategy + " failed starting CamelContext ({}) due {}", (Object)this.getName(), (Object)e.getMessage());
                throw e;
            }
        }
        for (EventNotifier notifier : this.getManagementStrategy().getEventNotifiers()) {
            if (notifier instanceof Service) {
                Service service = (Service)((Object)notifier);
                for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                    strategy.onServiceAdd(this, service, null);
                }
            }
            if (!(notifier instanceof Service)) continue;
            this.startService((Service)((Object)notifier));
        }
        EventHelper.notifyCamelContextStarting(this);
        this.forceLazyInitialization();
        this.endpoints = new DefaultEndpointRegistry(this, this.endpoints);
        this.addService(this.endpoints);
        this.doAddService(this.executorServiceManager, false);
        this.addService(this.producerServicePool);
        this.addService(this.pollingConsumerServicePool);
        this.addService(this.inflightRepository);
        this.addService(this.asyncProcessorAwaitManager);
        this.addService(this.shutdownStrategy);
        this.addService(this.packageScanClassResolver);
        this.addService(this.restRegistry);
        if (this.runtimeEndpointRegistry != null) {
            if (this.runtimeEndpointRegistry instanceof EventNotifier) {
                this.getManagementStrategy().addEventNotifier((EventNotifier)((Object)this.runtimeEndpointRegistry));
            }
            this.addService(this.runtimeEndpointRegistry);
        }
        if ((existing = CamelContextHelper.lookupPropertiesComponent(this, false)) != null) {
            if (existing instanceof PropertiesComponent) {
                this.propertiesComponent = (PropertiesComponent)existing;
            } else {
                throw new IllegalArgumentException("Found properties component of type: " + existing.getClass() + " instead of expected: " + PropertiesComponent.class);
            }
        }
        this.startServices(this.components.values());
        this.startRouteDefinitions(this.routeDefinitions);
        boolean streamCachingInUse = this.isStreamCaching();
        if (!streamCachingInUse) {
            for (RouteDefinition route : this.routeDefinitions) {
                Boolean routeCache = CamelContextHelper.parseBoolean(this, route.getStreamCache());
                if (routeCache == null || !routeCache.booleanValue()) continue;
                streamCachingInUse = true;
                break;
            }
        }
        if (this.isAllowUseOriginalMessage().booleanValue()) {
            this.log.info("AllowUseOriginalMessage is enabled. If access to the original message is not needed, then its recommended to turn this option off as it may improve performance.");
        }
        if (streamCachingInUse) {
            this.getStreamCachingStrategy().setEnabled(true);
            this.addService(this.getStreamCachingStrategy());
        } else {
            this.log.info("StreamCaching is not in use. If using streams then its recommended to enable stream caching. See more details at http://camel.apache.org/stream-caching.html");
        }
        if (this.doNotStartRoutesOnFirstStart) {
            this.log.debug("Skip starting of routes as CamelContext has been configured with autoStartup=false");
        }
        this.doStartOrResumeRoutes(this.routeServices, true, !this.doNotStartRoutesOnFirstStart, false, true);
    }

    @Override
    protected synchronized void doStop() throws Exception {
        this.stopWatch.restart();
        this.log.info("Apache Camel " + this.getVersion() + " (CamelContext: " + this.getName() + ") is shutting down");
        EventHelper.notifyCamelContextStopping(this);
        try {
            this.shutdownStrategy.shutdownForced(this, this.getRouteStartupOrder());
        }
        catch (Throwable e) {
            this.log.warn("Error occurred while shutting down routes. This exception will be ignored.", e);
        }
        this.getRouteStartupOrder().clear();
        this.shutdownServices(this.asyncProcessorAwaitManager);
        this.shutdownServices(this.routeServices.values());
        this.suspendedRouteServices.clear();
        for (Service service : this.servicesToStop) {
            if (!(service instanceof Consumer)) continue;
            this.shutdownServices(service);
        }
        if (this.errorHandlerExecutorService != null) {
            this.getExecutorServiceManager().shutdownNow(this.errorHandlerExecutorService);
            this.errorHandlerExecutorService = null;
        }
        ServiceHelper.stopAndShutdownService(this.getDebugger());
        this.shutdownServices(this.endpoints.values());
        this.endpoints.clear();
        this.shutdownServices(this.components.values());
        this.components.clear();
        this.shutdownServices(this.languages.values());
        this.languages.clear();
        try {
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onContextStop(this);
            }
        }
        catch (Throwable e) {
            this.log.warn("Error occurred while stopping lifecycle strategies. This exception will be ignored.", e);
        }
        this.shutdownServices(this.servicesToStop);
        this.servicesToStop.clear();
        EventHelper.notifyCamelContextStopped(this);
        for (EventNotifier notifier : this.getManagementStrategy().getEventNotifiers()) {
            this.shutdownServices(notifier);
        }
        this.shutdownServices(this.executorServiceManager);
        this.shutdownServices(this.managementStrategy);
        this.shutdownServices(this.managementMBeanAssembler);
        this.shutdownServices(this.lifecycleStrategies);
        this.forceStopLazyInitialization();
        IntrospectionSupport.stop();
        this.stopWatch.stop();
        if (this.log.isInfoEnabled()) {
            this.log.info("Apache Camel " + this.getVersion() + " (CamelContext: " + this.getName() + ") uptime {}", (Object)this.getUptime());
            this.log.info("Apache Camel " + this.getVersion() + " (CamelContext: " + this.getName() + ") is shutdown in " + TimeUtils.printDuration(this.stopWatch.taken()));
        }
        this.startDate = null;
        Container.Instance.unmanage(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStartOrResumeRoutes(Map<String, RouteService> routeServices, boolean checkClash, boolean startConsumer, boolean resumeConsumer, boolean addingRoutes) throws Exception {
        this.isStartingRoutes.set(true);
        try {
            LinkedHashMap<String, RouteService> filtered = new LinkedHashMap<String, RouteService>();
            for (Map.Entry<String, RouteService> entry : routeServices.entrySet()) {
                boolean startable = false;
                Consumer consumer = entry.getValue().getRoutes().iterator().next().getConsumer();
                if (consumer instanceof SuspendableService) {
                    startable = ((SuspendableService)((Object)consumer)).isSuspended();
                }
                if (!startable && consumer instanceof StatefulService) {
                    startable = ((StatefulService)((Object)consumer)).getStatus().isStartable();
                } else if (!startable) {
                    startable = entry.getValue().getStatus().isStartable();
                }
                if (!startable) continue;
                filtered.put(entry.getKey(), entry.getValue());
            }
            if (!filtered.isEmpty()) {
                this.safelyStartRouteServices(checkClash, startConsumer, resumeConsumer, addingRoutes, filtered.values());
            }
            this.isStartingRoutes.remove();
            for (StartupListener startup : this.startupListeners) {
                startup.onCamelContextStarted(this, this.isStarted());
            }
        }
        finally {
            this.isStartingRoutes.remove();
        }
    }

    protected boolean routeSupportsSuspension(String routeId) {
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            return routeService.getRoutes().iterator().next().supportsSuspension();
        }
        return false;
    }

    private void shutdownServices(Object service) {
        try {
            if (service instanceof Service) {
                ServiceHelper.stopAndShutdownService(service);
            } else if (service instanceof Collection) {
                ServiceHelper.stopAndShutdownServices((Collection)service);
            }
        }
        catch (Throwable e) {
            this.log.warn("Error occurred while shutting down service: " + service + ". This exception will be ignored.", e);
            EventHelper.notifyServiceStopFailure(this, service, e);
        }
    }

    private void shutdownServices(Collection<?> services) {
        this.shutdownServices(services, true);
    }

    private void shutdownServices(Collection<?> services, boolean reverse) {
        Collection<?> list = services;
        if (reverse) {
            ArrayList reverseList = new ArrayList(services);
            Collections.reverse(reverseList);
            list = reverseList;
        }
        for (Object service : list) {
            this.shutdownServices(service);
        }
    }

    private void startService(Service service) throws Exception {
        if (service instanceof StartupListener) {
            StartupListener listener = (StartupListener)((Object)service);
            this.addStartupListener(listener);
        }
        if (service instanceof CamelContextAware) {
            CamelContextAware aware = (CamelContextAware)((Object)service);
            aware.setCamelContext(this);
        }
        service.start();
    }

    private void startServices(Collection<?> services) throws Exception {
        for (Object element : services) {
            if (!(element instanceof Service)) continue;
            this.startService((Service)element);
        }
    }

    private void stopServices(Object service) throws Exception {
        try {
            ServiceHelper.stopService(service);
        }
        catch (Exception e) {
            EventHelper.notifyServiceStopFailure(this, service, e);
            throw e;
        }
    }

    protected void startRouteDefinitions(Collection<RouteDefinition> list) throws Exception {
        if (list != null) {
            for (RouteDefinition route : list) {
                this.startRoute(route);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void startRouteService(RouteService routeService, boolean addingRoutes) throws Exception {
        boolean alreadyStartingRoutes = this.isStartingRoutes();
        if (!alreadyStartingRoutes) {
            this.isStartingRoutes.set(true);
        }
        try {
            if (routeService.getStatus().isSuspended()) {
                this.resumeRouteService(routeService);
            } else {
                this.routeServices.put(routeService.getId(), routeService);
                if (this.shouldStartRoutes()) {
                    boolean autoStartup;
                    this.safelyStartRouteServices(true, true, true, false, addingRoutes, routeService);
                    boolean bl = autoStartup = routeService.getRouteDefinition().isAutoStartup(this) && this.isAutoStartup() != false;
                    if (!addingRoutes || autoStartup) {
                        routeService.start();
                    }
                }
            }
        }
        finally {
            if (!alreadyStartingRoutes) {
                this.isStartingRoutes.remove();
            }
        }
    }

    protected synchronized void resumeRouteService(RouteService routeService) throws Exception {
        if (!routeService.getStatus().isSuspended()) {
            this.startRouteService(routeService, false);
        } else if (this.shouldStartRoutes()) {
            this.safelyStartRouteServices(true, false, true, true, false, routeService);
            routeService.resume();
        }
    }

    protected synchronized void stopRouteService(RouteService routeService, boolean removingRoutes) throws Exception {
        routeService.setRemovingRoutes(removingRoutes);
        this.stopRouteService(routeService);
    }

    protected void logRouteState(Route route, String state) {
        if (this.log.isInfoEnabled()) {
            if (route.getConsumer() != null) {
                this.log.info("Route: {} is {}, was consuming from: {}", route.getId(), state, route.getConsumer().getEndpoint());
            } else {
                this.log.info("Route: {} is {}.", (Object)route.getId(), (Object)state);
            }
        }
    }

    protected synchronized void stopRouteService(RouteService routeService) throws Exception {
        routeService.stop();
        for (Route route : routeService.getRoutes()) {
            this.logRouteState(route, "stopped");
        }
    }

    protected synchronized void shutdownRouteService(RouteService routeService) throws Exception {
        routeService.shutdown();
        for (Route route : routeService.getRoutes()) {
            this.logRouteState(route, "shutdown and removed");
        }
    }

    protected synchronized void suspendRouteService(RouteService routeService) throws Exception {
        routeService.setRemovingRoutes(false);
        routeService.suspend();
        for (Route route : routeService.getRoutes()) {
            this.logRouteState(route, "suspended");
        }
    }

    protected synchronized void safelyStartRouteServices(boolean checkClash, boolean startConsumer, boolean resumeConsumer, boolean addingRoutes, Collection<RouteService> routeServices) throws Exception {
        TreeMap<Integer, DefaultRouteStartupOrder> inputs = new TreeMap<Integer, DefaultRouteStartupOrder>();
        for (RouteService routeService : routeServices) {
            DefaultRouteStartupOrder order = this.doPrepareRouteToBeStarted(routeService);
            if (checkClash) {
                this.doCheckStartupOrderClash(order, inputs);
            }
            inputs.put(order.getStartupOrder(), order);
        }
        this.doWarmUpRoutes(inputs, startConsumer);
        if (startConsumer) {
            if (resumeConsumer) {
                this.doResumeRouteConsumers(inputs, addingRoutes);
            } else {
                this.doStartRouteConsumers(inputs, addingRoutes);
            }
        }
        inputs.clear();
    }

    protected synchronized void safelyStartRouteServices(boolean forceAutoStart, boolean checkClash, boolean startConsumer, boolean resumeConsumer, boolean addingRoutes, RouteService ... routeServices) throws Exception {
        this.safelyStartRouteServices(checkClash, startConsumer, resumeConsumer, addingRoutes, Arrays.asList(routeServices));
    }

    private DefaultRouteStartupOrder doPrepareRouteToBeStarted(RouteService routeService) {
        Integer startupOrder = routeService.getRouteDefinition().getStartupOrder();
        if (startupOrder == null) {
            startupOrder = this.defaultRouteStartupOrder++;
        }
        Route route = routeService.getRoutes().iterator().next();
        return new DefaultRouteStartupOrder(startupOrder, route, routeService);
    }

    private boolean doCheckStartupOrderClash(DefaultRouteStartupOrder answer, Map<Integer, DefaultRouteStartupOrder> inputs) throws FailedToStartRouteException {
        DefaultRouteStartupOrder other = inputs.get(answer.getStartupOrder());
        if (other != null && answer != other) {
            String otherId = other.getRoute().getId();
            throw new FailedToStartRouteException(answer.getRoute().getId(), "startupOrder clash. Route " + otherId + " already has startupOrder " + answer.getStartupOrder() + " configured which this route have as well. Please correct startupOrder to be unique among all your routes.");
        }
        for (RouteStartupOrder order : this.routeStartupOrder) {
            String otherId = order.getRoute().getId();
            if (answer.getRoute().getId().equals(otherId) || answer.getStartupOrder() != order.getStartupOrder()) continue;
            throw new FailedToStartRouteException(answer.getRoute().getId(), "startupOrder clash. Route " + otherId + " already has startupOrder " + answer.getStartupOrder() + " configured which this route have as well. Please correct startupOrder to be unique among all your routes.");
        }
        return true;
    }

    private void doWarmUpRoutes(Map<Integer, DefaultRouteStartupOrder> inputs, boolean autoStartup) throws Exception {
        for (Map.Entry<Integer, DefaultRouteStartupOrder> entry : inputs.entrySet()) {
            RouteService routeService = entry.getValue().getRouteService();
            this.log.debug("Warming up route id: {} having autoStartup={}", (Object)routeService.getId(), (Object)autoStartup);
            routeService.warmUp();
        }
    }

    private void doResumeRouteConsumers(Map<Integer, DefaultRouteStartupOrder> inputs, boolean addingRoutes) throws Exception {
        this.doStartOrResumeRouteConsumers(inputs, true, addingRoutes);
    }

    private void doStartRouteConsumers(Map<Integer, DefaultRouteStartupOrder> inputs, boolean addingRoutes) throws Exception {
        this.doStartOrResumeRouteConsumers(inputs, false, addingRoutes);
    }

    private void doStartOrResumeRouteConsumers(Map<Integer, DefaultRouteStartupOrder> inputs, boolean resumeOnly, boolean addingRoute) throws Exception {
        ArrayList<Endpoint> routeInputs = new ArrayList<Endpoint>();
        for (Map.Entry<Integer, DefaultRouteStartupOrder> entry : inputs.entrySet()) {
            boolean autoStartup;
            Integer order = entry.getKey();
            Route route = entry.getValue().getRoute();
            RouteService routeService = entry.getValue().getRouteService();
            boolean bl = autoStartup = routeService.getRouteDefinition().isAutoStartup(this) && this.isAutoStartup() != false;
            if (addingRoute && !autoStartup) {
                this.log.info("Skipping starting of route " + routeService.getId() + " as its configured with autoStartup=false");
                continue;
            }
            for (Consumer consumer : routeService.getInputs().values()) {
                Endpoint endpoint = consumer.getEndpoint();
                if (!this.doCheckMultipleConsumerSupportClash(endpoint, routeInputs)) {
                    throw new FailedToStartRouteException(routeService.getId(), "Multiple consumers for the same endpoint is not allowed: " + endpoint);
                }
                ArrayList<Endpoint> existingEndpoints = new ArrayList<Endpoint>();
                for (Route existingRoute : this.getRoutes()) {
                    if (route.getId().equals(existingRoute.getId())) continue;
                    Endpoint existing = existingRoute.getEndpoint();
                    ServiceStatus status2 = this.getRouteStatus(existingRoute.getId());
                    if (status2 == null || !status2.isStarted() && !status2.isStarting()) continue;
                    existingEndpoints.add(existing);
                }
                if (!this.doCheckMultipleConsumerSupportClash(endpoint, existingEndpoints)) {
                    throw new FailedToStartRouteException(routeService.getId(), "Multiple consumers for the same endpoint is not allowed: " + endpoint);
                }
                this.log.debug("Route: {} >>> {}", (Object)route.getId(), (Object)route);
                if (resumeOnly) {
                    this.log.debug("Resuming consumer (order: {}) on route: {}", (Object)order, (Object)route.getId());
                } else {
                    this.log.debug("Starting consumer (order: {}) on route: {}", (Object)order, (Object)route.getId());
                }
                if (resumeOnly && route.supportsSuspension()) {
                    ServiceHelper.resumeService(consumer);
                    this.log.info("Route: " + route.getId() + " resumed and consuming from: " + endpoint);
                } else {
                    for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                        strategy.onServiceAdd(this, consumer, route);
                    }
                    this.startService(consumer);
                    this.log.info("Route: " + route.getId() + " started and consuming from: " + endpoint);
                }
                routeInputs.add(endpoint);
                boolean found = false;
                for (RouteStartupOrder other : this.routeStartupOrder) {
                    if (!other.getRoute().getId().equals(route.getId())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.routeStartupOrder.add(entry.getValue());
            }
            if (resumeOnly) {
                routeService.resume();
                continue;
            }
            routeService.start(false);
        }
    }

    private boolean doCheckMultipleConsumerSupportClash(Endpoint endpoint, List<Endpoint> routeInputs) {
        boolean multipleConsumersSupported = false;
        if (endpoint instanceof MultipleConsumersSupport) {
            multipleConsumersSupported = ((MultipleConsumersSupport)((Object)endpoint)).isMultipleConsumersSupported();
        }
        if (multipleConsumersSupported) {
            return true;
        }
        return !routeInputs.contains(endpoint);
    }

    protected void forceLazyInitialization() {
        this.getRegistry();
        this.getInjector();
        this.getLanguageResolver();
        this.getTypeConverterRegistry();
        this.getTypeConverter();
        this.getRuntimeEndpointRegistry();
        if (this.isTypeConverterStatisticsEnabled() != null) {
            this.getTypeConverterRegistry().getStatistics().setStatisticsEnabled(this.isTypeConverterStatisticsEnabled());
        }
    }

    protected void forceStopLazyInitialization() {
        this.injector = null;
        this.languageResolver = null;
        this.typeConverterRegistry = null;
        this.typeConverter = null;
    }

    protected TypeConverter createTypeConverter() {
        BaseTypeConverterRegistry answer = this.isLazyLoadTypeConverters() != false ? new LazyLoadingTypeConverter(this.packageScanClassResolver, this.getInjector(), this.getDefaultFactoryFinder()) : new DefaultTypeConverter(this.packageScanClassResolver, this.getInjector(), this.getDefaultFactoryFinder());
        this.setTypeConverterRegistry(answer);
        return answer;
    }

    protected Injector createInjector() {
        FactoryFinder finder = this.getDefaultFactoryFinder();
        try {
            return (Injector)finder.newInstance("Injector");
        }
        catch (NoFactoryAvailableException e) {
            return new DefaultInjector(this);
        }
    }

    protected ManagementMBeanAssembler createManagementMBeanAssembler() {
        return new DefaultManagementMBeanAssembler(this);
    }

    protected ComponentResolver createComponentResolver() {
        return new DefaultComponentResolver();
    }

    protected Registry createRegistry() {
        JndiRegistry jndi = new JndiRegistry();
        try {
            jndi.getContext();
            return jndi;
        }
        catch (Throwable e) {
            this.log.debug("Cannot create javax.naming.InitialContext due " + e.getMessage() + ". Will fallback and use SimpleRegistry instead. This exception is ignored.", e);
            return new SimpleRegistry();
        }
    }

    protected Endpoint createEndpoint(String uri) {
        Object value = this.getRegistry().lookupByName(uri);
        if (value instanceof Endpoint) {
            return (Endpoint)value;
        }
        if (value instanceof Processor) {
            return new ProcessorEndpoint(uri, this, (Processor)value);
        }
        if (value != null) {
            return this.convertBeanToEndpoint(uri, value);
        }
        return null;
    }

    protected Endpoint convertBeanToEndpoint(String uri, Object bean) {
        throw new IllegalArgumentException("uri: " + uri + " bean: " + bean + " could not be converted to an Endpoint");
    }

    protected boolean shouldStartRoutes() {
        return this.isStarted() && !this.isStarting();
    }

    protected PropertiesComponent getPropertiesComponent() {
        return this.propertiesComponent;
    }

    @Override
    public void setDataFormats(Map<String, DataFormatDefinition> dataFormats) {
        this.dataFormats = dataFormats;
    }

    @Override
    public Map<String, DataFormatDefinition> getDataFormats() {
        return this.dataFormats;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public FactoryFinder getDefaultFactoryFinder() {
        if (this.defaultFactoryFinder == null) {
            this.defaultFactoryFinder = this.factoryFinderResolver.resolveDefaultFactoryFinder(this.getClassResolver());
        }
        return this.defaultFactoryFinder;
    }

    @Override
    public void setFactoryFinderResolver(FactoryFinderResolver resolver) {
        this.factoryFinderResolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FactoryFinder getFactoryFinder(String path) throws NoFactoryAvailableException {
        Map<String, FactoryFinder> map = this.factories;
        synchronized (map) {
            FactoryFinder answer = this.factories.get(path);
            if (answer == null) {
                answer = this.factoryFinderResolver.resolveFactoryFinder(this.getClassResolver(), path);
                this.factories.put(path, answer);
            }
            return answer;
        }
    }

    @Override
    public ClassResolver getClassResolver() {
        return this.classResolver;
    }

    @Override
    public void setClassResolver(ClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    @Override
    public PackageScanClassResolver getPackageScanClassResolver() {
        return this.packageScanClassResolver;
    }

    @Override
    public void setPackageScanClassResolver(PackageScanClassResolver packageScanClassResolver) {
        this.packageScanClassResolver = packageScanClassResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getComponentNames() {
        Map<String, Component> map = this.components;
        synchronized (map) {
            ArrayList<String> answer = new ArrayList<String>();
            for (String name : this.components.keySet()) {
                answer.add(name);
            }
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getLanguageNames() {
        Map<String, Language> map = this.languages;
        synchronized (map) {
            ArrayList<String> answer = new ArrayList<String>();
            for (String name : this.languages.keySet()) {
                answer.add(name);
            }
            return answer;
        }
    }

    @Override
    public ModelJAXBContextFactory getModelJAXBContextFactory() {
        if (this.modelJAXBContextFactory == null) {
            this.modelJAXBContextFactory = new DefaultModelJAXBContextFactory();
        }
        return this.modelJAXBContextFactory;
    }

    @Override
    public void setModelJAXBContextFactory(ModelJAXBContextFactory modelJAXBContextFactory) {
        this.modelJAXBContextFactory = modelJAXBContextFactory;
    }

    @Override
    public NodeIdFactory getNodeIdFactory() {
        return this.nodeIdFactory;
    }

    @Override
    public void setNodeIdFactory(NodeIdFactory idFactory) {
        this.nodeIdFactory = idFactory;
    }

    @Override
    public ManagementStrategy getManagementStrategy() {
        return this.managementStrategy;
    }

    @Override
    public void setManagementStrategy(ManagementStrategy managementStrategy) {
        this.managementStrategy = managementStrategy;
    }

    @Override
    public InterceptStrategy getDefaultTracer() {
        if (this.defaultTracer == null) {
            this.defaultTracer = new Tracer();
        }
        return this.defaultTracer;
    }

    @Override
    public void setDefaultTracer(InterceptStrategy tracer) {
        this.defaultTracer = tracer;
    }

    @Override
    public InterceptStrategy getDefaultBacklogTracer() {
        if (this.defaultBacklogTracer == null) {
            this.defaultBacklogTracer = BacklogTracer.createTracer(this);
        }
        return this.defaultBacklogTracer;
    }

    @Override
    public void setDefaultBacklogTracer(InterceptStrategy backlogTracer) {
        this.defaultBacklogTracer = backlogTracer;
    }

    @Override
    public InterceptStrategy getDefaultBacklogDebugger() {
        if (this.defaultBacklogDebugger == null) {
            this.defaultBacklogDebugger = new BacklogDebugger(this);
        }
        return this.defaultBacklogDebugger;
    }

    @Override
    public void setDefaultBacklogDebugger(InterceptStrategy defaultBacklogDebugger) {
        this.defaultBacklogDebugger = defaultBacklogDebugger;
    }

    @Override
    public void disableJMX() {
        if (this.isStarting() || this.isStarted()) {
            throw new IllegalStateException("Disabling JMX can only be done when CamelContext has not been started");
        }
        this.managementStrategy = new DefaultManagementStrategy(this);
        this.lifecycleStrategies.clear();
    }

    @Override
    public InflightRepository getInflightRepository() {
        return this.inflightRepository;
    }

    @Override
    public void setInflightRepository(InflightRepository repository) {
        this.inflightRepository = repository;
    }

    @Override
    public AsyncProcessorAwaitManager getAsyncProcessorAwaitManager() {
        return this.asyncProcessorAwaitManager;
    }

    @Override
    public void setAsyncProcessorAwaitManager(AsyncProcessorAwaitManager asyncProcessorAwaitManager) {
        this.asyncProcessorAwaitManager = asyncProcessorAwaitManager;
    }

    @Override
    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    @Override
    public Boolean isAutoStartup() {
        return this.autoStartup != null && this.autoStartup != false;
    }

    @Override
    @Deprecated
    public Boolean isLazyLoadTypeConverters() {
        return this.lazyLoadTypeConverters != null && this.lazyLoadTypeConverters != false;
    }

    @Override
    @Deprecated
    public void setLazyLoadTypeConverters(Boolean lazyLoadTypeConverters) {
        this.lazyLoadTypeConverters = lazyLoadTypeConverters;
    }

    @Override
    public Boolean isTypeConverterStatisticsEnabled() {
        return this.typeConverterStatisticsEnabled != null && this.typeConverterStatisticsEnabled != false;
    }

    @Override
    public void setTypeConverterStatisticsEnabled(Boolean typeConverterStatisticsEnabled) {
        this.typeConverterStatisticsEnabled = typeConverterStatisticsEnabled;
    }

    @Override
    public Boolean isUseMDCLogging() {
        return this.useMDCLogging != null && this.useMDCLogging != false;
    }

    @Override
    public void setUseMDCLogging(Boolean useMDCLogging) {
        this.useMDCLogging = useMDCLogging;
    }

    @Override
    public Boolean isUseBreadcrumb() {
        return this.useBreadcrumb != null && this.useBreadcrumb != false;
    }

    @Override
    public void setUseBreadcrumb(Boolean useBreadcrumb) {
        this.useBreadcrumb = useBreadcrumb;
    }

    @Override
    public ClassLoader getApplicationContextClassLoader() {
        return this.applicationContextClassLoader;
    }

    @Override
    public void setApplicationContextClassLoader(ClassLoader classLoader) {
        this.applicationContextClassLoader = classLoader;
    }

    @Override
    public DataFormatResolver getDataFormatResolver() {
        return this.dataFormatResolver;
    }

    @Override
    public void setDataFormatResolver(DataFormatResolver dataFormatResolver) {
        this.dataFormatResolver = dataFormatResolver;
    }

    @Override
    public DataFormat resolveDataFormat(String name) {
        DataFormat answer = this.dataFormatResolver.resolveDataFormat(name, this);
        if (answer != null && answer instanceof CamelContextAware) {
            ((CamelContextAware)((Object)answer)).setCamelContext(this);
        }
        return answer;
    }

    @Override
    public DataFormatDefinition resolveDataFormatDefinition(String name) {
        DataFormatDefinition type = DefaultCamelContext.lookup(this, name, DataFormatDefinition.class);
        if (type == null && this.getDataFormats() != null) {
            type = this.getDataFormats().get(name);
        }
        return type;
    }

    private static <T> T lookup(CamelContext context, String ref, Class<T> type) {
        try {
            return context.getRegistry().lookupByNameAndType(ref, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    protected Component lookupPropertiesComponent() {
        return CamelContextHelper.lookupPropertiesComponent(this, false);
    }

    @Override
    public ShutdownStrategy getShutdownStrategy() {
        return this.shutdownStrategy;
    }

    @Override
    public void setShutdownStrategy(ShutdownStrategy shutdownStrategy) {
        this.shutdownStrategy = shutdownStrategy;
    }

    @Override
    public ShutdownRoute getShutdownRoute() {
        return this.shutdownRoute;
    }

    @Override
    public void setShutdownRoute(ShutdownRoute shutdownRoute) {
        this.shutdownRoute = shutdownRoute;
    }

    @Override
    public ShutdownRunningTask getShutdownRunningTask() {
        return this.shutdownRunningTask;
    }

    @Override
    public void setShutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
    }

    @Override
    public void setAllowUseOriginalMessage(Boolean allowUseOriginalMessage) {
        this.allowUseOriginalMessage = allowUseOriginalMessage;
    }

    @Override
    public Boolean isAllowUseOriginalMessage() {
        return this.allowUseOriginalMessage != null && this.allowUseOriginalMessage != false;
    }

    @Override
    public ExecutorServiceManager getExecutorServiceManager() {
        return this.executorServiceManager;
    }

    @Override
    @Deprecated
    public ExecutorServiceStrategy getExecutorServiceStrategy() {
        return new DefaultExecutorServiceStrategy(this);
    }

    @Override
    public void setExecutorServiceManager(ExecutorServiceManager executorServiceManager) {
        this.executorServiceManager = executorServiceManager;
    }

    @Override
    public ProcessorFactory getProcessorFactory() {
        return this.processorFactory;
    }

    @Override
    public void setProcessorFactory(ProcessorFactory processorFactory) {
        this.processorFactory = processorFactory;
    }

    @Override
    public Debugger getDebugger() {
        return this.debugger;
    }

    @Override
    public void setDebugger(Debugger debugger) {
        this.debugger = debugger;
    }

    @Override
    public UuidGenerator getUuidGenerator() {
        return this.uuidGenerator;
    }

    @Override
    public void setUuidGenerator(UuidGenerator uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
    }

    @Override
    public StreamCachingStrategy getStreamCachingStrategy() {
        if (this.streamCachingStrategy == null) {
            this.streamCachingStrategy = new DefaultStreamCachingStrategy();
        }
        return this.streamCachingStrategy;
    }

    @Override
    public void setStreamCachingStrategy(StreamCachingStrategy streamCachingStrategy) {
        this.streamCachingStrategy = streamCachingStrategy;
    }

    @Override
    public RestRegistry getRestRegistry() {
        return this.restRegistry;
    }

    @Override
    public void setRestRegistry(RestRegistry restRegistry) {
        this.restRegistry = restRegistry;
    }

    @Override
    public String getProperty(String name) {
        String value = this.getProperties().get(name);
        if (ObjectHelper.isNotEmpty(value)) {
            try {
                value = this.resolvePropertyPlaceholders(value);
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error getting property: " + name, e);
            }
        }
        return value;
    }

    protected Map<String, RouteService> getRouteServices() {
        return this.routeServices;
    }

    protected ManagementStrategy createManagementStrategy() {
        return new ManagementStrategyFactory().create(this, this.disableJMX != false || Boolean.getBoolean("org.apache.camel.jmx.disabled"));
    }

    public static void setContextCounter(int value) {
        DefaultCamelContextNameStrategy.setCounter(value);
        DefaultManagementNameStrategy.setCounter(value);
    }

    private static UuidGenerator createDefaultUuidGenerator() {
        if (System.getProperty("com.google.appengine.runtime.environment") != null) {
            return new JavaUuidGenerator();
        }
        return new ActiveMQUuidGenerator();
    }

    public String toString() {
        return "CamelContext(" + this.getName() + ")";
    }
}

