/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring31.properties;

import java.util.Map;
import java.util.Properties;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.properties.EncryptableProperties;
import org.jasypt.util.text.TextEncryptor;
import org.springframework.core.env.PropertiesPropertySource;

public final class EncryptablePropertiesPropertySource
extends PropertiesPropertySource {
    public EncryptablePropertiesPropertySource(String name, EncryptableProperties props) {
        super(name, (Properties)props);
    }

    public EncryptablePropertiesPropertySource(String name, Properties props, TextEncryptor encryptor) {
        super(name, EncryptablePropertiesPropertySource.processProperties(props, encryptor));
    }

    public EncryptablePropertiesPropertySource(String name, Properties props, StringEncryptor encryptor) {
        super(name, EncryptablePropertiesPropertySource.processProperties(props, encryptor));
    }

    private static Properties processProperties(Properties props, TextEncryptor encryptor) {
        if (props == null) {
            return null;
        }
        if (props instanceof EncryptableProperties) {
            throw new IllegalArgumentException("Properties object already is an " + EncryptableProperties.class.getName() + " object. No encryptor should be specified.");
        }
        EncryptableProperties encryptableProperties = new EncryptableProperties(encryptor);
        encryptableProperties.putAll((Map)props);
        return encryptableProperties;
    }

    private static Properties processProperties(Properties props, StringEncryptor encryptor) {
        if (props == null) {
            return null;
        }
        if (props instanceof EncryptableProperties) {
            throw new IllegalArgumentException("Properties object already is an " + EncryptableProperties.class.getName() + " object. No encryptor should be specified.");
        }
        EncryptableProperties encryptableProperties = new EncryptableProperties(encryptor);
        encryptableProperties.putAll((Map)props);
        return encryptableProperties;
    }
}

