/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.fs;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.fs.FsBlobContainer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.internal.io.IOUtils;

public class FsBlobStore
implements BlobStore {
    private final Path path;
    private final int bufferSizeInBytes;
    private final boolean readOnly;

    public FsBlobStore(Settings settings, Path path) throws IOException {
        this.path = path;
        this.readOnly = settings.getAsBoolean("readonly", false);
        if (!this.readOnly) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        this.bufferSizeInBytes = (int)settings.getAsBytesSize("repositories.fs.buffer_size", new ByteSizeValue(100L, ByteSizeUnit.KB)).getBytes();
    }

    public String toString() {
        return this.path.toString();
    }

    public Path path() {
        return this.path;
    }

    public int bufferSizeInBytes() {
        return this.bufferSizeInBytes;
    }

    @Override
    public BlobContainer blobContainer(BlobPath path) {
        try {
            return new FsBlobContainer(this, path, this.buildAndCreate(path));
        }
        catch (IOException ex) {
            throw new ElasticsearchException("failed to create blob container", (Throwable)ex, new Object[0]);
        }
    }

    @Override
    public void delete(BlobPath path) throws IOException {
        IOUtils.rm((Path[])new Path[]{this.buildPath(path)});
    }

    @Override
    public void close() {
    }

    private synchronized Path buildAndCreate(BlobPath path) throws IOException {
        Path f = this.buildPath(path);
        if (!this.readOnly) {
            Files.createDirectories(f, new FileAttribute[0]);
        }
        return f;
    }

    private Path buildPath(BlobPath path) {
        String[] paths = path.toArray();
        if (paths.length == 0) {
            return this.path();
        }
        Path blobPath = this.path.resolve(paths[0]);
        if (paths.length > 1) {
            for (int i = 1; i < paths.length; ++i) {
                blobPath = blobPath.resolve(paths[i]);
            }
        }
        return blobPath;
    }
}

