/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.bitpatterns.gui.FunctionBitPatternsExplorerPlugin;
import ghidra.bitpatterns.info.PatternEvalRowObject;
import ghidra.bitpatterns.info.PatternMatchType;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.task.TaskMonitor;
import java.awt.Font;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class PatternEvalTabelModel
extends AddressBasedTableModel<PatternEvalRowObject> {
    private static final int MONOSPACE_FONT_SIZE = 14;
    private List<PatternEvalRowObject> rowObjects;
    protected final GColumnRenderer<String> monospacedRenderer = new AbstractGColumnRenderer<String>(){

        protected void configureFont(JTable table, TableModel model, int column) {
            Font f = new Font("monospaced", this.getFixedWidthFont().getStyle(), 14);
            this.setFont(f);
        }

        public String getFilterString(String t, Settings settings) {
            return t;
        }
    };

    public PatternEvalTabelModel(FunctionBitPatternsExplorerPlugin plugin, Program program, List<PatternEvalRowObject> rowObjects) {
        super("Pattern Evaluation", (ServiceProvider)plugin.getTool(), program, null);
        this.rowObjects = rowObjects;
    }

    public Address getAddress(int row) {
        PatternEvalRowObject rowObject = (PatternEvalRowObject)this.getRowObject(row);
        return rowObject.getMatchedAddress();
    }

    protected TableColumnDescriptor<PatternEvalRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new AddressTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new MatchTypeTableColumn(), 0, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new PostBitsColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new TotalBitsColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new PatternStringTableColumn());
        return descriptor;
    }

    protected void doLoad(Accumulator<PatternEvalRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.rowObjects != null) {
            accumulator.addAll(this.rowObjects);
        }
    }

    private class PatternStringTableColumn
    extends AbstractDynamicTableColumn<PatternEvalRowObject, String, Object> {
        private PatternStringTableColumn() {
        }

        public String getColumnName() {
            return "Pattern";
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return PatternEvalTabelModel.this.monospacedRenderer;
        }

        public String getValue(PatternEvalRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getPatternString();
        }
    }

    private class TotalBitsColumn
    extends AbstractDynamicTableColumn<PatternEvalRowObject, Integer, Object> {
        private TotalBitsColumn() {
        }

        public String getColumnName() {
            return "Totalbits";
        }

        public Integer getValue(PatternEvalRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getTotalBits();
        }
    }

    private class PostBitsColumn
    extends AbstractDynamicTableColumn<PatternEvalRowObject, Integer, Object> {
        private PostBitsColumn() {
        }

        public String getColumnName() {
            return "Postbits";
        }

        public Integer getValue(PatternEvalRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getPostBits();
        }
    }

    private class AddressTableColumn
    extends AbstractDynamicTableColumn<PatternEvalRowObject, Address, Object> {
        private AddressTableColumn() {
        }

        public String getColumnName() {
            return "Address";
        }

        public Address getValue(PatternEvalRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getMatchedAddress();
        }
    }

    private class MatchTypeTableColumn
    extends AbstractDynamicTableColumn<PatternEvalRowObject, PatternMatchType, Object> {
        private MatchTypeTableColumn() {
        }

        public String getColumnName() {
            return "Match Type";
        }

        public PatternMatchType getValue(PatternEvalRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getMatchType();
        }
    }
}

