/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.bookmark;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.bookmark.BookmarkProvider;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.BookmarkType;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

class FilterDialog
extends DialogComponentProvider {
    private BookmarkProvider provider;
    private JCheckBox[] buttons;
    private BookmarkType[] types;

    FilterDialog(BookmarkProvider provider, Program p) {
        super("Bookmark Filter", true, false, true, false);
        this.setHelpLocation(new HelpLocation("BookmarkPlugin", "Filter_Dialog"));
        this.provider = provider;
        this.addWorkPanel(this.buildPanel(p));
        this.addOKButton();
        this.addCancelButton();
    }

    private JComponent buildPanel(Program program) {
        JPanel p = new JPanel((LayoutManager)new VerticalLayout(20));
        p.add(this.getTypesPanel(program));
        return p;
    }

    private JPanel getTypesPanel(Program program) {
        BookmarkManager bmMgr = program.getBookmarkManager();
        this.types = bmMgr.getBookmarkTypes();
        this.buttons = new JCheckBox[this.types.length];
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 20));
        panel.setBorder(BorderFactory.createTitledBorder("Include Bookmark Types"));
        for (int i = 0; i < this.types.length; ++i) {
            this.buttons[i] = new JCheckBox();
            JPanel p = new JPanel(new BorderLayout());
            p.add((Component)this.buttons[i], "West");
            this.buttons[i].setSelected(this.provider.isShowingType(this.types[i].getTypeString()));
            JLabel l = new JLabel(this.types[i].getTypeString(), this.types[i].getIcon(), 2);
            p.add((Component)l, "Center");
            panel.add(p);
        }
        return panel;
    }

    protected void okCallback() {
        ArrayList<String> typesList = new ArrayList<String>(this.types.length);
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.buttons[i].isSelected()) continue;
            typesList.add(this.types[i].getTypeString());
        }
        this.provider.setFilterTypes(typesList);
        this.close();
    }

    void setFilter(String filterName, boolean state) {
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.types[i].getTypeString().equals(filterName)) continue;
            this.buttons[i].setSelected(state);
        }
    }
}

