/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.app.plugin.core.compositeeditor.StructureEditorModel;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.UsrException;
import java.util.Arrays;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class CreateInternalStructureAction
extends CompositeEditorTableAction {
    private static final ImageIcon createInternalStructureIcon = ResourceManager.loadImage((String)"images/cstruct.png");
    private static final String ACTION_NAME = "Create Structure From Selection";
    private static final String GROUP_NAME = "4_COMPONENT_EDITOR_ACTION";
    private static final String DESCRIPTION = "Create a new structure from the selected components and replace them with it.";
    private static String[] popupPath = new String[]{"Create Structure From Selection"};

    public CreateInternalStructureAction(CompositeEditorProvider provider) {
        super(provider, "Editor: Create Structure From Selection", GROUP_NAME, popupPath, null, createInternalStructureIcon);
        this.setDescription(DESCRIPTION);
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        int[] selectedComponentRows = this.model.getSelectedComponentRows();
        boolean hasComponentSelection = this.model.hasComponentSelection();
        boolean contiguousComponentSelection = this.model.isContiguousComponentSelection();
        if (hasComponentSelection && contiguousComponentSelection && selectedComponentRows.length > 0) {
            Arrays.sort(selectedComponentRows);
            int numComponents = this.model.getNumComponents();
            int maxRow = selectedComponentRows[selectedComponentRows.length - 1];
            if (maxRow < numComponents) {
                try {
                    ((StructureEditorModel)this.model).createInternalStructure();
                }
                catch (UsrException e1) {
                    this.model.setStatus(e1.getMessage(), true);
                }
            }
        }
        this.requestTableFocus();
        SystemUtilities.runSwingLater((Runnable)new Runnable(){

            @Override
            public void run() {
                CreateInternalStructureAction.this.provider.toFront();
                CreateInternalStructureAction.this.provider.requestFocus();
                CreateInternalStructureAction.this.provider.editorPanel.requestFocus();
                CreateInternalStructureAction.this.provider.editorPanel.table.requestFocus();
            }
        });
    }

    @Override
    public void adjustEnablement() {
        this.setEnabled(this.isCreateInternalStructureAllowed());
    }

    private boolean isCreateInternalStructureAllowed() {
        return this.model.hasComponentSelection() && this.model.isContiguousComponentSelection();
    }
}

