/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.app.plugin.core.datamgr.actions.DerivativeDataTypeInfo;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.BuiltInArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeTreeNode;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.PointerDataType;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.SystemUtilities;
import java.awt.Component;
import javax.swing.tree.TreePath;

public class CreatePointerAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public CreatePointerAction(DataTypeManagerPlugin plugin) {
        super("Create Pointer", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"New", "Pointer"}, null, "Create"));
    }

    public void actionPerformed(ActionContext context) {
        DataTypeArchiveGTree gTree = (DataTypeArchiveGTree)((Object)context.getContextObject());
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        DataTypeNode dataTypeNode = (DataTypeNode)selectionPaths[0].getLastPathComponent();
        DataType baseDataType = dataTypeNode.getDataType();
        DerivativeDataTypeInfo info = new DerivativeDataTypeInfo(this.plugin, gTree, (GTreeNode)dataTypeNode, baseDataType);
        CategoryPath categoryPath = info.getCategoryPath();
        PointerDataType pointerDataType = new PointerDataType(baseDataType);
        DataTypeManager dataTypeManager = info.getDataTypeManager();
        DataType newDataType = this.createNewDataType((Component)((Object)gTree), (DataType)pointerDataType, categoryPath, dataTypeManager);
        DataTypesProvider provider = this.plugin.getProvider();
        if (provider.isFilteringPointers()) {
            DataTypePath newPath = new DataTypePath(categoryPath, newDataType.getName());
            DataTypeManager newManager = newDataType.getDataTypeManager();
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)((Object)gTree), (String)"Pointers Filter Enabled", (Object)("<html>Newly created pointer is filtered out of view.<br><br>Toggle the <b>Filter Pointers Action</b> to view the pointer<br>Pointer: " + newManager.getName() + newPath));
            return;
        }
        GTreeNode parentNode = info.getParentNode();
        TreePath treePath = parentNode.getTreePath();
        String newNodeName = newDataType.getName();
        SystemUtilities.runSwingLater(() -> {
            TreePath newPath = treePath.pathByAddingChild(newNodeName);
            gTree.setSelectedNodeByPathName(newPath);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataType createNewDataType(Component parentComponent, DataType dataType, CategoryPath categoryPath, DataTypeManager dataTypeManager) {
        int transactionID = dataTypeManager.startTransaction("Create Typedef");
        try {
            DataType dataType2 = dataTypeManager.addDataType(dataType, this.plugin.getConflictHandler());
            return dataType2;
        }
        finally {
            dataTypeManager.endTransaction(transactionID, true);
        }
    }

    public boolean isEnabledForContext(ActionContext context) {
        DataTypeNode node = this.getDataTypeNode(context);
        if (node == null) {
            return false;
        }
        ArchiveNode archiveNode = node.getArchiveNode();
        boolean enabled = archiveNode.isModifiable();
        if (archiveNode instanceof BuiltInArchiveNode) {
            enabled = true;
        }
        if (enabled) {
            String dtName = node.getName();
            dtName = StringUtilities.trim((String)dtName, (int)10);
            MenuData newMenuData = new MenuData(new String[]{"New", "Pointer to " + dtName}, null, "Create");
            this.setPopupMenuData(newMenuData);
        }
        return enabled;
    }

    public boolean isAddToPopup(ActionContext context) {
        DataTypeManager manager;
        DataTypeNode node = this.getDataTypeNode(context);
        if (node == null) {
            return false;
        }
        DataType dataType = node.getDataType();
        DataTypeManager dataTypeManager = dataType.getDataTypeManager();
        return !(dataTypeManager instanceof BuiltInDataTypeManager) || (manager = this.plugin.getProgramDataTypeManager()) != null;
    }

    private DataTypeNode getDataTypeNode(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return null;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths.length != 1) {
            return null;
        }
        DataTypeTreeNode node = (DataTypeTreeNode)selectionPaths[0].getLastPathComponent();
        if (!(node instanceof DataTypeNode)) {
            return null;
        }
        return (DataTypeNode)node;
    }
}

