/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ProgramLocation;
import java.util.Objects;

public class LocationReference
implements Comparable<LocationReference> {
    private final boolean isOffcutReference;
    private final Address locationOfUseAddress;
    private final String refType;
    private final String context;
    private final ProgramLocation location;
    private int hashCode = -1;

    private static String getRefType(Reference r) {
        return r != null ? r.getReferenceType().getName() : "";
    }

    private LocationReference(Address address, ProgramLocation location, String refType, String context, boolean isOffcut) {
        this.locationOfUseAddress = Objects.requireNonNull(address);
        this.location = location;
        this.refType = refType == null ? "" : refType;
        this.context = context == null ? "" : context;
        this.isOffcutReference = isOffcut;
    }

    LocationReference(Reference reference, boolean isOffcutReference) {
        this(reference.getFromAddress(), null, LocationReference.getRefType(reference), null, isOffcutReference);
    }

    LocationReference(Address locationOfUseAddress, String refType, boolean isOffcutReference) {
        this(locationOfUseAddress, null, refType, null, isOffcutReference);
    }

    LocationReference(Address locationOfUseAddress) {
        this(locationOfUseAddress, null, null, null, false);
    }

    LocationReference(Address locationOfUseAddress, String context) {
        this(locationOfUseAddress, null, null, context, false);
    }

    LocationReference(Address locationOfUseAddress, String context, ProgramLocation location) {
        this(locationOfUseAddress, location, null, context, false);
    }

    public String getRefTypeString() {
        return this.refType;
    }

    public boolean isOffcutReference() {
        return this.isOffcutReference;
    }

    public Address getLocationOfUse() {
        return this.locationOfUseAddress;
    }

    public String getContext() {
        return this.context;
    }

    public ProgramLocation getProgramLocation() {
        return this.location;
    }

    public int hashCode() {
        if (this.hashCode != -1) {
            return this.hashCode;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.locationOfUseAddress == null ? 0 : this.locationOfUseAddress.hashCode());
        this.hashCode = result = 31 * result + this.refType.hashCode();
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocationReference other = (LocationReference)obj;
        if (this.isOffcutReference != other.isOffcutReference) {
            return false;
        }
        if (!this.context.equals(other.context)) {
            return false;
        }
        if (this.locationOfUseAddress == null ? other.locationOfUseAddress != null : !this.locationOfUseAddress.equals((Object)other.locationOfUseAddress)) {
            return false;
        }
        return this.refType.equals(other.refType);
    }

    @Override
    public int compareTo(LocationReference other) {
        return this.locationOfUseAddress.compareTo((Object)other.locationOfUseAddress);
    }

    public String toString() {
        return "{\n\taddress: " + this.locationOfUseAddress + ",\n" + (String)(this.refType.equals("") ? "" : "\trefType: " + this.refType + ",\n") + "\tisOffcut: " + this.isOffcutReference + ",\n" + (String)(this.context.equals("") ? "" : "\tcontext: " + this.context + ",") + "}";
    }
}

