/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.nodes;

import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.symboltree.SymbolCategory;
import ghidra.app.plugin.core.symboltree.nodes.FunctionSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.LabelCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.OrganizationNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.task.TaskMonitor;
import java.awt.datatransfer.DataFlavor;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import resources.ResourceManager;

class FunctionCategoryNode
extends SymbolCategoryNode {
    public static final Icon OPEN_FOLDER_FUNCTIONS_ICON = ResourceManager.loadImage((String)"images/openFolderFunctions.png");
    public static final Icon CLOSED_FOLDER_FUNCTIONS_ICON = ResourceManager.loadImage((String)"images/closedFolderFunctions.png");

    FunctionCategoryNode(Program program) {
        super(SymbolCategory.FUNCTION_CATEGORY, program);
    }

    public Icon getIcon(boolean expanded) {
        return expanded ? OPEN_FOLDER_FUNCTIONS_ICON : CLOSED_FOLDER_FUNCTIONS_ICON;
    }

    @Override
    public String getToolTip() {
        return "Symbols for Functions";
    }

    @Override
    public boolean supportsDataFlavors(DataFlavor[] dataFlavors) {
        for (DataFlavor flavor : dataFlavors) {
            if (flavor != FunctionSymbolNode.LOCAL_DATA_FLAVOR) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canPaste(List<GTreeNode> pastedNodes) {
        for (GTreeNode treeNode : pastedNodes) {
            if (treeNode instanceof FunctionCategoryNode || treeNode instanceof LabelCategoryNode) continue;
            return false;
        }
        return true;
    }

    @Override
    public Comparator<GTreeNode> getChildrenComparator() {
        return OrganizationNode.COMPARATOR;
    }

    @Override
    public void symbolAdded(Symbol symbol) {
        if (!this.isChildrenLoadedOrInProgress()) {
            return;
        }
        if (!this.supportsSymbol(symbol)) {
            return;
        }
        if (this.isVariableParameterOrCodeSymbol(symbol)) {
            super.symbolAdded(symbol);
            return;
        }
        if (this.isChildNamespaceOfFunction(symbol)) {
            super.symbolAdded(symbol);
            return;
        }
        SymbolNode newNode = SymbolNode.createNode(symbol, this.program);
        this.doAddNode((GTreeNode)this, (GTreeNode)newNode);
    }

    private boolean isChildNamespaceOfFunction(Symbol symbol) {
        if (symbol instanceof Function) {
            return false;
        }
        for (Namespace parentNamespace = symbol.getParentNamespace(); parentNamespace != null && parentNamespace != this.globalNamespace; parentNamespace = parentNamespace.getParentNamespace()) {
            if (!(parentNamespace instanceof Function)) continue;
            return true;
        }
        return false;
    }

    private boolean isVariableParameterOrCodeSymbol(Symbol symbol) {
        SymbolType symbolType = symbol.getSymbolType();
        return symbolType.equals((Object)SymbolType.LOCAL_VAR) || symbolType.equals((Object)SymbolType.PARAMETER) || symbolType.equals((Object)SymbolType.CODE);
    }

    @Override
    protected boolean supportsSymbol(Symbol symbol) {
        if (super.supportsSymbol(symbol)) {
            return true;
        }
        for (Namespace parentNamespace = symbol.getParentNamespace(); parentNamespace != null && parentNamespace != this.globalNamespace; parentNamespace = parentNamespace.getParentNamespace()) {
            if (!(parentNamespace instanceof Function)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GTreeNode findSymbolTreeNode(SymbolNode key, boolean loadChildren, TaskMonitor monitor) {
        if (!loadChildren && !this.isChildrenLoadedOrInProgress()) {
            return null;
        }
        GTreeNode node = this.maybeSearchForSymbolInsideOfFunction(key, loadChildren, monitor);
        if (node != null) {
            return node;
        }
        return super.findSymbolTreeNode(key, loadChildren, monitor);
    }

    private GTreeNode maybeSearchForSymbolInsideOfFunction(SymbolNode key, boolean loadChildren, TaskMonitor monitor) {
        Symbol symbol = key.getSymbol();
        Symbol parentSymbol = symbol.getParentSymbol();
        if (parentSymbol == null) {
            return null;
        }
        SymbolType parentType = parentSymbol.getSymbolType();
        if (parentType != SymbolType.FUNCTION) {
            return null;
        }
        SymbolNode parentKey = SymbolNode.createNode(parentSymbol, this.program);
        GTreeNode parentNode = super.findSymbolTreeNode(parentKey, loadChildren, monitor);
        if (parentNode == null) {
            return null;
        }
        return ((FunctionSymbolNode)parentNode).findSymbolTreeNode(key, loadChildren, monitor);
    }
}

