/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.plugin.core.symboltree.actions.ClearPinSymbolAction;
import ghidra.app.plugin.core.symboltree.actions.EditExternalLocationAction;
import ghidra.app.plugin.core.symboltree.actions.PinSymbolAction;
import ghidra.app.plugin.core.symtable.ReferenceProvider;
import ghidra.app.plugin.core.symtable.SymbolProvider;
import ghidra.app.services.BlockModelService;
import ghidra.app.services.GoToService;
import ghidra.app.util.SymbolInspector;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.DummyKeyBindingsOptionsAction;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import resources.Icons;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Show Symbols in Symbol Table", description="This plugin shows the symbols in the symbol table, provides navigation to the symbols in the Code Browser, and allows symbols to be renamed and deleted. This plugin also shows references to a symbol. Filters can be set to show subsets of the symbols.", servicesRequired={GoToService.class, BlockModelService.class}, eventsProduced={ProgramLocationPluginEvent.class}, eventsConsumed={ProgramActivatedPluginEvent.class})
public class SymbolTablePlugin
extends Plugin
implements DomainObjectListener,
OptionsChangeListener {
    private static final String PLUGIN_NAME = "SymbolTablePlugin";
    static final Cursor WAIT_CURSOR = new Cursor(3);
    static final Cursor NORM_CURSOR = new Cursor(0);
    static final ImageIcon SYM_GIF = ResourceManager.loadImage((String)"images/table.png");
    static final ImageIcon REF_GIF = ResourceManager.loadImage((String)"images/table_go.png");
    private DockingAction viewSymTableAction;
    private DockingAction viewRefTableAction;
    private DockingAction openRefsAction;
    private DockingAction deleteAction;
    private DockingAction makeSelectionAction;
    private DockingAction setFilterAction;
    private ToggleDockingAction referencesToAction;
    private ToggleDockingAction instructionsFromAction;
    private ToggleDockingAction dataFromAction;
    private SymbolProvider symProvider;
    private ReferenceProvider refProvider;
    private SymbolInspector inspector;
    private Program currentProgram;
    private GoToService gotoService;
    private BlockModelService blockModelService;
    private SwingUpdateManager swingMgr = new SwingUpdateManager(1000, () -> {
        this.symProvider.getComponent().repaint();
        this.refProvider.getComponent().repaint();
    });

    public SymbolTablePlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        this.gotoService = (GoToService)this.tool.getService(GoToService.class);
        this.blockModelService = (BlockModelService)this.tool.getService(BlockModelService.class);
        this.symProvider = new SymbolProvider(this);
        this.refProvider = new ReferenceProvider(this);
        this.tool.addComponentProvider((ComponentProvider)this.symProvider, false);
        this.tool.addComponentProvider((ComponentProvider)this.refProvider, false);
        this.createActions();
        this.createSymActions();
        this.createRefActions();
        this.inspector = new SymbolInspector((ServiceProvider)this.getTool(), (Component)this.symProvider.getComponent());
    }

    public void dispose() {
        super.dispose();
        this.swingMgr.dispose();
        this.viewSymTableAction.dispose();
        this.viewRefTableAction.dispose();
        this.deleteAction.dispose();
        this.makeSelectionAction.dispose();
        if (this.symProvider != null) {
            this.symProvider.dispose();
            this.symProvider = null;
        }
        if (this.refProvider != null) {
            this.refProvider.dispose();
            this.refProvider = null;
        }
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
            this.currentProgram = null;
        }
        this.gotoService = null;
        this.blockModelService = null;
        if (this.inspector != null) {
            this.inspector.dispose();
            this.inspector = null;
        }
    }

    public void readConfigState(SaveState saveState) {
        this.symProvider.readConfigState(saveState);
    }

    public void writeConfigState(SaveState saveState) {
        this.symProvider.writeConfigState(saveState);
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent progEvent = (ProgramActivatedPluginEvent)event;
            Program oldProg = this.currentProgram;
            Program newProg = progEvent.getActiveProgram();
            if (oldProg != null) {
                this.inspector.setProgram(null);
                oldProg.removeListener((DomainObjectListener)this);
                this.symProvider.setProgram(null, this.inspector);
                this.refProvider.setProgram(null, this.inspector);
                this.tool.contextChanged((ComponentProvider)this.symProvider);
            }
            this.currentProgram = newProg;
            if (newProg != null) {
                this.currentProgram.addListener((DomainObjectListener)this);
                this.inspector.setProgram(this.currentProgram);
                this.symProvider.setProgram(this.currentProgram, this.inspector);
                this.refProvider.setProgram(this.currentProgram, this.inspector);
            }
            this.tool.contextChanged((ComponentProvider)this.symProvider);
        }
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (!this.symProvider.isVisible()) {
            return;
        }
        if (ev.containsEvent(4)) {
            this.symProvider.reload();
            this.refProvider.reload();
            return;
        }
        int eventCnt = ev.numRecords();
        block13: for (int i = 0; i < eventCnt; ++i) {
            DomainObjectChangeRecord doRecord = ev.getChangeRecord(i);
            int eventType = doRecord.getEventType();
            if (!(doRecord instanceof ProgramChangeRecord)) continue;
            ProgramChangeRecord rec = (ProgramChangeRecord)doRecord;
            Symbol symbol = null;
            switch (eventType) {
                case 30: 
                case 31: {
                    if (!(rec.getNewValue() instanceof Data) || (symbol = this.currentProgram.getSymbolTable().getPrimarySymbol(rec.getStart())) == null || !symbol.isDynamic()) continue block13;
                    this.symProvider.symbolChanged(symbol);
                    this.refProvider.symbolChanged(symbol);
                    continue block13;
                }
                case 40: {
                    Address addAddr = rec.getStart();
                    Symbol primaryAtAdd = this.currentProgram.getSymbolTable().getPrimarySymbol(addAddr);
                    if (primaryAtAdd != null && primaryAtAdd.isDynamic()) {
                        this.symProvider.symbolRemoved(primaryAtAdd.getID());
                    }
                    symbol = (Symbol)rec.getNewValue();
                    this.symProvider.symbolAdded(symbol);
                    this.refProvider.symbolAdded(symbol);
                    continue block13;
                }
                case 41: {
                    Address removeAddr = rec.getStart();
                    Long symbolID = (Long)rec.getNewValue();
                    this.symProvider.symbolRemoved(symbolID);
                    this.refProvider.symbolRemoved(symbolID);
                    Symbol primaryAtRemove = this.currentProgram.getSymbolTable().getPrimarySymbol(removeAddr);
                    if (primaryAtRemove == null || !primaryAtRemove.isDynamic()) continue block13;
                    this.symProvider.symbolAdded(primaryAtRemove);
                    continue block13;
                }
                case 46: 
                case 49: 
                case 52: {
                    symbol = (Symbol)rec.getObject();
                    if (!symbol.checkIsValid()) continue block13;
                    this.symProvider.symbolChanged(symbol);
                    this.refProvider.symbolChanged(symbol);
                    continue block13;
                }
                case 42: {
                    symbol = (Symbol)rec.getObject();
                    this.symProvider.symbolChanged(symbol);
                    continue block13;
                }
                case 45: {
                    symbol = (Symbol)rec.getNewValue();
                    this.symProvider.symbolChanged(symbol);
                    Symbol oldSymbol = (Symbol)rec.getOldValue();
                    if (oldSymbol == null) continue block13;
                    this.symProvider.symbolChanged(oldSymbol);
                    continue block13;
                }
                case 50: 
                case 51: {
                    continue block13;
                }
                case 60: {
                    Reference ref = (Reference)rec.getObject();
                    symbol = this.currentProgram.getSymbolTable().getSymbol(ref);
                    if (symbol == null) continue block13;
                    this.symProvider.symbolChanged(symbol);
                    this.refProvider.symbolChanged(symbol);
                    continue block13;
                }
                case 61: {
                    Reference ref = (Reference)rec.getObject();
                    Address toAddr = ref.getToAddress();
                    if (!toAddr.isMemoryAddress()) continue block13;
                    symbol = this.currentProgram.getSymbolTable().getSymbol(ref);
                    if (symbol == null) {
                        long id = this.currentProgram.getSymbolTable().getDynamicSymbolID(ref.getToAddress());
                        this.symProvider.symbolRemoved(id);
                        continue block13;
                    }
                    this.refProvider.symbolChanged(symbol);
                    continue block13;
                }
                case 47: 
                case 48: {
                    Symbol[] symbols;
                    for (Symbol element : symbols = this.currentProgram.getSymbolTable().getSymbols(rec.getStart())) {
                        this.symProvider.symbolChanged(element);
                        this.refProvider.symbolChanged(element);
                    }
                    continue block13;
                }
                case 20: 
                case 21: {
                    this.symProvider.reload();
                    this.refProvider.reload();
                }
            }
        }
    }

    Program getProgram() {
        return this.currentProgram;
    }

    BlockModelService getBlockModelService() {
        return this.blockModelService;
    }

    GoToService getGoToService() {
        return this.gotoService;
    }

    SymbolProvider getSymbolProvider() {
        return this.symProvider;
    }

    ReferenceProvider getReferenceProvider() {
        return this.refProvider;
    }

    void openSymbolProvider() {
        if (this.symProvider != null) {
            this.symProvider.open();
        }
    }

    void closeReferenceProvider() {
        if (this.refProvider != null) {
            this.refProvider.closeComponent();
        }
    }

    private void createActions() {
        this.viewSymTableAction = new DockingAction("View Symbol Table", this.getName()){

            public void actionPerformed(ActionContext context) {
                SymbolTablePlugin.this.tool.showComponentProvider((ComponentProvider)SymbolTablePlugin.this.symProvider, true);
            }
        };
        this.viewSymTableAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/table.png"), "View"));
        this.viewSymTableAction.setKeyBindingData(new KeyBindingData(84, 128));
        this.viewSymTableAction.setDescription("Display Symbol Table");
        this.tool.addAction((DockingActionIf)this.viewSymTableAction);
        this.viewRefTableAction = new DockingAction("View Symbol References", this.getName()){

            public void actionPerformed(ActionContext context) {
                SymbolTablePlugin.this.tool.showComponentProvider((ComponentProvider)SymbolTablePlugin.this.refProvider, true);
            }
        };
        this.viewRefTableAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/table_go.png"), "View"));
        this.viewRefTableAction.setDescription("Display Symbol References");
        this.tool.addAction((DockingActionIf)this.viewRefTableAction);
    }

    private void createSymActions() {
        String popupGroup = "1";
        this.openRefsAction = new DockingAction("Symbol References", this.getName()){

            public void actionPerformed(ActionContext context) {
                SymbolTablePlugin.this.refProvider.open();
                SymbolTablePlugin.this.refProvider.setCurrentSymbol(SymbolTablePlugin.this.symProvider.getCurrentSymbol());
            }
        };
        ImageIcon icon = ResourceManager.loadImage((String)"images/table_go.png");
        this.openRefsAction.setPopupMenuData(new MenuData(new String[]{"Symbol References"}, (Icon)icon, popupGroup));
        this.openRefsAction.setToolBarData(new ToolBarData((Icon)icon));
        this.openRefsAction.setDescription("Symbol References");
        this.tool.addLocalAction((ComponentProvider)this.symProvider, (DockingActionIf)this.openRefsAction);
        this.deleteAction = new DockingAction("Delete Symbols", this.getName()){

            public void actionPerformed(ActionContext context) {
                SymbolTablePlugin.this.symProvider.deleteSymbols();
            }

            public boolean isEnabledForContext(ActionContext context) {
                GhidraTable table = SymbolTablePlugin.this.symProvider.getTable();
                return table.getSelectedRowCount() > 0;
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        icon = ResourceManager.loadImage((String)"images/edit-delete.png");
        String deleteGroup = "3";
        this.deleteAction.setPopupMenuData(new MenuData(new String[]{"Delete"}, (Icon)icon, deleteGroup));
        this.deleteAction.setToolBarData(new ToolBarData((Icon)icon));
        this.deleteAction.setKeyBindingData(new KeyBindingData(127, 0));
        this.deleteAction.setDescription("Delete Selected Symbols");
        this.deleteAction.setEnabled(false);
        this.tool.addLocalAction((ComponentProvider)this.symProvider, (DockingActionIf)this.deleteAction);
        EditExternalLocationAction editExternalLocationAction = new EditExternalLocationAction(this);
        this.tool.addLocalAction((ComponentProvider)this.symProvider, (DockingActionIf)editExternalLocationAction);
        this.makeSelectionAction = new DockingAction("Make Selection", this.getName(), false){

            public void actionPerformed(ActionContext context) {
                SymbolTablePlugin.this.symProvider.makeSelection();
            }

            public boolean isEnabledForContext(ActionContext context) {
                GhidraTable table = SymbolTablePlugin.this.symProvider.getTable();
                return table.getSelectedRowCount() > 0;
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        icon = ResourceManager.loadImage((String)"images/text_align_justify.png");
        this.makeSelectionAction.setPopupMenuData(new MenuData(new String[]{"Make Selection"}, (Icon)icon, popupGroup));
        this.makeSelectionAction.setToolBarData(new ToolBarData((Icon)icon));
        this.makeSelectionAction.setDescription("Make a selection using selected Symbol addresses");
        this.makeSelectionAction.setEnabled(false);
        this.installDummyAction(this.makeSelectionAction);
        this.tool.addLocalAction((ComponentProvider)this.symProvider, (DockingActionIf)this.makeSelectionAction);
        this.setFilterAction = new DockingAction("Set Filter", this.getName()){

            public void actionPerformed(ActionContext context) {
                SymbolTablePlugin.this.symProvider.setFilter();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return SymbolTablePlugin.this.currentProgram != null;
            }
        };
        icon = Icons.CONFIGURE_FILTER_ICON;
        this.setFilterAction.setPopupMenuData(new MenuData(new String[]{"Configure Symbol Filter"}, (Icon)icon, popupGroup));
        this.setFilterAction.setToolBarData(new ToolBarData((Icon)icon));
        this.setFilterAction.setDescription("Configure Symbol Filter");
        this.tool.addLocalAction((ComponentProvider)this.symProvider, (DockingActionIf)this.setFilterAction);
        SelectionNavigationAction selectionNavigationAction = new SelectionNavigationAction(this, this.symProvider.getTable()){

            @Override
            protected void toggleSelectionListening(boolean listen) {
                super.toggleSelectionListening(listen);
                SymbolTablePlugin.this.refProvider.getTable().setNavigateOnSelectionEnabled(listen);
            }
        };
        this.tool.addLocalAction((ComponentProvider)this.symProvider, (DockingActionIf)selectionNavigationAction);
        String pinnedPopupGroup = "2";
        PinSymbolAction setPinnedAction = new PinSymbolAction(this.getName(), pinnedPopupGroup);
        this.tool.addAction((DockingActionIf)setPinnedAction);
        ClearPinSymbolAction clearPinnedAction = new ClearPinSymbolAction(this.getName(), pinnedPopupGroup);
        this.tool.addAction((DockingActionIf)clearPinnedAction);
    }

    private void installDummyAction(DockingAction action) {
        DummyKeyBindingsOptionsAction dummyAction = new DummyKeyBindingsOptionsAction(action.getName(), null);
        this.tool.addAction((DockingActionIf)dummyAction);
        ToolOptions options = this.tool.getOptions("Key Bindings");
        options.addOptionsChangeListener((OptionsChangeListener)this);
        KeyStroke keyStroke = options.getKeyStroke(dummyAction.getFullName(), null);
        if (keyStroke != null) {
            action.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        }
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (optionName.startsWith(this.makeSelectionAction.getName())) {
            KeyStroke keyStroke = (KeyStroke)newValue;
            this.makeSelectionAction.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        }
    }

    private void createRefActions() {
        this.referencesToAction = new ToggleDockingAction("References To", this.getName()){

            public void actionPerformed(ActionContext context) {
                if (SymbolTablePlugin.this.referencesToAction.isSelected()) {
                    SymbolTablePlugin.this.refProvider.showReferencesTo();
                    SymbolTablePlugin.this.referencesToAction.setSelected(true);
                    SymbolTablePlugin.this.instructionsFromAction.setSelected(false);
                    SymbolTablePlugin.this.dataFromAction.setSelected(false);
                } else {
                    SymbolTablePlugin.this.reselectAction(SymbolTablePlugin.this.referencesToAction);
                }
            }
        };
        this.referencesToAction.setDescription("References To");
        this.referencesToAction.setSelected(true);
        this.referencesToAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/references_to.gif"), null));
        this.tool.addLocalAction((ComponentProvider)this.refProvider, (DockingActionIf)this.referencesToAction);
        this.instructionsFromAction = new ToggleDockingAction("Instruction References From", this.getName()){

            public void actionPerformed(ActionContext context) {
                if (SymbolTablePlugin.this.instructionsFromAction.isSelected()) {
                    SymbolTablePlugin.this.refProvider.showInstructionsFrom();
                    SymbolTablePlugin.this.referencesToAction.setSelected(false);
                    SymbolTablePlugin.this.instructionsFromAction.setSelected(true);
                    SymbolTablePlugin.this.dataFromAction.setSelected(false);
                } else {
                    SymbolTablePlugin.this.reselectAction(SymbolTablePlugin.this.instructionsFromAction);
                }
            }
        };
        this.instructionsFromAction.setDescription("Instructions From");
        this.instructionsFromAction.setSelected(false);
        this.instructionsFromAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/I.gif"), null));
        this.tool.addLocalAction((ComponentProvider)this.refProvider, (DockingActionIf)this.instructionsFromAction);
        this.dataFromAction = new ToggleDockingAction("Data References From", this.getName()){

            public void actionPerformed(ActionContext context) {
                if (SymbolTablePlugin.this.dataFromAction.isSelected()) {
                    SymbolTablePlugin.this.refProvider.showDataFrom();
                    SymbolTablePlugin.this.referencesToAction.setSelected(false);
                    SymbolTablePlugin.this.instructionsFromAction.setSelected(false);
                    SymbolTablePlugin.this.dataFromAction.setSelected(true);
                } else {
                    SymbolTablePlugin.this.reselectAction(SymbolTablePlugin.this.dataFromAction);
                }
            }
        };
        this.dataFromAction.setDescription("Data From");
        this.dataFromAction.setSelected(false);
        this.dataFromAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/D.gif"), null));
        this.tool.addLocalAction((ComponentProvider)this.refProvider, (DockingActionIf)this.dataFromAction);
    }

    private void reselectAction(ToggleDockingAction action) {
        action.setSelected(false);
        action.setSelected(true);
    }
}

