/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.prototype.dataArchiveUtilities;

import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.util.Msg;
import java.util.Hashtable;

public class ComplexName {
    boolean isPointer;
    boolean isArray;
    boolean usesNamespace;
    String complexName;
    String namespace;
    String name;
    int count = 1;

    public ComplexName(String complexName) {
        this.complexName = complexName;
        if (complexName.startsWith("Pointer%")) {
            this.isPointer = true;
            complexName = complexName.substring(complexName.indexOf("%") + 1);
        }
        if (complexName.startsWith("Array%")) {
            this.isArray = true;
            String countStr = (complexName = complexName.substring(complexName.indexOf("%") + 1)).substring(0, complexName.indexOf("%"));
            this.count = countStr.compareToIgnoreCase("") != 0 ? new Integer(countStr) : 1;
            complexName = complexName.substring(complexName.indexOf("%") + 1);
            complexName = complexName.substring(complexName.indexOf("%") + 1);
        }
        boolean bl = this.usesNamespace = complexName.indexOf(":") >= 0;
        if (this.usesNamespace) {
            this.namespace = complexName.substring(complexName.indexOf("/"), complexName.indexOf(":"));
            this.name = complexName.substring(0, complexName.indexOf("/")) + complexName.substring(complexName.indexOf(":") + 1, complexName.length());
        } else {
            this.namespace = "";
            this.name = complexName;
        }
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isPointer() {
        return this.isPointer;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean usesNamespace() {
        return this.usesNamespace;
    }

    public CategoryPath getCategoryPath() {
        return this.usesNamespace ? new CategoryPath(this.namespace) : CategoryPath.ROOT;
    }

    public DataType getDataType(FileDataTypeManager dtMgr, Hashtable<String, DataType> dataTypes) {
        return this.getDataType((DataTypeManager)dtMgr, dataTypes, true);
    }

    public DataType getDataType(DataTypeManager dtMgr, Hashtable<String, DataType> dataTypes, boolean generateUI) {
        DataType dt;
        if (this.name.indexOf("%") >= 0) {
            ComplexName cName = new ComplexName(this.name);
            dt = cName.getDataType(dtMgr, dataTypes, generateUI);
            this.name = cName.getName();
        } else {
            dt = dataTypes == null ? dtMgr.getDataType(this.getCategoryPath(), this.getName()) : dataTypes.get(this.getCategoryPath() + this.getName());
        }
        if (dt == null) {
            if (generateUI) {
                dt = this.genUIData(dtMgr, dataTypes, new ComplexName(this.complexName), 4);
            } else {
                Msg.warn((Object)this, (Object)("Data type (" + this.name + ") not found."));
                return dt;
            }
        }
        if (this.isPointer) {
            dt = new Pointer32DataType(dt);
        }
        if (this.isArray) {
            if (dt.getLength() >= 0) {
                dt = new ArrayDataType(dt, this.count, dt.getLength());
            } else {
                Msg.error((Object)this, (Object)("Error in array length (" + dt.getLength() + ") for " + dt.getName()));
                return null;
            }
        }
        return dt;
    }

    public DataType genUIData(DataTypeManager dtMgr, Hashtable<String, DataType> dataTypes, ComplexName cName, int len) {
        TypedefDataType dt = new TypedefDataType(cName.getCategoryPath(), cName.getName(), (DataType)new ArrayDataType((DataType)new ByteDataType(), len, 1));
        this.addDataType(dtMgr, dataTypes, (DataType)dt);
        return dt;
    }

    private void addDataType(DataTypeManager dtMgr, Hashtable<String, DataType> dataTypes, DataType dt) {
        DataType type = dtMgr.addDataType(dt, DataTypeConflictHandler.REPLACE_HANDLER);
        dataTypes.put(type.getCategoryPath() + type.getName(), type);
    }
}

